/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseFontHelper;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;
import net.sf.jasperreports.engine.fonts.FontFace;

public class PptxFontHelper
extends BaseFontHelper {
    public PptxFontHelper(JasperReportsContext jasperReportsContext, Writer writer, Writer relsWriter, FileBufferedZip zip, boolean isEmbedFonts) {
        super(jasperReportsContext, writer, relsWriter, zip, isEmbedFonts);
    }

    @Override
    protected String getExporterKey() {
        return "net.sf.jasperreports.pptx";
    }

    @Override
    protected String getEndFontTag() {
        return "  </p:embeddedFont>\n";
    }

    @Override
    protected String getFontsDir() {
        return "ppt/fonts/";
    }

    @Override
    protected String getStartFontTag(String fontName) {
        return "  <p:embeddedFont>\n    <p:font typeface=\"" + fontName + "\"/>\n";
    }

    @Override
    protected String getRegularEmbedding(String id) {
        return "    <p:regular r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getBoldEmbedding(String id) {
        return "    <p:bold r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getItalicEmbedding(String id) {
        return "    <p:italic r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getBoldItalicEmbedding(String id) {
        return "    <p:boldItalic r:id=\"" + id + "\"/>\n";
    }

    @Override
    protected String getFontPath(FontFace fontFace) {
        return fontFace == null ? null : fontFace.getEot();
    }
}

