/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnonymousClass;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import java.util.ArrayList;
import java.util.List;

public final class JInvocation
extends JExpressionImpl
implements JStatement {
    private JGenerable object;
    private String name;
    private JMethod method;
    private boolean isConstructor = false;
    private List<JExpression> args = new ArrayList<JExpression>();
    private JType type = null;

    JInvocation(JExpression object, String name) {
        this((JGenerable)object, name);
    }

    JInvocation(JExpression object, JMethod method) {
        this((JGenerable)object, method);
    }

    JInvocation(JClass type, String name) {
        this((JGenerable)type, name);
    }

    JInvocation(JClass type, JMethod method) {
        this((JGenerable)type, method);
    }

    private JInvocation(JGenerable object, String name) {
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + name);
        }
        this.name = name;
    }

    private JInvocation(JGenerable object, JMethod method) {
        this.object = object;
        this.method = method;
    }

    JInvocation(JType c) {
        this.isConstructor = true;
        this.type = c;
    }

    public JInvocation arg(JExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        this.args.add(arg);
        return this;
    }

    public JInvocation arg(String v) {
        return this.arg(JExpr.lit(v));
    }

    public JExpression[] listArgs() {
        return this.args.toArray(new JExpression[this.args.size()]);
    }

    public void generate(JFormatter f) {
        if (this.isConstructor && this.type.isArray()) {
            f.p("new").g(this.type).p('{');
        } else if (this.isConstructor) {
            f.p("new").g(this.type).p('(');
        } else {
            String name = this.name;
            if (name == null) {
                name = this.method.name();
            }
            if (this.object != null) {
                f.g(this.object).p('.').p(name).p('(');
            } else {
                f.id(name).p('(');
            }
        }
        f.g(this.args);
        if (this.isConstructor && this.type.isArray()) {
            f.p('}');
        } else {
            f.p(')');
        }
        if (this.type instanceof JDefinedClass && ((JDefinedClass)this.type).isAnonymous()) {
            ((JAnonymousClass)this.type).declareBody(f);
        }
    }

    public void state(JFormatter f) {
        f.g(this).p(';').nl();
    }
}

