/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.wssecurity.util;

import java.util.List;
import org.opensaml.ws.wssecurity.IdBearing;
import org.opensaml.ws.wssecurity.TokenTypeBearing;
import org.opensaml.ws.wssecurity.UsageBearing;
import org.opensaml.xml.AttributeExtensibleXMLObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.AttributeMap;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSSecurityHelper {
    private WSSecurityHelper() {
    }

    public static void addWSUId(XMLObject soapObject, String id) {
        if (soapObject instanceof IdBearing) {
            ((IdBearing)soapObject).setWSUId(id);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(IdBearing.WSU_ID_ATTR_NAME, id);
        } else {
            throw new IllegalArgumentException("Specified object was neither IdBearing nor AttributeExtensible");
        }
    }

    public static String getWSUId(XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof IdBearing && (value = DatatypeHelper.safeTrimOrNullString((String)((IdBearing)soapObject).getWSUId())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)IdBearing.WSU_ID_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addWSSE11TokenType(XMLObject soapObject, String tokenType) {
        if (soapObject instanceof TokenTypeBearing) {
            ((TokenTypeBearing)soapObject).setWSSE11TokenType(tokenType);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(TokenTypeBearing.WSSE11_TOKEN_TYPE_ATTR_NAME, tokenType);
        } else {
            throw new IllegalArgumentException("Specified object was neither TokenTypeBearing nor AttributeExtensible");
        }
    }

    public static String getWSSE11TokenType(XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof TokenTypeBearing && (value = DatatypeHelper.safeTrimOrNullString((String)((TokenTypeBearing)soapObject).getWSSE11TokenType())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)TokenTypeBearing.WSSE11_TOKEN_TYPE_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addWSSEUsage(XMLObject soapObject, String usage) {
        if (soapObject instanceof UsageBearing) {
            UsageBearing usageBearing = (UsageBearing)soapObject;
            LazyList list = usageBearing.getWSSEUsages();
            if (list == null) {
                list = new LazyList();
                usageBearing.setWSSEUsages((List<String>)list);
            }
            list.add((String)usage);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            AttributeMap am = ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes();
            String list = am.get((Object)UsageBearing.WSSE_USAGE_ATTR_NAME);
            list = list == null ? usage : list + " " + usage;
            am.put(UsageBearing.WSSE_USAGE_ATTR_NAME, list);
        } else {
            throw new IllegalArgumentException("Specified object was neither UsageBearing nor AttributeExtensible");
        }
    }

    public static void addWSSEUsages(XMLObject soapObject, List<String> usages) {
        if (soapObject instanceof UsageBearing) {
            ((UsageBearing)soapObject).setWSSEUsages(usages);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(UsageBearing.WSSE_USAGE_ATTR_NAME, DatatypeHelper.listToStringValue(usages, (String)" "));
        } else {
            throw new IllegalArgumentException("Specified object was neither UsageBearing nor AttributeExtensible");
        }
    }

    public static List<String> getWSSEUsages(XMLObject soapObject) {
        Object value;
        if (soapObject instanceof UsageBearing && (value = ((UsageBearing)soapObject).getWSSEUsages()) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject && (value = DatatypeHelper.safeTrimOrNullString((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)UsageBearing.WSSE_USAGE_ATTR_NAME))) != null) {
            DatatypeHelper.stringToList((String)value, (String)" \n\r\t");
        }
        return null;
    }
}

