/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jelly;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.apache.commons.jelly.JellyContext;

public class ScriptJellyContext
extends JellyContext {
    private ScriptContext ctx;
    private ScriptEngine engine;

    ScriptJellyContext(JellyContext parent, ScriptContext ctx) {
        this.setScriptContext(ctx);
        this.setParent(parent);
        this.setInherit(false);
        this.setExportLibraries(false);
    }

    public synchronized ScriptContext getScriptContext() {
        return this.ctx;
    }

    public synchronized void setScriptContext(ScriptContext ctx) {
        this.ctx = ctx;
        this.setContextURLs();
    }

    public synchronized ScriptEngine getScriptEngine() {
        return this.engine;
    }

    public synchronized void setScriptEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    private void setContextURLs() {
        URL rootURL = null;
        URL currentURL = null;
        Object root = this.ctx.getAttribute("com.sun.script.jelly.root_url", 100);
        if (root instanceof URL) {
            rootURL = (URL)root;
        } else {
            String filename = (String)this.ctx.getAttribute("javax.script.filename", 100);
            if (filename != null) {
                try {
                    rootURL = new File(filename).toURL();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
        }
        Object current = this.ctx.getAttribute("com.sun.script.jelly.current_url", 100);
        currentURL = current instanceof URL ? (URL)current : rootURL;
        if (rootURL != null) {
            this.setRootURL(rootURL);
            this.setCurrentURL(currentURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariable(String name) {
        ScriptContext scriptContext = this.ctx;
        synchronized (scriptContext) {
            int scope = this.ctx.getAttributesScope(name);
            if (scope != -1) {
                return this.ctx.getAttribute(name, scope);
            }
        }
        return super.getVariable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findVariable(String name) {
        ScriptContext scriptContext = this.ctx;
        synchronized (scriptContext) {
            int scope = this.ctx.getAttributesScope(name);
            if (scope != -1) {
                return this.ctx.getAttribute(name, scope);
            }
        }
        return super.findVariable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariable(String name, Object value) {
        ScriptContext scriptContext = this.ctx;
        synchronized (scriptContext) {
            int scope = this.ctx.getAttributesScope(name);
            if (scope == -1) {
                scope = 100;
            }
            this.ctx.setAttribute(name, value, scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVariable(String name) {
        ScriptContext scriptContext = this.ctx;
        synchronized (scriptContext) {
            int scope = this.ctx.getAttributesScope(name);
            if (scope != -1) {
                this.ctx.removeAttribute(name, scope);
                return;
            }
        }
        super.removeVariable(name);
    }
}

