/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.scriptapi;

import java.util.Enumeration;
import javax.script.Bindings;
import org.pnuts.scriptapi.PnutsBindings;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;

public class BindingsPackage
extends Package {
    private Package globalPackage;
    private Package enginePackage;

    public BindingsPackage() {
        super(null, null);
    }

    public void setBindings(Bindings ns, int scope) {
        if (scope == 200) {
            this.globalPackage = BindingsPackage.bindingsToPackage(ns);
        } else if (scope == 100) {
            this.enginePackage = BindingsPackage.bindingsToPackage(ns);
        } else {
            throw new IllegalArgumentException("Illegal scope value.");
        }
    }

    static Package bindingsToPackage(Bindings ns) {
        PnutsBindings pns = ns instanceof PnutsBindings ? (PnutsBindings)ns : new PnutsBindings(ns);
        return pns.getPackage();
    }

    public Object get(String symbol) {
        NamedValue value = this.enginePackage.lookup(symbol);
        if (value != null) {
            return value.get();
        }
        if (this.globalPackage != null) {
            return this.globalPackage.get(symbol);
        }
        return null;
    }

    public Object get(String symbol, Context context) {
        return this.get(symbol);
    }

    public void set(String symbol, Object value) {
        this.enginePackage.set(symbol, value);
    }

    public boolean defined(String name, Context context) {
        return this.enginePackage.lookup(name) != null || this.globalPackage != null && this.globalPackage.lookup(name) != null;
    }

    public Enumeration keys() {
        throw new RuntimeException();
    }

    public Enumeration values() {
        throw new RuntimeException();
    }

    public int size() {
        int sz = 0;
        if (this.enginePackage != null) {
            sz += this.enginePackage.size();
        }
        if (this.globalPackage != null) {
            sz += this.globalPackage.size();
        }
        return sz;
    }

    public NamedValue lookup(String symbol) {
        NamedValue value = this.enginePackage.lookup(symbol);
        if (value != null) {
            return value;
        }
        if (this.globalPackage != null) {
            return this.globalPackage.lookup(symbol);
        }
        return null;
    }

    public NamedValue lookup(String symbol, Context context) {
        return this.lookup(symbol);
    }

    public Enumeration bindings() {
        return super.bindings();
    }

    public void clear() {
        super.clear();
    }

    public void setConstant(String x0, Object x1) {
        super.setConstant(x0, x1);
    }
}

