/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.nhttp.util.ConnectionsViewMBean;

public class ConnectionsView
implements ConnectionsViewMBean {
    private static final String NHTTP_CONNECTIONS = "NhttpConnections";
    private static final int LESS_THAN_1K = 0;
    private static final int LESS_THAN_10K = 1;
    private static final int LESS_THAN_100K = 2;
    private static final int LESS_THAN_1M = 3;
    private static final int LESS_THAN_10M = 4;
    private static final int GREATER_THAN_10M = 5;
    private static final int SHORT_DATA_COLLECTION_PERIOD = 60;
    private static final int LONG_DATA_COLLECTION_PERIOD = 300;
    private static final int SAMPLES_PER_HOUR = 12;
    private Queue<Integer> shortTermDataQueue = new LinkedList<Integer>();
    private Queue<Integer> longTermDataQueue = new LinkedList<Integer>();
    private AtomicInteger activeConnections = new AtomicInteger(0);
    private AtomicInteger shortTermOpenedConnections = new AtomicInteger(0);
    private AtomicInteger longTermOpenedConnections = new AtomicInteger(0);
    private Map<String, AtomicInteger> activeConnectionsPerHost = new HashMap<String, AtomicInteger>();
    private AtomicInteger[] requestSizeCounters = new AtomicInteger[6];
    private AtomicInteger[] responseSizeCounters = new AtomicInteger[6];
    private Date resetTime = Calendar.getInstance().getTime();
    private ScheduledExecutorService scheduler;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionsView(final String name) {
        this.name = name;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, name + "-connections-view");
            }
        });
        this.initCounters(this.requestSizeCounters);
        this.initCounters(this.responseSizeCounters);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (ConnectionsView.this.shortTermDataQueue.size() == 15) {
                    ConnectionsView.this.shortTermDataQueue.remove();
                }
                ConnectionsView.this.shortTermDataQueue.offer(ConnectionsView.this.shortTermOpenedConnections.getAndSet(0));
            }
        };
        this.scheduler.scheduleAtFixedRate(task, 60L, 60L, TimeUnit.SECONDS);
        Runnable longTermCollector = new Runnable(){

            @Override
            public void run() {
                if (ConnectionsView.this.longTermDataQueue.size() == 288) {
                    ConnectionsView.this.longTermDataQueue.remove();
                }
                ConnectionsView.this.longTermDataQueue.offer(ConnectionsView.this.longTermOpenedConnections.getAndSet(0));
            }
        };
        this.scheduler.scheduleAtFixedRate(longTermCollector, 300L, 300L, TimeUnit.SECONDS);
        boolean registered = false;
        try {
            registered = MBeanRegistrar.getInstance().registerMBean((Object)this, NHTTP_CONNECTIONS, name);
        }
        finally {
            if (!registered) {
                this.scheduler.shutdownNow();
            }
        }
    }

    public void destroy() {
        MBeanRegistrar.getInstance().unRegisterMBean(NHTTP_CONNECTIONS, this.name);
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    private void initCounters(AtomicInteger[] counters) {
        for (int i = 0; i < counters.length; ++i) {
            if (counters[i] == null) {
                counters[i] = new AtomicInteger(0);
                continue;
            }
            counters[i].set(0);
        }
    }

    protected void connected() {
        this.activeConnections.incrementAndGet();
        this.shortTermOpenedConnections.incrementAndGet();
        this.longTermOpenedConnections.incrementAndGet();
    }

    protected void disconnected() {
        this.activeConnections.decrementAndGet();
    }

    protected void notifyMessageSize(long size, boolean isRequest) {
        AtomicInteger[] counters;
        AtomicInteger[] atomicIntegerArray = counters = isRequest ? this.requestSizeCounters : this.responseSizeCounters;
        if (size < 1024L) {
            counters[0].incrementAndGet();
        } else if (size < 10240L) {
            counters[1].incrementAndGet();
        } else if (size < 102400L) {
            counters[2].incrementAndGet();
        } else if (size < 0x100000L) {
            counters[3].incrementAndGet();
        } else if (size < 0xA00000L) {
            counters[4].incrementAndGet();
        } else {
            counters[5].incrementAndGet();
        }
    }

    @Override
    public int getActiveConnections() {
        return this.activeConnections.get();
    }

    @Override
    public int getLastMinuteConnections() {
        return this.getTotalConnections(1);
    }

    @Override
    public int getLast5MinuteConnections() {
        return this.getTotalConnections(5);
    }

    @Override
    public int getLast15MinuteConnections() {
        return this.getTotalConnections(15);
    }

    @Override
    public int getLastHourConnections() {
        return this.getTotalConnectionsByHour(1);
    }

    @Override
    public int getLast8HourConnections() {
        return this.getTotalConnectionsByHour(8);
    }

    @Override
    public int getLast24HourConnections() {
        return this.getTotalConnectionsByHour(24);
    }

    @Override
    public Map getRequestSizesMap() {
        return this.getCountersMap(this.requestSizeCounters);
    }

    @Override
    public Map getResponseSizesMap() {
        return this.getCountersMap(this.responseSizeCounters);
    }

    @Override
    public Date getLastResetTime() {
        return this.resetTime;
    }

    private Map<String, Integer> getCountersMap(AtomicInteger[] counters) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("< 1 K", counters[0].get());
        map.put("< 10 K", counters[1].get());
        map.put("< 100 K", counters[2].get());
        map.put("< 1 M", counters[3].get());
        map.put("< 10 M", counters[4].get());
        map.put("> 10 M", counters[5].get());
        return map;
    }

    @Override
    public void reset() {
        this.initCounters(this.requestSizeCounters);
        this.initCounters(this.responseSizeCounters);
        this.shortTermDataQueue.clear();
        this.longTermDataQueue.clear();
        this.resetTime = Calendar.getInstance().getTime();
    }

    private int getTotalConnections(int n) {
        int sum = 0;
        Integer[] array = this.shortTermDataQueue.toArray(new Integer[this.shortTermDataQueue.size()]);
        if (n > array.length) {
            for (int i = 0; i < array.length; ++i) {
                sum += array[i].intValue();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                sum += array[array.length - 1 - i].intValue();
            }
        }
        return sum;
    }

    private int getTotalConnectionsByHour(int n) {
        int samples = n * 12;
        int sum = 0;
        Integer[] array = this.longTermDataQueue.toArray(new Integer[this.longTermDataQueue.size()]);
        if (samples > array.length) {
            for (int i = 0; i < array.length; ++i) {
                sum += array[i].intValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += array[array.length - 1 - i].intValue();
            }
        }
        return sum;
    }

    public void setActiveConnectionPerHostEntry(Map<String, AtomicInteger> activeConnectionsPerHost) {
        this.activeConnectionsPerHost = activeConnectionsPerHost;
    }

    @Override
    public Map getActiveConnectionsPerHosts() {
        return this.activeConnectionsPerHost;
    }
}

