/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.core.persistence.neo4j.entity;

import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.RelationshipTypeExtension;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Relationship;

@Node(Neo4jRelationshipTypeExtension.NODE)
public class Neo4jRelationshipTypeExtension extends AbstractTypeExtension implements RelationshipTypeExtension {

    private static final long serialVersionUID = 7566998432028027512L;

    public static final String NODE = "RelationshipTypeExtension";

    @Relationship(
            type = Neo4jRelationshipType.RELATIONSHIP_TYPE_EXTENSION_REL,
            direction = Relationship.Direction.OUTGOING, cascadeUpdates = false)
    private Neo4jRelationshipType group;

    @Override
    public RelationshipType getRelationshipType() {
        return group;
    }

    @Override
    public void setRelationshipType(final RelationshipType relationshipType) {
        checkType(relationshipType, Neo4jRelationshipType.class);
        this.group = (Neo4jRelationshipType) relationshipType;
    }
}
