/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class CsplineCG
extends Script {
    public CsplineCG() {
        String string = "scripts/algorithms/CsplineCG.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public double interpSpline(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/algorithms/CsplineCG.dml') as mlcontextns;q = mlcontextns::interpSpline(x, X, Y, K);";
        Script script = new Script(string);
        script.in("x", object).in("X", object2).in("Y", object3).in("K", object4).out("q");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("q");
        return d;
    }

    public String interpSpline__docs() {
        String string = "interpSpline = function(\n  double x, matrix[double] X, matrix[double] Y, matrix[double] K\n) return (double q) {\n\n  #first find the right knots for interpolation\n  i = as.integer(nrow(X) - sum(X >= x) + 1)\n\n  #calc the y as per the algo docs\n  t = (x - X[i-1,1]) / ( X[i,1] - X[i-1,1])\n\n  a =  K[i-1,1]*(X[i,1]-X[i-1,1]) - (Y[i,1]-Y[i-1,1])\n  b = -K[i,1]*(X[i,1]-X[i-1,1]) + (Y[i,1]-Y[i-1,1])\n\n  qm = (1-t)*Y[i-1,1] + t*Y[i,1] + t*(1-t)*(a*(1-t)+b*t)\n\n  q = as.scalar(qm)\n\n}\n";
        return string;
    }

    public String interpSpline__source() {
        String string = "interpSpline = function(\n  double x, matrix[double] X, matrix[double] Y, matrix[double] K\n) return (double q) {\n\n  #first find the right knots for interpolation\n  i = as.integer(nrow(X) - sum(X >= x) + 1)\n\n  #calc the y as per the algo docs\n  t = (x - X[i-1,1]) / ( X[i,1] - X[i-1,1])\n\n  a =  K[i-1,1]*(X[i,1]-X[i-1,1]) - (Y[i,1]-Y[i-1,1])\n  b = -K[i,1]*(X[i,1]-X[i-1,1]) + (Y[i,1]-Y[i-1,1])\n\n  qm = (1-t)*Y[i-1,1] + t*Y[i,1] + t*(1-t)*(a*(1-t)+b*t)\n\n  q = as.scalar(qm)\n\n}\n";
        return string;
    }

    public Matrix calcKnotsDerivKs(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/algorithms/CsplineCG.dml') as mlcontextns;K = mlcontextns::calcKnotsDerivKs(X, Y, max_iteration, tolerance, fileLog);";
        Script script = new Script(string);
        script.in("X", object).in("Y", object2).in("max_iteration", object3).in("tolerance", object4).in("fileLog", object5).out("K");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("K");
        return matrix;
    }

    public String calcKnotsDerivKs__docs() {
        String string = "calcKnotsDerivKs = function (\n  matrix[double] X, matrix[double] Y,\n  int max_iteration,\n  double tolerance,\n  String fileLog\n) return (matrix[double] K) {\n\n  nx = nrow(X)\n  ny = nrow(Y)\n  if (nx != ny) {\n      stop(\"X and Y vectors are of different size\")\n  }\n\n  Xu = trunc(X, 1, \"up\") # Xu is (X where X[0] is removed)\n  Xd = trunc(X, 1, \"down\") # Xd is (X where X[n] is removed)\n\n  Bx=1/(Xu-Xd) # The expr => 1/Delta(X(i) = 1/(X(i)-X(i-1))\n\n\n  Bxd = resize(Bx, 1, 0, \"tr\") # Bxd is (0, Bx) vector\n  Bxu = resize(Bx, 1, 0, \"br\") # Bxu is (Bx, 0) vector\n  Dx = 2*(Bxd + Bxu) # the major diagonal entry 2(1/Delta(X(i) + 1/Delta(X(i+1)))\n\n  MDx = diag(Dx) # convert vector to diagonal matrix\n\n  MBx = diag(Bx) # this is the temp diagonal matrix, which will form the bands of the tri-diagonal matrix\n  MUx = resize(MBx, 1, 1, \"bl\") # the upper diagonal matrix of the band\n  MLx = resize(MBx, 1, 1, \"tr\") # the lower diagonal matrix of the band\n\n  A=MUx+MDx+MLx # create the complete tri-diagonal matrix\n\n  #calculate b matrix\n  Yu = trunc(Y, 1, \"up\") # Yu is (Y where Y[0] is removed)\n  Yd = trunc(Y, 1, \"down\") # Yd is (Y where Y[n] is removed)\n  By=(Yu-Yd)/(Bx*Bx) # the expr => Delta(Y(i))/Delta(X(i))*Delta(X(i))\n\n  By1=resize(By, 1, 0, \"tr\") # By1 is (0, By) vector\n  By2=resize(By, 1, 0, \"br\") # By2 is (By, 0) vector\n  b=3*(By1+By2) # the b entries 3*(Delta(Y(i))/Delta(X(i))*Delta(X(i)) + Delta(Y(i+1))/Delta(X(i+1))*Delta(X(i+1)))\n\n\n  # solve Ax = b for x vector and assign it to K\n  K = CGSolver(A, b,\n                   max_iteration, tolerance, fileLog)\n\n}\n";
        return string;
    }

    public String calcKnotsDerivKs__source() {
        String string = "calcKnotsDerivKs = function (\n  matrix[double] X, matrix[double] Y,\n  int max_iteration,\n  double tolerance,\n  String fileLog\n) return (matrix[double] K) {\n\n  nx = nrow(X)\n  ny = nrow(Y)\n  if (nx != ny) {\n      stop(\"X and Y vectors are of different size\")\n  }\n\n  Xu = trunc(X, 1, \"up\") # Xu is (X where X[0] is removed)\n  Xd = trunc(X, 1, \"down\") # Xd is (X where X[n] is removed)\n\n  Bx=1/(Xu-Xd) # The expr => 1/Delta(X(i) = 1/(X(i)-X(i-1))\n\n\n  Bxd = resize(Bx, 1, 0, \"tr\") # Bxd is (0, Bx) vector\n  Bxu = resize(Bx, 1, 0, \"br\") # Bxu is (Bx, 0) vector\n  Dx = 2*(Bxd + Bxu) # the major diagonal entry 2(1/Delta(X(i) + 1/Delta(X(i+1)))\n\n  MDx = diag(Dx) # convert vector to diagonal matrix\n\n  MBx = diag(Bx) # this is the temp diagonal matrix, which will form the bands of the tri-diagonal matrix\n  MUx = resize(MBx, 1, 1, \"bl\") # the upper diagonal matrix of the band\n  MLx = resize(MBx, 1, 1, \"tr\") # the lower diagonal matrix of the band\n\n  A=MUx+MDx+MLx # create the complete tri-diagonal matrix\n\n  #calculate b matrix\n  Yu = trunc(Y, 1, \"up\") # Yu is (Y where Y[0] is removed)\n  Yd = trunc(Y, 1, \"down\") # Yd is (Y where Y[n] is removed)\n  By=(Yu-Yd)/(Bx*Bx) # the expr => Delta(Y(i))/Delta(X(i))*Delta(X(i))\n\n  By1=resize(By, 1, 0, \"tr\") # By1 is (0, By) vector\n  By2=resize(By, 1, 0, \"br\") # By2 is (By, 0) vector\n  b=3*(By1+By2) # the b entries 3*(Delta(Y(i))/Delta(X(i))*Delta(X(i)) + Delta(Y(i+1))/Delta(X(i+1))*Delta(X(i+1)))\n\n\n  # solve Ax = b for x vector and assign it to K\n  K = CGSolver(A, b,\n                   max_iteration, tolerance, fileLog)\n\n}\n";
        return string;
    }

    public Matrix trunc(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/CsplineCG.dml') as mlcontextns;Y = mlcontextns::trunc(X, by, dir);";
        Script script = new Script(string);
        script.in("X", object).in("by", object2).in("dir", object3).out("Y");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Y");
        return matrix;
    }

    public String trunc__docs() {
        String string = "trunc = function (\n  matrix[double] X, # nxm matrix\n  int by, # shift amount\n  String dir # currently only 'up' is supported. but should handle 'up', 'down', 'left', 'right'\n) return (matrix[double] Y) # Y is\n{\n    r = nrow(X); c = ncol(X);\n    if (by > r) {\n      stop(\"can't pop matrix more than number of rows\")\n    }\n    Y = matrix(0.0, r-by, c)\n\n    if (r != by ) {\n      if (dir == \"up\") {\n        Y[1:r-by,] = X[1+by:r,]\n      } else if (dir == \"down\") {\n        Y[1:r-by,] = X[1:r-by,]\n      } else {\n        stop(\"trunc unsupported direction \" + dir)\n      }\n    }\n}\n";
        return string;
    }

    public String trunc__source() {
        String string = "trunc = function (\n  matrix[double] X, # nxm matrix\n  int by, # shift amount\n  String dir # currently only 'up' is supported. but should handle 'up', 'down', 'left', 'right'\n) return (matrix[double] Y) # Y is\n{\n    r = nrow(X); c = ncol(X);\n    if (by > r) {\n      stop(\"can't pop matrix more than number of rows\")\n    }\n    Y = matrix(0.0, r-by, c)\n\n    if (r != by ) {\n      if (dir == \"up\") {\n        Y[1:r-by,] = X[1+by:r,]\n      } else if (dir == \"down\") {\n        Y[1:r-by,] = X[1:r-by,]\n      } else {\n        stop(\"trunc unsupported direction \" + dir)\n      }\n    }\n}\n";
        return string;
    }

    public Matrix resize(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/algorithms/CsplineCG.dml') as mlcontextns;Y = mlcontextns::resize(X, rby, cby, dir);";
        Script script = new Script(string);
        script.in("X", object).in("rby", object2).in("cby", object3).in("dir", object4).out("Y");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Y");
        return matrix;
    }

    public String resize__docs() {
        String string = "resize = function(\n  matrix[double] X, #nxm matrix\n  int rby, # row resize count\n  int cby,  # col resize count\n  String dir\n) return (matrix[double] Y) # Y is\n{\n   r = nrow(X); c = ncol(X);\n   rn = r + rby; cn = c + cby;\n   Y = matrix(0.0, rn, cn)\n   if (dir == \"tr\") { # top right\n     Y[1+rby:rn, 1:c] = X\n   } else if (dir == \"bl\") { # bottom left\n     Y[1:r, 1+cby:cn] = X\n   } else if (dir == \"tl\") { # top left\n     Y[1+rby:rn, 1+cby:cn ] = X\n   } else if (dir == \"br\") { # bottom right\n     Y[1:r, 1:c] = X\n   } else {\n     stop(\"Unknown direction dir => \" + dir)\n   }\n}\n";
        return string;
    }

    public String resize__source() {
        String string = "resize = function(\n  matrix[double] X, #nxm matrix\n  int rby, # row resize count\n  int cby,  # col resize count\n  String dir\n) return (matrix[double] Y) # Y is\n{\n   r = nrow(X); c = ncol(X);\n   rn = r + rby; cn = c + cby;\n   Y = matrix(0.0, rn, cn)\n   if (dir == \"tr\") { # top right\n     Y[1+rby:rn, 1:c] = X\n   } else if (dir == \"bl\") { # bottom left\n     Y[1:r, 1+cby:cn] = X\n   } else if (dir == \"tl\") { # top left\n     Y[1+rby:rn, 1+cby:cn ] = X\n   } else if (dir == \"br\") { # bottom right\n     Y[1:r, 1:c] = X\n   } else {\n     stop(\"Unknown direction dir => \" + dir)\n   }\n}\n";
        return string;
    }

    public Matrix CGSolver(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/algorithms/CsplineCG.dml') as mlcontextns;x = mlcontextns::CGSolver(A, b, max_iteration, tolerance, fileLog);";
        Script script = new Script(string);
        script.in("A", object).in("b", object2).in("max_iteration", object3).in("tolerance", object4).in("fileLog", object5).out("x");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("x");
        return matrix;
    }

    public String CGSolver__docs() {
        String string = "CGSolver = function (\n matrix[double] A, matrix[double] b,\n int max_iteration,\n double tolerance,\n String fileLog\n) return (matrix[double] x) {\n\n  n = nrow(A)\n  if (max_iteration < 0) {\n    max_iteration = n\n  }\n  if (tolerance < 0) {\n    tolerance = 0.000001\n  }\n\n  x = matrix (0, rows = n, cols = 1); #/* solution vector x<nx1>*/\n";
        return string;
    }

    public String CGSolver__source() {
        String string = "CGSolver = function (\n matrix[double] A, matrix[double] b,\n int max_iteration,\n double tolerance,\n String fileLog\n) return (matrix[double] x) {\n\n  n = nrow(A)\n  if (max_iteration < 0) {\n    max_iteration = n\n  }\n  if (tolerance < 0) {\n    tolerance = 0.000001\n  }\n\n  x = matrix (0, rows = n, cols = 1); #/* solution vector x<nx1>*/\n\n  # BEGIN THE CONJUGATE GRADIENT ALGORITHM\n  print (\"Running the CG algorithm...\");\n\n  i = 0\n  r = -t(A) %*% b # initial guess x0 = t(0.0)\n  p = -r\n  norm_r2 = sum (r ^ 2)\n  norm_r2_initial = norm_r2\n  norm_r2_target = norm_r2_initial * tolerance ^ 2\n  print (\"||r|| initial value = \" + sqrt (norm_r2_initial) + \",  target value = \" + sqrt (norm_r2_target));\n  log_str = \"CG_RESIDUAL_NORM,0,\" + sqrt (norm_r2_initial)\n  log_str = append (log_str, \"CG_RESIDUAL_RATIO,0,1.0\")\n\n  while (i < max_iteration & norm_r2 > norm_r2_target) {\n    q = t(A) %*% (A %*% p)\n    a = norm_r2 / sum (p*q)\n    x = x + a*p\n    r = r + a*q\n    old_norm_r2 = norm_r2\n    norm_r2 = sum(r^2)\n    p = -r + (norm_r2/ old_norm_r2)*p\n    i = i + 1\n    print (\"Iteration \" + i + \":  ||r|| / ||r init|| = \" + sqrt (norm_r2 / norm_r2_initial))\n    log_str = append (log_str, \"CG_RESIDUAL_NORM,\"  + i + \",\" + sqrt (norm_r2))\n    log_str = append (log_str, \"CG_RESIDUAL_RATIO,\" + i + \",\" + sqrt (norm_r2 / norm_r2_initial))\n  }\n  if (i >= max_iteration) {\n    print (\"Warning: the maximum number of iterations has been reached.\")\n  }\n\n  print (\"The CG algorithm is done.\")\n  # END THE CONJUGATE GRADIENT ALGORITHM\n\n  if (fileLog != \" \") {\n    write (log_str, fileLog);\n  } else {\n    print(\"log_str:\" + log_str)\n  }\n}\n";
        return string;
    }
}

