/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.optim.rmsprop.Update_output;

public class Rmsprop
extends Script {
    public Rmsprop() {
        String string = "scripts/nn/optim/rmsprop.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix init(Object object) {
        String string = "source('scripts/nn/optim/rmsprop.dml') as mlcontextns;cache = mlcontextns::init(X);";
        Script script = new Script(string);
        script.in("X", object).out("cache");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("cache");
        return matrix;
    }

    public String init__docs() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] cache) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - cache: State that maintains the moving average of the squared\n   *      gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] cache) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - cache: State that maintains the moving average of the squared\n   *      gradients, of same shape as `X`.\n   */\n  cache = matrix(0, rows=nrow(X), cols=ncol(X))\n}\n";
        return string;
    }

    public Update_output update(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/optim/rmsprop.dml') as mlcontextns;[X, cache] = mlcontextns::update(X, dX, lr, decay_rate, epsilon, cache);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).in("decay_rate", object4).in("epsilon", object5).in("cache", object6).out("X").out("cache");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Matrix matrix2 = mLResults.getMatrix("cache");
        Update_output update_output = new Update_output(matrix, matrix2);
        return update_output;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double decay_rate,\n                  double epsilon, matrix[double] cache)\n    return (matrix[double] X, matrix[double] cache) {\n  /*\n   * Performs an RMSprop update.\n   *\n   * This is an adaptive learning rate optimizer that can be viewed\n   * as an adjustment of the Adagrad method to use a moving average\n   * of the sum of squared gradients in order to improve convergence.\n   *\n   * Reference:\n   *  - Neural Networks for Machine Learning, Lecture 6a, Hinton,\n   *    slide 29.\n   *    - http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - decay_rate: Term controlling the rate of the moving average.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-8, 1e-4].\n   *  - cache: State that maintains the moving average of the squared\n   *      gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - cache: Updated state that maintains the moving average of the\n   *      squared gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double decay_rate,\n                  double epsilon, matrix[double] cache)\n    return (matrix[double] X, matrix[double] cache) {\n  /*\n   * Performs an RMSprop update.\n   *\n   * This is an adaptive learning rate optimizer that can be viewed\n   * as an adjustment of the Adagrad method to use a moving average\n   * of the sum of squared gradients in order to improve convergence.\n   *\n   * Reference:\n   *  - Neural Networks for Machine Learning, Lecture 6a, Hinton,\n   *    slide 29.\n   *    - http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - decay_rate: Term controlling the rate of the moving average.\n   *      Typical values are in the range of [0.9, 0.999].\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-8, 1e-4].\n   *  - cache: State that maintains the moving average of the squared\n   *      gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - cache: Updated state that maintains the moving average of the\n   *      squared gradients, of same shape as `X`.\n   */\n  cache = decay_rate*cache + (1-decay_rate)*dX^2\n  X = X - (lr * dX / (sqrt(cache)+epsilon))\n}\n";
        return string;
    }
}

