/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CumulativeSplitAggregate
extends Lop {
    private double _initValue = 0.0;

    public CumulativeSplitAggregate(Lop input, Expression.DataType dt, Expression.ValueType vt, double init) {
        super(Lop.Type.CumulativeSplitAggregate, dt, vt);
        this._initValue = init;
        this.init(input, dt, vt, LopProperties.ExecType.MR);
    }

    private void init(Lop input, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.GMR);
        this.lps.addCompatibility(JobType.DATAGEN);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "CumulativeSplitAggregate";
    }

    private static String getOpcode() {
        return "ucumsplit";
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(CumulativeSplitAggregate.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append(String.valueOf(this._initValue));
        return sb.toString();
    }
}

