/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import scala.Tuple2;

public class ConvertFrameBlockToIJVLines
implements FlatMapFunction<Tuple2<Long, FrameBlock>, String> {
    private static final long serialVersionUID = 1803516615963340115L;

    public Iterator<String> call(Tuple2<Long, FrameBlock> kv) throws Exception {
        long rowoffset = (Long)kv._1;
        FrameBlock block = (FrameBlock)kv._2;
        ArrayList<String> cells = new ArrayList<String>();
        if (rowoffset == 1L) {
            for (int j = 0; j < block.getNumColumns(); ++j) {
                if (block.isColumnMetadataDefault(j)) continue;
                cells.add("-1 " + (j + 1) + " " + block.getColumnMetadata(j).getNumDistinct());
                cells.add("-2 " + (j + 1) + " " + block.getColumnMetadata(j).getMvValue());
            }
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String[]> iter = block.getStringRowIterator();
        int i = 0;
        while (iter.hasNext()) {
            String rowIndex = Long.toString(rowoffset + (long)i);
            String[] row = iter.next();
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == null) continue;
                sb.append(rowIndex);
                sb.append(' ');
                sb.append(j + 1);
                sb.append(' ');
                sb.append(row[j]);
                cells.add(sb.toString());
                sb.setLength(0);
            }
            ++i;
        }
        return cells.iterator();
    }
}

