/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class CentralMoment
extends Lop {
    private void init(Lop input1, Lop input2, Lop input3, Types.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        if (input3 != null) {
            this.addInput(input3);
            input3.addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    public CentralMoment(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this(input1, input2, null, dt, vt, et);
    }

    public CentralMoment(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.CentralMoment, dt, vt);
        this.init(input1, input2, input3, et);
    }

    @Override
    public String toString() {
        return "Operation = CentralMoment";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        if (input3 == null) {
            return InstructionUtils.concatOperands(this.getExecType().toString(), "cm", this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(input3 != null ? 2 : 1).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
        }
        return InstructionUtils.concatOperands(this.getExecType().toString(), "cm", this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(input3 != null ? 2 : 1).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }
}

