/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.CompressionSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class DeCompressionSPInstruction
extends UnarySPInstruction {
    private DeCompressionSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.DeCompression, op, in, out, opcode, istr);
    }

    public static DeCompressionSPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        return new DeCompressionSPInstruction(null, new CPOperand(parts[1]), new CPOperand(parts[2]), parts[0], str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = in.mapValues((Function)new CompressionSPInstruction.CompressionFunction());
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.input1.getName(), this.output.getName());
    }

    public static class DeCompressionFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = -6528833083609413922L;

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            if (arg0 instanceof CompressedMatrixBlock) {
                return ((CompressedMatrixBlock)arg0).decompress(OptimizerUtils.getConstrainedNumThreads(-1));
            }
            return arg0;
        }
    }
}

