/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToChar
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    private final char[] _data;

    public MapToChar(int unique, int size) {
        super(unique);
        this._data = new char[size];
    }

    public MapToChar(int unique, char[] data) {
        super(unique);
        this._data = data;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (char)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToChar.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        return size += MemoryEstimates.charArrayCost(dataLength);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 2;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (char)v;
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void replace(int v, int r) {
        char cv = (char)v;
        char rv = (char)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.CHAR.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeChar(this._data[i]);
        }
    }

    public static MapToChar readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data = new char[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readChar();
        }
        return new MapToChar(unique, data);
    }

    public char[] getChars() {
        return this._data;
    }
}

