/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class OffsetByte
extends AOffset {
    private static final long serialVersionUID = -4716104973912491790L;
    private static final int maxV = 255;
    private final byte[] offsets;
    private final int offsetToFirst;
    private final int offsetToLast;
    private final boolean noOverHalf;
    private final boolean noZero;

    public OffsetByte(int[] indexes) {
        this(indexes, 0, indexes.length);
    }

    public OffsetByte(int[] indexes, int apos, int alen) {
        int endSize = 0;
        this.offsetToFirst = indexes[apos];
        this.offsetToLast = indexes[alen - 1];
        int ov = this.offsetToFirst;
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            endSize += 1 + (nv - ov - 1) / 255;
            ov = nv;
        }
        this.noZero = endSize == alen - apos - 1;
        this.offsets = new byte[endSize];
        ov = this.offsetToFirst;
        int p = 0;
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            int offsetSize = nv - ov;
            int div = offsetSize / 255;
            int mod = offsetSize % 255;
            if (mod == 0) {
                p += div - 1;
                this.offsets[p++] = -1;
            } else {
                p += div;
                this.offsets[p++] = (byte)mod;
            }
            ov = nv;
        }
        this.noOverHalf = this.getNoOverHalf();
    }

    protected OffsetByte(byte[] offsets, int offsetToFirst, int offsetToLast) {
        this.offsets = offsets;
        this.offsetToFirst = offsetToFirst;
        this.offsetToLast = offsetToLast;
        this.noOverHalf = this.getNoOverHalf();
        this.noZero = this.getNoZero();
    }

    private boolean getNoOverHalf() {
        boolean noOverHalf = true;
        for (byte b : this.offsets) {
            if (b >= 1) continue;
            noOverHalf = false;
            break;
        }
        return noOverHalf;
    }

    private boolean getNoZero() {
        boolean noZero = true;
        for (byte b : this.offsets) {
            if (b != 0) continue;
            noZero = false;
            break;
        }
        return noZero;
    }

    @Override
    public AIterator getIterator() {
        if (this.noOverHalf) {
            return new IterateByteOffsetNoOverHalf();
        }
        if (this.noZero) {
            return new IterateByteOffsetNoZero();
        }
        return new IterateByteOffset();
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        if (this.noOverHalf) {
            return new OffsetByteIteratorNoOverHalf();
        }
        if (this.noZero) {
            return new OffsetByteIteratorNoZero();
        }
        return new OffsetByteIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE.BYTE.ordinal());
        out.writeInt(this.offsetToFirst);
        out.writeInt(this.offsets.length);
        out.writeInt(this.offsetToLast);
        for (byte o : this.offsets) {
            out.writeByte(o);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13 + this.offsets.length;
    }

    @Override
    public int getSize() {
        if (this.noZero) {
            return this.offsets.length + 1;
        }
        int size = 1;
        for (byte b : this.offsets) {
            if (b == 0) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getOffsetToFirst() {
        return this.offsetToFirst;
    }

    @Override
    public int getOffsetToLast() {
        return this.offsetToLast;
    }

    @Override
    public int getOffsetsLength() {
        return this.offsets.length;
    }

    @Override
    public long getInMemorySize() {
        return OffsetByte.estimateInMemorySize(this.offsets.length);
    }

    public static long estimateInMemorySize(int nOffs) {
        long size = 32L;
        return size += MemoryEstimates.byteArrayCost(nOffs);
    }

    public static OffsetByte readFields(DataInput in) throws IOException {
        int offsetToFirst = in.readInt();
        int offsetsLength = in.readInt();
        int offsetToLast = in.readInt();
        byte[] offsets = new byte[offsetsLength];
        for (int i = 0; i < offsetsLength; ++i) {
            offsets[i] = in.readByte();
        }
        return new OffsetByte(offsets, offsetToFirst, offsetToLast);
    }

    private class OffsetByteIteratorNoZero
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoZero() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByte.this.offsets[this.index++] & 0xFF;
        }
    }

    private class OffsetByteIterator
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIterator() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            ++this.index;
            return this.offset += v & 0xFF;
        }
    }

    private class OffsetByteIteratorNoOverHalf
    extends AOffsetIterator {
        protected int index;

        private OffsetByteIteratorNoOverHalf() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
        }

        @Override
        public int next() {
            return this.offset += OffsetByte.this.offsets[this.index++];
        }
    }

    private class IterateByteOffsetNoOverHalf
    extends IterateByteOffsetNoZero {
        private IterateByteOffsetNoOverHalf() {
        }

        private IterateByteOffsetNoOverHalf(int index, int offset) {
            super(index, offset);
        }

        @Override
        public final int next() {
            this.offset += OffsetByte.this.offsets[this.index];
            ++this.index;
            return this.offset;
        }

        @Override
        public final int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                this.offset += OffsetByte.this.offsets[this.index];
                ++this.index;
            }
            return this.offset;
        }

        @Override
        public final IterateByteOffsetNoOverHalf clone() {
            return new IterateByteOffsetNoOverHalf(this.index, this.offset);
        }
    }

    private class IterateByteOffsetNoZero
    extends AIterator {
        protected int index;

        private IterateByteOffsetNoZero() {
            super(OffsetByte.this.offsetToFirst);
        }

        private IterateByteOffsetNoZero(int index, int offset) {
            super(offset);
            this.index = index;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            this.offset += v & 0xFF;
            ++this.index;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                this.next();
            }
            return this.offset;
        }

        @Override
        public IterateByteOffsetNoZero clone() {
            return new IterateByteOffsetNoZero(this.index, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.index;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }

    private class IterateByteOffset
    extends AIterator {
        protected int index;
        protected int dataIndex;

        private IterateByteOffset() {
            super(OffsetByte.this.offsetToFirst);
            this.index = 0;
            this.dataIndex = 0;
        }

        private IterateByteOffset(int index, int dataIndex, int offset) {
            super(offset);
            this.index = index;
            this.dataIndex = dataIndex;
        }

        @Override
        public int next() {
            byte v = OffsetByte.this.offsets[this.index];
            while (v == 0) {
                this.offset += 255;
                ++this.index;
                v = OffsetByte.this.offsets[this.index];
            }
            this.offset += v & 0xFF;
            ++this.index;
            ++this.dataIndex;
            return this.offset;
        }

        @Override
        public int skipTo(int idx) {
            if (idx < OffsetByte.this.offsetToLast) {
                while (this.offset < idx) {
                    this.next();
                }
            } else {
                while (this.offset < idx && this.index < OffsetByte.this.offsets.length) {
                    this.next();
                }
            }
            return this.offset;
        }

        @Override
        public IterateByteOffset clone() {
            return new IterateByteOffset(this.index, this.dataIndex, this.offset);
        }

        @Override
        public int getDataIndex() {
            return this.dataIndex;
        }

        @Override
        public int getOffsetsIndex() {
            return this.index;
        }
    }
}

