/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.PrivacyUtils;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;
import org.apache.sysds.runtime.privacy.propagation.Propagator;

public abstract class AppendPropagator
implements Propagator {
    protected MatrixBlock input1;
    protected MatrixBlock input2;
    protected PrivacyConstraint privacyConstraint1;
    protected PrivacyConstraint privacyConstraint2;

    public AppendPropagator(MatrixBlock input1, PrivacyConstraint privacyConstraint1, MatrixBlock input2, PrivacyConstraint privacyConstraint2) {
        this.setFields(input1, privacyConstraint1, input2, privacyConstraint2);
    }

    public void setFields(MatrixBlock input1, PrivacyConstraint privacyConstraint1, MatrixBlock input2, PrivacyConstraint privacyConstraint2) {
        this.input1 = input1;
        this.input2 = input2;
        this.privacyConstraint1 = privacyConstraint1;
        this.privacyConstraint2 = privacyConstraint2;
    }

    @Override
    public PrivacyConstraint propagate() {
        PrivacyConstraint mergedPrivacyConstraint = new PrivacyConstraint();
        this.propagateInput1Constraint(mergedPrivacyConstraint);
        this.propagateInput2Constraint(mergedPrivacyConstraint);
        return mergedPrivacyConstraint;
    }

    private void propagateInput1Constraint(PrivacyConstraint mergedPrivacyConstraint) {
        if (PrivacyUtils.privacyConstraintActivated(this.privacyConstraint1)) {
            long[] endDims = new long[]{this.input1.getNumRows() - 1, this.input1.getNumColumns() - 1};
            mergedPrivacyConstraint.getFineGrainedPrivacy().put(new DataRange(new long[]{0L, 0L}, endDims), this.privacyConstraint1.getPrivacyLevel());
        }
        if (PrivacyUtils.privacyConstraintFineGrainedActivated(this.privacyConstraint1)) {
            this.privacyConstraint1.getFineGrainedPrivacy().getAllConstraintsList().forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> mergedPrivacyConstraint.getFineGrainedPrivacy().put((DataRange)constraint.getKey(), (PrivacyConstraint.PrivacyLevel)((Object)((Object)constraint.getValue())))));
        }
    }

    private void propagateInput2Constraint(PrivacyConstraint mergedPrivacyConstraint) {
        if (PrivacyUtils.privacyConstraintActivated(this.privacyConstraint2)) {
            long[] endDims = new long[]{this.input2.getNumRows() - 1, this.input2.getNumColumns() - 1};
            this.appendInput2(mergedPrivacyConstraint.getFineGrainedPrivacy(), new DataRange(new long[]{0L, 0L}, endDims), this.privacyConstraint2.getPrivacyLevel());
        }
        if (PrivacyUtils.privacyConstraintFineGrainedActivated(this.privacyConstraint2)) {
            this.privacyConstraint2.getFineGrainedPrivacy().getAllConstraintsList().forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> this.appendInput2(mergedPrivacyConstraint.getFineGrainedPrivacy(), (DataRange)constraint.getKey(), (PrivacyConstraint.PrivacyLevel)((Object)((Object)constraint.getValue())))));
        }
    }

    protected abstract void appendInput2(FineGrainedPrivacy var1, DataRange var2, PrivacyConstraint.PrivacyLevel var3);
}

