/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils.stats;

import java.util.concurrent.atomic.LongAdder;

public class CodegenStatistics {
    private static final LongAdder compileTime = new LongAdder();
    private static final LongAdder classCompileTime = new LongAdder();
    private static final LongAdder hopCompile = new LongAdder();
    private static final LongAdder cPlanCompile = new LongAdder();
    private static final LongAdder classCompile = new LongAdder();
    private static final LongAdder enumAll = new LongAdder();
    private static final LongAdder enumAllP = new LongAdder();
    private static final LongAdder enumEval = new LongAdder();
    private static final LongAdder enumEvalP = new LongAdder();
    private static final LongAdder opCacheHits = new LongAdder();
    private static final LongAdder opCacheTotal = new LongAdder();
    private static final LongAdder planCacheHits = new LongAdder();
    private static final LongAdder planCacheTotal = new LongAdder();

    public static void incrementDAGCompile() {
        hopCompile.increment();
    }

    public static void incrementCPlanCompile(long delta) {
        cPlanCompile.add(delta);
    }

    public static void incrementEnumAll(long delta) {
        enumAll.add(delta);
    }

    public static void incrementEnumAllP(long delta) {
        enumAllP.add(delta);
    }

    public static void incrementEnumEval(long delta) {
        enumEval.add(delta);
    }

    public static void incrementEnumEvalP(long delta) {
        enumEvalP.add(delta);
    }

    public static void incrementClassCompile() {
        classCompile.increment();
    }

    public static void incrementCompileTime(long delta) {
        compileTime.add(delta);
    }

    public static void incrementClassCompileTime(long delta) {
        classCompileTime.add(delta);
    }

    public static void incrementOpCacheHits() {
        opCacheHits.increment();
    }

    public static void incrementOpCacheTotal() {
        opCacheTotal.increment();
    }

    public static void incrementPlanCacheHits() {
        planCacheHits.increment();
    }

    public static void incrementPlanCacheTotal() {
        planCacheTotal.increment();
    }

    public static long getDAGCompile() {
        return hopCompile.longValue();
    }

    public static long getCPlanCompile() {
        return cPlanCompile.longValue();
    }

    public static long getEnumAll() {
        return enumAll.longValue();
    }

    public static long getEnumAllP() {
        return enumAllP.longValue();
    }

    public static long getEnumEval() {
        return enumEval.longValue();
    }

    public static long getEnumEvalP() {
        return enumEvalP.longValue();
    }

    public static long getClassCompile() {
        return classCompile.longValue();
    }

    public static long getCompileTime() {
        return compileTime.longValue();
    }

    public static long getClassCompileTime() {
        return classCompileTime.longValue();
    }

    public static long getOpCacheHits() {
        return opCacheHits.longValue();
    }

    public static long getOpCacheTotal() {
        return opCacheTotal.longValue();
    }

    public static long getPlanCacheHits() {
        return planCacheHits.longValue();
    }

    public static long getPlanCacheTotal() {
        return planCacheTotal.longValue();
    }

    public static void reset() {
        hopCompile.reset();
        cPlanCompile.reset();
        classCompile.reset();
        enumAll.reset();
        enumAllP.reset();
        enumEval.reset();
        enumEvalP.reset();
        compileTime.reset();
        classCompileTime.reset();
        opCacheHits.reset();
        opCacheTotal.reset();
        planCacheHits.reset();
        planCacheTotal.reset();
    }

    public static String displayStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Codegen compile (DAG,CP,JC):\t" + CodegenStatistics.getDAGCompile() + "/" + CodegenStatistics.getCPlanCompile() + "/" + CodegenStatistics.getClassCompile() + ".\n");
        sb.append("Codegen enum (ALLt/p,EVALt/p):\t" + CodegenStatistics.getEnumAll() + "/" + CodegenStatistics.getEnumAllP() + "/" + CodegenStatistics.getEnumEval() + "/" + CodegenStatistics.getEnumEvalP() + ".\n");
        sb.append("Codegen compile times (DAG,JC):\t" + String.format("%.3f", (double)CodegenStatistics.getCompileTime() / 1.0E9) + "/" + String.format("%.3f", (double)CodegenStatistics.getClassCompileTime() / 1.0E9) + " sec.\n");
        sb.append("Codegen enum plan cache hits:\t" + CodegenStatistics.getPlanCacheHits() + "/" + CodegenStatistics.getPlanCacheTotal() + ".\n");
        sb.append("Codegen op plan cache hits:\t" + CodegenStatistics.getOpCacheHits() + "/" + CodegenStatistics.getOpCacheTotal() + ".\n");
        return sb.toString();
    }
}

