/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerLaunchContext {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ContainerLaunchContext newInstance(Map<String, LocalResource> localResources, Map<String, String> environment, List<String> commands, Map<String, ByteBuffer> serviceData, ByteBuffer tokens, Map<ApplicationAccessType, String> acls) {
        return ContainerLaunchContext.newInstance(localResources, environment, commands, serviceData, tokens, acls, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ContainerLaunchContext newInstance(Map<String, LocalResource> localResources, Map<String, String> environment, List<String> commands, Map<String, ByteBuffer> serviceData, ByteBuffer tokens, Map<ApplicationAccessType, String> acls, ContainerRetryContext containerRetryContext) {
        ContainerLaunchContext container = Records.newRecord(ContainerLaunchContext.class);
        container.setLocalResources(localResources);
        container.setEnvironment(environment);
        container.setCommands(commands);
        container.setServiceData(serviceData);
        container.setTokens(tokens);
        container.setApplicationACLs(acls);
        container.setContainerRetryContext(containerRetryContext);
        return container;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ByteBuffer getTokens();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setTokens(ByteBuffer var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ByteBuffer getTokensConf();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setTokensConf(ByteBuffer var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<String, LocalResource> getLocalResources();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setLocalResources(Map<String, LocalResource> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<String, ByteBuffer> getServiceData();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setServiceData(Map<String, ByteBuffer> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<String, String> getEnvironment();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setEnvironment(Map<String, String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<String> getCommands();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setCommands(List<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<ApplicationAccessType, String> getApplicationACLs();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationACLs(Map<ApplicationAccessType, String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ContainerRetryContext getContainerRetryContext();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerRetryContext(ContainerRetryContext var1);
}

