/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.r.RAuthHelper;
import org.apache.spark.api.r.RBackend;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.internal.config.R$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileIntRef;
import scala.runtime.VolatileObjectRef;

public final class RRunner$ {
    public static RRunner$ MODULE$;

    static {
        new RRunner$();
    }

    public void main(String[] args) {
        String rFile = PythonRunner$.MODULE$.formatPath(args[0], PythonRunner$.MODULE$.formatPath$default$2());
        String[] otherArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(1, args.length);
        int backendTimeout = new StringOps(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARKR_BACKEND_TIMEOUT", (Function0 & Serializable & scala.Serializable)() -> "120"))).toInt();
        ObjectRef cmd = ObjectRef.create((Object)((String)scala.sys.package$.MODULE$.props().getOrElse((Object)R$.MODULE$.SPARKR_COMMAND().key(), (Function0 & Serializable & scala.Serializable)() -> (String)R$.MODULE$.SPARKR_COMMAND().defaultValue().get())));
        cmd.elem = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)R$.MODULE$.R_COMMAND().key(), (Function0 & Serializable & scala.Serializable)() -> (String)cmd$1.elem);
        Object object = scala.sys.package$.MODULE$.props().getOrElse((Object)package$.MODULE$.SUBMIT_DEPLOY_MODE().key(), (Function0 & Serializable & scala.Serializable)() -> "client");
        String string = "client";
        if (!(object != null ? !object.equals(string) : string != null)) {
            cmd.elem = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.r.driver.command", (Function0 & Serializable & scala.Serializable)() -> (String)cmd$1.elem);
        }
        String rCommand = (String)cmd.elem;
        String backendConnectionTimeout = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)R$.MODULE$.R_BACKEND_CONNECTION_TIMEOUT().key(), (Function0 & Serializable & scala.Serializable)() -> R$.MODULE$.R_BACKEND_CONNECTION_TIMEOUT().defaultValue().get().toString());
        File rF = new File(rFile);
        String rFileNormalized = !rF.exists() ? new Path(rFile).getName() : rFile;
        RBackend sparkRBackend = new RBackend();
        VolatileIntRef sparkRBackendPort = VolatileIntRef.create((int)0);
        VolatileObjectRef sparkRBackendSecret = VolatileObjectRef.create(null);
        Semaphore initialized = new Semaphore(0);
        Thread sparkRBackendThread = new Thread(sparkRBackend, sparkRBackendPort, sparkRBackendSecret, initialized){
            private final RBackend sparkRBackend$1;
            private final VolatileIntRef sparkRBackendPort$1;
            private final VolatileObjectRef sparkRBackendSecret$1;
            private final Semaphore initialized$1;

            public void run() {
                Tuple2<Object, RAuthHelper> tuple2 = this.sparkRBackend$1.init();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int port = tuple2._1$mcI$sp();
                RAuthHelper authHelper = (RAuthHelper)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)port), (Object)authHelper);
                int port2 = tuple22._1$mcI$sp();
                RAuthHelper authHelper2 = (RAuthHelper)tuple22._2();
                this.sparkRBackendPort$1.elem = port2;
                this.sparkRBackendSecret$1.elem = authHelper2.secret();
                this.initialized$1.release();
                this.sparkRBackend$1.run();
            }
            {
                this.sparkRBackend$1 = sparkRBackend$1;
                this.sparkRBackendPort$1 = sparkRBackendPort$1;
                this.sparkRBackendSecret$1 = sparkRBackendSecret$1;
                this.initialized$1 = initialized$1;
                super("SparkR backend");
            }
        };
        sparkRBackendThread.start();
        if (initialized.tryAcquire(backendTimeout, TimeUnit.SECONDS)) {
            int n;
            try {
                ProcessBuilder builder = new ProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)new .colon.colon((Object)rCommand, (List)new .colon.colon((Object)rFileNormalized, (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Seq$.MODULE$.canBuildFrom())).asJava());
                Map<String, String> env = builder.environment();
                env.put("EXISTING_SPARKR_BACKEND_PORT", Integer.toString(sparkRBackendPort.elem));
                env.put("SPARKR_BACKEND_CONNECTION_TIMEOUT", backendConnectionTimeout);
                Seq<String> rPackageDir = RUtils$.MODULE$.sparkRPackagePath(true);
                env.put("SPARKR_PACKAGE_DIR", rPackageDir.mkString(","));
                env.put("R_PROFILE_USER", ((TraversableOnce)new .colon.colon((Object)((String)rPackageDir.apply(0)), (List)new .colon.colon((Object)"SparkR", (List)new .colon.colon((Object)"profile", (List)new .colon.colon((Object)"general.R", (List)Nil$.MODULE$))))).mkString(File.separator));
                env.put("SPARKR_BACKEND_AUTH_SECRET", (String)sparkRBackendSecret.elem);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                new RedirectThread(process.getInputStream(), System.out, "redirect R output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
                n = process.waitFor();
            }
            finally {
                sparkRBackend.close();
            }
            int returnCode = n;
            if (returnCode != 0) {
                throw new SparkUserAppException(returnCode);
            }
            return;
        }
        String errorMessage = new StringBuilder(45).append("SparkR backend did not initialize in ").append(backendTimeout).append(" seconds").toString();
        System.err.println(errorMessage);
        throw new SparkException(errorMessage);
    }

    private RRunner$() {
        MODULE$ = this;
    }
}

