/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.FrameReaderBinaryBlock;
import org.apache.sysds.runtime.io.FrameReaderBinaryBlockParallel;
import org.apache.sysds.runtime.io.FrameReaderProto;
import org.apache.sysds.runtime.io.FrameReaderTextCSV;
import org.apache.sysds.runtime.io.FrameReaderTextCSVParallel;
import org.apache.sysds.runtime.io.FrameReaderTextCell;
import org.apache.sysds.runtime.io.FrameReaderTextCellParallel;

public class FrameReaderFactory {
    protected static final Log LOG = LogFactory.getLog((String)FrameReaderFactory.class.getName());

    public static FrameReader createFrameReader(Types.FileFormat fmt) {
        FileFormatPropertiesCSV props = fmt == Types.FileFormat.CSV ? new FileFormatPropertiesCSV() : null;
        return FrameReaderFactory.createFrameReader(fmt, props);
    }

    public static FrameReader createFrameReader(Types.FileFormat fmt, FileFormatProperties props) {
        boolean textParallel = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS);
        boolean binaryParallel = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS);
        switch (fmt) {
            case TEXT: {
                return textParallel ? new FrameReaderTextCellParallel() : new FrameReaderTextCell();
            }
            case CSV: {
                if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
                }
                FileFormatPropertiesCSV fp = (FileFormatPropertiesCSV)props;
                return textParallel ? new FrameReaderTextCSVParallel(fp) : new FrameReaderTextCSV(fp);
            }
            case COMPRESSED: 
            case BINARY: {
                return binaryParallel ? new FrameReaderBinaryBlockParallel() : new FrameReaderBinaryBlock();
            }
            case PROTO: {
                return new FrameReaderProto();
            }
        }
        throw new DMLRuntimeException("Failed to create frame reader for unknown format: " + fmt.toString());
    }
}

