/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public final class FrameLibDetectSchema {
    protected static final Log LOG = LogFactory.getLog((String)FrameLibDetectSchema.class.getName());
    private static final int DEFAULT_MIN_CELLS = 100000;
    private final FrameBlock in;
    private final int k;
    private final int sampleSize;

    private FrameLibDetectSchema(FrameBlock in, double sampleFraction, int k) {
        this.in = in;
        this.k = k;
        int inRows = in.getNumRows();
        this.sampleSize = Math.min(inRows, Math.max((int)((double)inRows * sampleFraction), 100000));
    }

    public static FrameBlock detectSchema(FrameBlock in, int k) {
        return new FrameLibDetectSchema(in, 1.0, k).apply();
    }

    public static FrameBlock detectSchema(FrameBlock in, double sampleFraction, int k) {
        return new FrameLibDetectSchema(in, sampleFraction, k).apply();
    }

    private FrameBlock apply() {
        int cols = this.in.getNumColumns();
        FrameBlock fb = new FrameBlock(UtilFunctions.nCopies(cols, Types.ValueType.STRING));
        String[] schemaInfo = this.k == 1 ? this.singleThreadApply() : this.parallelApply();
        fb.appendRow(schemaInfo);
        return fb;
    }

    private String[] singleThreadApply() {
        int cols = this.in.getNumColumns();
        String[] schemaInfo = new String[cols];
        for (int i = 0; i < cols; ++i) {
            FrameLibDetectSchema.assign(schemaInfo, this.in.getColumn(i).analyzeValueType(this.sampleSize), i);
        }
        return schemaInfo;
    }

    private String[] parallelApply() {
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            int cols = this.in.getNumColumns();
            ArrayList<DetectValueTypeTask> tasks = new ArrayList<DetectValueTypeTask>(cols);
            for (int i = 0; i < cols; ++i) {
                tasks.add(new DetectValueTypeTask(this.in.getColumn(i), this.sampleSize));
            }
            List ret = pool.invokeAll(tasks);
            String[] schemaInfo = new String[cols];
            pool.shutdown();
            for (int i = 0; i < cols; ++i) {
                FrameLibDetectSchema.assign(schemaInfo, (Pair)ret.get(i).get(), i);
            }
            return schemaInfo;
        }
        catch (InterruptedException | ExecutionException e) {
            pool.shutdown();
            throw new DMLRuntimeException("Exception interrupted or exception thrown in detectSchema", e);
        }
    }

    private static void assign(String[] schemaInfo, Pair<Types.ValueType, Boolean> v, int i) {
        schemaInfo[i] = v.getValue() != false ? (Object)((Object)v.getKey()) + "\u00b7n" : v.getKey().toString();
    }

    private static class DetectValueTypeTask
    implements Callable<Pair<Types.ValueType, Boolean>> {
        private final Array<?> _obj;
        final int _nCells;

        protected DetectValueTypeTask(Array<?> obj, int nCells) {
            this._obj = obj;
            this._nCells = nCells;
        }

        @Override
        public Pair<Types.ValueType, Boolean> call() {
            return this._obj.analyzeValueType(this._nCells);
        }
    }
}

