/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.RegistryBuilder;
import org.apache.tapestry5.ioc.util.ExceptionUtils;

public final class IOCUtilities {
    private IOCUtilities() {
    }

    public static Registry buildDefaultRegistry() {
        RegistryBuilder builder = new RegistryBuilder();
        IOCUtilities.addDefaultModules(builder);
        Registry registry = builder.build();
        registry.performRegistryStartup();
        return registry;
    }

    public static void addDefaultModules(RegistryBuilder builder) {
        HashSet<String> blacklistedManifestModules = new HashSet<String>();
        String modulesBlacklist = System.getProperty("tapestry.manifest-modules-blacklist");
        if (modulesBlacklist != null) {
            String[] blacklistedClassnames;
            for (String classname : blacklistedClassnames = modulesBlacklist.split(",")) {
                blacklistedManifestModules.add(classname.trim());
            }
        }
        try {
            Enumeration<URL> urls = builder.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                IOCUtilities.addModulesInManifest(builder, url, blacklistedManifestModules);
            }
            IOCUtilities.addModulesInList(builder, System.getProperty("tapestry.modules"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addModulesInManifest(RegistryBuilder builder, URL url, Set<String> blacklist) {
        InputStream in = null;
        Exception fail = null;
        try {
            in = url.openStream();
            Manifest mf = new Manifest(in);
            in.close();
            in = null;
            String list = mf.getMainAttributes().getValue("Tapestry-Module-Classes");
            IOCUtilities.addModulesInList(builder, list, blacklist);
        }
        catch (RuntimeException ex) {
            fail = ex;
        }
        catch (IOException ex) {
            fail = ex;
        }
        finally {
            IOCUtilities.close(in);
        }
        if (fail != null) {
            throw new RuntimeException(String.format("Exception loading module(s) from manifest %s: %s", url.toString(), ExceptionUtils.toMessage((Throwable)fail)), fail);
        }
    }

    static void addModulesInList(RegistryBuilder builder, String list) {
        IOCUtilities.addModulesInList(builder, list, Collections.emptySet());
    }

    static void addModulesInList(RegistryBuilder builder, String list, Set<String> blacklist) {
        String[] classnames;
        if (list == null) {
            return;
        }
        for (String classname : classnames = list.split(",")) {
            String trimmedClassname = classname.trim();
            if (blacklist != null && blacklist.contains(trimmedClassname)) continue;
            builder.add(trimmedClassname);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

