/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.plastic;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tapestry5.internal.plastic.PrimitiveType;
import org.apache.tapestry5.plastic.MethodDescription;

public class PlasticUtils {
    public static final Method TO_STRING = PlasticUtils.getMethod(Object.class, "toString", new Class[0]);
    public static final MethodDescription TO_STRING_DESCRIPTION = new MethodDescription(TO_STRING);
    private static final AtomicLong UID_GENERATOR = new AtomicLong(System.nanoTime());

    public static String nextUID() {
        return Long.toHexString(UID_GENERATOR.getAndIncrement());
    }

    public static String toTypeName(Class type) {
        if (type.isArray()) {
            return PlasticUtils.toTypeName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    public static String[] toTypeNames(Class[] types) {
        String[] result = new String[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PlasticUtils.toTypeName(types[i]);
        }
        return result;
    }

    public static Class toWrapperType(Class type) {
        assert (type != null);
        return type.isPrimitive() ? PrimitiveType.getByPrimitiveType((Class)type).wrapperType : type;
    }

    public static Method getMethod(Class declaringClass, String name, Class ... parameterTypes) {
        try {
            return declaringClass.getMethod(name, parameterTypes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static MethodDescription getMethodDescription(Class declaringClass, String name, Class ... parameterTypes) {
        return new MethodDescription(PlasticUtils.getMethod(declaringClass, name, parameterTypes));
    }

    public static boolean isPrimitive(String typeName) {
        return PrimitiveType.getByName(typeName) != null;
    }
}

