/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ContextAwareException;
import org.apache.tapestry5.ExceptionHandlerAssistant;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ExceptionReporter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestExceptionHandler;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;

public class DefaultRequestExceptionHandler
implements RequestExceptionHandler {
    private final RequestPageCache pageCache;
    private final PageResponseRenderer renderer;
    private final Logger logger;
    private final String pageName;
    private final Request request;
    private final Response response;
    private final ComponentClassResolver componentClassResolver;
    private final LinkSource linkSource;
    private final ExceptionReporter exceptionReporter;
    private final Map<Class, Object> configuration;

    public DefaultRequestExceptionHandler(RequestPageCache pageCache, PageResponseRenderer renderer, Logger logger, @Symbol(value="tapestry.exception-report-page") String pageName, Request request, Response response, ComponentClassResolver componentClassResolver, LinkSource linkSource, ServiceResources serviceResources, ExceptionReporter exceptionReporter, Map<Class, Object> configuration) {
        this.pageCache = pageCache;
        this.renderer = renderer;
        this.logger = logger;
        this.pageName = pageName;
        this.request = request;
        this.response = response;
        this.componentClassResolver = componentClassResolver;
        this.linkSource = linkSource;
        this.exceptionReporter = exceptionReporter;
        HashMap<Class, ExceptionHandlerAssistant> handlerAssistants = new HashMap<Class, ExceptionHandlerAssistant>();
        for (Map.Entry<Class, Object> entry : configuration.entrySet()) {
            if (!Throwable.class.isAssignableFrom(entry.getKey())) {
                throw new IllegalArgumentException(Throwable.class.getName() + " is the only allowable key type but " + entry.getKey().getName() + " was contributed");
            }
            if (!(entry.getValue() instanceof Class) || !ExceptionHandlerAssistant.class.isAssignableFrom((Class)entry.getValue())) continue;
            Class handlerType = (Class)entry.getValue();
            ExceptionHandlerAssistant assistant = (ExceptionHandlerAssistant)handlerAssistants.get(handlerType);
            if (assistant == null) {
                assistant = (ExceptionHandlerAssistant)serviceResources.autobuild(handlerType);
                handlerAssistants.put(handlerType, assistant);
            }
            entry.setValue(assistant);
        }
        this.configuration = configuration;
    }

    @Override
    public void handleRequestException(Throwable exception) throws IOException {
        if (this.configuration.isEmpty()) {
            this.renderException(exception);
            return;
        }
        Throwable cause = exception;
        while (cause instanceof TapestryException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        Class<?> causeClass = cause.getClass();
        if (!(this.configuration.containsKey(causeClass) || (causeClass = causeClass.getSuperclass()) != null && this.configuration.containsKey(causeClass) || (causeClass = causeClass.getSuperclass()) != null && this.configuration.containsKey(causeClass))) {
            this.renderException(exception);
            return;
        }
        Object[] exceptionContext = this.formExceptionContext(cause);
        Object value = this.configuration.get(causeClass);
        Object page = null;
        ExceptionHandlerAssistant assistant = null;
        if (value instanceof ExceptionHandlerAssistant) {
            assistant = (ExceptionHandlerAssistant)value;
            List<Object> context = Arrays.asList(exceptionContext);
            page = assistant.handleRequestException(exception, context);
            exceptionContext = context.toArray();
        } else {
            if (!(value instanceof Class)) {
                this.renderException(exception);
                return;
            }
            page = value;
        }
        if (page == null) {
            return;
        }
        try {
            Link link;
            if (page instanceof Class) {
                page = this.componentClassResolver.resolvePageClassNameToPageName(((Class)page).getName());
            }
            Link link2 = link = page instanceof Link ? (Link)page : this.linkSource.createPageRenderLink(page.toString(), false, exceptionContext);
            if (this.request.isXHR()) {
                OutputStream os = this.response.getOutputStream("application/json;charset=UTF-8");
                JSONObject reply = new JSONObject();
                reply.in("_tapestry").put("redirectURL", (Object)link.toRedirectURI());
                os.write(reply.toCompactString().getBytes("UTF-8"));
                os.close();
                return;
            }
            this.response.sendRedirect(link);
        }
        catch (Exception e) {
            this.logger.warn("A new exception was thrown while trying to handle an instance of {}.", (Object)exception.getClass().getName(), (Object)e);
            this.renderException(exception);
        }
    }

    private void renderException(Throwable exception) throws IOException {
        this.logger.error("Processing of request failed with uncaught exception: {}", (Object)exception, (Object)exception);
        this.exceptionReporter.reportException(exception);
        this.response.setStatus(500);
        String rawMessage = ExceptionUtils.toMessage((Throwable)exception);
        String encoded = URLEncoder.encode(rawMessage, "UTF-8").replace("+", "%20");
        this.response.setHeader("X-Tapestry-ErrorMessage", encoded);
        Page page = this.pageCache.get(this.pageName);
        ExceptionReporter rootComponent = (ExceptionReporter)((Object)page.getRootComponent());
        rootComponent.reportException(exception);
        this.renderer.renderPageResponse(page);
    }

    protected Object[] formExceptionContext(Throwable exception) {
        if (exception instanceof ContextAwareException) {
            return ((ContextAwareException)((Object)exception)).getContext();
        }
        Class<RuntimeException> exceptionClass = exception.getClass();
        while ("".equals(exceptionClass.getSimpleName())) {
            exceptionClass = exceptionClass.getSuperclass();
        }
        if (exceptionClass.isAssignableFrom(RuntimeException.class)) {
            Object[] objectArray;
            if (exception.getMessage() == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = exception.getMessage().toLowerCase();
            }
            return objectArray;
        }
        String exceptionType = exceptionClass.getSimpleName();
        if (exceptionType.endsWith("Exception")) {
            exceptionType = exceptionType.substring(0, exceptionType.length() - 9);
        }
        return new Object[]{exceptionType.toLowerCase()};
    }
}

