/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.internal.services.ComponentModelSource;
import org.apache.tapestry5.internal.services.PageActivationContextCollector;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.InvalidationEventHub;

public class PageActivationContextCollectorImpl
implements PageActivationContextCollector {
    private final Object[] EMPTY = new Object[0];
    private final TypeCoercer typeCoercer;
    private final ComponentModelSource modelSource;
    private final RequestPageCache requestPageCache;
    private final Map<String, Boolean> cache = CollectionFactory.newConcurrentMap();

    public PageActivationContextCollectorImpl(TypeCoercer typeCoercer, RequestPageCache requestPageCache, ComponentModelSource modelSource) {
        this.typeCoercer = typeCoercer;
        this.requestPageCache = requestPageCache;
        this.modelSource = modelSource;
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub invalidationEventHub) {
        invalidationEventHub.clearOnInvalidation(this.cache);
    }

    @Override
    public Object[] collectPageActivationContext(String pageName) {
        Boolean hasHandler = this.cache.get(pageName);
        if (hasHandler == null) {
            ComponentModel model = this.modelSource.getPageModel(pageName);
            hasHandler = model.handlesEvent("passivate");
            this.cache.put(pageName, hasHandler);
        }
        if (!hasHandler.booleanValue()) {
            return this.EMPTY;
        }
        Page page = this.requestPageCache.get(pageName);
        ComponentPageElement element = page.getRootElement();
        final Holder holder = Holder.create();
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                holder.put(PageActivationContextCollectorImpl.this.typeCoercer.coerce(result, Object[].class));
                return true;
            }
        };
        element.triggerEvent("passivate", null, callback);
        if (!holder.hasValue()) {
            return this.EMPTY;
        }
        return (Object[])holder.get();
    }
}

