/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.io.IOException;
import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackAssembler;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.AssetPathConstructor;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;

public class JavaScriptStackPathConstructorImpl
implements JavaScriptStackPathConstructor {
    private final ThreadLocale threadLocale;
    private final AssetPathConstructor assetPathConstructor;
    private final JavaScriptStackSource javascriptStackSource;
    private final JavaScriptStackAssembler assembler;
    private final ResponseCompressionAnalyzer compressionAnalyzer;
    private final boolean combineScripts;
    private final Mapper<Asset, String> toPath = new Mapper<Asset, String>(){

        public String map(Asset input) {
            return input.toClientURL();
        }
    };

    public JavaScriptStackPathConstructorImpl(ThreadLocale threadLocale, AssetPathConstructor assetPathConstructor, JavaScriptStackSource javascriptStackSource, JavaScriptStackAssembler assembler, ResponseCompressionAnalyzer compressionAnalyzer, @Symbol(value="tapestry.combine-scripts") boolean combineScripts) {
        this.threadLocale = threadLocale;
        this.assetPathConstructor = assetPathConstructor;
        this.javascriptStackSource = javascriptStackSource;
        this.assembler = assembler;
        this.compressionAnalyzer = compressionAnalyzer;
        this.combineScripts = combineScripts;
    }

    @Override
    public List<String> constructPathsForJavaScriptStack(String stackName) {
        JavaScriptStack stack = this.javascriptStackSource.getStack(stackName);
        List<Asset> assets = stack.getJavaScriptLibraries();
        if (this.combineScripts && stack.getJavaScriptAggregationStrategy().enablesCombine()) {
            boolean needsVirtual;
            boolean bl = needsVirtual = assets.size() > 1 || !stack.getModules().isEmpty();
            if (needsVirtual) {
                return this.combinedStackURL(stackName, stack);
            }
        }
        return this.toPaths(assets);
    }

    private List<String> toPaths(List<Asset> assets) {
        assert (assets != null);
        return F.flow(assets).map(this.toPath).toList();
    }

    private List<String> combinedStackURL(String stackName, JavaScriptStack stack) {
        try {
            StreamableResource assembled = this.assembler.assembleJavaScriptResourceForStack(stackName, this.compressionAnalyzer.isGZipSupported(), stack.getJavaScriptAggregationStrategy());
            String path = this.threadLocale.getLocale().toString() + '/' + stackName + ".js";
            String stackURL = this.assetPathConstructor.constructAssetPath("stack", path, assembled);
            return CollectionFactory.newList((Object[])new String[]{stackURL});
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to construct path for '%s' JavaScript stack: %s", stackName, ExceptionUtils.toMessage((Throwable)ex)), ex);
        }
    }
}

