/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.annotations.NotLazy;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.internal.services.CachingObjectCreator;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.LazyAdvisor;
import org.apache.tapestry5.ioc.services.ThunkCreator;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;

@PreventServiceDecoration
public class LazyAdvisorImpl
implements LazyAdvisor {
    private final ThunkCreator thunkCreator;

    public LazyAdvisorImpl(ThunkCreator thunkCreator) {
        this.thunkCreator = thunkCreator;
    }

    @Override
    public void addLazyMethodInvocationAdvice(MethodAdviceReceiver methodAdviceReceiver) {
        for (Method m : methodAdviceReceiver.getInterface().getMethods()) {
            if (!this.filter(m)) continue;
            this.addAdvice(m, methodAdviceReceiver);
        }
    }

    private void addAdvice(Method method, MethodAdviceReceiver receiver) {
        final Class<?> thunkType = method.getReturnType();
        final String description = String.format("<%s Thunk for %s>", thunkType.getName(), InternalUtils.asString(method));
        MethodAdvice advice = new MethodAdvice(){

            public void advise(final MethodInvocation invocation) {
                ObjectCreator deferred = new ObjectCreator(){

                    public Object createObject() {
                        invocation.proceed();
                        return invocation.getReturnValue();
                    }
                };
                CachingObjectCreator cachingObjectCreator = new CachingObjectCreator(deferred);
                Object thunk = LazyAdvisorImpl.this.thunkCreator.createThunk(thunkType, cachingObjectCreator, description);
                invocation.setReturnValue(thunk);
            }
        };
        receiver.adviseMethod(method, advice);
    }

    private boolean filter(Method method) {
        if (method.getAnnotation(NotLazy.class) != null) {
            return false;
        }
        if (!method.getReturnType().isInterface()) {
            return false;
        }
        for (Class<?> extype : method.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(extype)) continue;
            return false;
        }
        return true;
    }
}

