#region License

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#endregion



//********************************************************************************
//* Do NOT edit this file directly - generated by build/generate.groovy
//********************************************************************************

#nullable disable

using System;
using System.Numerics;
using System.Collections.Generic;
using Gremlin.Net.Structure;
using Gremlin.Net.Process.Traversal;
using Gremlin.Net.Process.Traversal.Strategy.Optimization;
using Gremlin.Net.Process.Traversal.Strategy.Verification;
using Gremlin.Net.Process.Traversal.Strategy.Finalization;
using Gremlin.Net.Process.Traversal.Strategy.Decoration;

namespace Gremlin.Net.IntegrationTest.Gherkin
{
    public class Gremlin
    {
        public static void InstantiateTranslationsForTestRun()
        {
            // We need to copy the fixed translations as we remove translations from the list after using them
            // so we can enumerate through the translations while evaluating a scenario.
            _translationsForTestRun =
                new Dictionary<string, List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>>>(
                    FixedTranslations.Count);
            foreach (var (traversal, translations) in FixedTranslations)
            {
                _translationsForTestRun.Add(traversal,
                    new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>>(translations));
            }
        }

        private static IDictionary<string, List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>>>
            _translationsForTestRun;

        private static readonly IDictionary<string, List<Func<GraphTraversalSource, IDictionary<string, object>,ITraversal>>> FixedTranslations = 
            new Dictionary<string, List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>>>
            {
               {"g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Branch<object>(__.Label().Is("person").Count()).Option(p["xx1"], __.Values<object>("age")).Option(p["xx2"], __.Values<object>("lang")).Option(p["xx2"], __.Values<object>("name"))}}, 
               {"g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX_optionXany__labelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Branch<object>(__.Label().Is("person").Count()).Option(p["xx1"], __.Values<object>("age")).Option(p["xx2"], __.Values<object>("lang")).Option(p["xx2"], __.Values<object>("name")).Option(Pick.Any, __.Label())}}, 
               {"g_V_branchXageX_optionXltX30X__youngX_optionXgtX30X__oldX_optionXnone__on_the_edgeX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Branch<object>(__.Values<object>("age")).Option(P.Lt(30), __.Constant<object>("young")).Option(P.Gt(30), __.Constant<object>("old")).Option(Pick.None, __.Constant<object>("on the edge"))}}, 
               {"g_V_branchXidentityX_optionXhasLabelXsoftwareX__inXcreatedX_name_order_foldX_optionXhasXname_vadasX__ageX_optionXneqX123X__bothE_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Branch<object>(__.Identity()).Option(__.HasLabel("software"), __.In("created").Values<object>("name").Order().Fold()).Option(__.Has("name", "vadas"), __.Values<object>("age")).Option(P.Neq(123), __.BothE().Count())}}, 
               {"g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Out().Count()).Option(p["xx1"], __.Values<object>("name")).Option(p["xx2"], __.Values<object>("age"))}}, 
               {"g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX_optionXnone_discardX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Out().Count()).Option(p["xx1"], __.Values<object>("name")).Option(p["xx2"], __.Values<object>("age")).Option(Pick.None, __.Discard())}}, 
               {"g_V_chooseXhasLabelXpersonX_and_outXcreatedX__outXknowsX_identityX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.HasLabel("person").And().Out("created"), __.Out("knows"), __.Identity()).Values<object>("name")}}, 
               {"g_V_chooseXhasLabelXpersonX_and_outXcreatedX_outXknowsX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.HasLabel("person").And().Out("created"), __.Out("knows")).Values<object>("name")}}, 
               {"g_V_chooseXlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Label()).Option("blah", __.Out("knows")).Option("bleep", __.Out("created")).Option(Pick.None, __.Identity()).Values<object>("name")}}, 
               {"g_V_chooseXTlabelX_optionXperson__outXknowsX_nameX_optionXbleep_constantXbleepXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(T.Label).Option("person", __.Out("knows").Values<object>("name")).Option("bleep", __.Constant<object>("bleep"))}}, 
               {"g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(T.Label).Option("blah", __.Out("knows")).Option("bleep", __.Out("created")).Option(Pick.None, __.Identity()).Values<object>("name")}}, 
               {"g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone_discardX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(T.Label).Option("blah", __.Out("knows")).Option("bleep", __.Out("created")).Option(Pick.None, __.Discard()).Values<object>("name")}}, 
               {"g_V_chooseXoutXknowsX_count_isXgtX0XX__outXknowsXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Out("knows").Count().Is(P.Gt(0)), __.Out("knows")).Values<object>("name")}}, 
               {"g_V_hasLabelXpersonX_asXp1X_chooseXoutEXknowsX__outXknowsXX_asXp2X_selectXp1_p2X_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("p1").Choose<object>(__.OutE("knows"), __.Out("knows")).As("p2").Select<object>("p1", "p2").By("name")}}, 
               {"g_V_hasLabelXpersonX_chooseXageX__optionX27L__constantXyoungXX_optionXnone__constantXoldXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age")).Option(p["xx1"], __.Constant<object>("young")).Option(Pick.None, __.Constant<object>("old")).GroupCount<object>()}}, 
               {"g_injectX1X_chooseXisX1X__constantX10Xfold__foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).Choose<object>(__.Is(p["xx1"]), __.Constant<object>(10).Fold(), __.Fold<object>())}}, 
               {"g_injectX2X_chooseXisX1X__constantX10Xfold__foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(2).Choose<object>(__.Is(p["xx1"]), __.Constant<object>(10).Fold(), __.Fold<object>())}}, 
               {"g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_constantXxXX_optionXbetweenX20_30X_constantXyXX_optionXnone_constantXzXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Constant<object>("x")).Option(P.Between(20, 30), __.Constant<object>("y")).Option(Pick.None, __.Constant<object>("z"))}}, 
               {"g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_orXgtX34XX_constantXxXX_optionXgtX34X_constantXyXX_optionXnone_constantXzXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30).Or(P.Gt(34)), __.Constant<object>("x")).Option(P.Gt(34), __.Constant<object>("y")).Option(Pick.None, __.Constant<object>("z"))}}, 
               {"g_V_hasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name")).Option(Pick.None, __.Values<object>("name"))}}, 
               {"g_V_chooseXhasLabelXpersonX_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Local<object>(__.Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name").Fold()).Option(Pick.None, __.Values<object>("name").Fold()))}}, 
               {"g_V_chooseXhasLabelXpersonX_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Map<object>(__.Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name").Fold()).Option(Pick.None, __.Values<object>("name").Fold()))}}, 
               {"g_unionXV_VXhasLabelXpersonX_barrier_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V(), __.V()).HasLabel("person").Barrier().Local<object>(__.Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name").Fold()).Option(Pick.None, __.Values<object>("name").Fold()))}}, 
               {"g_unionXV_VXhasLabelXpersonX_barrier_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V(), __.V()).HasLabel("person").Barrier().Map<object>(__.Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name").Fold()).Option(Pick.None, __.Values<object>("name").Fold()))}}, 
               {"g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name")).Option(Pick.None, __.Values<object>("name"))}}, 
               {"g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXunproductive_labelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name")).Option(Pick.None, __.Values<object>("name")).Option(Pick.Unproductive, __.Label())}}, 
               {"g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXnone_identityX_optionXnone_failX_optionXunproductive_identityX_optionXunproductive_labelX_optionXnone_failX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name")).Option(Pick.None, __.Values<object>("name")).Option(Pick.None, __.Identity()).Option(Pick.None, __.Fail()).Option(Pick.Unproductive, __.Label()).Option(Pick.Unproductive, __.Identity()).Option(Pick.Unproductive, __.Fail())}}, 
               {"g_V_chooseXage_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age"), __.Values<object>("name"))}}, 
               {"g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_discardX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age")).Option(P.Between(26, 30), __.Values<object>("name")).Option(Pick.None, __.Discard())}}, 
               {"g_V_chooseXnameX_optionXneqXyX_ageX_optionXnone_constantXxXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("name")).Option(P.Neq("y"), __.Values<object>("age")).Option(Pick.None, __.Constant<object>("x"))}}, 
               {"g_V_hasLabelXpersonX_chooseXoutXcreatedX_count_isXeqX0XX__constantXdidnt_createX__constantXcreatedXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Out("created").Count().Is(P.Eq(0)), __.Constant<object>("didnt_create"), __.Constant<object>("created"))}}, 
               {"g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX30XX__valuesXageX__constantX30XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age").Is(P.Gt(30)), __.Values<object>("age"), __.Constant<object>(30))}}, 
               {"g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX29XX_and_valuesXageX_isXltX35XX__valuesXnameX__constantXotherXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("age").Is(P.Gt(29)).And().Values<object>("age").Is(P.Lt(35)), __.Values<object>("name"), __.Constant<object>("other"))}}, 
               {"g_V_chooseXhasXname_vadasX__valuesXnameX__valuesXageXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Has("name", "vadas"), __.Values<object>("name"), __.Values<object>("age"))}}, 
               {"g_V_hasLabelXpersonX_chooseXoutXcreatedX_countX_optionX0__constantXnoneXX_optionX1__constantXoneXX_optionX2__constantXmanyXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Out("created").Count()).Option(p["xx0"], __.Constant<object>("none")).Option(p["xx1"], __.Constant<object>("one")).Option(p["xx2"], __.Constant<object>("many"))}}, 
               {"g_V_hasLabelXpersonX_chooseXlocalXoutXknowsX_countX__optionX0__constantXnoFriendsXX__optionXnone__constantXhasFriendsXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Local<object>(__.Out("knows").Count())).Option(p["xx0"], __.Constant<object>("noFriends")).Option(Pick.None, __.Constant<object>("hasFriends"))}}, 
               {"g_V_chooseXoutE_countX_optionX0__constantXnoneXX_optionXnone__constantXsomeXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.OutE().Count()).Option(p["xx0"], __.Constant<object>("none")).Option(Pick.None, __.Constant<object>("some"))}}, 
               {"g_V_chooseXlabelX_optionXperson__chooseXageX_optionXP_lt_30__constantXyoungXX_optionXP_gte_30__constantXoldXXX_optionXsoftware__constantXprogramXX_optionXnone__constantXunknownXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Label()).Option("person", __.Choose<object>(__.Values<object>("age")).Option(P.Lt(30), __.Constant<object>("young")).Option(P.Gte(30), __.Constant<object>("old"))).Option("software", __.Constant<object>("program")).Option(Pick.None, __.Constant<object>("unknown"))}}, 
               {"g_V_chooseXhasXname_vadasX__valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Has("name", "vadas"), __.Values<object>("name"))}}, 
               {"g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX_constantXotherXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("age").Choose<object>(P.Eq(29), __.Constant<object>("matched"), __.Constant<object>("other"))}}, 
               {"g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("age").Choose<object>(P.Eq(29), __.Constant<object>("matched"))}}, 
               {"g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_isXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("name")).Option(__.Is("marko"), __.Values<object>("age")).Option(Pick.None, __.Values<object>("name"))}}, 
               {"g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_PeqXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Choose<object>(__.Values<object>("name")).Option(P.Eq("marko"), __.Values<object>("age")).Option(Pick.None, __.Values<object>("name"))}}, 
               {"g_V_localXpropertiesXlocationX_order_byXvalueX_limitX2XX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Properties<object>("location").Order().By(T.Value, Order.Asc).Range<object>(0, 2)).Value<object>()}}, 
               {"g_V_hasXlabel_personX_asXaX_localXoutXcreatedX_asXbXX_selectXa_bX_byXnameX_byXidX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has(T.Label, "person").As("a").Local<object>(__.Out("created").As("b")).Select<object>("a", "b").By("name").By(T.Id)}}, 
               {"g_V_localXoutE_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.OutE().Count())}}, 
               {"g_VX1X_localXoutEXknowsX_limitX1XX_inV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Local<object>(__.OutE("knows").Limit<object>(1)).InV().Values<object>("name")}}, 
               {"g_V_localXbothEXcreatedX_limitX1XX_otherV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.BothE("created").Limit<object>(1)).OtherV().Values<object>("name")}}, 
               {"g_VX4X_localXbothEX1_createdX_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Local<object>(__.BothE("created").Limit<object>(1))}}, 
               {"g_VX4X_localXbothEXknows_createdX_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Local<object>(__.BothE("knows", "created").Limit<object>(1))}}, 
               {"g_VX4X_localXbothE_limitX1XX_otherV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Local<object>(__.BothE().Limit<object>(1)).OtherV().Values<object>("name")}}, 
               {"g_VX4X_localXbothE_limitX2XX_otherV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Local<object>(__.BothE().Limit<object>(2)).OtherV().Values<object>("name")}}, 
               {"g_V_localXinEXknowsX_limitX2XX_outV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.InE("knows").Limit<object>(2)).OutV().Values<object>("name")}}, 
               {"g_V_localXmatchXproject__created_person__person_name_nameX_selectXname_projectX_by_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Match<object>(__.As("project").In("created").As("person"), __.As("person").Values<object>("name").As("name"))).Select<object>("name", "project").By().By("name")}}, 
               {"g_V_in_barrier_localXcountX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().In().Barrier().Local<object>(__.Count())}}, 
               {"g_V_localXout_in_simplePathX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Out().In().SimplePath()).Path()}}, 
               {"g_withSackX0LX_V_in_barrier_localXsackXsumX_byXageXX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(0l).V().In().Barrier().Local<object>(__.Sack(Operator.Sum).By("age")).Sack<object>()}}, 
               {"g_V_localXout_localXcountXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Out().Local<object>(__.Count()))}}, 
               {"g_V_unionXoutE_count_localXinE_countXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.OutE().Count(), __.Local<object>(__.InE().Count()))}}, 
               {"g_VX2X_optionalXoutXknowsXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Optional<object>(__.Out("knows"))}}, 
               {"g_VX2X_optionalXinXknowsXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Optional<object>(__.In("knows"))}}, 
               {"g_V_hasLabelXpersonX_optionalXoutXknowsX_optionalXoutXcreatedXXX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Optional<object>(__.Out("knows").Optional<object>(__.Out("created"))).Path()}}, 
               {"g_V_optionalXout_optionalXoutXX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Optional<object>(__.Out().Optional<object>(__.Out())).Path()}}, 
               {"g_VX1X_optionalXaddVXdogXX_label", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).Optional<object>(__.AddV("dog")).Label(), (g,p) =>g.V()}}, 
               {"g_V_repeatXoutX_timesX2X_emit_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(2).Emit().Path()}}, 
               {"g_V_repeatXoutX_timesX2X_repeatXinX_timesX2X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(2).Repeat(__.In()).Times(2).Values<object>("name")}}, 
               {"g_V_repeatXoutE_inVX_timesX2X_path_by_name_by_label", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.OutE().InV()).Times(2).Path().By("name").By(T.Label)}}, 
               {"g_V_repeatXoutX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(2)}}, 
               {"g_V_repeatXoutX_timesX2X_emit", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(2).Emit()}}, 
               {"g_VX1X_timesX2X_repeatXoutX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Times(2).Repeat(__.Out()).Values<object>("name")}}, 
               {"g_V_emit_timesX2X_repeatXoutX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Emit().Times(2).Repeat(__.Out()).Path()}}, 
               {"g_V_emit_repeatXoutX_timesX2X_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Emit().Repeat(__.Out()).Times(2).Path()}}, 
               {"g_VX1X_emitXhasXlabel_personXX_repeatXoutX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Emit(__.Has(T.Label, "person")).Repeat(__.Out()).Values<object>("name")}}, 
               {"g_V_repeatXgroupCountXmX_byXnameX_outX_timesX2X_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.GroupCount("m").By("name").Out()).Times(2).Cap<object>("m")}}, 
               {"g_VX1X_repeatXgroupCountXmX_byXloopsX_outX_timesX3X_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.GroupCount("m").By(__.Loops()).Out()).Times(3).Cap<object>("m")}}, 
               {"g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both()).Times(10).As("a").Out().As("b").Select<object>("a", "b").Count()}}, 
               {"g_VX1X_repeatXoutX_untilXoutE_count_isX0XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Out()).Until(__.OutE().Count().Is(0)).Values<object>("name")}}, 
               {"g_V_hasXname_markoX_repeatXoutE_inV_simplePathX_untilXhasXname_rippleXX_path_byXnameX_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").Repeat(__.OutE().InV().SimplePath()).Until(__.Has("name", "ripple")).Path().By("name").By(T.Label)}}, 
               {"g_V_hasXloop_name_loopX_repeatXinX_timesX5X_path_by_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("loops", "name", "loop").Repeat(__.In()).Times(5).Path().By("name")}}, 
               {"g_V_repeatXout_repeatXout_order_byXname_descXX_timesX1XX_timesX1X_limitX1X_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out().Repeat(__.Out().Order().By("name", Order.Desc)).Times(1)).Times(1).Limit<object>(1).Path().By("name")}}, 
               {"g_V_repeatXoutXknowsXX_untilXrepeatXoutXcreatedXX_emitXhasXname_lopXXX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out("knows")).Until(__.Repeat(__.Out("created")).Emit(__.Has("name", "lop"))).Path().By("name")}}, 
               {"g_V_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Repeat(__.Out("created")).Until(__.Has("name", "ripple"))).Emit().Values<object>("lang")}}, 
               {"g_V_untilXconstantXtrueXX_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Until(__.Constant<object>(true)).Repeat(__.Repeat(__.Out("created")).Until(__.Has("name", "ripple"))).Emit().Values<object>("lang")}}, 
               {"g_V_emit_repeatXa_outXknows_filterXloops_isX0XX_lang", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Emit().Repeat("a", __.Out("knows").Filter(__.Loops("a").Is(0))).Values<object>("lang")}}, 
               {"g_VX3X_repeatXbothX_createdXX_untilXloops_is_40XXemit_repeatXin_knowsXX_emit_loopsXisX1Xdedup_values", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Both("created")).Until(__.Loops().Is(40)).Emit(__.Repeat(__.In("knows")).Emit(__.Loops().Is(1))).Dedup().Values<object>("name")}}, 
               {"g_VX1X_repeatXrepeatXunionXout_uses_out_traversesXX_whereXloops_isX0X_timesX1X_timeX2X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Repeat(__.Union<object>(__.Out("uses"), __.Out("traverses")).Where(__.Loops().Is(0))).Times(1)).Times(2).Values<object>("name")}}, 
               {"g_V_repeatXa_outXknows_repeatXb_outXcreatedX_filterXloops_isX0XX_emit_lang", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat("a", __.Out("knows").Repeat("b", __.Out("created").Filter(__.Loops("a").Is(0))).Emit()).Emit().Values<object>("lang")}}, 
               {"g_VX6X_repeatXa_bothXcreatedX_simplePathX_emitXrepeatXb_bothXknowsXX_untilXloopsXbX_asXb_whereXloopsXaX_asXbX_hasXname_vadasXX_dedup_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid6"]).Repeat("a", __.Both("created").SimplePath()).Emit(__.Repeat("b", __.Both("knows")).Until(__.Loops("b").As("b").Where(__.Loops("a").As("b"))).Has("name", "vadas")).Dedup().Values<object>("name")}}, 
               {"g_V_emit", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Emit()}}, 
               {"g_V_untilXidentityX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Until(__.Identity())}}, 
               {"g_V_timesX5X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Times(5)}}, 
               {"g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX1X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Repeat(__.Out("created")).Times(1).Values<object>("name")}}, 
               {"g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX0X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Repeat(__.Out("created")).Times(0).Values<object>("name")}}, 
               {"g_V_hasXperson_name_markoX_timesX1X_repeatXoutXcreatedXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Times(1).Repeat(__.Out("created")).Values<object>("name")}}, 
               {"g_V_hasXperson_name_markoX_timesX0X_repeatXoutXcreatedXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Times(0).Repeat(__.Out("created")).Values<object>("name")}}, 
               {"g_V_repeatXboth_hasXnot_productiveXX_timesX3X_constantX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both().Has("not", "productive")).Times(3).Constant<object>(1)}}, 
               {"g_V_hasXnot_productiveX_repeatXbothX_timesX3X_constantX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("not", "productive").Repeat(__.Both()).Times(3).Constant<object>(1)}}, 
               {"g_VX1_2_3X_repeatXboth_barrierX_emit_timesX2X_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"], p["vid2"], p["vid3"]).Repeat(__.Both().Barrier()).Emit().Times(2).Path()}}, 
               {"g_V_order_byXname_descX_repeatXboth_simplePath_order_byXname_descXX_timesX2X_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name", Order.Desc).Repeat(__.Both().SimplePath().Order().By("name", Order.Desc)).Times(2).Path()}}, 
               {"g_V_repeatXboth_repeatXorder_byXnameXX_timesX1XX_timesX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both().Repeat(__.Order().By("name")).Times(1)).Times(1)}}, 
               {"g_V_order_byXname_descX_repeatXlocalXout_order_byXnameXXX_timesX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name", Order.Desc).Repeat(__.Local<object>(__.Out().Order().By("name"))).Times(1)}}, 
               {"g_V_order_byXnameX_repeatXlocalXboth_simplePath_order_byXnameXXX_timesX2X_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name").Repeat(__.Local<object>(__.Both().SimplePath().Order().By("name"))).Times(2).Path()}}, 
               {"g_V_repeatXunionXoutXknowsX_order_byXnameX_inXcreatedX_order_byXnameXXX_timesX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Union<object>(__.Out("knows").Order().By("name"), __.In("created").Order().By("name"))).Times(1)}}, 
               {"g_V_repeatXaddV_propertyXgenerated_trueXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("notGenerated", "true").AddV().Property("notGenerated", "true"), (g,p) =>g.V().Repeat(__.AddV().Property("generated", "true")).Times(2), (g,p) =>g.V().Has("notGenerated"), (g,p) =>g.V().Has("generated")}}, 
               {"g_V_repeatXdedup_bothX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Dedup().Both()).Times(2)}}, 
               {"g_V_repeatXaggregateXxXX_timesX2X_selectXxX_limitX1X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Aggregate("x")).Times(2).Select<object>("x").Limit<object>(1).Unfold<object>()}}, 
               {"g_V_valuesXstrX_repeatXsplitXabcX_conjoinX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("str", "ababcczababcc").AddV().Property("str", "abcyabc"), (g,p) =>g.V().Values<object>("str").Repeat(__.Split("abc").Conjoin((string) "")).Times(2)}}, 
               {"g_withSackX0X_V_repeatXsackXsumX_byXageX_whereXsack_isXltX59XXXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(0l).V().Repeat(__.Sack(Operator.Sum).By("age").Where(__.Sack<object>().Is(P.Lt(59)))).Times(2)}}, 
               {"g_V_repeatXinjectXyXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Inject("y")).Times(2)}}, 
               {"g_V_repeatXunionXconstantXyX_limitX1X_identityXX_timesX3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Union<object>(__.Constant<object>("y").Limit<object>(1), __.Identity())).Times(2)}}, 
               {"g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Out().Order().By("performances").Tail<object>(2)).Times(1).Values<object>("name")}}, 
               {"g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Out().Order().By("performances").Tail<object>(2)).Times(2).Values<object>("name")}}, 
               {"g_VX2X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Repeat(__.Out().Local<object>(__.Order().By("performances").Tail<object>(1))).Times(1).Values<object>("name")}}, 
               {"g_VX250X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid250"]).Repeat(__.Out().Local<object>(__.Order().By("performances").Tail<object>(1))).Times(2).Values<object>("name")}}, 
               {"g_VX3X_repeatXout_order_byXperformancesX_tailX3X_limitX1XX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Out().Order().By("performances").Tail<object>(3).Limit<object>(1)).Times(2).Values<object>("name")}}, 
               {"g_VX3X_repeatXout_order_byXperformances_descX_limitX5X_tailX1XX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Out().Order().By("performances", Order.Desc).Limit<object>(5).Tail<object>(1)).Times(2).Values<object>("name")}}, 
               {"g_VX3X_repeatXoutE_order_byXweightX_tailX2X_inVX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.OutE().Order().By("weight").Tail<object>(2).InV()).Times(2).Values<object>("name")}}, 
               {"g_VX3X_repeatXoutE_order_byXweight_descX_limitX2X_inVX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.OutE().Order().By("weight", Order.Desc).Limit<object>(2).InV()).Times(2).Values<object>("name")}}, 
               {"g_unionXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>()}}, 
               {"g_unionXV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V().Values<object>("name"))}}, 
               {"g_unionXVXv1X_VX4XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V(p["vid1"]), __.V(p["vid4"])).Values<object>("name")}}, 
               {"g_unionXV_hasLabelXsoftwareX_V_hasLabelXpersonXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V().HasLabel("software"), __.V().HasLabel("person")).Values<object>("name")}}, 
               {"g_unionXV_out_out_V_hasLabelXsoftwareXX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V().Out().Out(), __.V().HasLabel("software")).Path()}}, 
               {"g_unionXV_out_out_V_hasLabelXsoftwareXX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.V().Out().Out(), __.V().HasLabel("software")).Path().By("name")}}, 
               {"g_unionXunionXV_out_outX_V_hasLabelXsoftwareXX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.Union<object>(__.V().Out().Out()), __.V().HasLabel("software")).Path().By("name")}}, 
               {"g_unionXinjectX1X_injectX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.Inject(1), __.Inject(2))}}, 
               {"g_V_unionXconstantX1X_constantX2X_constantX3XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Union<object>(__.Constant<object>(1), __.Constant<object>(2), __.Constant<object>(3))}}, 
               {"g_V_unionXout__inX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.Out(), __.In()).Values<object>("name")}}, 
               {"g_VX1X_unionXrepeatXoutX_timesX2X__outX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Union<object>(__.Repeat(__.Out()).Times(2), __.Out()).Values<object>("name")}}, 
               {"g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Label().Is("person"), __.Union<object>(__.Out().Values<object>("lang"), __.Out().Values<object>("name")), __.In().Label())}}, 
               {"g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Label().Is("person"), __.Union<object>(__.Out().Values<object>("lang"), __.Out().Values<object>("name")), __.In().Label()).GroupCount<object>()}}, 
               {"g_V_unionXrepeatXunionXoutXcreatedX__inXcreatedXX_timesX2X__repeatXunionXinXcreatedX__outXcreatedXX_timesX2XX_label_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.Repeat(__.Union<object>(__.Out("created"), __.In("created"))).Times(2), __.Repeat(__.Union<object>(__.In("created"), __.Out("created"))).Times(2)).Label().GroupCount<object>()}}, 
               {"g_VX1_2X_unionXoutE_count__inE_count__outE_weight_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"], p["vid2"]).Union<object>(__.OutE().Count(), __.InE().Count(), __.OutE().Values<object>("weight").Sum<object>())}}, 
               {"g_VX1_2X_localXunionXoutE_count__inE_count__outE_weight_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"], p["vid2"]).Local<object>(__.Union<object>(__.OutE().Count(), __.InE().Count(), __.OutE().Values<object>("weight").Sum<object>()))}}, 
               {"g_VX1_2X_localXunionXcountXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"], p["vid2"]).Local<object>(__.Union<object>(__.Count()))}}, 
               {"g_unionXaddVXpersonX_propertyXname_aliceX_addVXpersonX_propertyXname_bobX_addVXpersonX_propertyXname_chrisX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Union<object>(__.AddV("person").Property("name", "alice"), __.AddV("person").Property("name", "bob"), __.AddV("person").Property("name", "chris")).Values<object>("name")}}, 
               {"g_VX_hasLabelXpersonX_unionX_whereX_out_count_isXgtX2XXX_valuesXageX_notX_whereX_bothE_count_isXgt2XXX_valusXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Union<object>(__.Where(__.OutE().Count().Is(P.Gt(2))).Values<object>("age"), __.Not(__.Where(__.OutE().Count().Is(P.Gt(2)))).Values<object>("name"))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 123), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_mathXaddX0_5XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 10), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Math("_ + 0.5")}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_isXgtX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 5), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Is(P.Gt(0))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 2).AddV("data").Property("int", 3).AddV("data").Property("int", 4), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Sum<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 1).AddV("data").Property("int", 5).AddV("data").Property("int", 10), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Min<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 7).AddV("data").Property("int", 14).AddV("data").Property("int", 21), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Max<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_project_byXidentityX_byXmathXmulX10XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 6), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).Project<object>("original", "multiplied").By(__.Identity()).By(__.Math("_ * 10"))}}, 
               {"g_injectX99X_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(99).AsNumber(GType.BigDecimal).Is(P.TypeOf(GType.BigDecimal)).GroupCount<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_BIGDECIMALXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.BigDecimal))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 456), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_mathXmulX1000XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 100), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Math("_ * 1000")}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_isXeqX42XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 42), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Is(P.Eq(42))}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 10).AddV("data").Property("int", 20).AddV("data").Property("int", 30), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Sum<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 5).AddV("data").Property("int", 15).AddV("data").Property("int", 25), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Min<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 100).AddV("data").Property("int", 200).AddV("data").Property("int", 300), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Max<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_project_byXidentityX_byXmathXaddX999XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 50), (g,p) =>g.V().Values<object>("int").AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).Project<object>("original", "added").By(__.Identity()).By(__.Math("_ + 999"))}}, 
               {"g_injectX777X_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(777).AsNumber(GType.BigInt).Is(P.TypeOf(GType.BigInt)).GroupCount<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_BIGINTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.BigInt))}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 5), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte))}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_mathXaddX20XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 10), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).Math("_ + 20")}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_isXltX10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 7), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).Is(P.Lt(10))}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 1).AddV("data").Property("int", 2).AddV("data").Property("int", 3), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).Sum<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_project_byXidentityX_byXmathXmulX2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 8), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).Project<object>("original", "doubled").By(__.Identity()).By(__.Math("_ * 2"))}}, 
               {"g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_chooseXisXeqX12XX_constantXtwelveX_constantXotherXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 12), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).Choose<object>(__.Is(P.Eq(12)), __.Constant<object>("twelve"), __.Constant<object>("other"))}}, 
               {"g_injectX15X_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(15).AsNumber(GType.Byte).Is(P.TypeOf(GType.Byte)).GroupCount<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_BYTEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Byte))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_project_byXidentityX_byXdateAddXDT_dayX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime)).Project<object>("original", "nextDay").By(__.Identity()).By(__.DateAdd(DT.Day, 1))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_dateDiffXdatetimeX2023_08_10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime)).DateDiff(DateTimeOffset.Parse("2023-08-08T00:00:30Z"))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_whereXisXgtXdatetimeX2020_01_01XXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime)).Where(__.Is(P.Gt(DateTimeOffset.Parse("2020-01-01T00:00Z"))))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_chooseXisXeqXdatetimeX2023_08_08XXXX_constantXmatchX_constantXnoMatchXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime)).Choose<object>(__.Is(P.Eq(DateTimeOffset.Parse("2023-08-08T00:00Z"))), __.Constant<object>("match"), __.Constant<object>("noMatch"))}}, 
               {"g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_localXaggregateXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("event").Property("datetime", DateTimeOffset.Parse("2023-08-08T00:00Z")), (g,p) =>g.V().Values<object>("datetime").Is(P.TypeOf(GType.DateTime)).Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_aggregateXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-08T00:00Z")).Is(P.TypeOf(GType.DateTime)).Aggregate("a").Cap<object>("a")}}, 
               {"g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-08T00:00Z")).Is(P.TypeOf(GType.DateTime)).GroupCount<object>()}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 1.5d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double))}}, 
               {"g_E_valuesXweightX_isXtypeOfXGType_DOUBLEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Values<object>("weight").Is(P.TypeOf(GType.Double))}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_mathXceilX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 2.7d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Math("ceil _")}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_isXgtX1_0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 0.8d).AddV("data").Property("double", 1.2d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Is(P.Gt(1.0d))}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 1.5d).AddV("data").Property("double", 2.5d).AddV("data").Property("double", 3.5d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Sum<object>()}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 0.1d).AddV("data").Property("double", 0.5d).AddV("data").Property("double", 0.9d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Min<object>()}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 2.1d).AddV("data").Property("double", 3.7d).AddV("data").Property("double", 1.9d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Max<object>()}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_meanX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 2.1d).AddV("data").Property("double", 4.1d).AddV("data").Property("double", 6.1d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Mean<object>()}}, 
               {"g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_order_byXascX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("double", 3.2d).AddV("data").Property("double", 1.8d).AddV("data").Property("double", 2.5d), (g,p) =>g.V().Values<object>("double").Is(P.TypeOf(GType.Double)).Order().By(Order.Asc)}}, 
               {"g_injectX5_5dX_isXtypeOfXGType_DOUBLEXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5.5d).Is(P.TypeOf(GType.Double)).GroupCount<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_DOUBLEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Double))}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 2.5), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float))}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_mathXmulX2XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 3.0), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Math("_ * 2")}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_isXeqX1_5XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 1.5), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Is(P.Eq(1.5))}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 1.5).AddV("data").Property("float", 2.5).AddV("data").Property("float", 3.0), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Sum<object>()}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_project_byXidentityX_byXmathXmulX10XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 4.5), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Project<object>("original", "multiplied").By(__.Identity()).By(__.Math("_ * 10"))}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_whereXisXgtX1_0XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 0.5).AddV("data").Property("float", 1.5), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Where(__.Is(P.Gt(1.0)))}}, 
               {"g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_chooseXisXeqX3_0XX_constantXthreeX_constantXotherXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("float", 3.0), (g,p) =>g.V().Values<object>("float").AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).Choose<object>(__.Is(P.Eq(3.0)), __.Constant<object>("three"), __.Constant<object>("other"))}}, 
               {"g_injectX2_0fX_isXtypeOfXGType_FLOATXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(2.0).AsNumber(GType.Float).Is(P.TypeOf(GType.Float)).GroupCount<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_FLOATXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Float))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int))}}, 
               {"g_V_hasXage_typeOfXGType_INTXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.TypeOf(GType.Int)).Values<object>("name")}}, 
               {"g_V_whereXvaluesXageX_isXtypeOfXGType_INTXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Values<object>("age").Is(P.TypeOf(GType.Int))).Values<object>("name")}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_mathXincX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name", "age").Is(P.TypeOf(GType.Int)).Math("_ + 1")}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).Sum<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).Min<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).Max<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_meanX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).Mean<object>()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_order_byXdescX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).Order().By(Order.Desc)}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_INTXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Int)).GroupCount<object>()}}, 
               {"g_V_valuesXnameX_fold_isXtypeOfXGType_LISTXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Is(P.TypeOf(GType.List)).Count()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_LISTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.List))}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { "a", "b", "c" }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List))}}, 
               {"g_V_hasXlist_typeOfXGType_LISTXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("name", "test").Property("list", new List<object> { 1, 2, 3 }), (g,p) =>g.V().Has("list", P.TypeOf(GType.List)).Values<object>("name")}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { "x", "y", "z" }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List)).Unfold<object>()}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { 1, 2, 3, 4, 5 }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List)).Count(Scope.Local)}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold_rangeX1_3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { "first", "second", "third", "fourth" }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List)).Unfold<object>().Range<object>(1, 3)}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX_project_byXidentityX_byXcountXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { "apple", "banana" }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List)).Project<object>("original", "size").By(__.Identity()).By(__.Count(Scope.Local))}}, 
               {"g_V_valuesXlistX_isXtypeOfXGType_LISTXX_whereXcountXlocalX_isXgtX2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("list", new List<object> { 1 }).AddV("data").Property("list", new List<object> { 1, 2, 3 }), (g,p) =>g.V().Values<object>("list").Is(P.TypeOf(GType.List)).Where(__.Count(Scope.Local).Is(P.Gt(2)))}}, 
               {"g_injectXlistX_isXtypeOfXGType_LISTXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "test" }).Is(P.TypeOf(GType.List)).GroupCount<object>()}}, 
               {"g_V_valuesXlongX_isXtypeOfXGType_LONGXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("long", 1l), (g,p) =>g.V().Values<object>("long").Is(P.TypeOf(GType.Long))}}, 
               {"g_V_hasXlong_typeOfXGType_LONGXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("name", "test").Property("long", 1l), (g,p) =>g.V().Has("long", P.TypeOf(GType.Long)).Values<object>("name")}}, 
               {"g_V_valuesXlongX_isXtypeOfXGType_LONGXX_mathXmulX2XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("long", 5l), (g,p) =>g.V().Values<object>("long").Is(P.TypeOf(GType.Long)).Math("_ * 2")}}, 
               {"g_V_valuesXlongX_isXtypeOfXGType_LONGXX_isXgtX5XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("long", 10l), (g,p) =>g.V().Values<object>("long").Is(P.TypeOf(GType.Long)).Is(P.Gt(5l))}}, 
               {"g_V_valuesXlongX_isXtypeOfXGType_LONGXX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("long", 1l).AddV("data").Property("long", 2l).AddV("data").Property("long", 3l), (g,p) =>g.V().Values<object>("long").Is(P.TypeOf(GType.Long)).Sum<object>()}}, 
               {"g_V_valuesXlongX_isXtypeOfXGType_LONGXX_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("long", 100l), (g,p) =>g.V().Values<object>("long").Is(P.TypeOf(GType.Long)).Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_hasLabelXpersonX_valueMap_isXtypeOfXGType_MAPXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").ValueMap<object, object>().Is(P.TypeOf(GType.Map)).Count()}}, 
               {"g_V_groupCount_byXlabelX_isXtypeOfXGType_MAPX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().GroupCount<object>().By(T.Label).Is(P.TypeOf(GType.Map))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_MAPXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Map))}}, 
               {"g_V_valuesXmapX_isXtypeOfXGType_MAPXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("map", new Dictionary<object, object> {{ "key1", "1" }, { "key2", "2" }}), (g,p) =>g.V().Values<object>("map").Is(P.TypeOf(GType.Map))}}, 
               {"g_V_hasXmap_typeOfXGType_MAPXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("name", "test").Property("map", new Dictionary<object, object> {{ "a", 1 }, { "b", 2 }}), (g,p) =>g.V().Has("map", P.TypeOf(GType.Map)).Values<object>("name")}}, 
               {"g_V_valuesXmapX_isXtypeOfXGType_MAPXX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("map", new Dictionary<object, object> {{ "a", 1 }, { "b", 2 }, { "c", 3 }}), (g,p) =>g.V().Values<object>("map").Is(P.TypeOf(GType.Map)).Count(Scope.Local)}}, 
               {"g_V_valuesXmapX_isXtypeOfXGType_MAPXX_selectXvaluesX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("map", new Dictionary<object, object> {{ "city", "NYC" }, { "country", "USA" }}), (g,p) =>g.V().Values<object>("map").Is(P.TypeOf(GType.Map)).Select<object>(Column.Values)}}, 
               {"g_V_valuesXmapX_isXtypeOfXGType_MAPXX_whereX_countXlocalX_isXgtX1XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("map", new Dictionary<object, object> {{ "single", "value" }}).AddV("data").Property("map", new Dictionary<object, object> {{ "key1", "1" }, { "key2", "2" }}), (g,p) =>g.V().Values<object>("map").Is(P.TypeOf(GType.Map)).Where(__.Count(Scope.Local).Is(P.Gt(1)))}}, 
               {"g_V_valuesXmapX_isXtypeOfXGType_MAPXX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("map", new Dictionary<object, object> {{ "a", 1 }}).AddV("data").Property("map", new Dictionary<object, object> {{ "b", 2 }, { "c", 3 }}), (g,p) =>g.V().Values<object>("map").Is(P.TypeOf(GType.Map)).Fold()}}, 
               {"g_V_valueXnameX_aggregateXxX_capXxX_isXtypeOfXGType_SETX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Aggregate("x").Cap<object>("x").Is(P.TypeOf(GType.Set))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_SETXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Set))}}, 
               {"g_V_valueMap_selectXkeysX_dedup_isXtypeOfXGType_SETXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Column.Keys).Dedup().Is(P.TypeOf(GType.Set))}}, 
               {"g_V_valuesXsetX_isXtypeOfXGType_SETXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("set", new HashSet<object> { "a", "b", "c" }), (g,p) =>g.V().Values<object>("set").Is(P.TypeOf(GType.Set))}}, 
               {"g_V_hasXset_typeOfXGType_SETXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("name", "test").Property("set", new HashSet<object> { 1, 2, 3 }), (g,p) =>g.V().Has("set", P.TypeOf(GType.Set)).Values<object>("name")}}, 
               {"g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("set", new HashSet<object> { "x", "y", "z" }), (g,p) =>g.V().Values<object>("set").Is(P.TypeOf(GType.Set)).Unfold<object>()}}, 
               {"g_V_valuesXsetX_isXtypeOfXGType_SETXX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("set", new HashSet<object> { 1, 2, 3, 4, 5 }), (g,p) =>g.V().Values<object>("set").Is(P.TypeOf(GType.Set)).Count(Scope.Local)}}, 
               {"g_V_valuesXsetX_isXtypeOfXGType_SETXX_whereXcountXlocalX_isXeqX3XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("set", new HashSet<object> { 1, 2 }).AddV("data").Property("set", new HashSet<object> { 1, 2, 3 }), (g,p) =>g.V().Values<object>("set").Is(P.TypeOf(GType.Set)).Where(__.Count(Scope.Local).Is(P.Eq(3)))}}, 
               {"g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold_limitX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("set", new HashSet<object> { "first", "second", "third", "fourth" }), (g,p) =>g.V().Values<object>("set").Is(P.TypeOf(GType.Set)).Unfold<object>().Limit<object>(2)}}, 
               {"g_injectXsetX_isXtypeOfXGType_SETXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new HashSet<object> { "test" }).Is(P.TypeOf(GType.Set)).GroupCount<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 100), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Short).Is(P.TypeOf(GType.Short))}}, 
               {"g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_mathXmulX10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 50), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Short).Is(P.TypeOf(GType.Short)).Math("_ * 10")}}, 
               {"g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_isXbetweenX20_30XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 25), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Short).Is(P.TypeOf(GType.Short)).Is(P.Between(20, 30))}}, 
               {"g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 10).AddV("data").Property("int", 20).AddV("data").Property("int", 30), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Short).Is(P.TypeOf(GType.Short)).Min<object>()}}, 
               {"g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("int", 15).AddV("data").Property("int", 25).AddV("data").Property("int", 35), (g,p) =>g.V().Values<object>("int").AsNumber(GType.Short).Is(P.TypeOf(GType.Short)).Max<object>()}}, 
               {"g_injectX42X_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_storeXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(42).AsNumber(GType.Short).Is(P.TypeOf(GType.Short))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_SHORTXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Short))}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID))}}, 
               {"g_V_hasXuuid_typeOfXGType_UUIDXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("name", "test").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Has("uuid", P.TypeOf(GType.UUID)).Values<object>("name")}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_project_byXidentityX_byXconstantXuuidXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID)).Project<object>("original", "type").By(__.Identity()).By(__.Constant<object>("uuid"))}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_whereXisXeqXuuidXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID)).Where(__.Is(P.Eq(Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479"))))}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_chooseXisXeqXuuidXX_constantXmatchX_constantXnoMatchXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID)).Choose<object>(__.Is(P.Eq(Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479"))), __.Constant<object>("match"), __.Constant<object>("noMatch"))}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID)).Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_aggregateXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("data").Property("uuid", Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")), (g,p) =>g.V().Values<object>("uuid").Is(P.TypeOf(GType.UUID)).Aggregate("a").Cap<object>("a")}}, 
               {"g_injectXuuidX_isXtypeOfXGType_UUIDXX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479")).Is(P.TypeOf(GType.UUID)).GroupCount<object>()}}, 
               {"g_injectXUUIDX47af10b_58cc_4372_a567_0f02b2f3d479XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Guid.Parse("f47af10b-58cc-4372-a567-0f02b2f3d479"))}}, 
               {"g_injectXUUIDXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Guid.NewGuid())}}, 
               {"g_V_aggregateXxX_byXnameX_byXageX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("x").By("name").By("age").Cap<object>("x")}}, 
               {"g_V_localXaggregateXxX_byXnameXX_byXageX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("x").By("name").By("age")).Cap<object>("x")}}, 
               {"g_V_valuesXageX_allXgtX32XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").All(P.Gt(32))}}, 
               {"g_V_valuesXageX_whereXisXP_gtX33XXX_fold_allXgtX33XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Where(__.Is(P.Gt(33))).Fold().All(P.Gt(33))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_allXgtX10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().All(P.Gt(10))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_allXgtX30XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().All(P.Gt(30))}}, 
               {"g_injectXabc_bcdX_allXeqXbcdXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "abc", "bcd" }).All(P.Eq("bcd"))}}, 
               {"g_injectXbcd_bcdX_allXeqXbcdXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "bcd", "bcd" }).All(P.Eq("bcd"))}}, 
               {"g_injectXnull_abcX_allXTextP_startingWithXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, "abc" }).All(TextP.StartingWith("a"))}}, 
               {"g_injectX5_8_10_10_7X_allXgteX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 5, 8, 10 }, new List<object> { 10, 7 }).All(P.Gte(7))}}, 
               {"g_injectXnullX_allXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).All(P.Eq(null))}}, 
               {"g_injectX7X_allXeqX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(7).All(P.Eq(7))}}, 
               {"g_injectXnull_nullX_allXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, null }).All(P.Eq(null))}}, 
               {"g_injectX3_threeX_allXeqX3XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).All(P.Eq(3))}}, 
               {"g_V_andXhasXage_gt_27X__outE_count_gte_2X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().And(__.Has("age", P.Gt(27)), __.OutE().Count().Is(P.Gte(2))).Values<object>("name")}}, 
               {"g_V_andXoutE__hasXlabel_personX_and_hasXage_gte_32XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().And(__.OutE(), __.Has(T.Label, "person").And().Has("age", P.Gte(32))).Values<object>("name")}}, 
               {"g_V_asXaX_outXknowsX_and_outXcreatedX_inXcreatedX_asXaX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("knows").And().Out("created").In("created").As("a").Values<object>("name")}}, 
               {"g_V_asXaX_andXselectXaX_selectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").And(__.Select<object>("a"), __.Select<object>("a"))}}, 
               {"g_V_hasXname_markoX_and_hasXname_markoX_and_hasXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").And().Has("name", "marko").And().Has("name", "marko")}}, 
               {"g_V_valuesXageX_anyXgtX32XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Any(P.Gt(32))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_anyXeqX29XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().Any(P.Eq(29))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_anyXgtX10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().Any(P.Gt(10))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_anyXgtX42XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().Any(P.Gt(42))}}, 
               {"g_injectXabc_cdeX_anyXeqXbcdXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "abc", "cde" }).Any(P.Eq("bcd"))}}, 
               {"g_injectXabc_bcdX_anyXeqXbcdXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "abc", "bcd" }).Any(P.Eq("bcd"))}}, 
               {"g_injectXnull_abcX_anyXTextP_startingWithXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, "abc" }).Any(TextP.StartingWith("a"))}}, 
               {"g_injectX5_8_10_10_7X_anyXeqX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 5, 8, 10 }, new List<object> { 10, 7 }).Any(P.Eq(7))}}, 
               {"g_injectXnullX_anyXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Any(P.Eq(null))}}, 
               {"g_injectX7X_anyXeqX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(7).Any(P.Eq(7))}}, 
               {"g_injectXnull_nullX_anyXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, null }).Any(P.Eq(null))}}, 
               {"g_injectX3_threeX_anyXeqX3XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Any(P.Eq(3))}}, 
               {"g_V_coinX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Coin(1.0)}}, 
               {"g_V_coinX0X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Coin(0.0)}}, 
               {"g_withStrategiesXSeedStrategyX_V_order_byXnameX_coinX50X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SeedStrategy(seed: 999999)).V().Order().By("name").Coin(0.5)}}, 
               {"g_VX1X_outXcreatedX_inXcreatedX_cyclicPath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").In("created").CyclicPath()}}, 
               {"g_VX1X_both_both_cyclicPath_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Both().Both().CyclicPath().By("age")}}, 
               {"g_VX1X_outXcreatedX_inXcreatedX_cyclicPath_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").In("created").CyclicPath().Path()}}, 
               {"g_VX1X_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_cyclicPath_fromXaX_toXbX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("created").As("b").In("created").As("c").CyclicPath().From("a").To("b").Path()}}, 
               {"g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_cyclicPath_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(0).V().Both().Coalesce<object>(__.Has("name", "marko").Both(), __.Constant<object>(0)).CyclicPath().Path()}}, 
               {"g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().In().Values<object>("name").Fold().Dedup(Scope.Local).Unfold<object>()}}, 
               {"g_V_out_in_valuesXnameX_fold_dedupXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Map<object>(__.In().Values<object>("name").Fold().Dedup(Scope.Local))}}, 
               {"g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().As("x").In().As("y").Select<object>("x", "y").By("name").Fold().Dedup(Scope.Local, "x", "y").Unfold<object>()}}, 
               {"g_V_both_dedup_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Dedup().Values<object>("name")}}, 
               {"g_V_both_hasXlabel_softwareX_dedup_byXlangX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Has(T.Label, "software").Dedup().By("lang").Values<object>("name")}}, 
               {"g_V_both_both_name_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Both().Values<object>("name").Dedup()}}, 
               {"g_V_both_both_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Both().Dedup()}}, 
               {"g_V_both_both_dedup_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Both().Dedup().By(T.Label)}}, 
               {"g_V_group_byXlabelX_byXbothE_weight_dedup_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(T.Label).By(__.BothE().Values<object>("weight").Dedup().Order().By(Order.Asc).Fold())}}, 
               {"g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Both().As("b").Dedup("a", "b").By(T.Label).Select<object>("a", "b")}}, 
               {"g_V_asXaX_out_asXbX_in_asXcX_dedupXa_bX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").As("a").AddV("person").Property("name", "bob").As("b").AddV("person").Property("name", "carol").As("c").AddE("knows").From("a").To("b").AddE("likes").From("a").To("b").AddE("likes").From("a").To("c"), (g,p) =>g.V().As("a").Out().As("b").In().As("c").Dedup("a", "b").Path().By("name")}}, 
               {"g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().As("e").InV().As("v").Select<object>("e").Order().By("weight", Order.Asc).Select<object>("v").Values<object>("name").Dedup()}}, 
               {"g_V_both_both_dedup_byXoutE_countX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Both().Dedup().By(__.OutE().Count()).Values<object>("name")}}, 
               {"g_V_groupCount_selectXvaluesX_unfold_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().GroupCount<object>().Select<object>(Column.Values).Unfold<object>().Dedup()}}, 
               {"g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Repeat(__.Both()).Times(3).Emit().Values<object>("name").As("b").Group<object, object>().By(__.Select<object>("a")).By(__.Select<object>("b").Dedup().Order().Fold()).Select<object>(Column.Values).Unfold<object>().Dedup()}}, 
               {"g_V_repeatXdedupX_timesX2X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Dedup()).Times(2).Count()}}, 
               {"g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Group<object, object>().By().By(__.Out().Dedup().Fold()).Unfold<object>().Select<object>(Column.Values).Unfold<object>().Out().Order().By("name").Limit<object>(1).Values<object>("name")}}, 
               {"g_V_bothE_properties_dedup_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().BothE().Properties<object>().Dedup().Count()}}, 
               {"g_V_both_properties_dedup_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Properties<object>().Dedup().Count()}}, 
               {"g_V_both_properties_properties_dedup_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Properties<object>().Properties<object>().Dedup().Count()}}, 
               {"g_V_order_byXname_descX_barrier_dedup_age_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name", Order.Desc).Barrier().Dedup().By("age").Values<object>("name")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_order_byXname_descX_barrier_dedup_age_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Order().By("name", Order.Desc).Barrier().Dedup().By("age").Values<object>("name")}}, 
               {"g_V_both_dedup_age_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Dedup().By("age").Values<object>("name")}}, 
               {"g_VX1X_asXaX_both_asXbX_both_asXcX_dedupXa_bX_age_selectXa_b_cX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Both().As("b").Both().As("c").Dedup("a", "b").By("age").Select<object>("a", "b", "c").By("name")}}, 
               {"g_VX1X_valuesXageX_dedupXlocalX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Dedup(Scope.Local).Unfold<object>()}}, 
               {"g_V_properties_dedup_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "josh").AddV("person").Property("name", "josh").AddV("person").Property("name", "josh"), (g,p) =>g.V().Properties<object>("name").Dedup().Count()}}, 
               {"g_V_properties_dedup_byXvalueX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "josh").AddV("person").Property("name", "josh").AddV("person").Property("name", "josh"), (g,p) =>g.V().Properties<object>("name").Dedup().By(T.Value).Count()}}, 
               {"g_V_both_hasXlabel_softwareX_dedup_byXlangX_byXnameX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Has(T.Label, "software").Dedup().By("lang").By("name").Values<object>("name")}}, 
               {"g_V_count_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Count().Discard()}}, 
               {"g_V_hasLabelXpersonX_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Discard()}}, 
               {"g_VX1X_outXcreatedX_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").Discard()}}, 
               {"g_V_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Discard()}}, 
               {"g_V_discard_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Discard().Discard()}}, 
               {"g_V_discard_fold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Discard().Fold()}}, 
               {"g_V_discard_fold_discard", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Discard().Fold().Discard()}}, 
               {"g_V_discard_fold_constantX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Discard().Fold().Constant<object>(1)}}, 
               {"g_V_projectXxX_byXcoalesceXage_isXgtX29XX_discardXX_selectXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Project<object>("x").By(__.Coalesce<object>(__.Values<object>("age").Is(P.Gt(29)), __.Discard())).Select<object>("x")}}, 
               {"g_V_drop", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().As("a").AddV().As("b").AddE("knows").To("a"), (g,p) =>g.V().Drop(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_V_outE_drop", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().As("a").AddV().As("b").AddE("knows").To("a"), (g,p) =>g.V().OutE().Drop(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_V_properties_drop", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("name", "bob").AddV().Property("name", "alice"), (g,p) =>g.V().Properties<object>().Drop(), (g,p) =>g.V(), (g,p) =>g.V().Properties<object>()}}, 
               {"g_E_propertiesXweightX_drop", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.E().Properties<object>("weight").Drop(), (g,p) =>g.E().Properties<object>()}}, 
               {"g_V_properties_propertiesXstartTimeX_drop", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("name", "bob").Property(Cardinality.List, "location", "ny", "startTime", 2014, "endTime", 2016).Property(Cardinality.List, "location", "va", "startTime", 2016).AddV().Property("name", "alice").Property(Cardinality.List, "location", "va", "startTime", 2014, "endTime", 2016).Property(Cardinality.List, "location", "ny", "startTime", 2016), (g,p) =>g.V().Properties<object>().Properties<object>("startTime").Drop(), (g,p) =>g.V().Properties<object>().Properties<object>(), (g,p) =>g.V().Properties<object>().Properties<object>("startTime")}}, 
               {"g_V_filterXisX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Filter(__.Is(0))}}, 
               {"g_V_filterXconstantX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Filter(__.Constant<object>(0))}}, 
               {"g_V_filterXhasXlang_javaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Filter(__.Has("lang", "java"))}}, 
               {"g_VX1X_filterXhasXage_gtX30XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Filter(__.Has("age", P.Gt(30)))}}, 
               {"g_VX2X_filterXhasXage_gtX30XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Filter(__.Has("age", P.Gt(30)))}}, 
               {"g_VX1X_out_filterXhasXage_gtX30XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Filter(__.Has("age", P.Gt(30)))}}, 
               {"g_V_filterXhasXname_startingWithXm_or_pXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Filter(__.Has("name", TextP.StartingWith("m").Or(TextP.StartingWith("p"))))}}, 
               {"g_E_filterXisX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Filter(__.Is(0))}}, 
               {"g_E_filterXconstantX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Filter(__.Constant<object>(0))}}, 
               {"g_VX1X_hasXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("name")}}, 
               {"g_VX1X_hasXcircumferenceX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("circumference")}}, 
               {"g_VX1X_hasXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("name", "marko")}}, 
               {"g_VX1X_hasXname_markovarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("name", (object) p["xx1"])}}, 
               {"g_VX2X_hasXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("name", "marko")}}, 
               {"g_V_hasXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko")}}, 
               {"g_V_hasXname_blahX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "blah")}}, 
               {"g_V_hasXage_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Gt(30))}}, 
               {"g_VX1X_hasXage_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("age", P.Gt(30))}}, 
               {"g_V_hasXpersonvar_age_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has((string) p["xx1"], "age", P.Gt(30))}}, 
               {"g_VX4X_hasXage_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Has("age", P.Gt(30))}}, 
               {"g_VXv1X_hasXage_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Has("age", P.Gt(30))}}, 
               {"g_VXv4X_hasXage_gt_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Has("age", P.Gt(30))}}, 
               {"g_VX1X_out_hasXid_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Has("age", P.Gt(30))}}, 
               {"g_V_hasXblahX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("blah")}}, 
               {"g_V_hasXperson_name_markoX_age", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Values<object>("age")}}, 
               {"g_V_hasXperson_name_markovarX_age", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", (object) p["xx1"]).Values<object>("age")}}, 
               {"g_V_hasXpersonvar_name_markoX_age", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has((string) p["xx1"], "name", "marko").Values<object>("age")}}, 
               {"g_VX1X_outE_hasXweight_inside_0_06X_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().Has("weight", P.Inside(0.0, 0.6)).InV()}}, 
               {"g_EX11X_outV_outE_hasXid_10X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).OutV().OutE().Has(T.Id, (object) p["eid10"])}}, 
               {"g_EX11X_outV_outE_hasXid_10AsStringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).OutV().OutE().Has(T.Id, (object) p["eid10"])}}, 
               {"g_V_hasXlocationX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("location")}}, 
               {"g_V_hasXage_withinX27X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Within(27)).Count()}}, 
               {"g_V_hasXage_withinX27_nullX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Within(27, null)).Count()}}, 
               {"g_V_hasXage_withinX27_29X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Within(27, 29)).Count()}}, 
               {"g_V_hasXage_withoutX27X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Without(27)).Count()}}, 
               {"g_V_hasXage_withoutX27_29X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Without(27, 29)).Count()}}, 
               {"g_V_hasXperson_age_withinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "age", P.Within())}}, 
               {"g_V_hasXperson_age_withoutX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "age", P.Without())}}, 
               {"g_V_hasXname_containingXarkXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.Containing("ark"))}}, 
               {"g_V_hasXname_startingWithXmarXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.StartingWith("mar"))}}, 
               {"g_V_hasXname_endingWithXasXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.EndingWith("as"))}}, 
               {"g_V_hasXperson_name_containingXoX_andXltXmXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", TextP.Containing("o").And(P.Lt("m")))}}, 
               {"g_V_hasXname_gtXmX_andXcontainingXoXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", P.Gt("m").And(TextP.Containing("o")))}}, 
               {"g_V_hasXname_not_containingXarkXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.NotContaining("ark"))}}, 
               {"g_V_hasXname_not_startingWithXmarXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.NotStartingWith("mar"))}}, 
               {"g_V_hasXname_not_endingWithXasXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.NotEndingWith("as"))}}, 
               {"g_V_hasXname_regexXrMarXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.Regex("^mar"))}}, 
               {"g_V_hasXname_notRegexXrMarXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", TextP.NotRegex("^mar"))}}, 
               {"g_V_hasXname_regexXTinkerXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("software").Property("name", "Apache TinkerPop©"), (g,p) =>g.V().Has("name", TextP.Regex("Tinker")).Values<object>("name")}}, 
               {"g_V_hasXname_regexXTinkerUnicodeXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("software").Property("name", "Apache TinkerPop©"), (g,p) =>g.V().Has("name", TextP.Regex("Tinker.*\u00A9")).Values<object>("name")}}, 
               {"g_V_hasXp_neqXvXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("p", P.Neq("v"))}}, 
               {"g_V_hasXage_gtX18X_andXltX30XXorXgtx35XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Gt(18).And(P.Lt(30)).Or(P.Gt(35)))}}, 
               {"g_V_hasXage_gtX18X_andXltX30XXorXltx35XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age", P.Gt(18).And(P.Lt(30)).And(P.Lt(35)))}}, 
               {"g_V_hasXk_withinXcXX_valuesXkX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("k", "轉注").AddV().Property("k", "✦").AddV().Property("k", "♠").AddV().Property("k", "A"), (g,p) =>g.V().Has("k", P.Within("轉注", "✦", "♠")).Values<object>("k")}}, 
               {"g_V_hasXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has(null)}}, 
               {"g_V_hasXnull_testnullkeyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has((string) null, "test-null-key")}}, 
               {"g_E_hasXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Has(null)}}, 
               {"g_V_hasXlabel_personX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has(T.Label, "person")}}, 
               {"g_V_hasXlabel_eqXpersonXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has(T.Label, P.Eq("person"))}}, 
               {"g_V_hasXname_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", (object) null)}}, 
               {"g_V_hasIdXemptyX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["xx1"]).Count()}}, 
               {"g_V_hasIdXwithinXemptyXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(P.Within(new List<object> {  })).Count()}}, 
               {"g_V_hasIdXwithoutXemptyXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(P.Without(new List<object> {  })).Count()}}, 
               {"g_V_notXhasIdXwithinXemptyXXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.HasId(P.Within(new List<object> {  }))).Count()}}, 
               {"g_V_hasIdXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(null)}}, 
               {"g_V_hasIdXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(P.Eq(null))}}, 
               {"g_V_hasIdX2_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid2"], null)}}, 
               {"g_V_hasIdXmarkovar_vadasvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid1"], p["vid2"])}}, 
               {"g_V_hasIdX2AsString_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid2"], null)}}, 
               {"g_V_hasIdX1AsString_2AsString_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid1"], p["vid2"], null)}}, 
               {"g_V_hasIdXnull_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(null, p["vid2"])}}, 
               {"g_V_hasIdX1X_hasIdX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid1"]).HasId(p["vid2"])}}, 
               {"g_V_in_hasIdXneqX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().In().HasId(P.Neq(p["xx1"]))}}, 
               {"g_VX1X_out_hasIdX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
               {"g_VX1X_out_hasXid_2_3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
               {"g_VX1X_out_hasXid_2AsString_3AsStringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().HasId(p["vid2"], p["vid3"])}}, 
               {"g_VX1AsStringX_out_hasXid_2AsStringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().HasId(p["vid2"])}}, 
               {"g_VX1X_out_hasXid_2_3X_inList", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().HasId(p["xx1"])}}, 
               {"g_V_hasXid_1_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["vid1"], p["vid2"])}}, 
               {"g_V_hasXid_1_2X_inList", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasId(p["xx1"])}}, 
               {"g_V_both_dedup_properties_hasKeyXageX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Properties<object>().Dedup().HasKey("age").Value<object>()}}, 
               {"g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Properties<object>().Dedup().HasKey("age").HasValue(P.Gt(30)).Value<object>(), (g,p) =>g.V().Both().Properties<object>().Dedup().HasKey("age").HasValue(P.Gt(30)).Value<object>()}}, 
               {"g_V_bothE_properties_dedup_hasKeyXweightX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().BothE().Properties<object>().Dedup().HasKey("weight").Value<object>()}}, 
               {"g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().BothE().Properties<object>().Dedup().HasKey("weight").HasValue(P.Lt(0.3)).Value<object>(), (g,p) =>g.V().BothE().Properties<object>().Dedup().HasKey("weight").HasValue(P.Lt(0.3)).Value<object>()}}, 
               {"g_V_properties_hasKeyXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasKey((string) null)}}, 
               {"g_V_properties_hasKeyXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasKey(null, null)}}, 
               {"g_V_properties_hasKeyXnull_ageX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasKey(null, "age").Value<object>()}}, 
               {"g_E_properties_hasKeyXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Properties<object>().HasKey((string) null)}}, 
               {"g_E_properties_hasKeyXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Properties<object>().HasKey(null, null)}}, 
               {"g_E_properties_hasKeyXnull_weightX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Properties<object>().HasKey(null, "weight").Value<object>()}}, 
               {"g_EX7X_hasLabelXknowsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid7"]).HasLabel("knows")}}, 
               {"g_E_hasLabelXknowsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().HasLabel("knows")}}, 
               {"g_E_hasLabelXuses_traversesX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().HasLabel("uses", "traverses")}}, 
               {"g_V_hasLabelXperson_software_blahX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person", "software", "blah")}}, 
               {"g_V_hasLabelXperson_softwarevarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person", (string) p["xx1"])}}, 
               {"g_V_hasLabelXpersonX_hasLabelXsoftwareX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").HasLabel("software")}}, 
               {"g_V_hasLabelXpersonvarX_hasLabelXsoftwareX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel((string) p["xx1"]).HasLabel("software")}}, 
               {"g_V_hasLabelXpersonvar_softwarevarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel((string) p["xx1"], (string) p["xx2"])}}, 
               {"g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Has("age", P.Not(P.Lte(10).And(P.Not(P.Between(11, 20)))).And(P.Lt(29).Or(P.Eq(35)))).Values<object>("name")}}, 
               {"g_V_hasLabelXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel((string) null)}}, 
               {"g_V_hasXlabel_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has(T.Label, (object) null)}}, 
               {"g_V_hasLabelXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel((string) null, (string) null)}}, 
               {"g_V_hasLabelXnull_personX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel((string) null, "person")}}, 
               {"g_E_hasLabelXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().HasLabel((string) null)}}, 
               {"g_E_hasXlabel_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Has(T.Label, (object) null)}}, 
               {"g_V_properties_hasLabelXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasLabel((string) null)}}, 
               {"g_V_hasNotXageX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasNot("age").Values<object>("name")}}, 
               {"g_V_properties_hasValueXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasValue((object) null)}}, 
               {"g_V_properties_hasValueXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasValue(null, null)}}, 
               {"g_V_properties_hasValueXnull_joshX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().HasValue(null, "josh").Value<object>()}}, 
               {"g_V_valuesXageX_isX32X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(32)}}, 
               {"g_V_valuesXageX_isX32varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(p["xx1"])}}, 
               {"g_V_valuesXageX_isXlte_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.Lte(30))}}, 
               {"g_V_valuesXageX_isXlte_30varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.Lte(p["xx1"]))}}, 
               {"g_V_valuesXageX_isXgte_29X_isXlt_34X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.Gte(29)).Is(P.Lt(34))}}, 
               {"g_V_valuesXageX_isXgte_29vaarX_isXlt_34varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.Gte(p["xx1"])).Is(P.Lt(p["xx2"]))}}, 
               {"g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.In("created").Count().Is(1)).Values<object>("name")}}, 
               {"g_V_whereXinXcreatedX_count_isXgte_2XX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.In("created").Count().Is(P.Gte(2))).Values<object>("name")}}, 
               {"g_V_valuesXageX_noneXgtX32XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").None(P.Gt(32))}}, 
               {"g_V_valuesXageX_whereXisXP_gtX33XXX_fold_noneXlteX33XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Where(__.Is(P.Gt(33))).Fold().None(P.Lte(33))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_noneXltX10XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().None(P.Lt(10))}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_noneXgtX30XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().None(P.Gt(30))}}, 
               {"g_injectXabc_bcdX_noneXeqXbcdXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "abc", "bcd" }).None(P.Eq("bcd"))}}, 
               {"g_injectXbcd_bcdX_noneXeqXabcXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "bcd", "bcd" }).None(P.Eq("abc"))}}, 
               {"g_injectXnull_bcdX_noneXP_eqXabcXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, "bcd" }).None(P.Eq("abc"))}}, 
               {"g_injectX5_8_10_10_7X_noneXltX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 5, 8, 10 }, new List<object> { 10, 7 }).None(P.Lt(7))}}, 
               {"g_injectXnullX_noneXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).None(P.Eq(null))}}, 
               {"g_injectX7X_noneXeqX7XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(7).None(P.Eq(7))}}, 
               {"g_injectXnull_1_emptyX_noneXeqXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, 1 }, new List<object> {  }).None(P.Eq(null))}}, 
               {"g_injectXnull_nullX_noneXnotXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, null }).None(P.Neq(null))}}, 
               {"g_injectX3_threeX_noneXeqX3XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).None(P.Eq(3))}}, 
               {"g_V_notXhasXage_gt_27XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.Has("age", P.Gt(27))).Values<object>("name")}}, 
               {"g_V_notXnotXhasXage_gt_27XXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.Not(__.Has("age", P.Gt(27)))).Values<object>("name")}}, 
               {"g_V_notXhasXname_gt_27XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.Has("name", P.Gt(27))).Values<object>("name")}}, 
               {"g_V_orXhasXage_gt_27X__outE_count_gte_2X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Or(__.Has("age", P.Gt(27)), __.OutE().Count().Is(P.Gte(2))).Values<object>("name")}}, 
               {"g_V_orXoutEXknowsX__hasXlabel_softwareX_or_hasXage_gte_35XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Or(__.OutE("knows"), __.Has(T.Label, "software").Or().Has("age", P.Gte(35))).Values<object>("name")}}, 
               {"g_V_asXaX_orXselectXaX_selectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Or(__.Select<object>("a"), __.Select<object>("a"))}}, 
               {"g_VX1X_out_limitX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Limit<object>(2)}}, 
               {"g_VX1X_out_limitX2varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Limit<object>((long) p["xx1"])}}, 
               {"g_V_localXoutE_limitX1X_inVX_limitX3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.OutE().Limit<object>(1)).InV().Limit<object>(3)}}, 
               {"g_VX1X_outXknowsX_outEXcreatedX_rangeX0_1X_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("knows").OutE("created").Range<object>(0, 1).InV()}}, 
               {"g_VX1X_outXknowsX_outXcreatedX_rangeX0_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("knows").Out("created").Range<object>(0, 1)}}, 
               {"g_VX1X_outXcreatedX_inXcreatedX_rangeX1_3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").In("created").Range<object>(1, 3)}}, 
               {"g_VX1X_outXcreatedX_inXcreatedX_rangeX1var_3varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").In("created").Range<object>((long) p["xx1"], (long) p["xx2"])}}, 
               {"g_VX1X_outXcreatedX_inEXcreatedX_rangeX1_3X_outV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").InE("created").Range<object>(1, 3).OutV()}}, 
               {"g_V_repeatXbothX_timesX3X_rangeX5_11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both()).Times(3).Range<object>(5, 11)}}, 
               {"g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").In().As("b").In().As("c").Select<object>("a", "b", "c").By("name").Limit<object>(Scope.Local, 2)}}, 
               {"g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").In().As("b").In().As("c").Select<object>("a", "b", "c").By("name").Limit<object>(Scope.Local, (long) p["xx1"])}}, 
               {"g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").In().As("b").In().As("c").Select<object>("a", "b", "c").By("name").Limit<object>(Scope.Local, 1)}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Range<object>(Scope.Local, 1, 3)}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1var_3varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Range<object>(Scope.Local, (long) p["xx1"], (long) p["xx2"])}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Range<object>(Scope.Local, 1, 2)}}, 
               {"g_V_hasLabelXpersonX_order_byXageX_skipX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Order().By("age").Skip<object>(1).Values<object>("name")}}, 
               {"g_V_hasLabelXpersonX_order_byXageX_skipX1varX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Order().By("age").Skip<object>((long) p["xx1"]).Values<object>("name")}}, 
               {"g_V_foldX_rangeXlocal_6_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Range<object>(Scope.Local, 6, 7)}}, 
               {"g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").Fold().Order(Scope.Local).Skip<object>(Scope.Local, 2)}}, 
               {"g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").Fold().Order(Scope.Local).Skip<object>(Scope.Local, (long) p["xx1"])}}, 
               {"g_V_hasLabelXpersonX_order_byXageX_valuesXnameX_skipX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Order().By("age").Values<object>("name").Skip<object>(1)}}, 
               {"g_VX1X_valuesXageX_rangeXlocal_20_30X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Range<object>(Scope.Local, 20, 30)}}, 
               {"g_V_mapXin_hasIdX1XX_limitX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Map<object>(__.In().HasId(p["vid1"])).Limit<object>(2).Values<object>("name")}}, 
               {"g_V_rangeX2_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Range<object>(2, 1)}}, 
               {"g_V_rangeX3_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Range<object>(3, 2)}}, 
               {"g_injectXlistX1_2_3XX_rangeXlocal_1_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }).Range<object>(Scope.Local, 1, 2)}}, 
               {"g_injectXlistX1_2_3XX_limitXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }).Limit<object>(Scope.Local, 1)}}, 
               {"g_injectXlistX1_2_3X_limitXlocal_1X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }).Limit<object>(Scope.Local, 1).Unfold<object>()}}, 
               {"g_injectX1_2_3_4_5X_limitXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }, new List<object> { 3, 4, 5 }).Limit<object>(Scope.Local, 1)}}, 
               {"g_injectX1_2_3_4_5_6X_rangeXlocal_1_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }, new List<object> { 4, 5, 6 }).Range<object>(Scope.Local, 1, 2)}}, 
               {"g_VX5X_repeatXlimitX1X_inX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Limit<object>(1).In()).Times(2).Values<object>("name")}}, 
               {"g_VX5X_repeatXlimitX1X_inX_untilXloopsXisX2XXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Limit<object>(1).In()).Until(__.Loops().Is(2)).Values<object>("name")}}, 
               {"g_VX5X_limitX1X_in_limitX1X_in_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Limit<object>(1).In().Limit<object>(1).In().Values<object>("name")}}, 
               {"g_VX5X_repeatXlimitX1X_inX_timesX1X_repeatXlimitX1X_inX_timesX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Limit<object>(1).In()).Times(1).Repeat(__.Limit<object>(1).In()).Times(1).Values<object>("name")}}, 
               {"g_VX5X_repeatXlimitX1X_in_aggregateXxXX_timesX2X_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Limit<object>(1).In().Aggregate("x")).Times(2).Cap<object>("x")}}, 
               {"g_VX5X_repeatXrangeX0_1X_inX_timesX2X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Range<object>(0, 1).In()).Times(2).Values<object>("name")}}, 
               {"g_VX5X_repeatXrangeX0_1X_inX_untilXloopsXisX2XXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Range<object>(0, 1).In()).Until(__.Loops().Is(2)).Values<object>("name")}}, 
               {"g_VX5X_rangeX0_1X_in_rangeX0_1X_in_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Range<object>(0, 1).In().Range<object>(0, 1).In().Values<object>("name")}}, 
               {"g_VX5X_repeatXrangeX0_1X_in_repeatXrangeX0_1X_inX_timesX1XX_timesX1X_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Range<object>(0, 1).In().Repeat(__.Range<object>(0, 1).In()).Times(1)).Times(1).Values<object>("name")}}, 
               {"g_VX5X_repeatXrangeX0_1X_in_aggregateXxXX_timesX2X_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid5"]).Repeat(__.Range<object>(0, 1).In().Aggregate("x")).Times(2).Cap<object>("x")}}, 
               {"g_withoutStrategiesXEarlyLimitStrategyX_VX5X_repeatXlimitX1X_in_limitX1X_limitX1XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(EarlyLimitStrategy)).V(p["vid5"]).Repeat(__.Limit<object>(1).In().Limit<object>(1).Limit<object>(1)).Times(2)}}, 
               {"g_V_repeatXout_whereXhasXnameX_order_byXnameX_limitX1XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out().Where(__.Has("name").Order().By("name").Limit<object>(1))).Times(2)}}, 
               {"g_V_out_whereXhasXnameX_order_byXnameX_limitX1XX_out_whereXhasXnameX_order_byXnameX_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Where(__.Has("name").Order().By("name").Limit<object>(1)).Out().Where(__.Has("name").Order().By("name").Limit<object>(1))}}, 
               {"g_V_hasXnameXJAMXX_repeatXoutXfollowedByX_order_byXnameX_limitX2XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "JAM").Repeat(__.Out("followedBy").Order().By("name").Limit<object>(2)).Times(2)}}, 
               {"g_V_hasXnameXJAMXX_outXfollowedByX_order_byXnameX_limitX2X_outXfollowedByX_order_byXnameX_limitX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "JAM").Out("followedBy").Order().By("name").Limit<object>(2).Out("followedBy").Order().By("name").Limit<object>(2)}}, 
               {"g_V_hasXnameXDRUMSXX_repeatXinXfollowedByX_order_byXnameX_rangeX1_4XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "DRUMS").Repeat(__.In("followedBy").Order().By("name").Range<object>(1, 4)).Times(2)}}, 
               {"g_V_hasXnameXDRUMSXX_inXfollowedByX_order_byXnameX_rangeX1_4X_inXfollowedByX_order_byXnameX_rangeX1_4X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "DRUMS").In("followedBy").Order().By("name").Range<object>(1, 4).In("followedBy").Order().By("name").Range<object>(1, 4)}}, 
               {"g_V_chooseXvaluesXageX_isXlteX30XX_out_order_byXnameX_limitX1X_out_order_byXnameX_limitX2XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age").Is(P.Lte(30)), __.Out().Order().By("name").Limit<object>(1), __.Out().Order().By("name").Limit<object>(2))}}, 
               {"g_V_chooseXvaluesXageX_isXlteX30XX_localXout_order_byXnameX_limitX1XX_localXout_order_byXnameX_limitX2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Values<object>("age").Is(P.Lte(30)), __.Local<object>(__.Out().Order().By("name").Limit<object>(1)), __.Local<object>(__.Out().Order().By("name").Limit<object>(2)))}}, 
               {"g_V_hasXnameXHEY_BO_DIDDLEYXX_unionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_byXnameX_limitX1XX_unionXoutXfollowedByX_order_limitX2X_outXsungByX_order_byXnameX_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "HEY BO DIDDLEY").Union<object>(__.Out("followedBy").Order().By("name").Limit<object>(2), __.Out("sungBy").Order().By("name").Limit<object>(1)).Union<object>(__.Out("followedBy").Order().By("name").Limit<object>(2), __.Out("sungBy").Order().By("name").Limit<object>(1))}}, 
               {"g_V_hasXnameXHEY_BO_DIDDLEYXX_repeatXunionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_limitX1XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "HEY BO DIDDLEY").Repeat(__.Union<object>(__.Out("followedBy").Order().By("name").Limit<object>(2), __.Out("sungBy").Order().By("name").Limit<object>(1))).Times(2)}}, 
               {"g_V_sampleX1X_byXageX_byXT_idX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sample(1).By("age").By(T.Id)}}, 
               {"g_E_sampleX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Sample(1)}}, 
               {"g_E_sampleX2X_byXweightX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Sample(2).By("weight")}}, 
               {"g_V_localXoutE_sampleX1X_byXweightXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.OutE().Sample(1).By("weight"))}}, 
               {"g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_sampleX2X_foldXunfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SeedStrategy(seed: 999999)).V().Group<object, object>().By(T.Label).By(__.BothE().Values<object>("weight").Order().Sample(2).Fold()).Unfold<object>()}}, 
               {"g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_fold_sampleXlocal_5XXunfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SeedStrategy(seed: 999999)).V().Group<object, object>().By(T.Label).By(__.BothE().Values<object>("weight").Order().Fold().Sample(Scope.Local, 5)).Unfold<object>()}}, 
               {"g_withStrategiesXSeedStrategyX_V_order_byXlabel_descX_sampleX1X_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SeedStrategy(seed: 999999)).V().Order().By(T.Label, Order.Desc).Sample(1).By("age")}}, 
               {"g_VX1X_valuesXageX_sampleXlocal_5X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Sample(Scope.Local, 5)}}, 
               {"g_V_repeatXsampleX2XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Sample(2)).Times(2)}}, 
               {"g_V_sampleX2X_sampleX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sample(2).Sample(2)}}, 
               {"g_V3_repeatXout_order_byXperformancesX_sampleX2X_aggregateXxXX_untilXloops_isX2XX_capXxX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Repeat(__.Out().Order().By("performances").Sample(2).Aggregate("x")).Until(__.Loops().Is(2)).Cap<object>("x").Unfold<object>()}}, 
               {"g_V3_out_order_byXperformancesX_sampleX2X_aggregateXxX_out_order_byXperformancesX_sampleX2X_aggregateXxX_capXxX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).Out().Order().By("performances").Sample(2).Aggregate("x").Out().Order().By("performances").Sample(2).Aggregate("x").Cap<object>("x").Unfold<object>()}}, 
               {"g_VX1X_outXcreatedX_inXcreatedX_simplePath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").In("created").SimplePath()}}, 
               {"g_V_repeatXboth_simplePathX_timesX3X_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both().SimplePath()).Times(3).Path()}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_simplePath_byXlabelX_fromXbX_toXcX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").SimplePath().By(T.Label).From("b").To("c").Path().By("name")}}, 
               {"g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_simplePath_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(0).V().Both().Coalesce<object>(__.Has("name", "marko").Both(), __.Constant<object>(0)).SimplePath().Path()}}, 
               {"g_V_both_asXaX_both_asXbX_simplePath_path_byXageX__fromXaX_toXbX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().As("a").Both().As("b").SimplePath().Path().By("age").From("a").To("b")}}, 
               {"g_V_valuesXnameX_order_tailXglobal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Tail<object>(Scope.Global, 2)}}, 
               {"g_V_valuesXnameX_order_tailX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Tail<object>(2)}}, 
               {"g_V_valuesXnameX_order_tailX2varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Tail<object>((long) p["xx1"])}}, 
               {"g_V_valuesXnameX_order_tail", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Tail<object>()}}, 
               {"g_V_valuesXnameX_order_tailX7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Tail<object>(7)}}, 
               {"g_V_repeatXbothX_timesX3X_tailX7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both()).Times(3).Tail<object>(7)}}, 
               {"g_V_repeatXin_outX_timesX3X_tailX7X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.In().Out()).Times(3).Tail<object>(7).Count()}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>("a").By(__.Unfold<object>().Values<object>("name").Fold()).Tail<object>(Scope.Local, 1).Unfold<object>()}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>("a").By(__.Unfold<object>().Values<object>("name").Fold()).Tail<object>(Scope.Local).Unfold<object>()}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Tail<object>(Scope.Local, 2)}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Tail<object>(Scope.Local, (long) p["xx1"])}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Select<object>("a", "b", "c").By("name").Tail<object>(Scope.Local, 1)}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.Mixed, "a").By(__.Unfold<object>().Values<object>("name").Fold()).Tail<object>(Scope.Local, 1).Unfold<object>()}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.Mixed, "a").By(__.Unfold<object>().Values<object>("name").Fold()).Tail<object>(Scope.Local).Unfold<object>()}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXlimitXlocal_0XX_tailXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.Mixed, "a").By(__.Limit<object>(Scope.Local, 0)).Tail<object>(Scope.Local, 1)}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.Mixed, "a").By(__.Unfold<object>().Values<object>("name").Fold()).Tail<object>(Scope.Local, 2)}}, 
               {"g_VX1X_valuesXageX_tailXlocal_5X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Tail<object>(Scope.Local, 50)}}, 
               {"g_injectXlistX1_2_3XX_tailXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }).Tail<object>(Scope.Local, 1)}}, 
               {"g_VX1X_valueMapXnameX_tailXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).ValueMap<object, object>("name").Tail<object>(Scope.Local, 1)}}, 
               {"g_injectX1_2_3X_tailXlocal_1X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }).Tail<object>(Scope.Local, 1).Unfold<object>()}}, 
               {"g_injectX1_2_3_4_5_6X_tailXlocal_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3 }, new List<object> { 4, 5, 6 }).Tail<object>(Scope.Local, 1)}}, 
               {"g_injectX1_2_3_4_5X_tailXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3, 4, 5 }).Tail<object>(Scope.Local, 2)}}, 
               {"g_V_valuesXnameX_isXtypeOfXGType_STRINGXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Is(P.TypeOf(GType.String))}}, 
               {"g_V_valuesXnameX_isXtypeOfXjava_lang_StringXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Is(P.TypeOf("String"))}}, 
               {"g_V_hasXname_typeOfXGType_STRINGXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", P.TypeOf(GType.String)).Values<object>("name")}}, 
               {"g_V_orXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Or(__.Has("name", P.TypeOf(GType.String)), __.Has("age", P.TypeOf(GType.Int))).Values<object>("name")}}, 
               {"g_V_andXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().And(__.Has("name", P.TypeOf(GType.String)), __.Has("age", P.TypeOf(GType.Int))).Values<object>("name")}}, 
               {"g_V_notXhasXage_typeOfXGType_STRINGXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.Has("age", P.TypeOf(GType.String))).Values<object>("name")}}, 
               {"g_V_valuesXageX_isXnotXtypeOfXGType_STRINGXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.Not(P.TypeOf(GType.String)))}}, 
               {"g_V_valuesXnameX_isXtypeOfXstringStringXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Is(P.TypeOf("String"))}}, 
               {"g_V_orXvaluesXageX_isXtypeOfXGType_INTXX__valuesXnameX_isXtypeOfXGType_STRINGXXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Or(__.Values<object>("age").Is(P.TypeOf(GType.Int)), __.Values<object>("name").Is(P.TypeOf(GType.String))).Count()}}, 
               {"g_V_whereXvaluesXnameX_isXtypeOfXGType_STRINGXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Values<object>("name").Is(P.TypeOf(GType.String))).Values<object>("name")}}, 
               {"g_V_whereXvaluesXageX_isXtypeOfXGType_STRINGXXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Values<object>("age").Is(P.TypeOf(GType.String))).Count()}}, 
               {"g_V_whereXnotXvaluesXageX_isXtypeOfXGType_STRINGXXXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Not(__.Values<object>("age").Is(P.TypeOf(GType.String)))).Values<object>("name")}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_NULLXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Null))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_BOOLEANXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Boolean))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_CHARXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Char))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_BINARYXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Binary))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_UUIDXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.UUID))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_DATETIMEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.DateTime))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_DURATIONXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Duration))}}, 
               {"g_V_valuesXageX_isXtypeOfXnon_registered_NameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf("non-registered-Name"))}}, 
               {"g_injectXtrueX_isXtypeOfXGType_BOOLEANX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(true).Is(P.TypeOf(GType.Boolean))}}, 
               {"g_V_path_isXtypeOfXGType_PATHXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Path().Is(P.TypeOf(GType.Path))}}, 
               {"g_V_out_path_isXtypeOfXGType_PATHXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().Is(P.TypeOf(GType.Path)).Count()}}, 
               {"g_V_hasXname_markoX_out_out_path_isXtypeOfXGType_PATHXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").Out().Out().Path().Is(P.TypeOf(GType.Path))}}, 
               {"g_V_out_tree_isXtypeOfXGType_TREEXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").Out().Tree<object>().Is(P.TypeOf(GType.Tree)).Count()}}, 
               {"g_V_whereXtree_isXtypeOfXGType_TREEXXX_values_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Tree<object>().Is(P.TypeOf(GType.Tree))).Values<object>("name")}}, 
               {"g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isXtypeOfXGType_GRAPHXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE("knows").Subgraph("sg").Cap<object>("sg").Is(P.TypeOf(GType.Graph)).Count()}}, 
               {"g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isX_notXtypeOfXGType_GRAPHXXX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE("knows").Subgraph("sg").Cap<object>("sg").Is(P.Not(P.TypeOf(GType.Graph))).Count()}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_PATHXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Path))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_TREEXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Tree))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_GRAPHXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.Graph))}}, 
               {"g_V_valuesXageX_isXtypeOfXGType_VPROPERTYXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Is(P.TypeOf(GType.VProperty))}}, 
               {"g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_eqXbXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").As("a").Out().In().Has("age").As("b").Select<object>("a", "b").Where("a", P.Eq("b"))}}, 
               {"g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_neqXbXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").As("a").Out().In().Has("age").As("b").Select<object>("a", "b").Where("a", P.Neq("b"))}}, 
               {"g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXb_hasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").As("a").Out().In().Has("age").As("b").Select<object>("a", "b").Where(__.As("b").Has("name", "marko"))}}, 
               {"g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_outXknowsX_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").As("a").Out().In().Has("age").As("b").Select<object>("a", "b").Where(__.As("a").Out("knows").As("b"))}}, 
               {"g_V_asXaX_outXcreatedX_whereXasXaX_name_isXjoshXX_inXcreatedX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").Where(__.As("a").Values<object>("name").Is("josh")).In("created").Values<object>("name")}}, 
               {"g_withSideEffectXa_josh_peterX_VX1X_outXcreatedX_inXcreatedX_name_whereXwithinXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new List<object> { "josh", "peter" }).V(p["vid1"]).Out("created").In("created").Values<object>("name").Where(P.Within("a"))}}, 
               {"g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_neqXbXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where("a", P.Neq("b")).Values<object>("name")}}, 
               {"g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXasXbX_outXcreatedX_hasXname_rippleXX_valuesXage_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("created").In("created").As("b").Where(__.As("b").Out("created").Has("name", "ripple")).Values<object>("age", "name")}}, 
               {"g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXeqXaXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("created").In("created").Where(P.Eq("a")).Values<object>("name")}}, 
               {"g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("created").In("created").Where(P.Neq("a")).Values<object>("name")}}, 
               {"g_VX1X_out_aggregateXxX_out_whereXnotXwithinXaXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Aggregate("x").Out().Where(P.Not(P.Within("x")))}}, 
               {"g_withSideEffectXa_g_VX2XX_VX1X_out_whereXneqXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Where(__.Id().Where(P.Neq("a")))}}, 
               {"g_VX1X_repeatXbothEXcreatedX_whereXwithoutXeXX_aggregateXeX_otherVX_emit_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.BothE("created").Where(P.Without("e")).Aggregate("e").OtherV()).Emit().Path()}}, 
               {"g_V_whereXnotXoutXcreatedXXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Not(__.Out("created"))).Values<object>("name")}}, 
               {"g_V_asXaX_out_asXbX_whereXandXasXaX_outXknowsX_asXbX__orXasXbX_outXcreatedX_hasXname_rippleX__asXbX_inXknowsX_count_isXnotXeqX0XXXXX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Where(__.And(__.As("a").Out("knows").As("b"), __.Or(__.As("b").Out("created").Has("name", "ripple"), __.As("b").In("knows").Count().Is(P.Not(P.Eq(0)))))).Select<object>("a", "b")}}, 
               {"g_V_whereXoutXcreatedX_and_outXknowsX_or_inXknowsXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Out("created").And().Out("knows").Or().In("knows")).Values<object>("name")}}, 
               {"g_V_asXaX_outXcreatedX_asXbX_whereXandXasXbX_in__notXasXaX_outXcreatedX_hasXname_rippleXXX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").As("b").Where(__.And(__.As("b").In(), __.Not(__.As("a").Out("created").Has("name", "ripple")))).Select<object>("a", "b")}}, 
               {"g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_bothXknowsX_bothXknowsX_asXdX_whereXc__notXeqXaX_orXeqXdXXXX_selectXa_b_c_dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").As("b").In("created").As("c").Both("knows").Both("knows").As("d").Where("c", P.Not(P.Eq("a").Or(P.Eq("d")))).Select<object>("a", "b", "c", "d")}}, 
               {"g_V_asXaX_out_asXbX_whereXin_count_isXeqX3XX_or_whereXoutXcreatedX_and_hasXlabel_personXXX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Where(__.As("b").In().Count().Is(P.Eq(3)).Or().Where(__.As("b").Out("created").And().As("b").Has(T.Label, "person"))).Select<object>("a", "b")}}, 
               {"g_V_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_gtXbXX_byXageX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").In("created").As("b").Where("a", P.Gt("b")).By("age").Select<object>("a", "b").By("name")}}, 
               {"g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_whereXa_gtXbX_orXeqXbXXX_byXageX_byXweightX_byXweightX_selectXa_cX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").OutE("created").As("b").InV().As("c").Where("a", P.Gt("b").Or(P.Eq("b"))).By("age").By("weight").By("weight").Select<object>("a", "c").By("name")}}, 
               {"g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_inXcreatedX_asXdX_whereXa_ltXbX_orXgtXcXX_andXneqXdXXX_byXageX_byXweightX_byXinXcreatedX_valuesXageX_minX_selectXa_c_dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").OutE("created").As("b").InV().As("c").In("created").As("d").Where("a", P.Lt("b").Or(P.Gt("c")).And(P.Neq("d"))).By("age").By("weight").By(__.In("created").Values<object>("age").Min<object>()).Select<object>("a", "c", "d").By("name")}}, 
               {"g_VX1X_asXaX_out_hasXageX_whereXgtXaXX_byXageX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out().Has("age").Where(P.Gt("a")).By("age").Values<object>("name")}}, 
               {"g_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid3"]).As("a").In().Out().As("b").Where("a", P.Eq("b")).By("age").Values<object>("name")}}, 
               {"g_withStrategiesXProductiveByStrategyX_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V(p["vid3"]).As("a").In().Out().As("b").Where("a", P.Eq("b")).By("age").Values<object>("name")}}, 
               {"g_V_asXnX_whereXorXhasLabelXsoftwareX_hasLabelXpersonXXX_selectXnX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("n").Where(__.Or(__.HasLabel("software"), __.HasLabel("person"))).Select<object>("n").By("name")}}, 
               {"g_V_asXnX_whereXorXselectXnX_hasLabelXsoftwareX_selectXnX_hasLabelXpersonXXX_selectXnX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("n").Where(__.Or(__.Select<object>("n").HasLabel("software"), __.Select<object>("n").HasLabel("person"))).Select<object>("n").By("name")}}, 
               {"g_V_hasLabelXpersonX_asXxX_whereXinEXknowsX_count_isXgteX1XXX_selectXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("x").Where(__.InE("knows").Count().Is(P.Gte(1))).Select<object>("x")}}, 
               {"get_g_V_whereXage_isXgt_30XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Values<object>("age").Is(P.Gt(30)))}}, 
               {"g_V_whereXlabel_isXsoftwareXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Label().Is("software"))}}, 
               {"g_V_whereXlabel_isXpersonXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Label().Is("person"))}}, 
               {"g_withStrategiesXAdjacentToIncidentStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new AdjacentToIncidentStrategy()).V()}}, 
               {"g_withoutStrategiesXAdjacentToIncidentStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(AdjacentToIncidentStrategy)).V()}}, 
               {"g_withStrategiesXAdjacentToIncidentStrategyX_V_out_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new AdjacentToIncidentStrategy()).V().Out().Count()}}, 
               {"g_withStrategiesXAdjacentToIncidentStrategyX_V_whereXoutX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new AdjacentToIncidentStrategy()).V().Where(__.Out())}}, 
               {"g_withStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ByModulatorOptimizationStrategy()).V().Order().By(__.Values<object>("name"))}}, 
               {"g_withoutStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ByModulatorOptimizationStrategy)).V().Order().By(__.Values<object>("name"))}}, 
               {"g_withStrategiesXComputerFinalizationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ComputerFinalizationStrategy()).V()}}, 
               {"g_withoutStrategiesXByModulatorOptimizationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ComputerFinalizationStrategy)).V()}}, 
               {"g_withStrategiesXComputerVerificationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ComputerVerificationStrategy()).V()}}, 
               {"g_withoutStrategiesXComputerVerificationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ComputerVerificationStrategy)).V()}}, 
               {"g_withStrategiesXConnectiveStrategyStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ConnectiveStrategy()).V().Has("name", "marko").Or().Where(__.In("knows").Has("name", "marko"))}}, 
               {"g_withoutStrategiesXConnectiveStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ConnectiveStrategy)).V().Has("name", "marko").Or().Where(__.In("knows").Has("name", "marko"))}}, 
               {"g_withStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new CountStrategy()).V().Where(__.OutE().Count().Is(0))}}, 
               {"g_withoutStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(CountStrategy)).V().Where(__.OutE().Count().Is(0))}}, 
               {"g_withStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new EarlyLimitStrategy()).V().Out().Order().By("name").ValueMap<object, object>().Limit<object>(3).Select<object>("name")}}, 
               {"g_withoutStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(EarlyLimitStrategy)).V().Out().Order().By("name").ValueMap<object, object>().Limit<object>(3).Select<object>("name")}}, 
               {"g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_true_logWarning_falseXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new EdgeLabelVerificationStrategy(throwException: true, logWarning: false)).V().Out()}}, 
               {"g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_false_logWarning_falseXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new EdgeLabelVerificationStrategy(throwException: false, logWarning: false)).V().Out()}}, 
               {"g_withoutStrategiesXEdgeLabelVerificationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(EdgeLabelVerificationStrategy)).V().Out()}}, 
               {"g_withStrategiesXElementIdStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ElementIdStrategy()).V()}}, 
               {"g_withoutStrategiesXElementIdStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ElementIdStrategy)).V()}}, 
               {"g_withStrategiesXFilterRankingStrategyX_V_out_order_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new FilterRankingStrategy()).V().Out().Order().Dedup()}}, 
               {"g_withoutStrategiesXFilterRankingStrategyX_V_out_order_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(FilterRankingStrategy)).V().Out().Order().Dedup()}}, 
               {"g_withStrategiesXGraphFilterStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new GraphFilterStrategy()).V()}}, 
               {"g_withoutStrategiesXGraphFilterStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(GraphFilterStrategy)).V()}}, 
               {"g_withStrategiesXHaltedTraverserStrategyXDetachedFactoryXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new HaltedTraverserStrategy(haltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory")).V()}}, 
               {"g_withStrategiesXHaltedTraverserStrategyXReferenceFactoryXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new HaltedTraverserStrategy(haltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory")).V()}}, 
               {"g_withoutStrategiesXHaltedTraverserStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(HaltedTraverserStrategy)).V()}}, 
               {"g_withStrategiesXIdentityRemovalStrategyX_V_identity_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new IdentityRemovalStrategy()).V().Identity().Out()}}, 
               {"g_withoutStrategiesXIdentityRemovalStrategyX_V_identity_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(IdentityRemovalStrategy)).V().Identity().Out()}}, 
               {"g_withStrategiesXIncidentToAdjacentStrategyX_V_outE_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new IncidentToAdjacentStrategy()).V().OutE().InV()}}, 
               {"g_withoutStrategiesXIncidentToAdjacentStrategyX_V_outE_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(IncidentToAdjacentStrategy)).V().OutE().InV()}}, 
               {"g_withStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new InlineFilterStrategy()).V().Filter(__.Has("name", "marko"))}}, 
               {"g_withoutStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(InlineFilterStrategy)).V().Filter(__.Has("name", "marko"))}}, 
               {"g_withStrategiesXLambdaRestrictionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new LambdaRestrictionStrategy()).V()}}, 
               {"g_withoutStrategiesXLambdaRestrictionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(LambdaRestrictionStrategy)).V()}}, 
               {"g_withStrategiesXLazyBarrierStrategyX_V_out_bothE_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new LazyBarrierStrategy()).V().Out().BothE().Count()}}, 
               {"g_withoutStrategiesXLazyBarrierStrategyX_V_out_bothE_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(LazyBarrierStrategy)).V().Out().BothE().Count()}}, 
               {"g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_CountMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new MatchAlgorithmStrategy(matchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$CountMatchAlgorithm")).V().Match<object>(__.As("a").Out("knows").As("b"), __.As("a").Out("created").As("c"))}}, 
               {"g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_GreedyMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new MatchAlgorithmStrategy(matchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$GreedyMatchAlgorithm")).V().Match<object>(__.As("a").Out("knows").As("b"), __.As("a").Out("created").As("c"))}}, 
               {"g_withoutStrategiesXMatchAlgorithmStrategyX_V_matchXa_knows_b__a_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(MatchAlgorithmStrategy)).V().Match<object>(__.As("a").Out("knows").As("b"), __.As("a").Out("created").As("c"))}}, 
               {"g_withStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new MatchPredicateStrategy()).V().Match<object>(__.As("a").Out("created").Has("name", "lop").As("b"), __.As("b").In("created").Has("age", 29).As("c")).Where(__.As("c").Repeat(__.Out()).Times(2)).Select<object>("a", "b", "c")}}, 
               {"g_withoutStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(MatchPredicateStrategy)).V().Match<object>(__.As("a").Out("created").Has("name", "lop").As("b"), __.As("b").In("created").Has("age", 29).As("c")).Where(__.As("c").Repeat(__.Out()).Times(2)).Select<object>("a", "b", "c")}}, 
               {"g_withStrategiesXMessagePassingReductionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new MessagePassingReductionStrategy()).V()}}, 
               {"g_withoutStrategiesXMessagePassingReductionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(MessagePassingReductionStrategy)).V()}}, 
               {"g_V_coworker", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Filter(__.OutE("created")).Aggregate("p").As("p1").Values<object>("name").As("p1n").Select<object>("p").Unfold<object>().Where(P.Neq("p1")).As("p2").Values<object>("name").As("p2n").Select<object>("p2").Out("created").Choose<object>(__.In("created").Where(P.Eq("p1")), __.Values<object>("name"), __.Constant<object>(new List<object> {  })).Group<object, object>().By(__.Select<object>("p1n")).By(__.Group<object, object>().By(__.Select<object>("p2n")).By(__.Unfold<object>().Fold().Project<object>("numCoCreated", "coCreated").By(__.Count(Scope.Local)).By())).Unfold<object>()}}, 
               {"g_V_coworker_with_midV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Filter(__.OutE("created")).As("p1").V().HasLabel("person").Where(P.Neq("p1")).Filter(__.OutE("created")).As("p2").Map<object>(__.Out("created").Where(__.In("created").As("p1")).Values<object>("name").Fold()).Group<object, object>().By(__.Select<object>("p1").By("name")).By(__.Group<object, object>().By(__.Select<object>("p2").By("name")).By(__.Project<object>("numCoCreated", "coCreated").By(__.Count(Scope.Local)).By())).Unfold<object>()}}, 
               {"g_withStrategiesXOptionsStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new OptionsStrategy()).V()}}, 
               {"g_withStrategiesXOptionsStrategyXmyVar_myValueXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new OptionsStrategy(new Dictionary<string, object> {{"myVar","myValue"},})).V()}}, 
               {"g_withoutStrategiesXOptionsStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(OptionsStrategy)).V()}}, 
               {"g_withStrategiesXOrderLimitStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new OrderLimitStrategy()).V()}}, 
               {"g_withoutStrategiesXOrderLimitStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(OrderLimitStrategy)).V()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).V().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a", "b" })).V().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "bob"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "c" })).V().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_bothE_weight", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).V().BothE().Values<object>("weight")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_bothE_weight", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "b" })).V().BothE().Values<object>("weight")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_bothE_dedup_weight", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a", "b" })).V().BothE().Dedup().Values<object>("weight")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_bothE_weight", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "c" })).V().BothE().Values<object>("weight")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_both_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).V().Both().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_both_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "b" })).V().Both().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_both_dedup_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a", "b" })).V().Both().Dedup().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_both_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "c" })).V().Both().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_out_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).V().Out().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_in_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "b" })).V().In().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_out_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a", "b" })).V().Out().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_out_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").As("a").AddV("person").Property("_partition", "b").Property("name", "bob").As("b").AddE("knows").From("a").To("b").Property("_partition", "a").Property("weight", 1.0d).AddE("knows").From("b").To("a").Property("_partition", "b").Property("weight", 2.0d), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "c" })).V().Out().Values<object>("name")}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_addVXpersonX_propertyXname_aliceX_addXselfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).AddV("person").Property("name", "alice").AddE("self"), (g,p) =>g.V().Has("person", "name", "alice").Has("_partition", "a"), (g,p) =>g.V(), (g,p) =>g.E().Has("_partition", "a"), (g,p) =>g.E()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectXzeroX_addVXpersonX_propertyXname_aliceX_addXselfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).Inject<object>(0).AddV("person").Property("name", "alice").AddE("self"), (g,p) =>g.V().Has("person", "name", "alice").Has("_partition", "a"), (g,p) =>g.V(), (g,p) =>g.E().Has("_partition", "a"), (g,p) =>g.E()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "alice").Has("_partition", "a"), (g,p) =>g.V()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X_mergeV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "alice").Has("_partition", "a"), (g,p) =>g.V()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.E().Has("knows", "_partition", "a"), (g,p) =>g.E()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0XmergeE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "a").Property("name", "bob"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).Inject<object>(0).MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.E().Has("knows", "_partition", "a"), (g,p) =>g.E()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeVXlabel_person_name_aliceX_optionXonMatch_name_bobX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "a").Property("name", "alice").AddV("person").Property("_partition", "b").Property("name", "alice"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("person", "name", "bob").Has("_partition", "a"), (g,p) =>g.V()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV_optionXonCreateX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "b").Property("name", "alice"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a"), (g,p) =>g.V()}}, 
               {"g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X__mergeV_optionXonCreateX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("_partition", "b").Property("name", "alice"), (g,p) =>g.WithStrategies(new PartitionStrategy(partitionKey: "_partition", writePartition: "a", readPartitions: new HashSet<string> { "a" })).Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("name", "alice").Has("age", 35).Has("_partition", "a"), (g,p) =>g.V()}}, 
               {"g_withStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PathProcessorStrategy()).V().As("a").Select<object>("a").By(__.Values<object>("name"))}}, 
               {"g_withoutStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(PathProcessorStrategy)).V().As("a").Select<object>("a").By(__.Values<object>("name"))}}, 
               {"g_withStrategiesXPathRetractionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new PathRetractionStrategy()).V()}}, 
               {"g_withoutStrategiesXPathRetractionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(PathRetractionStrategy)).V()}}, 
               {"g_V_shortestpath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Both().As("v").Project<object>("src", "tgt", "p").By(__.Select<object>(Pop.First, "v")).By(__.Select<object>(Pop.Last, "v")).By(__.Select<object>(Pop.All, "v")).As("triple").Group("x").By(__.Select<object>("src", "tgt")).By(__.Select<object>("p").Fold()).Select<object>("tgt").Barrier().Repeat(__.Both().As("v").Project<object>("src", "tgt", "p").By(__.Select<object>(Pop.First, "v")).By(__.Select<object>(Pop.Last, "v")).By(__.Select<object>(Pop.All, "v")).As("t").Filter(__.Select<object>(Pop.All, "p").Count(Scope.Local).As("l").Select<object>(Pop.Last, "t").Select<object>(Pop.All, "p").Dedup(Scope.Local).Count(Scope.Local).Where(P.Eq("l"))).Where("src", P.Neq("tgt")).Select<object>(Pop.Last, "t").Not(__.Select<object>(Pop.All, "p").As("p").Count(Scope.Local).As("l").Select<object>(Pop.All, "x").Unfold<object>().Filter(__.Select<object>(Column.Keys).Where(P.Eq("t")).By(__.Select<object>("src", "tgt"))).Filter(__.Select<object>(Column.Values).Unfold<object>().Or(__.Count(Scope.Local).Where(P.Lt("l")), __.Where(P.Eq("p"))))).Barrier().Group("x").By(__.Select<object>("src", "tgt")).By(__.Select<object>(Pop.All, "p").Fold()).Select<object>("tgt").Barrier()).Cap<object>("x").Select<object>(Column.Values).Unfold<object>().Unfold<object>().Map<object>(__.Unfold<object>().Values<object>("name").Fold())}}, 
               {"g_V_playlist_paths", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SeedStrategy(seed: 99999)).V().Has("name", "Bob_Dylan").In("sungBy").As("a").Repeat(__.Out().Order().By(Order.Shuffle).SimplePath().From("a")).Until(__.Out("writtenBy").Has("name", "Johnny_Cash")).Limit<object>(1).As("b").Repeat(__.Out().Order().By(Order.Shuffle).As("c").SimplePath().From("b").To("c")).Until(__.Out("sungBy").Has("name", "Grateful_Dead")).Limit<object>(1).Path().From("a").Unfold<object>().Project<object>("song", "artists").By("name").By(__.Coalesce<object>(__.Out("sungBy", "writtenBy").Dedup().Values<object>("name"), __.Constant<object>("Unknown")).Fold())}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Group<object, object>().By("age").By("name")}}, 
               {"g_withoutStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ProductiveByStrategy)).V().Group<object, object>().By("age").By("name")}}, 
               {"g_withStrategiesXProfileStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProfileStrategy()).V()}}, 
               {"g_withoutStrategiesXProfileStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ProfileStrategy)).V()}}, 
               {"g_withStrategiesXReadOnlyStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).V()}}, 
               {"g_withStrategiesXReadOnlyStrategyX_V_outXknowsX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).V().Out("knows").Values<object>("name")}}, 
               {"g_withStrategiesXReadOnlyStrategyX_addVXpersonX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).AddV("person")}}, 
               {"g_withStrategiesXReadOnlyStrategyX_addVXpersonX_fromXVX1XX_toXVX2XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).AddE("link").From(__.V(p["vid1"])).To(__.V(p["vid2"]))}}, 
               {"g_withStrategiesXReadOnlyStrategyX_V_addVXpersonX_fromXVX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).V().AddE("link").From(__.V(p["vid1"]))}}, 
               {"g_withStrategiesXReadOnlyStrategyX_V_propertyXname_joshX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).V().Property("name", "josh")}}, 
               {"g_withStrategiesXReadOnlyStrategyX_E_propertyXweight_0X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReadOnlyStrategy()).E().Property("weight", 0)}}, 
               {"g_V_classic_recommendation", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "DARK STAR").As("a").Out("followedBy").Aggregate("stash").In("followedBy").Where(P.Neq("a").And(P.Not(P.Within("stash")))).GroupCount<object>().Unfold<object>().Project<object>("x", "y", "z").By(__.Select<object>(Column.Keys).Values<object>("name")).By(__.Select<object>(Column.Keys).Values<object>("performances")).By(__.Select<object>(Column.Values)).Order().By(__.Select<object>("z"), Order.Desc).By(__.Select<object>("y"), Order.Asc).Limit<object>(5).Local<object>(__.Aggregate("m")).Select<object>("x")}}, 
               {"g_V_classic_recommendation_ranked", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "DARK STAR").As("a").Out("followedBy").Aggregate("stash").In("followedBy").Where(P.Neq("a").And(P.Not(P.Within("stash")))).GroupCount<object>().Unfold<object>().Project<object>("x", "y", "z").By(__.Select<object>(Column.Keys).Values<object>("name")).By(__.Select<object>(Column.Keys).Values<object>("performances")).By(__.Select<object>(Column.Values)).Order().By(__.Select<object>("z"), Order.Desc).By(__.Select<object>("y"), Order.Asc).Limit<object>(5).Local<object>(__.Aggregate("m"))}}, 
               {"g_withStrategiesXReferenceElementStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReferenceElementStrategy()).V()}}, 
               {"g_withoutStrategiesXReferenceElementStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ReferenceElementStrategy)).V()}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.Out()).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.Out()).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.In()).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.In()).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.Out().Has("name", TextP.NotStartingWith("z"))).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.Out().Has("name", TextP.NotStartingWith("z"))).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.In().Has("age", P.Gt(20))).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.In().Has("age", P.Gt(20))).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.Both().Has("age", P.Lt(30))).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.Both().Has("age", P.Lt(30))).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.BothE().OtherV().Has("age", P.Lt(30))).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.BothE().OtherV().Has("age", P.Lt(30))).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.Both().Limit<object>(1)).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.Both().Limit<object>(1)).Times(2)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Order().By("name").Repeat(__.Both().Order().By("name").Aggregate("x")).Times(2).Limit<object>(10)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Order().By("name").Repeat(__.Both().Order().By("name").Aggregate("x")).Times(2).Limit<object>(10)}}, 
               {"g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new RepeatUnrollStrategy()).V().Repeat(__.Both().Sample(1)).Times(2)}}, 
               {"g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(RepeatUnrollStrategy)).V().Repeat(__.Both().Sample(1)).Times(2)}}, 
               {"g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXid_123X_propertyXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReservedKeysVerificationStrategy(throwException: true)).AddV("person").Property("id", 123).Property("name", "marko")}}, 
               {"g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXage_29X_propertyXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ReservedKeysVerificationStrategy(throwException: true, keys: new HashSet<string> { "age" })).AddV("person").Property("age", 29).Property("name", "marko")}}, 
               {"g_withoutStrategiesXReservedKeysVerificationStrategyX_addVXpersonX_propertyXid_123X_propertyXname_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(ReservedKeysVerificationStrategy)).AddV("person").Property("id", 123).Property("name", "marko").Values<object>()}}, 
               {"g_withoutStrategiesXSeedStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(SeedStrategy)).V()}}, 
               {"g_withStrategiesXStandardVerificationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new StandardVerificationStrategy()).V()}}, 
               {"g_withoutStrategiesXStandardVerificationStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(StandardVerificationStrategy)).V()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).E()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_inE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).InE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).Out()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_in", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).In()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_both", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).Both()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_bothE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).BothE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_localXbothE_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).V(p["vid4"]).Local<object>(__.BothE().Limit<object>(1))}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX11X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).E(p["eid11"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX12X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")))).E(p["eid12"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).E()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid1"]).OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid1"]).Out()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outXcreatedX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid1"]).Out("knows")}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outXcreatedX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Out("created")}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Out()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_bothE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).BothE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_both", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Both()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outV_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.Or(__.Has("weight", 1.0).HasLabel("knows"), __.Has("weight", 0.4).HasLabel("created").OutV().Has("name", "marko"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid8"]).OutV().OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_hasXname_markoXXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.In("knows").Has("name", "marko"))).V().Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoXXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.In().Has("name", "marko"))).V().Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_whereXoutXcreatedX_hasXname_lopXXXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.In("knows").Where(__.Out("created").Has("name", "lop")))).V().Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoX_outXcreatedX_hasXname_lopXXXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.In().Where(__.Has("name", "marko").Out("created").Has("name", "lop")))).V().Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_orXboth_hasXname_markoX_hasXname_markoXXXX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Or(__.Both().Has("name", "marko"), __.Has("name", "marko")))).V().Where(__.BothE().Count().Is(P.Neq(0))).Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_inE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).InE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Out()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_in", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).In()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_both", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Both()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_bothE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).BothE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_localXbothE_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Local<object>(__.BothE().Limit<object>(1))}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX11X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid11"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX12X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid12"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX9X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid9"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_hasXname_withinXripple_josh_markoXXX_V_asXaX_out_in_asXbX_dedupXa_bX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertices: __.Has("name", P.Within("ripple", "josh", "marko")))).V().As("a").Out().In().As("b").Dedup("a", "b").Values<object>("name")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)))).V().Properties<object>("location").Value<object>()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)))).V().Values<object>("location")}}, 
               {"g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_propertiesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_value_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)))).V().As("a").Properties<object>("location").As("b").Select<object>("a").OutE().Properties<object>().Select<object>("b").Value<object>().Dedup()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_valuesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)))).V().As("a").Values<object>("location").As("b").Select<object>("a").OutE().Properties<object>().Select<object>("b").Dedup()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)), vertices: __.Has("name", P.Neq("stephen")))).V().Properties<object>("location").Value<object>()}}, 
               {"g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(vertexProperties: __.Has("startTime", P.Gt(2005)), vertices: __.Has("name", P.Neq("stephen")))).V().Values<object>("location")}}, 
               {"g_withStrategiesXSubgraphStrategyXedges_hasLabelXusesX_hasXskill_5XXX_V_outE_valueMap_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(edges: __.HasLabel("uses").Has("skill", 5))).V().OutE().ValueMap<object, object>().Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E()}}, 
               {"g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: true, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).OutE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_inE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).InE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Out()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_in", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).In()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_both", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Both()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_bothE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).BothE()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_localXbothE_limitX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).V(p["vid4"]).Local<object>(__.BothE().Limit<object>(1))}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX11X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid11"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX12X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid12"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX9X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: false, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid9"]).BothV()}}, 
               {"g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_EX9X_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new SubgraphStrategy(checkAdjacentVertices: true, vertices: __.Has("name", P.Within("josh", "lop", "ripple")), edges: __.Or(__.Has("weight", 0.4).HasLabel("created"), __.Has("weight", 1.0).HasLabel("created")))).E(p["eid9"]).BothV()}}, 
               {"g_withStrategiesXVertexProgramRestrictionStrategyX_withoutStrategiesXVertexProgramStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new VertexProgramRestrictionStrategy()).WithoutStrategies(typeof(VertexProgramStrategy)).V()}}, 
               {"g_withStrategiesXVertexProgramRestrictionStrategy_VertexProgramStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new VertexProgramRestrictionStrategy(), new VertexProgramStrategy()).V()}}, 
               {"g_withoutStrategiesXVertexProgramRestrictionStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(VertexProgramRestrictionStrategy)).WithStrategies(new VertexProgramStrategy()).V()}}, 
               {"g_withStrategiesXVertexProgramStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new VertexProgramStrategy()).V()}}, 
               {"g_withoutStrategiesXVertexProgramStrategyX_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithoutStrategies(typeof(VertexProgramStrategy)).V()}}, 
               {"g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a"), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).InE()}}, 
               {"g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).As("a").Out("created").AddE("createdBy").To("a").Property("weight", 2.0d), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE().Has("weight", 2.0d)}}, 
               {"g_V_outE_propertyXweight_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().OutE().Property("weight", null), (g,p) =>g.E().Properties<object>("weight")}}, 
               {"g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Aggregate("x").As("a").Select<object>("x").Unfold<object>().AddE("existsWith").To("a").Property("time", "now"), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE("existsWith"), (g,p) =>g.V(p["vid1"]).OutE("existsWith"), (g,p) =>g.V(p["vid1"]).BothE("existsWith").Has("time", "now"), (g,p) =>g.V(p["vid2"]).BothE(), (g,p) =>g.V(p["vid2"]).InE("existsWith"), (g,p) =>g.V(p["vid2"]).OutE("existsWith"), (g,p) =>g.V(p["vid2"]).BothE("existsWith").Has("time", "now"), (g,p) =>g.V(p["vid3"]).BothE(), (g,p) =>g.V(p["vid3"]).InE("existsWith"), (g,p) =>g.V(p["vid3"]).OutE("existsWith"), (g,p) =>g.V(p["vid3"]).BothE("existsWith").Has("time", "now"), (g,p) =>g.V(p["vid4"]).BothE(), (g,p) =>g.V(p["vid4"]).InE("existsWith"), (g,p) =>g.V(p["vid4"]).OutE("existsWith"), (g,p) =>g.V(p["vid4"]).BothE("existsWith").Has("time", "now"), (g,p) =>g.V(p["vid5"]).BothE(), (g,p) =>g.V(p["vid5"]).InE("existsWith"), (g,p) =>g.V(p["vid5"]).OutE("existsWith"), (g,p) =>g.V(p["vid5"]).BothE("existsWith").Has("time", "now"), (g,p) =>g.V(p["vid6"]).BothE(), (g,p) =>g.V(p["vid6"]).InE("existsWith"), (g,p) =>g.V(p["vid6"]).OutE("existsWith"), (g,p) =>g.V(p["vid6"]).BothE("existsWith").Has("time", "now")}}, 
               {"g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().As("a").Out("created").In("created").Where(P.Neq("a")).As("b").AddE("codeveloper").From("a").To("b").Property("year", 2009), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE("codeveloper"), (g,p) =>g.V(p["vid1"]).OutE("codeveloper"), (g,p) =>g.V(p["vid1"]).BothE("codeveloper").Has("year", 2009), (g,p) =>g.V(p["vid2"]).BothE(), (g,p) =>g.V(p["vid4"]).BothE(), (g,p) =>g.V(p["vid4"]).InE("codeveloper"), (g,p) =>g.V(p["vid4"]).OutE("codeveloper"), (g,p) =>g.V(p["vid4"]).BothE("codeveloper").Has("year", 2009), (g,p) =>g.V(p["vid6"]).BothE(), (g,p) =>g.V(p["vid6"]).InE("codeveloper"), (g,p) =>g.V(p["vid6"]).OutE("codeveloper"), (g,p) =>g.V(p["vid6"]).BothE("codeveloper").Has("year", 2009)}}, 
               {"g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().As("a").In("created").AddE("createdBy").From("a").Property("year", 2009).Property("acl", "public"), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE("createdBy"), (g,p) =>g.V(p["vid1"]).OutE("createdBy"), (g,p) =>g.V(p["vid1"]).BothE("createdBy").Has("year", 2009).Has("acl", "public"), (g,p) =>g.V(p["vid2"]).BothE(), (g,p) =>g.V(p["vid3"]).BothE(), (g,p) =>g.V(p["vid3"]).InE("createdBy"), (g,p) =>g.V(p["vid3"]).OutE("createdBy"), (g,p) =>g.V(p["vid3"]).BothE("createdBy").Has("year", 2009).Has("acl", "public"), (g,p) =>g.V(p["vid4"]).BothE(), (g,p) =>g.V(p["vid4"]).InE("createdBy"), (g,p) =>g.V(p["vid4"]).OutE("createdBy"), (g,p) =>g.V(p["vid4"]).BothE("createdBy").Has("year", 2009).Has("acl", "public"), (g,p) =>g.V(p["vid5"]).BothE(), (g,p) =>g.V(p["vid5"]).InE("createdBy"), (g,p) =>g.V(p["vid5"]).OutE("createdBy"), (g,p) =>g.V(p["vid5"]).BothE("createdBy").Has("year", 2009).Has("acl", "public"), (g,p) =>g.V(p["vid6"]).BothE(), (g,p) =>g.V(p["vid6"]).InE("createdBy"), (g,p) =>g.V(p["vid6"]).OutE("createdBy"), (g,p) =>g.V(p["vid6"]).BothE("createdBy").Has("year", 2009).Has("acl", "public")}}, 
               {"g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).AddE("knows").To("b").Property("weight", 0.5d), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE("knows"), (g,p) =>g.V(p["vid1"]).OutE("knows"), (g,p) =>g.V(p["vid1"]).BothE("knows").Has("weight", 0.5), (g,p) =>g.V(p["vid6"]).BothE(), (g,p) =>g.V(p["vid6"]).InE("knows"), (g,p) =>g.V(p["vid6"]).OutE("knows"), (g,p) =>g.V(p["vid6"]).BothE("knows").Has("weight", 0.5)}}, 
               {"g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().As("first").Repeat(__.AddE("next").To(__.AddV()).InV()).Times(5).AddE("next").To(__.Select<object>("first")), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("next"), (g,p) =>g.V().Limit<object>(1).BothE(), (g,p) =>g.V().Limit<object>(1).InE(), (g,p) =>g.V().Limit<object>(1).OutE()}}, 
               {"g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Has("name", "marko").As("a").OutE("created").As("b").InV().AddE(__.Select<object>("b").Label()).To("a"), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).BothE(), (g,p) =>g.V(p["vid1"]).InE("created"), (g,p) =>g.V(p["vid1"]).In("created").Has("name", "lop"), (g,p) =>g.V(p["vid1"]).OutE("created")}}, 
               {"g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddE(__.V().OutE().Label().GroupCount<object>().Order(Scope.Local).By(Column.Values, Order.Desc).Select<object>(Column.Keys).Unfold<object>().Limit<object>(1)).From(__.V().Has("name", "vadas")).To(__.V().Has("name", "lop")), (g,p) =>g.E(), (g,p) =>g.V(p["vid2"]).BothE(), (g,p) =>g.V(p["vid2"]).InE("knows"), (g,p) =>g.V(p["vid2"]).OutE("created"), (g,p) =>g.V(p["vid2"]).Out("created").Has("name", "lop")}}, 
               {"g_addEXknowsX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddE("knows").From(__.V(p["vid1"])).To(__.V(p["vid6"])).Property("weight", p["xx1"]), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).OutE("knows"), (g,p) =>g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
               {"g_addEXknowsvarX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddE((string) p["xx1"]).From(__.V(p["vid1"])).To(__.V(p["vid6"])).Property("weight", p["xx2"]), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).OutE("knows"), (g,p) =>g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
               {"g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).AddE("knows").To(__.V(p["vid6"])).Property("weight", p["xx1"]), (g,p) =>g.E(), (g,p) =>g.V(p["vid1"]).OutE("knows"), (g,p) =>g.V(p["vid1"]).Out("knows").Has("name", "peter")}}, 
               {"g_addEXknowsXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.AddE("knows").Property("weight", null).From(__.V().Has("name", "marko")).To(__.V().Has("name", "vadas")), (g,p) =>g.E().Has("knows", "weight", (object) null)}}, 
               {"g_addEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.AddE((string) p["xx1"]).Property("weight", null).From(__.V().Has("name", "marko")).To(__.V().Has("name", "vadas")), (g,p) =>g.E().Has("knows", "weight", (object) null)}}, 
               {"g_unionXaddEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.Union<object>(__.AddE((string) p["xx1"]).Property("weight", 1).From(__.V().Has("name", "marko")).To(__.V().Has("name", "vadas"))), (g,p) =>g.E().Has("knows", "weight", 1)}}, 
               {"g_addEXedgeX_fromXV_hasXname_markoXX_toXV_hasXname_vadasXX_propertyXweight_0_5X_withXkey_valueX_valuesXweight_keyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.AddE("edge").From(__.V().Has("name", "marko")).To(__.V().Has("name", "vadas")).Property("weight", 0.5).With("key", "value").Values<object>("weight", "key")}}, 
               {"g_VX1X_addVXanimalX_propertyXage_selectXaX_byXageXX_propertyXname_puppyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V(p["vid1"]).As("a").AddV("animal").Property("age", __.Select<object>("a").By("age")).Property("name", "puppy"), (g,p) =>g.V().Has("animal", "age", 29)}}, 
               {"g_V_addVXanimalX_propertyXage_0X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().AddV("animal").Property("age", 0), (g,p) =>g.V().Has("animal", "age", 0)}}, 
               {"g_V_addVXanimalvarX_propertyXage_0varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().AddV((string) p["xx1"]).Property("age", p["xx2"]), (g,p) =>g.V().Has("animal", "age", 0)}}, 
               {"g_addVXpersonX_propertyXname_stephenX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV("person").Property("name", "stephen"), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_addVXpersonvarX_propertyXname_stephenvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV((string) p["xx1"]).Property("name", p["xx2"]), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_V_hasLabelXpersonX_propertyXname_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().HasLabel("person").Property(Cardinality.Single, "name", (object) null), (g,p) =>g.V().Properties<object>("name")}}, 
               {"g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV("person").Property(Cardinality.Single, "name", "stephen").Property(Cardinality.Single, "name", "stephenm"), (g,p) =>g.V().Has("person", "name", "stephen"), (g,p) =>g.V().Has("person", "name", "stephenm")}}, 
               {"get_g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV("person").Property(Cardinality.Single, "name", "stephen").Property(Cardinality.Single, "name", "stephenm", "since", 2010), (g,p) =>g.V().Has("person", "name", "stephen"), (g,p) =>g.V().Has("person", "name", "stephenm"), (g,p) =>g.V().Has("person", "name", "stephenm").Properties<object>("name").Has("since", 2010)}}, 
               {"g_V_hasXname_markoX_propertyXfriendWeight_outEXknowsX_weight_sum__acl_privateX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Has("name", "marko").Property("friendWeight", __.OutE("knows").Values<object>("weight").Sum<object>(), "acl", "private"), (g,p) =>g.V().Has("person", "name", "marko").Has("friendWeight", 1.5), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("friendWeight").Has("acl", "private"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("friendWeight").Count()}}, 
               {"g_addVXanimalX_propertyXname_mateoX_propertyXname_gateoX_propertyXname_cateoX_propertyXage_5X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV("animal").Property("name", "mateo").Property("name", "gateo").Property("name", "cateo").Property("age", 5), (g,p) =>g.V().HasLabel("animal").Has("name", "mateo").Has("name", "gateo").Has("name", "cateo").Has("age", 5)}}, 
               {"g_withSideEffectXa_markoX_addV_propertyXname_selectXaXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.WithSideEffect("a", "marko").AddV().Property("name", __.Select<object>("a")).Values<object>("name"), (g,p) =>g.V().Has("name", "marko")}}, 
               {"g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV("person").Property(Cardinality.Single, "name", "stephen").Property(Cardinality.Single, "name", "stephenm", "since", 2010), (g,p) =>g.V().Has("name", "stephen"), (g,p) =>g.V().Has("name", "stephenm"), (g,p) =>g.V().Has("name", "stephenm").Properties<object>("name").Has("since", 2010)}}, 
               {"g_V_addVXanimalX_propertyXname_valuesXnameXX_propertyXname_an_animalX_propertyXvaluesXnameX_labelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().AddV("animal").Property("name", __.Values<object>("name")).Property("name", "an animal").Property(__.Values<object>("name"), __.Label()), (g,p) =>g.V().HasLabel("animal").Has("name", "marko").Has("name", "an animal").Has("marko", "person"), (g,p) =>g.V().HasLabel("animal").Has("name", "vadas").Has("name", "an animal").Has("vadas", "person"), (g,p) =>g.V().HasLabel("animal").Has("name", "lop").Has("name", "an animal").Has("lop", "software"), (g,p) =>g.V().HasLabel("animal").Has("name", "josh").Has("name", "an animal").Has("josh", "person"), (g,p) =>g.V().HasLabel("animal").Has("name", "ripple").Has("name", "an animal").Has("ripple", "software"), (g,p) =>g.V().HasLabel("animal").Has("name", "peter").Has("name", "an animal").Has("peter", "person")}}, 
               {"g_withSideEffectXa_testX_V_hasLabelXsoftwareX_propertyXtemp_selectXaXX_valueMapXname_tempX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.WithSideEffect("a", "test").V().HasLabel("software").Property("temp", __.Select<object>("a")).ValueMap<object, object>("name", "temp")}}, 
               {"g_withSideEffectXa_nameX_addV_propertyXselectXaX_markoX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.WithSideEffect("a", "name").AddV().Property(__.Select<object>("a"), "marko").Values<object>("name"), (g,p) =>g.V().Has("name", "marko")}}, 
               {"g_V_asXaX_hasXname_markoX_outXcreatedX_asXbX_addVXselectXaX_labelX_propertyXtest_selectXbX_labelX_valueMap_withXtokensX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().As("a").Has("name", "marko").Out("created").As("b").AddV(__.Select<object>("a").Label()).Property("test", __.Select<object>("b").Label()).ValueMap<object, object>().With(WithOptions.Tokens), (g,p) =>g.V().Has("person", "test", "software")}}, 
               {"g_addVXV_hasXname_markoX_propertiesXnameX_keyX_label", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV(__.V().Has("name", "marko").Properties<object>("name").Key()).Label()}}, 
               {"g_addV_propertyXlabel_personX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(T.Label, "person"), (g,p) =>g.V().HasLabel("person")}}, 
               {"g_addV_propertyXlabel_personvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(T.Label, p["xx1"]), (g,p) =>g.V().HasLabel("person")}}, 
               {"g_addV_propertyXid_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(T.Id, 1), (g,p) =>g.V().HasId("1")}}, 
               {"g_addV_propertyXidvar_1varX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(T.Id, p["xx1"]), (g,p) =>g.V().HasId("1")}}, 
               {"g_addV_propertyXmapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(new Dictionary<object, object> {{ "name", "foo" }, { "age", 42 }}), (g,p) =>g.V().Has("name", "foo")}}, 
               {"g_addV_propertyXsingle_mapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(Cardinality.Single, new Dictionary<object, object> {{ "name", "foo" }, { "age", 42 }}), (g,p) =>g.V().Has("name", "foo")}}, 
               {"g_V_hasXname_fooX_propertyXname_setXbarX_age_43X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(Cardinality.Single, "name", "foo").Property("age", 42), (g,p) =>g.V().Has("name", "foo").Property(new Dictionary<object, object> {{ "name", CardinalityValue.Set("bar") }, { "age", 43 }}), (g,p) =>g.V().Has("name", "foo"), (g,p) =>g.V().Has("name", "bar"), (g,p) =>g.V().Has("age", 43), (g,p) =>g.V().Has("age", 42)}}, 
               {"g_V_hasXname_fooX_propertyXset_name_bar_age_singleX43XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property(Cardinality.Single, "name", "foo").Property("age", 42), (g,p) =>g.V().Has("name", "foo").Property(Cardinality.Set, new Dictionary<object, object> {{ "name", "bar" }, { "age", CardinalityValue.Single(43) }}), (g,p) =>g.V().Has("name", "foo"), (g,p) =>g.V().Has("name", "bar"), (g,p) =>g.V().Has("age", 43), (g,p) =>g.V().Has("age", 42)}}, 
               {"g_addV_propertyXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property(null), (g,p) =>g.V().HasLabel("person").Values<object>()}}, 
               {"g_addV_propertyXemptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property(new Dictionary<object, object> {}), (g,p) =>g.V().HasLabel("person").Values<object>()}}, 
               {"g_addV_propertyXset_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("foo").Property(Cardinality.Set, null), (g,p) =>g.V().HasLabel("foo").Values<object>()}}, 
               {"g_addV_propertyXset_emptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("foo").Property(Cardinality.Set, new Dictionary<object, object> {}), (g,p) =>g.V().HasLabel("person").Values<object>()}}, 
               {"g_addVXpersonX_propertyXname_joshX_propertyXage_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "josh").Property("age", null), (g,p) =>g.V().Has("person", "age", (object) null)}}, 
               {"g_addVXpersonX_propertyXname_markoX_propertyXfriendWeight_null_acl_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("friendWeight", null, "acl", null), (g,p) =>g.V().Has("person", "name", "marko").Has("friendWeight", (object) null), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("friendWeight").Has("acl", (object) null), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("friendWeight").Count()}}, 
               {"g_V_hasXperson_name_aliceX_propertyXsingle_age_unionXage_constantX1XX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").Property(Cardinality.Single, "age", 50), (g,p) =>g.V().Has("person", "name", "alice").Property("age", __.Union<object>(__.Values<object>("age"), __.Constant<object>(1)).Sum<object>()), (g,p) =>g.V().Has("person", "age", 50), (g,p) =>g.V().Has("person", "age", 51)}}, 
               {"g_V_limitX3X_addVXsoftwareX_aggregateXa1X_byXlabelX_aggregateXa2X_byXlabelX_capXa1_a2X_selectXa_bX_byXunfoldX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Limit<object>(3).AddV("software").Aggregate("a1").By(T.Label).Aggregate("a2").By(T.Label).Cap<object>("a1", "a2").Select<object>("a1", "a2").By(__.Unfold<object>().Fold())}}, 
               {"g_addV_propertyXname_markoX_withXkey_valueX_valuesXname_keyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("name", "marko").With("key", "value").Values<object>("name", "key")}}, 
               {"g_addV_propertyXname_marko_since_2010X_withXkey_valueX_propertiesXnameX_valuesXsince_keyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV().Property("name", "marko", "since", 2010).With("key", "value").Properties<object>("name").Values<object>("since", "key")}}, 
               {"g_injectX1X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).AsBool()}}, 
               {"g_injectX3_14X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(3.14).AsBool()}}, 
               {"g_injectXneg_1X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(-1).AsBool()}}, 
               {"g_injectX0X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(0).AsBool()}}, 
               {"g_injectXneg_0X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(-0.0).AsBool()}}, 
               {"g_injectXNaNX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).AsBool()}}, 
               {"g_injectXbool_trueX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(true).AsBool()}}, 
               {"g_injectXfalseX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(false).AsBool()}}, 
               {"g_injectXtrueX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("true").AsBool()}}, 
               {"g_injectXmixed_trueX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("tRUe").AsBool()}}, 
               {"g_injectXnullX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).AsBool()}}, 
               {"g_injectXhelloX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("hello").AsBool()}}, 
               {"g_injectX1_2X_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).AsBool()}}, 
               {"g_VXX_localX_outE_countX_asBool", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.OutE().Count()).AsBool()}}, 
               {"g_V_sackXassignX_byX_hasLabelXpersonX_count_asBoolX_sackXandX_byX_outE_count_asBoolX_sack_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sack(Operator.Assign).By(__.HasLabel("person").Count().AsBool()).Sack(Operator.And).By(__.OutE().Count().AsBool()).Sack<object>().Path()}}, 
               {"g_injectXstrX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("2023-08-02T00:00:00Z").AsDate()}}, 
               {"g_injectXstr_offsetX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("2023-08-02T00:00:00-07:00").AsDate()}}, 
               {"g_injectX1694017707000X_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1694017707000).AsDate()}}, 
               {"g_injectX1694017708000LX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1694017708000l).AsDate()}}, 
               {"g_injectX1694017709000dX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1694017709000.1d).AsDate()}}, 
               {"g_injectX1_2X_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).AsDate()}}, 
               {"g_injectXnullX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).AsDate()}}, 
               {"g_injectXinvalidstrX_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("This String is not an ISO 8601 Date").AsDate()}}, 
               {"g_V_valuesXbirthdayX_asDate_asNumber_asDate", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").Property("birthday", "2020-08-02").AddV("person").Property("name", "john").Property("birthday", "1988-12-10").AddV("person").Property("name", "charlie").Property("birthday", "2002-02-01").AddV("person").Property("name", "suzy").Property("birthday", "1965-10-31"), (g,p) =>g.V().Values<object>("birthday").AsDate().AsNumber().AsDate()}}, 
               {"g_injectX5bX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 5).AsNumber()}}, 
               {"g_injectX5sX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((short) 5).AsNumber()}}, 
               {"g_injectX5iX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5).AsNumber()}}, 
               {"g_injectX5lX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5l).AsNumber()}}, 
               {"g_injectX5nX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(BigInteger.Parse("5")).AsNumber()}}, 
               {"g_injectX5_0X_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5.0).AsNumber()}}, 
               {"g_injectX5_75fX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5.75f).AsNumber()}}, 
               {"g_injectX5X_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("5").AsNumber()}}, 
               {"g_injectXtestX_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("test").AsNumber()}}, 
               {"g_injectX_1_2_3_4X_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3, 4 }).AsNumber()}}, 
               {"g_injectX1_2_3_4X_unfold_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2, 3, 4 }).Unfold<object>().AsNumber()}}, 
               {"g_injectX_1__2__3__4_X_asNumberXX_foldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("1", 2, "3", 4).AsNumber().Fold()}}, 
               {"g_injectX5_43X_asNumberXGType_INTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5.43).AsNumber(GType.Int)}}, 
               {"g_injectX5_67X_asNumberXGType_INTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5.67).AsNumber(GType.Int)}}, 
               {"g_injectX5X_asNumberXGType_LONGX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(5).AsNumber(GType.Long)}}, 
               {"g_injectX12X_asNumberXGType_BYTEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(12).AsNumber(GType.Byte)}}, 
               {"g_injectX32768X_asNumberXGType_SHORTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(32768).AsNumber(GType.Short)}}, 
               {"g_injectX300X_asNumberXGType_BYTEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(300).AsNumber(GType.Byte)}}, 
               {"g_injectX32768X_asNumberXGType_VertexX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(32768).AsNumber(GType.Vertex)}}, 
               {"g_injectX5X_asNumberXGType_BYTEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("5").AsNumber(GType.Byte)}}, 
               {"g_injectX1_000X_asNumberXGType_BIGINTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("1,000").AsNumber(GType.BigInt)}}, 
               {"g_injectX1_2_3_4_0x5X_asNumber_sum_asNumberXGType_BYTEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0, 2, 3, "4", "0x5").AsNumber().Sum<object>().AsNumber(GType.Byte)}}, 
               {"g_injectXnullX_asNumberXGType_INTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).AsNumber(GType.Int)}}, 
               {"g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX_asNumberXGType_INTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("knows").As("b").Math("a + b").By("age").AsNumber(GType.Int)}}, 
               {"g_withSideEffectXx_100X_V_age_mathX__plus_xX_asNumberXGType_LONGX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("x", 100).V().Values<object>("age").Math("_ + x").AsNumber(GType.Long)}}, 
               {"g_V_valuesXageX_asString_asNumberXGType_DOUBLEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").AsString().AsNumber(GType.Double)}}, 
               {"g_V_valuesXbirthdayX_asNumber_asDate_asNumber", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").Property("birthday", 1596326400000).AddV("person").Property("name", "john").Property("birthday", 597715200000).AddV("person").Property("name", "charlie").Property("birthday", 1012521600000).AddV("person").Property("name", "suzy").Property("birthday", -131587200000), (g,p) =>g.V().Values<object>("birthday").AsNumber().AsDate().AsNumber()}}, 
               {"g_injectX1_2X_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1, 2).AsString()}}, 
               {"g_injectX1_2X_asStringXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1, 2).AsString<object>(Scope.Local)}}, 
               {"g_injectXlist_1_2X_asStringXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).AsString<object>(Scope.Local)}}, 
               {"g_injectX1_nullX_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, 1).AsString()}}, 
               {"g_injectX1_nullX_asStringXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, null }).AsString<object>(Scope.Local)}}, 
               {"g_V_valueMapXnameX_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name").AsString()}}, 
               {"g_V_valueMapXnameX_order_fold_asStringXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name").Order().Fold().AsString<object>(Scope.Local)}}, 
               {"g_V_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().AsString()}}, 
               {"g_V_fold_asStringXlocalX_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().AsString<object>(Scope.Local).Order(Scope.Local)}}, 
               {"g_E_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().AsString()}}, 
               {"g_V_properties", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().AsString()}}, 
               {"g_V_hasLabelXpersonX_valuesXageX_asString", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("age").AsString()}}, 
               {"g_V_hasLabelXpersonX_valuesXageX_order_fold_asStringXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("age").Order().Fold().AsString<object>(Scope.Local)}}, 
               {"g_V_hasLabelXpersonX_valuesXageX_asString_concatX_years_oldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("age").AsString().Concat(" years old")}}, 
               {"g_call", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>()}}, 
               {"g_callXlistX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>((string) "--list")}}, 
               {"g_callXlistX_withXstring_stringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>((string) "--list").With("service", "tinker.search")}}, 
               {"g_callXlistX_withXstring_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>((string) "--list").With("service", __.Constant<object>("tinker.search"))}}, 
               {"g_callXlist_mapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("--list", (IDictionary<object, object>) p["xx1"])}}, 
               {"g_callXlist_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("--list", (ITraversal) __.Project<object>("service").By(__.Constant<object>("tinker.search")))}}, 
               {"g_callXlist_map_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("--list", (IDictionary<object, object>) p["xx1"], (ITraversal) __.Project<object>("service").By(__.Constant<object>("tinker.search")))}}, 
               {"g_callXsearch_mapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("tinker.search", (IDictionary<object, object>) p["xx1"]).Element()}}, 
               {"g_callXsearch_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("tinker.search", (ITraversal) __.Project<object>("search").By(__.Constant<object>("vada"))).Element()}}, 
               {"g_callXsearchX_withXstring_stringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>((string) "tinker.search").With("search", "vada").Element()}}, 
               {"g_callXsearchX_withXstring_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>((string) "tinker.search").With("search", __.Constant<object>("vada")).Element()}}, 
               {"g_callXsearch_mapX_withXstring_VertexX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("tinker.search", (IDictionary<object, object>) p["xx1"]).With("type", "Vertex").Element()}}, 
               {"g_callXsearch_mapX_withXstring_EdgeX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("tinker.search", (IDictionary<object, object>) p["xx1"]).With("type", "Edge").Element()}}, 
               {"g_callXsearch_mapX_withXstring_VertexPropertyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Call<object>("tinker.search", (IDictionary<object, object>) p["xx1"]).With("type", "VertexProperty").Element()}}, 
               {"g_V_callXdcX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Call<object>((string) "tinker.degree.centrality").Project<object>("vertex", "degree").By(__.Select<object>("v")).By()}}, 
               {"g_V_whereXcallXdcXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Call<object>((string) "tinker.degree.centrality").Is(3))}}, 
               {"g_V_callXdcX_withXdirection_OUTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Call<object>((string) "tinker.degree.centrality").With("direction", Direction.Out).Project<object>("vertex", "degree").By(__.Select<object>("v")).By()}}, 
               {"g_V_callXdc_mapX_withXdirection_OUTX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Call<object>("tinker.degree.centrality", (IDictionary<object, object>) p["xx1"]).With("direction", Direction.Out).Project<object>("vertex", "degree").By(__.Select<object>("v")).By()}}, 
               {"g_V_callXdc_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Call<object>("tinker.degree.centrality", (ITraversal) __.Project<object>("direction").By(__.Constant<object>(Direction.Out))).Project<object>("vertex", "degree").By(__.Select<object>("v")).By()}}, 
               {"g_V_callXdc_map_traversalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Call<object>("tinker.degree.centrality", (IDictionary<object, object>) p["xx1"], (ITraversal) __.Project<object>("direction").By(__.Constant<object>(Direction.Out))).Project<object>("vertex", "degree").By(__.Select<object>("v")).By()}}, 
               {"g_V_coalesceXoutXfooX_outXbarXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Coalesce<object>(__.Out("foo"), __.Out("bar"))}}, 
               {"g_VX1X_coalesceXoutXknowsX_outXcreatedXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Coalesce<object>(__.Out("knows"), __.Out("created")).Values<object>("name")}}, 
               {"g_VX1X_coalesceXoutXcreatedX_outXknowsXX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Coalesce<object>(__.Out("created"), __.Out("knows")).Values<object>("name")}}, 
               {"g_V_coalesceXoutXlikesX_outXknowsX_inXcreatedXX_groupCount_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Coalesce<object>(__.Out("likes"), __.Out("knows"), __.Out("created")).GroupCount<object>().By("name")}}, 
               {"g_V_coalesceXoutEXknowsX_outEXcreatedXX_otherV_path_byXnameX_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Coalesce<object>(__.OutE("knows"), __.OutE("created")).OtherV().Path().By("name").By(T.Label)}}, 
               {"g_V_outXcreatedX_order_byXnameX_coalesceXname_constantXxXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Order().By("name").Coalesce<object>(__.Values<object>("name"), __.Constant<object>("x"))}}, 
               {"g_injectXnullX_combineXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Combine(__.Inject(1))}}, 
               {"g_V_valuesXnameX_combineXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Combine(__.V().Fold())}}, 
               {"g_V_fold_combineXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Combine(__.Constant<object>(null))}}, 
               {"g_V_fold_combineXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Combine(__.V())}}, 
               {"g_V_valuesXnameX_fold_combineX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Combine(2)}}, 
               {"g_V_valuesXnameX_fold_combineXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Combine(null)}}, 
               {"g_V_valuesXnonexistantX_fold_combineXV_valuesXnameX_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Combine(__.V().Values<object>("name").Fold()).Unfold<object>()}}, 
               {"g_V_valuesXnameX_fold_combineXV_valuesXnonexistantX_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Combine(__.V().Values<object>("nonexistant").Fold()).Unfold<object>()}}, 
               {"g_V_valuesXageX_order_byXdescX_fold_combineXV_valuesXageX_order_byXdescX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Fold().Combine(__.V().Values<object>("age").Order().By(Order.Desc).Fold())}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_combineXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Combine(new List<object> { "MARKO" })}}, 
               {"g_injectXxx1X_combineXV_valuesXnameX_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Combine(__.V().Values<object>("name").Fold()).Unfold<object>()}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_combineXseattle_vancouverX_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Combine(new List<object> { "seattle", "vancouver" }).Order(Scope.Local)}}, 
               {"g_V_out_out_path_byXnameX_combineXempty_listX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Combine(new List<object> {  })}}, 
               {"g_V_valuesXageX_order_fold_combineXconstantX27X_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().Fold().Combine(__.Constant<object>(27).Fold())}}, 
               {"g_V_out_out_path_byXnameX_combineXdave_kelvinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Combine(new List<object> { "dave", "kelvin" })}}, 
               {"g_injectXa_null_bX_combineXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Combine(new List<object> { "a", "c" })}}, 
               {"g_injectXa_null_bX_combineXa_null_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Combine(new List<object> { "a", null, "c" })}}, 
               {"g_injectX3_threeX_combineXfive_three_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Combine(new List<object> { "five", "three", 7 })}}, 
               {"g_injectXa_bX_concat", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("a", "b").Concat()}}, 
               {"g_injectXa_bX_concat_XcX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("a", "b").Concat("c")}}, 
               {"g_injectXa_bX_concat_Xc_dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("a", "b").Concat("c", "d")}}, 
               {"g_injectXa_bX_concat_Xinject_c_dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("a", "b").Concat(__.Inject("c"))}}, 
               {"g_injectXaX_concat_Xinject_List_b_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("a").Concat(__.Inject(new List<object> { "b", "c" }))}}, 
               {"g_injectXListXa_bXcX_concat_XdX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }, "c").Concat("d")}}, 
               {"g_injectXnullX_concat_XinjectX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Concat()}}, 
               {"g_injectXnull_aX_concat_Xnull_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, "a").Concat(null, "b")}}, 
               {"g_injectXhello_hiX_concatXV_values_order_byXnameX_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("hello", "hi").Concat(__.V().Order().By("name").Values<object>("name"))}}, 
               {"g_V_hasLabel_value_concat_X_X_concat_XpersonX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Concat(" ").Concat("person")}}, 
               {"g_hasLabelXpersonX_valuesXnameX_asXaX_constantXMrX_concatXselectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Constant<object>("Mr.").Concat(__.Select<object>("a"))}}, 
               {"g_hasLabelXsoftwareX_asXaX_valuesXnameX_concatXunsesX_concatXselectXaXvaluesXlangX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").As("a").Values<object>("name").Concat(" uses ").Concat(__.Select<object>("a").Values<object>("lang"))}}, 
               {"g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_labelX_concatXselectXaX_inV_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().As("a").V(p["vid1"]).Values<object>("name").Concat(__.Select<object>("a").Label()).Concat(__.Select<object>("a").InV().Values<object>("name"))}}, 
               {"g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_label_selectXaX_inV_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().As("a").V(p["vid1"]).Values<object>("name").Concat(__.Select<object>("a").Label(), __.Select<object>("a").InV().Values<object>("name"))}}, 
               {"g_addVXconstantXprefix_X_concatXVX1X_labelX_label", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.AddV(__.Constant<object>("prefix_").Concat(__.V(p["vid1"]).Label())).Label()}}, 
               {"g_injectXnullX_conjoinX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Conjoin((string) "1")}}, 
               {"g_V_valuesXnameX_conjoinX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Conjoin((string) "1")}}, 
               {"g_V_valuesXnonexistantX_fold_conjoinX_X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Conjoin((string) ";")}}, 
               {"g_V_valuesXnameX_order_fold_conjoinX_X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Fold().Conjoin((string) "_")}}, 
               {"g_V_valuesXageX_order_fold_conjoinX_X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().Fold().Conjoin((string) ";")}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_conjoinXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Conjoin((string) "MARKO")}}, 
               {"g_injectXmarkoX_conjoinX_X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Conjoin((string) "-")}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_orderXlocalX_conjoinX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Order(Scope.Local).Conjoin((string) "1")}}, 
               {"g_V_out_out_path_byXnameX_conjoinXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Conjoin((string) "")}}, 
               {"g_injectXa_null_bX_conjoinXxyzX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Conjoin((string) "xyz")}}, 
               {"g_injectX3_threeX_conjoinX_X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Conjoin((string) ";")}}, 
               {"g_V_connectedComponent_hasXcomponentX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
               {"g_V_dedup_connectedComponent_hasXcomponentX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Dedup().ConnectedComponent().Has("gremlin.connectedComponentVertexProgram.component")}}, 
               {"g_V_hasLabelXsoftwareX_connectedComponent_project_byXnameX_byXcomponentX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").ConnectedComponent().Project<object>("name", "component").By("name").By("gremlin.connectedComponentVertexProgram.component")}}, 
               {"g_V_connectedComponent_withXEDGES_bothEXknowsXX_withXPROPERTY_NAME_clusterX_project_byXnameX_byXclusterX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").ConnectedComponent().With("~tinkerpop.connectedComponent.edges", __.BothE("knows")).With("~tinkerpop.connectedComponent.propertyName", "cluster").Project<object>("name", "cluster").By("name").By("cluster")}}, 
               {"g_V_constantX123X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Constant<object>(123)}}, 
               {"g_V_constantXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Constant<object>(null)}}, 
               {"g_V_chooseXhasLabelXpersonX_valuesXnameX_constantXinhumanXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.HasLabel("person"), __.Values<object>("name"), __.Constant<object>("inhuman"))}}, 
               {"g_V_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Count()}}, 
               {"g_V_out_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Count()}}, 
               {"g_V_both_both_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Both().Count()}}, 
               {"g_V_fold_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Count(Scope.Local)}}, 
               {"g_V_hasXnoX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("no").Count()}}, 
               {"g_V_whereXinXkknowsX_outXcreatedX_count_is_0XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.In("knows").Out("created").Count().Is(0)).Values<object>("name")}}, 
               {"g_V_repeatXoutX_timesX8X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(8).Count()}}, 
               {"g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(5).As("a").Out("writtenBy").As("b").Select<object>("a", "b").Count()}}, 
               {"g_V_repeatXoutX_timesX3X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(3).Count()}}, 
               {"g_V_order_byXlangX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("lang").Count()}}, 
               {"g_E_sampleX1X_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Sample(1).Count()}}, 
               {"g_V_sampleX1X_byXageX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sample(1).By("age").Count()}}, 
               {"g_V_order_byXnoX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("no").Count()}}, 
               {"g_V_group_byXlabelX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(T.Label).Count()}}, 
               {"g_V_group_byXlabelX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(T.Label).Count(Scope.Local)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXDT_hour_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateAdd(DT.Hour, 2)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXhour_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateAdd(DT.Hour, 2)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXhour_1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateAdd(DT.Hour, -1)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXminute_10X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateAdd(DT.Minute, 10)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXsecond_20X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateAdd(DT.Second, 20)}}, 
               {"g_injectXdatetimeXstrXX_dateAddXday_11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-09-06T00:00Z"), DateTimeOffset.Parse("2023-09-06T00:00Z")).DateAdd(DT.Day, 11)}}, 
               {"g_injectXdatetimeXstr1XX_dateDiffXdatetimeXstr2XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-02T00:00Z"), DateTimeOffset.Parse("2023-08-02T00:00Z")).DateDiff(DateTimeOffset.Parse("2023-08-09T00:00Z"))}}, 
               {"g_injectXdatetimeXstr1XX_dateDiffXconstantXdatetimeXstr2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-08T00:00Z"), DateTimeOffset.Parse("2023-08-08T00:00Z")).DateDiff(__.Constant<object>(DateTimeOffset.Parse("2023-08-01T00:00Z")))}}, 
               {"g_injectXdatetimeXstr1XX_dateDiffXinjectXdatetimeXstr2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(DateTimeOffset.Parse("2023-08-08T00:00Z"), DateTimeOffset.Parse("2023-08-08T00:00Z")).DateDiff(__.Inject(DateTimeOffset.Parse("2023-10-11T00:00Z")))}}, 
               {"g_V_valuesXbirthdayX_asDate_dateDiffXdatetimeX19700101T0000ZXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").Property("birthday", "1596326400000").AddV("person").Property("name", "john").Property("birthday", "597715200000").AddV("person").Property("name", "charlie").Property("birthday", "1012521600000").AddV("person").Property("name", "suzy").Property("birthday", "-131587200000"), (g,p) =>g.V().Values<object>("birthday").AsNumber().AsDate().DateDiff(DateTimeOffset.Parse("1970-01-01T00:00Z"))}}, 
               {"g_V_hasXname_aliceX_valuesXbirthdayX_asDate_dateDiffXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").Property("birthday", 1596326400000), (g,p) =>g.V().Has("name", "alice").Values<object>("birthday").AsDate().DateDiff(__.Constant<object>(null))}}, 
               {"g_injectXnullX_differenceXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Difference(__.Inject(1))}}, 
               {"g_V_valuesXnameX_differenceXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Difference(__.V().Fold())}}, 
               {"g_V_fold_differenceXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Difference(__.Constant<object>(null))}}, 
               {"g_V_fold_differenceXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Difference(__.V())}}, 
               {"g_V_valuesXnameX_fold_differenceX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Difference(2)}}, 
               {"g_V_valuesXnameX_fold_differenceXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Difference(null)}}, 
               {"g_V_valuesXnonexistantX_fold_differenceXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Difference(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valuesXnameX_fold_differenceXV_valuesXnonexistantX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Difference(__.V().Values<object>("nonexistant").Fold())}}, 
               {"g_V_valuesXageX_fold_differenceXV_valuesXageX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Difference(__.V().Values<object>("age").Fold())}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_differenceXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Difference(new List<object> { "MARKO" })}}, 
               {"g_injectXmarkoX_differenceXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Difference(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_differenceXseattle_vancouverX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Difference(new List<object> { "seattle", "vancouver" })}}, 
               {"g_V_out_out_path_byXnameX_differenceXrippleX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Difference(new List<object> { "ripple" })}}, 
               {"g_V_out_out_path_byXnameX_differenceXempty_listX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Difference(new List<object> {  })}}, 
               {"g_V_valuesXageX_fold_differenceXconstantX27X_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Difference(__.Constant<object>(27).Fold())}}, 
               {"g_V_out_out_path_byXnameX_differenceXdave_kelvinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Difference(new List<object> { "dave", "kelvin" })}}, 
               {"g_injectXa_null_bX_differenceXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Difference(new List<object> { "a", "c" })}}, 
               {"g_injectXa_null_bX_differenceXa_null_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Difference(new List<object> { "a", null, "c" })}}, 
               {"g_injectX3_threeX_differenceXfive_three_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Difference(new List<object> { "five", "three", 7 })}}, 
               {"g_injectXnullX_disjunctXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Disjunct(__.Inject(1))}}, 
               {"g_V_valuesXnameX_disjunctXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Disjunct(__.V().Fold())}}, 
               {"g_V_fold_disjunctXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Disjunct(__.Constant<object>(null))}}, 
               {"g_V_fold_disjunctXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Disjunct(__.V())}}, 
               {"g_V_valuesXnameX_fold_disjunctX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Disjunct(2)}}, 
               {"g_V_valuesXnameX_fold_disjunctXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Disjunct(null)}}, 
               {"g_V_valuesXnonexistantX_fold_disjunctXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Disjunct(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valuesXnameX_fold_disjunctXV_valuesXnonexistantX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Disjunct(__.V().Values<object>("nonexistant").Fold())}}, 
               {"g_V_valuesXageX_fold_disjunctXV_valuesXageX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Disjunct(__.V().Values<object>("age").Fold())}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_disjunctXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Disjunct(new List<object> { "MARKO" })}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_disjunctXseattle_vancouverX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Disjunct(new List<object> { "seattle", "vancouver" })}}, 
               {"g_V_out_out_path_byXnameX_disjunctXmarkoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Disjunct(new List<object> { "marko" })}}, 
               {"g_V_out_out_path_byXnameX_disjunctXstephen_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Disjunct(new List<object> { "stephen", "marko" })}}, 
               {"g_V_out_out_path_byXnameX_disjunctXdave_kelvinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Disjunct(new List<object> { "dave", "kelvin" })}}, 
               {"g_injectXa_null_bX_disjunctXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Disjunct(new List<object> { "a", "c" })}}, 
               {"g_injectXa_null_bX_disjunctXa_null_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Disjunct(new List<object> { "a", null, "c" })}}, 
               {"g_injectX3_threeX_disjunctXfive_three_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Disjunct(new List<object> { "five", "three", 7 })}}, 
               {"g_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E()}}, 
               {"g_EX11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"])}}, 
               {"g_EX11AsStringX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"])}}, 
               {"g_EXe11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["e11"])}}, 
               {"g_EXe7_e11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["e7"], p["e11"])}}, 
               {"g_EXlistXe7_e11XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["xx1"])}}, 
               {"g_EXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(null)}}, 
               {"g_EXlistXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["xx1"])}}, 
               {"g_EX11_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"], null)}}, 
               {"g_V_EX11X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().E(p["eid11"])}}, 
               {"g_EX11X_E", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).E()}}, 
               {"g_V_EXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().E(null)}}, 
               {"g_V_EXlistXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().E(p["xx1"])}}, 
               {"g_injectX1X_EX11_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).E(p["eid11"], null)}}, 
               {"g_injectX1X_coalesceXEX_hasLabelXtestsX_addEXtestsX_from_V_hasXnameX_XjoshXX_toXV_hasXnameX_XvadasXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "josh").AddV("person").Property("name", "vadas"), (g,p) =>g.Inject<object>(1).Coalesce<object>(__.E().HasLabel("tests"), __.AddE("tests").From(__.V().Has("name", "josh")).To(__.V().Has("name", "vadas"))), (g,p) =>g.E().HasLabel("tests")}}, 
               {"g_VX1X_outE_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().InV()}}, 
               {"g_VX2X_inE_outV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).InE().OutV()}}, 
               {"g_V_outE_hasXweight_1X_outV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Has("weight", 1.0).OutV()}}, 
               {"g_VX1X_outE_otherV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().OtherV()}}, 
               {"g_VX4X_bothE_otherV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).BothE().OtherV()}}, 
               {"g_VX4X_bothE_hasXweight_lt_1X_otherV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).BothE().Has("weight", P.Lt(1.0)).OtherV()}}, 
               {"get_g_VX1X_outE_otherV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().OtherV()}}, 
               {"g_VX1X_outEXknowsX_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").InV()}}, 
               {"g_VX1X_outEXknows_createdX_inV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows", "created").InV()}}, 
               {"g_VX1X_outEXknowsX_bothV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").BothV()}}, 
               {"g_VX1X_outEXknowsX_bothV_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").BothV().Values<object>("name")}}, 
               {"g_VX1X_properties_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).Properties<object>().Element().Limit<object>(1)}}, 
               {"g_V_properties_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().Element()}}, 
               {"g_V_propertiesXageX_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>("age").Element()}}, 
               {"g_EX_properties_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).Properties<object>().Element().Limit<object>(1)}}, 
               {"g_E_properties_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Properties<object>().Element()}}, 
               {"g_VXv7_properties_properties_element_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid7"]).Properties<object>().Properties<object>().Element().Element().Limit<object>(1)}}, 
               {"g_V_properties_properties_element_element", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid7"]).Properties<object>().Properties<object>().Element().Element()}}, 
               {"g_V_elementMap", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ElementMap<object>()}}, 
               {"g_V_elementMapXname_ageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ElementMap<object>("name", "age")}}, 
               {"g_EX11X_elementMap", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).ElementMap<object>()}}, 
               {"g_V_elementMapXname_age_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ElementMap<object>("name", "age", null)}}, 
               {"g_V_asXaX_flatMapXselectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").FlatMap<object>(__.Select<object>("a"))}}, 
               {"g_V_valuesXnameX_flatMapXsplitXaX_unfoldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").FlatMap<object>(__.Split("a").Unfold<object>())}}, 
               {"g_V_flatMapXout_outX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().FlatMap<object>(__.Out().Out()).Path()}}, 
               {"g_V_fold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold()}}, 
               {"g_V_fold_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Unfold<object>()}}, 
               {"g_V_age_foldX0_plusX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold<object>(0, Operator.Sum)}}, 
               {"g_injectXa1_b2X_foldXm_addAllX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new Dictionary<object, object> {{ "a", 1 }}, new Dictionary<object, object> {{ "b", 2 }}).Fold<object>(new Dictionary<object, object> {}, Operator.AddAll)}}, 
               {"g_injectXa1_b2_b4X_foldXm_addAllX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new Dictionary<object, object> {{ "a", 1 }}, new Dictionary<object, object> {{ "b", 2 }}, new Dictionary<object, object> {{ "b", 4 }}).Fold<object>(new Dictionary<object, object> {}, Operator.AddAll)}}, 
               {"g_VX1X_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").Format("Hello world")}}, 
               {"g_V_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Format("%{name} is %{age} years old")}}, 
               {"g_injectX1X_asXageX_V_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).As("age").V().Format("%{name} is %{age} years old")}}, 
               {"g_V_formatXstrX_byXvaluesXnameXX_byXvaluesXageXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Format("%{_} is %{_} years old").By(__.Values<object>("name")).By(__.Values<object>("age"))}}, 
               {"g_V_hasLabelXpersonX_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Format("%{_} %{_} %{_}").By(__.Constant<object>("hello")).By(__.Values<object>("name"))}}, 
               {"g_VX1X_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Format("%{_}").By(__.Constant<object>("hello")).By(__.Values<object>("name"))}}, 
               {"g_V_formatXstrX_byXbothE_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Format("%{name} has %{_} connections").By(__.BothE().Count())}}, 
               {"g_V_projectXname_countX_byXvaluesXnameXX_byXbothE_countX_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Project<object>("name", "count").By(__.Values<object>("name")).By(__.BothE().Count()).Format("%{name} has %{count} connections")}}, 
               {"g_V_elementMap_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ElementMap<object>().Format("%{name} is %{age} years old")}}, 
               {"g_V_hasLabelXpersonX_asXaX_valuesXnameX_asXp1X_selectXaX_inXknowsX_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("a").Values<object>("name").As("p1").Select<object>("a").In("knows").Format("%{p1} knows %{name}")}}, 
               {"g_V_asXsX_label_asXsubjectX_selectXsX_outE_asXpX_label_asXpredicateX_selectXpX_inV_label_asXobjectX_formatXstrX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("s").Label().As("subject").Select<object>("s").OutE().As("p").Label().As("predicate").Select<object>("p").InV().Label().As("object").Format("%{subject} %{predicate} %{object}")}}, 
               {"g_V_hasLabelXsoftwareX_index_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Index<object>().Unfold<object>()}}, 
               {"g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Order().By("name").Index<object>().With(WithOptions.Indexer, WithOptions.Map)}}, 
               {"g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Fold().Order(Scope.Local).Index<object>().Unfold<object>().Order().By(__.Tail<object>(Scope.Local, 1))}}, 
               {"g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Fold().Order(Scope.Local).Index<object>().With(WithOptions.Indexer, WithOptions.Map)}}, 
               {"g_VX1X_valuesXageX_index_unfold_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Index<object>().Unfold<object>().Unfold<object>()}}, 
               {"g_injectXnullX_intersectXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Intersect(__.Inject(1))}}, 
               {"g_V_valuesXnameX_intersectXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Intersect(__.V().Fold())}}, 
               {"g_V_fold_intersectXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Intersect(__.Constant<object>(null))}}, 
               {"g_V_fold_intersectXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Intersect(__.V())}}, 
               {"g_V_valuesXnameX_fold_intersectX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Intersect(2)}}, 
               {"g_V_valuesXnameX_fold_intersectXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Intersect(null)}}, 
               {"g_V_valuesXnonexistantX_fold_intersectXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Intersect(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valuesXnameX_fold_intersectXV_valuesXnonexistantX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Intersect(__.V().Values<object>("nonexistant").Fold())}}, 
               {"g_V_valuesXageX_fold_intersectXV_valuesXageX_foldX_order_local", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Intersect(__.V().Values<object>("age").Fold()).Order(Scope.Local)}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_intersectXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Intersect(new List<object> { "MARKO" })}}, 
               {"g_injectXmarkoX_intersectX___V_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Intersect(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_intersectXseattle_vancouverX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Intersect(new List<object> { "seattle", "vancouver" })}}, 
               {"g_V_valuesXageX_fold_intersectX___constantX27X_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Intersect(__.Constant<object>(27).Fold())}}, 
               {"g_V_out_out_path_byXnameX_intersectXdave_kelvinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Intersect(new List<object> { "dave", "kelvin" })}}, 
               {"g_injectXa_null_bX_intersectXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Intersect(new List<object> { "a", "c" })}}, 
               {"g_injectXa_null_bX_intersectXa_null_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Intersect(new List<object> { "a", null, "c" })}}, 
               {"g_injectX3_threeX_intersectXfive_three_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Intersect(new List<object> { "five", "three", 7 })}}, 
               {"g_injectX__feature___test__nullX_lTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("  feature", " one test", null, "", " ", "　abc", "abc　", "　abc　", "　　").LTrim()}}, 
               {"g_injectX__feature___test__nullX_lTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　" }).LTrim<object>(Scope.Local)}}, 
               {"g_injectX__feature__X_lTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("  feature  ").LTrim()}}, 
               {"g_injectXListXa_bXX_lTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).LTrim()}}, 
               {"g_injectXListX1_2XX_lTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).LTrim<object>(Scope.Local)}}, 
               {"g_V_valuesXnameX_lTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").LTrim()}}, 
               {"g_V_valuesXnameX_order_fold_lTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").Order().Fold().LTrim<object>(Scope.Local)}}, 
               {"g_injectXfeature_test_nullX_length", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("feature", "test", null).Length()}}, 
               {"g_injectXfeature_test_nullX_lengthXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("feature", "test", null).Length<object>(Scope.Local)}}, 
               {"g_injectXListXa_bXX_length", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).Length()}}, 
               {"g_V_valuesXnameX_length", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Length()}}, 
               {"g_V_valuesXnameX_order_fold_lengthXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Fold().Length<object>(Scope.Local)}}, 
               {"g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX3XX_hasXname_peterX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Both().SimplePath()).Until(__.Has("name", "peter").Or().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
               {"g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX2XX_hasXname_peterX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Both().SimplePath()).Until(__.Has("name", "peter").Or().Loops().Is(2)).Has("name", "peter").Path().By("name")}}, 
               {"g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_and_loops_isX3XX_hasXname_peterX_path_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Both().SimplePath()).Until(__.Has("name", "peter").And().Loops().Is(3)).Has("name", "peter").Path().By("name")}}, 
               {"g_V_emitXhasXname_markoX_or_loops_isX2XX_repeatXoutX_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Emit(__.Has("name", "marko").Or().Loops().Is(2)).Repeat(__.Out()).Values<object>("name")}}, 
               {"g_VX1X_mapXvaluesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Map<object>(__.Values<object>("name"))}}, 
               {"g_VX1X_outE_label_mapXlengthX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().Label().Map<object>(__.Length())}}, 
               {"g_VX1X_out_mapXvaluesXnameXX_mapXlengthX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Map<object>(__.Values<object>("name")).Map<object>(__.Length())}}, 
               {"g_withPath_V_asXaX_out_mapXselectXaX_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithPath().V().As("a").Out().Map<object>(__.Select<object>("a").Values<object>("name"))}}, 
               {"g_withPath_V_asXaX_out_out_asXbX_mapXselectXaX_valuesXnameX_concatXselectXbX_valuesXnameXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithPath().V().As("a").Out().Out().As("b").Map<object>(__.Select<object>("a").Values<object>("name").Concat(__.Select<object>("b").Values<object>("name")))}}, 
               {"g_V_mapXselectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Map<object>(__.Select<object>("a"))}}, 
               {"g_V_mapXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Map<object>(__.Constant<object>(null))}}, 
               {"g_V_valueMap_matchXa_selectXnameX_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Match<object>(__.As("a").Select<object>("name").As("b"))}}, 
               {"g_V_matchXa_out_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out().As("b"))}}, 
               {"g_V_matchXa_out_bX_selectXb_idX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out().As("b")).Select<object>("b").By(T.Id)}}, 
               {"g_V_matchXa_knows_b__b_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").As("b"), __.As("b").Out("created").As("c"))}}, 
               {"g_V_matchXb_created_c__a_knows_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("b").Out("created").As("c"), __.As("a").Out("knows").As("b"))}}, 
               {"g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("created").As("b"), __.As("b").In("created").As("c")).Where("a", P.Neq("c")).Select<object>("a", "c")}}, 
               {"g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("d").In("knows").As("a"), __.As("d").Has("name", "vadas"), __.As("a").Out("knows").As("b"), __.As("b").Out("created").As("c"))}}, 
               {"g_V_matchXa_created_lop_b__b_0created_29_c__c_whereXrepeatXoutX_timesX2XXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("created").Has("name", "lop").As("b"), __.As("b").In("created").Has("age", 29).As("c"), __.As("c").Where(__.Repeat(__.Out()).Times(2)))}}, 
               {"g_V_asXaX_out_asXbX_matchXa_out_count_c__b_in_count_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Match<object>(__.As("a").Out().Count().As("c"), __.As("b").In().Count().As("c"))}}, 
               {"g_V_matchXa__a_out_b__notXa_created_bXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out().As("b"), __.Not(__.As("a").Out("created").As("b")))}}, 
               {"g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("created").Has("name", "lop").As("b"), __.As("b").In("created").Has("age", 29).As("c")).Where(__.As("c").Repeat(__.Out()).Times(2)).Select<object>("a", "b", "c")}}, 
               {"g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Match<object>(__.As("a").In("created").As("b"), __.As("b").In("knows").As("c")).Select<object>("c").Out("created").Values<object>("name")}}, 
               {"g_V_matchXa_knows_b__b_created_c__a_created_cX_dedupXa_b_cX_selectXaX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").As("b"), __.As("b").Out("created").As("c"), __.As("a").Out("created").As("c")).Dedup("a", "b", "c").Select<object>("a").By("name")}}, 
               {"g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("created").As("b"), __.As("a").Repeat(__.Out()).Times(2).As("b")).Select<object>("a", "b")}}, 
               {"g_V_notXmatchXa_age_b__a_name_cX_whereXb_eqXcXX_selectXaXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Not(__.Match<object>(__.As("a").Values<object>("age").As("b"), __.As("a").Values<object>("name").As("c")).Where("b", P.Eq("c")).Select<object>("a")).Values<object>("name")}}, 
               {"g_V_matchXa_knows_b__andXa_created_c__b_created_c__andXb_created_count_d__a_knows_count_dXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").As("b"), __.And(__.As("a").Out("created").As("c"), __.As("b").Out("created").As("c"), __.And(__.As("b").Out("created").Count().As("d"), __.As("a").Out("knows").Count().As("d"))))}}, 
               {"g_V_matchXa_whereXa_neqXcXX__a_created_b__orXa_knows_vadas__a_0knows_and_a_hasXlabel_personXX__b_0created_c__b_0created_count_isXgtX1XXX_selectXa_b_cX_byXidX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.Where("a", P.Neq("c")), __.As("a").Out("created").As("b"), __.Or(__.As("a").Out("knows").Has("name", "vadas"), __.As("a").In("knows").And().As("a").Has(T.Label, "person")), __.As("b").In("created").As("c"), __.As("b").In("created").Count().Is(P.Gt(1))).Select<object>("a", "b", "c").By(T.Id)}}, 
               {"g_V_matchXa__a_both_b__b_both_cX_dedupXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Both().As("b"), __.As("b").Both().As("c")).Dedup("a", "b")}}, 
               {"g_V_matchXa_knows_b__b_created_lop__b_matchXb_created_d__d_0created_cX_selectXcX_cX_selectXa_b_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").As("b"), __.As("b").Out("created").Has("name", "lop"), __.As("b").Match<object>(__.As("b").Out("created").As("d"), __.As("d").In("created").As("c")).Select<object>("c").As("c")).Select<object>("a", "b", "c")}}, 
               {"g_V_matchXa_knows_b__a_created_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").As("b"), __.As("a").Out("created").As("c"))}}, 
               {"g_V_matchXwhereXandXa_created_b__b_0created_count_isXeqX3XXXX__a_both_b__whereXb_inXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.Where(__.And(__.As("a").Out("created").As("b"), __.As("b").In("created").Count().Is(P.Eq(3)))), __.As("a").Both().As("b"), __.Where(__.As("b").In()))}}, 
               {"g_V_matchXa_outEXcreatedX_order_byXweight_descX_limitX1X_inV_b__b_hasXlang_javaXX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").OutE("created").Order().By("weight", Order.Desc).Limit<object>(1).InV().As("b"), __.As("b").Has("lang", "java")).Select<object>("a", "b").By("name")}}, 
               {"g_V_matchXa_both_b__b_both_cX_dedupXa_bX_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Both().As("b"), __.As("b").Both().As("c")).Dedup("a", "b").By(T.Label)}}, 
               {"g_V_matchXa_created_b__b_0created_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("created").As("b"), __.As("b").In("created").As("a"))}}, 
               {"g_V_asXaX_out_asXbX_matchXa_out_count_c__orXa_knows_b__b_in_count_c__and__c_isXgtX2XXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Match<object>(__.As("a").Out().Count().As("c"), __.Or(__.As("a").Out("knows").As("b"), __.As("b").In().Count().As("c").And().As("c").Is(P.Gt(2))))}}, 
               {"g_V_matchXa_knows_count_bX_selectXbX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").Count().As("b")).Select<object>("b")}}, 
               {"g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").In("sungBy").As("b"), __.As("a").In("writtenBy").As("c"), __.As("b").Out("writtenBy").As("d"), __.As("c").Out("sungBy").As("d"), __.As("d").Has("name", "Garcia"))}}, 
               {"g_V_matchXa_hasXsong_name_sunshineX__a_mapX0followedBy_weight_meanX_b__a_0followedBy_c__c_filterXweight_whereXgteXbXXX_outV_dX_selectXdX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Has("song", "name", "HERE COMES SUNSHINE"), __.As("a").Map<object>(__.InE("followedBy").Values<object>("weight").Mean<object>()).As("b"), __.As("a").InE("followedBy").As("c"), __.As("c").Filter(__.Values<object>("weight").Where(P.Gte("b"))).OutV().As("d")).Select<object>("d").By("name")}}, 
               {"g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").In("sungBy").As("b"), __.As("a").In("sungBy").As("c"), __.As("b").Out("writtenBy").As("d"), __.As("c").Out("writtenBy").As("e"), __.As("d").Has("name", "George_Harrison"), __.As("e").Has("name", "Bob_Marley"))}}, 
               {"g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Has("name", "Garcia"), __.As("a").In("writtenBy").As("b"), __.As("a").In("sungBy").As("b"))}}, 
               {"g_V_hasLabelXsongsX_matchXa_name_b__a_performances_cX_selectXb_cX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("song").Match<object>(__.As("a").Values<object>("name").As("b"), __.As("a").Values<object>("performances").As("c")).Select<object>("b", "c").Count()}}, 
               {"g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("followedBy").Count().Is(P.Gt(10)).As("b"), __.As("a").In("followedBy").Count().Is(P.Gt(10)).As("b")).Count()}}, 
               {"g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").In("sungBy").As("b"), __.As("a").In("writtenBy").As("c"), __.As("b").Out("writtenBy").As("d")).Where(__.As("c").Out("sungBy").As("d")).Where(__.As("d").Has("name", "Garcia"))}}, 
               {"g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__b_followedBy_c__c_writtenBy_d__whereXd_neqXaXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Has("name", "Garcia"), __.As("a").In("writtenBy").As("b"), __.As("b").Out("followedBy").As("c"), __.As("c").Out("writtenBy").As("d"), __.Where("d", P.Neq("a")))}}, 
               {"g_V_matchXa_outXknowsX_name_bX_identity", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Match<object>(__.As("a").Out("knows").Values<object>("name").As("b")).Identity()}}, 
               {"g_V_outE_mathX0_minus_itX_byXweightX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Math("0-_").By("weight")}}, 
               {"g_V_hasXageX_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").ValueMap<object, object>().Math("_+_").By(__.Select<object>("age").Unfold<object>())}}, 
               {"g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("knows").As("b").Math("a + b").By("age")}}, 
               {"g_withSideEffectXx_100X_V_age_mathX__plus_xX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("x", 100).V().Values<object>("age").Math("_ + x")}}, 
               {"g_V_asXaX_outXcreatedX_asXbX_mathXb_plus_aX_byXinXcreatedX_countX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").As("b").Math("b + a").By(__.In("created").Count()).By("age")}}, 
               {"g_withSackX1X_injectX1X_repeatXsackXsumX_byXconstantX1XXX_timesX5X_emit_mathXsin__X_byXsackX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(1).Inject<object>(1).Repeat(__.Sack(Operator.Sum).By(__.Constant<object>(1))).Times(5).Emit().Math("sin _").By(__.Sack<object>())}}, 
               {"g_V_projectXa_b_cX_byXbothE_weight_sumX_byXbothE_countX_byXnameX_order_byXmathXa_div_bX_descX_selectXcX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Project<object>("a", "b", "c").By(__.BothE().Values<object>("weight").Sum<object>()).By(__.BothE().Count()).By("name").Order().By(__.Math("a / b"), Order.Desc).Select<object>("c")}}, 
               {"g_V_mathXit_plus_itXbyXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Math("_+_").By("age")}}, 
               {"g_V_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Math("_+_").By(__.Select<object>("age").Unfold<object>())}}, 
               {"g_VX1X_outE_asXexpectedWeightX_mathXexpectedWeightPlusOneXbyXweightX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().As("expectedWeight").Math("expectedWeight + 1").By("weight")}}, 
               {"g_V_age_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Max<object>()}}, 
               {"g_V_foo_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Max<object>()}}, 
               {"g_V_name_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Max<object>()}}, 
               {"g_V_age_fold_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Max<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Max<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Max<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_unfold_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Max<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Max<object>()}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Max<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Max<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_unfold_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Max<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Max<object>()}}, 
               {"g_V_foo_fold_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Fold().Max<object>(Scope.Local)}}, 
               {"g_V_name_fold_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Max<object>(Scope.Local)}}, 
               {"g_V_repeatXbothX_timesX5X_age_max", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both()).Times(5).Values<object>("age").Max<object>()}}, 
               {"g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_maxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Group<object, object>().By("name").By(__.BothE().Values<object>("weight").Max<object>())}}, 
               {"g_VX1X_valuesXageX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Max<object>(Scope.Local)}}, 
               {"g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_maxXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Union<object>(__.Values<object>("age"), __.OutE().Values<object>("weight")).Fold()).Max<object>(Scope.Local)}}, 
               {"g_V_age_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Mean<object>()}}, 
               {"g_V_foo_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Mean<object>()}}, 
               {"g_V_age_fold_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Mean<object>(Scope.Local)}}, 
               {"g_V_foo_fold_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Fold().Mean<object>(Scope.Local)}}, 
               {"g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Group<object, object>().By("name").By(__.BothE().Values<object>("weight").Mean<object>())}}, 
               {"g_V_aggregateXaX_byXageX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Mean<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Mean<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_unfold_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Mean<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Mean<object>()}}, 
               {"g_V_aggregateXaX_byXfooX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Mean<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Mean<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_unfold_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Mean<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Mean<object>()}}, 
               {"g_injectXnull_10_20_nullX_mean", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, 10, 20, null).Mean<object>()}}, 
               {"g_injectXlistXnull_10_20_nullXX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, 10, 20, null }).Mean<object>(Scope.Local)}}, 
               {"g_VX1X_valuesXageX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Mean<object>(Scope.Local)}}, 
               {"g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_meanXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Union<object>(__.Values<object>("age"), __.OutE().Values<object>("weight")).Fold()).Mean<object>(Scope.Local)}}, 
               {"g_injectXnullX_mergeXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Merge(__.Inject(1))}}, 
               {"g_V_valuesXnameX_mergeXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Merge(__.V().Fold())}}, 
               {"g_V_fold_mergeXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Merge(__.Constant<object>(null))}}, 
               {"g_V_fold_mergeXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Merge(__.V())}}, 
               {"g_V_elementMap_mergeXconstantXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ElementMap<object>().Merge(__.Constant<object>("a"))}}, 
               {"g_V_fold_mergeXV_asXaX_projectXaX_byXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Merge(__.V().As("a").Project<object>("a").By("name"))}}, 
               {"g_V_fold_mergeXk_vX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Merge(new Dictionary<object, object> {{ "k", "v" }})}}, 
               {"g_V_valuesXnameX_fold_mergeX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Merge(2)}}, 
               {"g_V_valuesXnameX_fold_mergeXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Merge(null)}}, 
               {"g_V_valuesXnonexistantX_fold_mergeXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Merge(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valuesXnameX_fold_mergeXV_valuesXnonexistantX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Merge(__.V().Values<object>("nonexistant").Fold())}}, 
               {"g_V_valuesXageX_fold_mergeXV_valuesXageX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Merge(__.V().Values<object>("age").Fold())}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_mergeXMARKOX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Merge(new List<object> { "MARKO" })}}, 
               {"g_injectXmarkoX_mergeXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Merge(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_mergeXseattle_vancouverX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Merge(new List<object> { "seattle", "vancouver" })}}, 
               {"g_V_out_out_path_byXnameX_mergeXempty_listX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Merge(new List<object> {  })}}, 
               {"g_V_valuesXageX_fold_mergeXconstantX27X_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Merge(__.Constant<object>(27).Fold())}}, 
               {"g_V_out_out_path_byXnameX_mergeXdave_kelvinX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Merge(new List<object> { "dave", "kelvin" })}}, 
               {"g_injectXa_null_bX_mergeXa_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Merge(new List<object> { "a", "c" })}}, 
               {"g_injectXa_null_bX_mergeXa_null_cX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Merge(new List<object> { "a", null, "c" })}}, 
               {"g_injectX3_threeX_mergeXfive_three_7X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Merge(new List<object> { "five", "three", 7 })}}, 
               {"g_V_asXnameX_projectXnameX_byXnameX_mergeXother_blueprintX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("name").Project<object>("name").By("name").Merge(new Dictionary<object, object> {{ "other", "blueprint" }})}}, 
               {"g_V_hasXname_markoX_elementMap_mergeXV_hasXname_lopX_elementMapX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").ElementMap<object>().Merge(__.V().Has("name", "lop").ElementMap<object>())}}, 
               {"g_V_mergeEXlabel_selfX_optionXonMatch_emptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self"), (g,p) =>g.V().MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.E(), (g,p) =>g.E().Properties<object>(), (g,p) =>g.V()}}, 
               {"g_V_mergeEXlabel_selfX_optionXonMatch_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self"), (g,p) =>g.V().MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) null), (g,p) =>g.E(), (g,p) =>g.E().Properties<object>(), (g,p) =>g.V()}}, 
               {"g_V_mergeEXemptyX_optionXonCreate_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().As("v").MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) null).Option(Merge.OutV, (ITraversal) __.Select<object>("v")).Option(Merge.InV, (ITraversal) __.Select<object>("v")), (g,p) =>g.E(), (g,p) =>g.V()}}, 
               {"g_V_mergeE_inlineXemptyX_optionXonCreate_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().As("v").MergeE((IDictionary<object, object>) new Dictionary<object, object> {{ T.Label, "self" }, { Direction.Out, Merge.OutV }, { Direction.In, Merge.InV }}).Option(Merge.OnCreate, (IDictionary<object, object>) null).Option(Merge.OutV, (ITraversal) __.Select<object>("v")).Option(Merge.InV, (ITraversal) __.Select<object>("v")), (g,p) =>g.E(), (g,p) =>g.V()}}, 
               {"g_mergeEXemptyX_exists", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddE("self"), (g,p) =>g.MergeE((IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.E(), (g,p) =>g.V()}}, 
               {"g_mergeEXemptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeE((IDictionary<object, object>) new Dictionary<object, object> {})}}, 
               {"g_V_mergeEXemptyX_two_exist", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.V().As("v").MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OutV, (ITraversal) __.Select<object>("v")).Option(Merge.InV, (ITraversal) __.Select<object>("v")), (g,p) =>g.E(), (g,p) =>g.V()}}, 
               {"g_V_mergeE_inlineXemptyX_two_exist", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.V().As("v").MergeE((IDictionary<object, object>) new Dictionary<object, object> {{ T.Label, "self" }, { Direction.Out, Merge.OutV }, { Direction.In, Merge.InV }}).Option(Merge.OutV, (ITraversal) __.Select<object>("v")).Option(Merge.InV, (ITraversal) __.Select<object>("v")), (g,p) =>g.E(), (g,p) =>g.V()}}, 
               {"g_mergeEXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeE((IDictionary<object, object>) null)}}, 
               {"g_mergeEXnullvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"])}}, 
               {"g_V_limitX1X_mergeEXnullvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().Limit<object>(1).MergeE((IDictionary<object, object>) p["xx1"])}}, 
               {"g_V_mergeEXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeE((IDictionary<object, object>) null)}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_withSideEffectXa_label_knows_out_marko_in_vadasX_mergeEXselectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((ITraversal) __.Select<object>("a")), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_mergeEXlabel_knows_out_marko1_in_vadas1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko").OutE("knows").Has("weight", 0.5).InV().Has("person", "name", "vadas"), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"])}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("a").To("b"), (g,p) =>g.V().Has("person", "name", "marko").MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_withSideEffectXlabel_knows_out_marko_in_vadasX_injectX1X_selectXmX_mergeE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.Inject<object>(1).Select<object>("m").MergeE(), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_mergeEXlabel_knows_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N").InV().Has("name", "vadas")}}, 
               {"g_mergeEXlabel_knows_out_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
               {"g_mergeEXout_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("created", "Y").AddE("knows").From("b").To("a").Property("created", "Y"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N").OutV().Has("name", "vadas")}}, 
               {"g_V_hasXperson_name_marko_X_mergeEXlabel_self_out_vadas1_in_vadas1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.V().Has("person", "name", "marko").MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("self").BothV().Has("name", "vadas")}}, 
               {"g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX_exists", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m")), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m")), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko1_in_vadas1X_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m")), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N")}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_aliased_direction", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas")}}, 
               {"g_withSideEffectXm1_label_knows_out_marko_in_vadas_m2_label_self_out_vadas_in_vadasX_unionXselectXm1X_selectXm2XX_mergeE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.Union<object>(__.Select<object>("m1"), __.Select<object>("m2")).MergeE(), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.V().Has("person", "name", "marko").Out("knows").Has("person", "name", "vadas"), (g,p) =>g.V().Has("person", "name", "vadas").Out("self").Has("person", "name", "vadas")}}, 
               {"g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_sideEffectXpropertiesXweightX_dropX_selectXmXX_exists", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1.0d).From("a").To("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.SideEffect(__.Properties<object>("weight").Drop()).Select<object>("m")), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows").Has("created", "Y"), (g,p) =>g.E().HasLabel("knows").Has("created", "N"), (g,p) =>g.E().HasLabel("knows").Has("weight")}}, 
               {"g_mergeE_with_outVinV_options_map", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OutV, (IDictionary<object, object>) p["xx2"]).Option(Merge.InV, (IDictionary<object, object>) p["xx3"]), (g,p) =>g.V(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_inline_with_outVinV_options_map", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) new Dictionary<object, object> {{ Direction.Out, Merge.OutV }, { Direction.In, Merge.InV }, { T.Label, "knows" }}).Option(Merge.OutV, (IDictionary<object, object>) p["xx1"]).Option(Merge.InV, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_with_outVinV_options_select", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.V(p["vid1"]).As("x").V(p["vid2"]).As("y").MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OutV, (ITraversal) __.Select<object>("x")).Option(Merge.InV, (ITraversal) __.Select<object>("y")), (g,p) =>g.V(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_inline_with_outVinV_options_select", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.V(p["vid1"]).As("x").V(p["vid2"]).As("y").MergeE((IDictionary<object, object>) new Dictionary<object, object> {{ Direction.Out, Merge.OutV }, { Direction.In, Merge.InV }, { T.Label, "knows" }}).Option(Merge.OutV, (ITraversal) __.Select<object>("x")).Option(Merge.InV, (ITraversal) __.Select<object>("y")), (g,p) =>g.V(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_with_eid_specified_and_inheritance_1", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E("201"), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_with_eid_specified_and_inheritance_2", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E("201"), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeE_outV_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeE_inV_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeE_label_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeE_id_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeV_mergeE_combination_new_vertices", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).As("outV").MergeV((IDictionary<object, object>) p["xx2"]).As("inV").MergeE((IDictionary<object, object>) p["xx3"]).Option(Merge.OutV, (ITraversal) __.Select<object>("outV")).Option(Merge.InV, (ITraversal) __.Select<object>("inV")), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_mergeV_mergeE_combination_existing_vertices", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").AddV("person").Property("name", "vadas"), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).As("outV").MergeV((IDictionary<object, object>) p["xx2"]).As("inV").MergeE((IDictionary<object, object>) p["xx3"]).Option(Merge.OutV, (ITraversal) __.Select<object>("outV")).Option(Merge.InV, (ITraversal) __.Select<object>("inV")), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.V().Has("name", "marko").Out("knows").Has("name", "vadas")}}, 
               {"g_V_asXvX_mergeEXxx1X_optionXMerge_onMatch_xx2X_optionXMerge_outV_selectXvXX_optionXMerge_inV_selectXvXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().As("v").MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]).Option(Merge.OutV, (ITraversal) __.Select<object>("v")).Option(Merge.InV, (ITraversal) __.Select<object>("v"))}}, 
               {"g_V_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b"), (g,p) =>g.V().MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (ITraversal) __.SideEffect(__.Property("weight", 0)).Constant<object>(new Dictionary<object, object> {})), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasLabel("knows").Has("weight", 0)}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").Property("weight", 1).From("a").To("b"), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (ITraversal) __.SideEffect(__.Property("weight", 0)).Constant<object>(new Dictionary<object, object> {})), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows").Has("weight", 1), (g,p) =>g.E().HasLabel("knows").Has("weight", 0), (g,p) =>g.V().Has("weight")}}, 
               {"g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.Union<object>(__.Select<object>("map"), __.Select<object>("map"), __.Constant<object>(new Dictionary<object, object> {{ "created", "N" }})).Fold().As("m").MergeE((ITraversal) __.Select<object>("m").Limit<object>(Scope.Local, 1).Unfold<object>()).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m").Range<object>(Scope.Local, 1, 2).Unfold<object>()).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m").Tail<object>(Scope.Local).Unfold<object>()), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().Has("created", "N"), (g,p) =>g.V().Has("person", "name", "marko").OutE("knows").Has("created", "N").InV().Has("person", "name", "vadas")}}, 
               {"g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.Union<object>(__.Select<object>("map"), __.Select<object>("map"), __.Constant<object>(new Dictionary<object, object> {{ "created", "N" }})).Fold().As("m").MergeE((ITraversal) __.Select<object>("m").Limit<object>(Scope.Local, 1).Unfold<object>()).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m").Range<object>(Scope.Local, 1, 2).Unfold<object>()).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m").Tail<object>(Scope.Local).Unfold<object>()), (g,p) =>g.V(), (g,p) =>g.E(), (g,p) =>g.E().HasNot("created"), (g,p) =>g.V().Has("person", "name", "marko").OutE("knows").HasNot("created").InV().Has("person", "name", "vadas"), (g,p) =>g.V().Has("person", "name", "vadas").OutE("self").HasNot("weight").InV().Has("person", "name", "vadas")}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX_allowed", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("weight", 1.0d), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows"), (g,p) =>g.E().HasLabel("knows").Has("weight", (object) null)}}, 
               {"g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").As("a").AddV("person").Property("name", "vadas").As("b").AddE("knows").From("a").To("b").Property("weight", 1.0d), (g,p) =>g.MergeE((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.E().HasLabel("knows"), (g,p) =>g.E().HasLabel("knows").Has("weight")}}, 
               {"g_mergeVXemptyX_optionXonMatch_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (IDictionary<object, object>) null), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 29)}}, 
               {"g_V_mergeVXemptyX_optionXonMatch_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (IDictionary<object, object>) null), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 29)}}, 
               {"g_mergeVXnullX_optionXonCreate_label_null_name_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"])}}, 
               {"g_V_mergeVXnullX_optionXonCreate_label_null_name_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeV((IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) null), (g,p) =>g.V(), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_V_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) null), (g,p) =>g.V(), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_mergeVXnullX_optionXonCreate_emptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) null).Option(Merge.OnCreate, (IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V()}}, 
               {"g_V_mergeVXnullX_optionXonCreate_emptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeV((IDictionary<object, object>) null).Option(Merge.OnCreate, (IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V()}}, 
               {"g_mergeVXemptyX_no_existing", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V()}}, 
               {"g_injectX0X_mergeVXemptyX_no_existing", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V()}}, 
               {"g_mergeVXemptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 29)}}, 
               {"g_V_mergeVXemptyX_two_exist", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.V().MergeV((IDictionary<object, object>) new Dictionary<object, object> {}), (g,p) =>g.V(), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 29), (g,p) =>g.V().Has("person", "name", "vadas").Has("age", 27)}}, 
               {"g_mergeVXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) null), (g,p) =>g.V()}}, 
               {"g_mergeVXnullvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V()}}, 
               {"g_V_mergeVXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.V().MergeV((IDictionary<object, object>) null), (g,p) =>g.V()}}, 
               {"g_mergeVXlabel_person_name_stephenX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_mergeVXlabel_person_name_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko")}}, 
               {"g_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
               {"g_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19)}}, 
               {"g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((ITraversal) __.Select<object>("c")).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m")), (g,p) =>g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
               {"g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m")), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19)}}, 
               {"g_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Property("name", "vadas", "acl", "public"), (g,p) =>g.V().Properties<object>("name").HasValue("vadas").Has("acl", "public")}}, 
               {"g_injectX0X_mergeVXlabel_person_name_stephenX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "stephen")}}, 
               {"g_injectX0X_mergeVXlabel_person_name_markoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]), (g,p) =>g.V().Has("person", "name", "marko")}}, 
               {"g_injectX0X_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
               {"g_injectX0X_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19)}}, 
               {"g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_injectX0X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((ITraversal) __.Select<object>("c")).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m")), (g,p) =>g.V().Has("person", "name", "stephen").Has("age", 19)}}, 
               {"g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_injectX0X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m")), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19)}}, 
               {"g_injectX0X_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(0).MergeV((IDictionary<object, object>) p["xx1"]).Property("name", "vadas", "acl", "public"), (g,p) =>g.V().Properties<object>("name").HasValue("vadas").Has("acl", "public")}}, 
               {"g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeVXidentityX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(new Dictionary<object, object> {{ T.Label, "person" }, { "name", "marko" }}, new Dictionary<object, object> {{ T.Label, "person" }, { "name", "stephen" }}).MergeV((ITraversal) __.Identity()), (g,p) =>g.V().Has("person", "name", "stephen"), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V()}}, 
               {"g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeV", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(new Dictionary<object, object> {{ T.Label, "person" }, { "name", "marko" }}, new Dictionary<object, object> {{ T.Label, "person" }, { "name", "stephen" }}).MergeV(), (g,p) =>g.V().Has("person", "name", "stephen"), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V()}}, 
               {"g_mergeVXlabel_person_name_stephenX_propertyXlist_name_steveX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property(Cardinality.List, "name", "stephen"), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Property(Cardinality.List, "name", "steve"), (g,p) =>g.V(), (g,p) =>g.V().Properties<object>("name").HasValue("steve"), (g,p) =>g.V().Properties<object>("name").HasValue("stephen"), (g,p) =>g.V().Properties<object>("name")}}, 
               {"g_mergeXlabel_person_name_vadasX_optionXonMatch_age_35X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "vadas").Property("age", 27), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V().Has("age", 35), (g,p) =>g.V()}}, 
               {"g_V_mapXmergeXlabel_person_name_joshXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "vadas").Property("age", 29).AddV("person").Property("name", "stephen").Property("age", 27), (g,p) =>g.V().Map<object>(__.MergeV((IDictionary<object, object>) p["xx1"])), (g,p) =>g.V().Has("person", "name", "josh"), (g,p) =>g.V()}}, 
               {"g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((ITraversal) __.Select<object>("c")).Option(Merge.OnMatch, (ITraversal) __.SideEffect(__.Properties<object>("age").Drop()).Select<object>("m")), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19), (g,p) =>g.V().Has("person", "name", "marko").Has("age")}}, 
               {"g_withSideEffectXm_age_19X_V_hasXperson_name_markoX_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.V().Has("person", "name", "marko").MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (ITraversal) __.SideEffect(__.Properties<object>("age").Drop()).Select<object>("m")), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 19), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeV_onCreate_inheritance_existing", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "mike").Property(T.Id, "1"), (g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.V("1").Has("person", "name", "mike")}}, 
               {"g_mergeV_onCreate_inheritance_new_1", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.V("1").Has("person", "name", "mike")}}, 
               {"g_mergeV_onCreate_inheritance_new_2", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"]), (g,p) =>g.V(), (g,p) =>g.V("1").Has("person", "name", "mike")}}, 
               {"g_mergeV_label_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeV_id_override_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"]).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx2"])}}, 
               {"g_mergeV_hidden_id_key_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_label_key_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_label_value_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_id_key_onCreate_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_label_key_onCreate_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_label_value_onCreate_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnCreate, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_id_key_onMatch_matched_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("vertex"), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeV_hidden_label_key_matched_onMatch_matched_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("vertex"), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_mergeVXname_markoX_optionXonMatch_age_listX33XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.List(33) }}), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 33), (g,p) =>g.V().Has("person", "name", "marko").Has("age"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_age_setX33XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.Set(33) }}), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 33), (g,p) =>g.V().Has("person", "name", "marko").Has("age"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_age_setX31XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.Set(31) }}), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 31), (g,p) =>g.V().Has("person", "name", "marko").Has("age"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_age_singleX33XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.Single(33) }}), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 33), (g,p) =>g.V().Has("person", "name", "marko").Has("age"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_age_33_singleX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, new Dictionary<object, object> {{ "age", 33 }}, Cardinality.Single), (g,p) =>g.V().Has("person", "name", "marko").Has("age", 33), (g,p) =>g.V().Has("person", "name", "marko").Has("age"), (g,p) =>g.V().Has("person", "name", "marko").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_name_allen_age_setX31X_singleX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, new Dictionary<object, object> {{ "name", "allen" }, { "age", CardinalityValue.Set(31) }}, Cardinality.Single), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V().Has("person", "name", "allen").Has("age", 31), (g,p) =>g.V().Has("person", "name", "allen").Has("age"), (g,p) =>g.V().Has("person", "name", "allen").Properties<object>("age")}}, 
               {"g_mergeVXname_markoX_optionXonMatch_name_allen_age_singleX31X_singleX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property(Cardinality.List, "age", 29).Property(Cardinality.List, "age", 31).Property(Cardinality.List, "age", 32), (g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "marko" }}).Option(Merge.OnMatch, new Dictionary<object, object> {{ "name", "allen" }, { "age", CardinalityValue.Single(31) }}, Cardinality.Single), (g,p) =>g.V().Has("person", "name", "marko"), (g,p) =>g.V().Has("person", "name", "allen").Has("age", 33), (g,p) =>g.V().Has("person", "name", "allen").Has("age", 31), (g,p) =>g.V().Has("person", "name", "allen").Has("age"), (g,p) =>g.V().Has("person", "name", "allen").Properties<object>("age")}}, 
               {"g_mergeVXname_aliceX_optionXonCreate_age_singleX81XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "alice" }, { T.Label, "person" }}).Option(Merge.OnCreate, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.Single(81) }}), (g,p) =>g.V().Has("person", "name", "alice").Has("age", 81), (g,p) =>g.V().Has("person", "name", "alice").Has("age"), (g,p) =>g.V().Has("person", "name", "alice").Properties<object>("age")}}, 
               {"g_mergeVXname_aliceX_optionXonCreate_age_setX81XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "alice" }, { T.Label, "person" }}).Option(Merge.OnCreate, (IDictionary<object, object>) new Dictionary<object, object> {{ "age", CardinalityValue.Set(81) }}), (g,p) =>g.V().Has("person", "name", "alice").Has("age", 81), (g,p) =>g.V().Has("person", "name", "alice").Has("age"), (g,p) =>g.V().Has("person", "name", "alice").Properties<object>("age")}}, 
               {"g_mergeVXname_aliceX_optionXonCreate_age_81_setX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "alice" }, { T.Label, "person" }}).Option(Merge.OnCreate, new Dictionary<object, object> {{ "age", 81 }}, Cardinality.Set), (g,p) =>g.V().Has("person", "name", "alice").Has("age", 81), (g,p) =>g.V().Has("person", "name", "alice").Has("age"), (g,p) =>g.V().Has("person", "name", "alice").Properties<object>("age")}}, 
               {"g_mergeVXname_aliceX_optionXonCreate_age_81_label_person_setX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {{ "name", "alice" }}).Option(Merge.OnCreate, new Dictionary<object, object> {{ "age", 81 }, { T.Label, "person" }}, Cardinality.Set), (g,p) =>g.V().Has("person", "name", "alice").Has("age", 81), (g,p) =>g.V().Has("person", "name", "alice").Has("age"), (g,p) =>g.V().Has("person", "name", "alice").Properties<object>("age")}}, 
               {"g_mergeV_hidden_label_key_onMatch_matched_prohibited", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.MergeV((IDictionary<object, object>) new Dictionary<object, object> {}).Option(Merge.OnMatch, (IDictionary<object, object>) p["xx1"])}}, 
               {"g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(new Dictionary<object, object> {{ T.Label, "person" }, { "name", "marko" }}, new Dictionary<object, object> {{ T.Label, "person" }, { "name", "marko" }}, new Dictionary<object, object> {{ "created", "N" }}).Fold().As("m").MergeV((ITraversal) __.Select<object>("m").Limit<object>(Scope.Local, 1).Unfold<object>()).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m").Range<object>(Scope.Local, 1, 2).Unfold<object>()).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m").Tail<object>(Scope.Local).Unfold<object>()), (g,p) =>g.V().Has("person", "name", "marko").Has("created", "N"), (g,p) =>g.V()}}, 
               {"g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29), (g,p) =>g.Inject<object>(new Dictionary<object, object> {{ T.Label, "person" }, { "name", "stephen" }}, new Dictionary<object, object> {{ T.Label, "person" }, { "name", "stephen" }}, new Dictionary<object, object> {{ "created", "N" }}).Fold().As("m").MergeV((ITraversal) __.Select<object>("m").Limit<object>(Scope.Local, 1).Unfold<object>()).Option(Merge.OnCreate, (ITraversal) __.Select<object>("m").Range<object>(Scope.Local, 1, 2).Unfold<object>()).Option(Merge.OnMatch, (ITraversal) __.Select<object>("m").Tail<object>(Scope.Local).Unfold<object>()), (g,p) =>g.V().Has("person", "name", "stephen").HasNot("created"), (g,p) =>g.V()}}, 
               {"g_V_age_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Min<object>()}}, 
               {"g_V_foo_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Min<object>()}}, 
               {"g_V_name_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Min<object>()}}, 
               {"g_V_age_fold_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Min<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Min<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Min<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_unfold_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Min<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Min<object>()}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Min<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Min<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_unfold_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Min<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Min<object>()}}, 
               {"g_V_foo_fold_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Fold().Min<object>(Scope.Local)}}, 
               {"g_V_name_fold_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Min<object>(Scope.Local)}}, 
               {"g_V_repeatXbothX_timesX5X_age_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both()).Times(5).Values<object>("age").Min<object>()}}, 
               {"g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_minX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Group<object, object>().By("name").By(__.BothE().Values<object>("weight").Min<object>())}}, 
               {"g_V_foo_injectX9999999999X_min", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Inject(9999999999l).Min<object>()}}, 
               {"g_VX1X_valuesXageX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Min<object>(Scope.Local)}}, 
               {"g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_minXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Union<object>(__.Values<object>("age"), __.OutE().Values<object>("weight")).Fold()).Min<object>(Scope.Local)}}, 
               {"g_V_name_order", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order()}}, 
               {"g_V_order_byXname_ascX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name", Order.Asc).Values<object>("name")}}, 
               {"g_V_order_byXnameX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name").Values<object>("name")}}, 
               {"g_V_outE_order_byXweight_descX_weight", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Order().By("weight", Order.Desc).Values<object>("weight")}}, 
               {"g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("created").As("b").Order().By(Order.Shuffle).Select<object>("a", "b")}}, 
               {"g_V_both_hasLabelXpersonX_order_byXage_descX_limitX5X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().HasLabel("person").Order().By("age", Order.Desc).Limit<object>(5).Values<object>("name")}}, 
               {"g_V_properties_order_byXkey_descX_key", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().Order().By(T.Key, Order.Desc).Key()}}, 
               {"g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_orderXlocalX_byXvaluesX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Group<object, object>().By("name").By(__.OutE().Values<object>("weight").Sum<object>()).Order(Scope.Local).By(Column.Values)}}, 
               {"g_V_mapXbothE_weight_foldX_order_byXsumXlocalX_descX_byXcountXlocalX_descX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Map<object>(__.BothE().Values<object>("weight").Order().By(Order.Asc).Fold()).Order().By(__.Sum<object>(Scope.Local), Order.Desc).By(__.Count(Scope.Local), Order.Desc)}}, 
               {"g_V_group_byXlabelX_byXname_order_byXdescX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(T.Label).By(__.Values<object>("name").Order().By(Order.Desc).Fold())}}, 
               {"g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_unfold_order_byXvalues_descX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Group<object, object>().By("name").By(__.OutE().Values<object>("weight").Sum<object>()).Unfold<object>().Order().By(Column.Values, Order.Desc)}}, 
               {"g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_descX_byXselectXvX_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("v").Map<object>(__.BothE().Values<object>("weight").Fold()).Sum<object>(Scope.Local).As("s").Select<object>("v", "s").Order().By(__.Select<object>("s"), Order.Desc).By(__.Select<object>("v").Values<object>("name"))}}, 
               {"g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Fold().Order(Scope.Local).By("age")}}, 
               {"g_V_both_hasLabelXpersonX_order_byXage_descX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().HasLabel("person").Order().By("age", Order.Desc).Values<object>("name")}}, 
               {"g_V_order_byXoutE_count_descX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By(__.OutE().Count(), Order.Desc).By("name")}}, 
               {"g_V_hasLabelXpersonX_order_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Order().By("age")}}, 
               {"g_V_order_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("age")}}, 
               {"g_V_fold_orderXlocalX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Order(Scope.Local).By("age")}}, 
               {"g_V_fold_orderXlocalX_byXage_descX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Order(Scope.Local).By("age", Order.Desc)}}, 
               {"g_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Or(__.HasLabel("person"), __.Has("software", "name", "lop")).Order().By("age")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Or(__.HasLabel("person"), __.Has("software", "name", "lop")).Order().By("age")}}, 
               {"g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_descX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("song", "name", "OH BOY").Out("followedBy").Out("followedBy").Order().By("performances").By("songType", Order.Desc).By("name")}}, 
               {"g_V_hasLabelXsongX_order_byXperformances_descX_byXnameX_rangeX110_120X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("song").Order().By("performances", Order.Desc).By("name").Range<object>(110, 120).Values<object>("name")}}, 
               {"g_VX1X_elementMap_orderXlocalX_byXkeys_descXunfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).ElementMap<object>().Order(Scope.Local).By(Column.Keys, Order.Desc).Unfold<object>()}}, 
               {"g_VX1X_elementMap_orderXlocalX_byXkeys_ascXunfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).ElementMap<object>().Order(Scope.Local).By(Column.Keys, Order.Asc).Unfold<object>()}}, 
               {"g_VX1X_valuesXageX_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Order(Scope.Local)}}, 
               {"g_V_pageRank_hasXpageRankX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PageRank().Has("gremlin.pageRankVertexProgram.pageRank")}}, 
               {"g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankX_withXtimes_0X_valueMapXname_projectRankX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").PageRank().With("~tinkerpop.pageRank.edges", __.BothE()).With("~tinkerpop.pageRank.propertyName", "projectRank").With("~tinkerpop.pageRank.times", 0).ValueMap<object, object>("name", "projectRank")}}, 
               {"g_V_pageRank_order_byXpageRank_descX_byXnameX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", Order.Desc).By("name").Values<object>("name")}}, 
               {"g_V_pageRank_order_byXpageRank_descX_name_limitX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PageRank().Order().By("gremlin.pageRankVertexProgram.pageRank", Order.Desc).Values<object>("name").Limit<object>(2)}}, 
               {"g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PageRank().With("~tinkerpop.pageRank.edges", __.OutE("knows")).With("~tinkerpop.pageRank.propertyName", "friendRank").Project<object>("name", "friendRank").By("name").By(__.Values<object>("friendRank").Math("ceil(_ * 100)"))}}, 
               {"g_V_hasLabelXpersonX_pageRank_withXpropertyName_kpageRankX_project_byXnameX_byXvaluesXpageRankX_mathX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").Project<object>("name", "pageRank").By("name").By(__.Values<object>("pageRank").Math("ceil(_ * 100)"))}}, 
               {"g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PageRank().With("~tinkerpop.pageRank.propertyName", "pageRank").As("a").Out("knows").Values<object>("pageRank").As("b").Select<object>("a", "b").By().By(__.Math("ceil(_ * 100)"))}}, 
               {"g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Has("name", "ripple").PageRank(1.0).With("~tinkerpop.pageRank.edges", __.InE("created")).With("~tinkerpop.pageRank.times", 1).With("~tinkerpop.pageRank.propertyName", "priors").In("created").Union<object>(__.Both(), __.Identity()).ValueMap<object, object>("name", "priors")}}, 
               {"g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankX_withXedges_inEX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Group("m").By(T.Label).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "pageRank").With("~tinkerpop.pageRank.edges", __.InE()).With("~tinkerpop.pageRank.times", 1).In("created").Group("m").By("pageRank").Cap<object>("m")}}, 
               {"g_VX1X_name_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("name").Path()}}, 
               {"g_VX1X_out_path_byXageX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Path().By("age").By("name")}}, 
               {"g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out()).Times(2).Path().By().By("name").By("lang")}}, 
               {"g_V_out_out_path_byXnameX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").By("age")}}, 
               {"g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Has("name", "marko").As("b").Has("age", 29).As("c").Path()}}, 
               {"g_VX1X_outEXcreatedX_inV_inE_outV_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("created").InV().InE().OutV().Path()}}, 
               {"g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Out().As("c").Path().From("b").To("c").By("name")}}, 
               {"g_VX1X_out_path_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Path().By("age")}}, 
               {"g_withStrategiesXProductiveByStrategyX_VX1X_out_path_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V(p["vid1"]).Out().Path().By("age")}}, 
               {"g_injectX1_null_nullX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1, null, null).Path()}}, 
               {"g_injectX1_null_nullX_path_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1, null, null).Path().Dedup()}}, 
               {"g_V_peerPressure_hasXclusterX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PeerPressure().Has("gremlin.peerPressureVertexProgram.cluster")}}, 
               {"g_V_peerPressure_withXpropertyName_clusterX_withXedges_outEXknowsXX_pageRankX1X_byXrankX_withXedges_outEXknowsX_withXtimes_2X_group_byXclusterX_byXrank_sumX_limitX100X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().PeerPressure().With("~tinkerpop.peerPressure.propertyName", "cluster").With("~tinkerpop.peerPressure.edges", __.OutE("knows")).PageRank(1.0).With("~tinkerpop.pageRank.propertyName", "rank").With("~tinkerpop.pageRank.edges", __.OutE("knows")).With("~tinkerpop.pageRank.times", 1).Group<object, object>().By("cluster").By(__.Values<object>("rank").Sum<object>()).Limit<object>(100)}}, 
               {"g_V_hasXname_rippleX_inXcreatedX_peerPressure_withXedges_outEX_withyXpropertyName_clusterX_repeatXunionXidentity__bothX_timesX2X_dedup_valueMapXname_clusterX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "ripple").In("created").PeerPressure().With("~tinkerpop.peerPressure.edges", __.OutE()).With("~tinkerpop.peerPressure.propertyName", "cluster").Repeat(__.Union<object>(__.Identity(), __.Both())).Times(2).Dedup().ValueMap<object, object>("name", "cluster")}}, 
               {"g_injectXnullX_productXinjectX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Product(__.Inject(1))}}, 
               {"g_V_valuesXnameX_productXV_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Product(__.V().Fold())}}, 
               {"g_V_fold_productXconstantXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Product(__.Constant<object>(null))}}, 
               {"g_V_fold_productXVX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fold().Product(__.V())}}, 
               {"g_V_valuesXnameX_fold_productX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Product(2)}}, 
               {"g_V_valuesXnameX_fold_productXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Product(null)}}, 
               {"g_V_valuesXnonexistantX_fold_productXV_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("nonexistant").Fold().Product(__.V().Values<object>("name").Fold())}}, 
               {"g_V_valuesXnameX_fold_productXV_valuesXnonexistantX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Product(__.V().Values<object>("nonexistant").Fold())}}, 
               {"g_V_valuesXageX_order_byXdescX_limitX3X_fold_productXV_valuesXageX_order_byXascX_limitX2X_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Desc).Limit<object>(3).Fold().Product(__.V().Values<object>("age").Order().By(Order.Asc).Limit<object>(2).Fold()).Unfold<object>()}}, 
               {"g_V_out_path_byXvaluesXnameX_toUpperX_productXMARKOX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By(__.Values<object>("name").ToUpper()).Product(new List<object> { "MARKO" }).Unfold<object>()}}, 
               {"g_injectXmarkoX_productXV_valuesXnameX_order_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "marko" }).Product(__.V().Values<object>("name").Order().Fold()).Unfold<object>()}}, 
               {"g_V_valueMapXlocationX_selectXvaluesX_unfold_productXdulles_seattle_vancouverX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("location").Select<object>(Column.Values).Unfold<object>().Product(new List<object> { "dulles", "seattle", "vancouver" }).Unfold<object>()}}, 
               {"g_V_valuesXageX_order_byXascX_fold_productXconstantX27X_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Order().By(Order.Asc).Fold().Product(__.Constant<object>(27).Fold()).Unfold<object>()}}, 
               {"g_V_out_out_path_byXnameX_productXdave_kelvinX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Product(new List<object> { "dave", "kelvin" }).Unfold<object>()}}, 
               {"g_injectXa_null_bX_productXa_cX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Product(new List<object> { "a", "c" }).Unfold<object>()}}, 
               {"g_injectXa_null_bX_productXa_null_cX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", null, "b" }).Product(new List<object> { "a", null, "c" }).Unfold<object>()}}, 
               {"g_injectX3_threeX_productXfive_three_7X_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Product(new List<object> { "five", "three", 7 }).Unfold<object>()}}, 
               {"g_V_hasLabelXpersonX_projectXa_bX_byXoutE_countX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Project<object>("a", "b").By(__.OutE().Count()).By("age")}}, 
               {"g_V_outXcreatedX_projectXa_bX_byXnameX_byXinXcreatedX_countX_order_byXselectXbX__descX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Project<object>("a", "b").By("name").By(__.In("created").Count()).Order().By(__.Select<object>("b"), Order.Desc).Select<object>("a")}}, 
               {"g_V_valueMap_projectXxX_byXselectXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Project<object>("x").By(__.Select<object>("name"))}}, 
               {"g_V_projectXa_bX_byXinE_countX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Project<object>("a", "b").By(__.InE().Count()).By("age")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_projectXa_bX_byXinE_countX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Project<object>("a", "b").By(__.InE().Count()).By("age")}}, 
               {"g_V_hasXageX_propertiesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").Properties<object>("name").Value<object>()}}, 
               {"g_V_hasXageX_propertiesXname_ageX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").Properties<object>("name", "age").Value<object>()}}, 
               {"g_V_hasXageX_propertiesXage_nameX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").Properties<object>("age", "name").Value<object>()}}, 
               {"g_V_propertiesXname_age_nullX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>("name", "age", null).Value<object>()}}, 
               {"g_V_valuesXname_age_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name", "age", null)}}, 
               {"g_injectX__feature___test__nullX_rTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("feature  ", "one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　").RTrim()}}, 
               {"g_injectX__feature___test__nullX_rTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　" }).RTrim<object>(Scope.Local)}}, 
               {"g_injectX__feature__X_rTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("  feature  ").RTrim()}}, 
               {"g_injectXListXa_bXX_rTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).RTrim()}}, 
               {"g_injectXListX1_2XX_rTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).RTrim<object>(Scope.Local)}}, 
               {"g_V_valuesXnameX_rTrim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").RTrim()}}, 
               {"g_V_valuesXnameX_order_fold_rTrimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").Order().Fold().RTrim<object>(Scope.Local)}}, 
               {"g_injectXthat_this_test_nullX_replaceXh_jX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("that", "this", "test", null).Replace("h", "j")}}, 
               {"g_injectXthat_this_test_nullX_fold_replaceXlocal_h_jX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("that", "this", "test", null).Fold().Replace<object>(Scope.Local, "h", "j")}}, 
               {"g_injectXListXa_bXcX_replaceXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).Replace("a", "b")}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_replaceXnull_iX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Replace(null, "g")}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_replaceXa_iX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Replace("p", "g")}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_order_fold_replaceXloacl_a_iX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Order().Fold().Replace<object>(Scope.Local, "p", "g")}}, 
               {"g_injectXfeature_test_nullX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("feature", "test one", null).Reverse()}}, 
               {"g_V_valuesXnameX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Reverse()}}, 
               {"g_V_valuesXageX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Reverse()}}, 
               {"g_V_out_path_byXnameX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Path().By("name").Reverse()}}, 
               {"g_V_out_out_path_byXnameX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Path().By("name").Reverse()}}, 
               {"g_V_valuesXageX_fold_orderXlocalX_byXdescX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Order(Scope.Local).By(Order.Desc).Reverse()}}, 
               {"g_V_valuesXnameX_fold_orderXlocalX_by_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Fold().Order(Scope.Local).By().Reverse()}}, 
               {"g_injectXnullX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Reverse()}}, 
               {"g_injectXbX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("b").Reverse()}}, 
               {"g_injectX3_threeX_reverse", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 3, "three" }).Reverse()}}, 
               {"g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("knows").As("b").Select<object>("a", "b")}}, 
               {"g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("knows").As("b").Select<object>("a", "b").By("name")}}, 
               {"g_VX1X_asXaX_outXknowsX_asXbX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("knows").As("b").Select<object>("a")}}, 
               {"g_VX1X_asXaX_outXknowsX_asXbX_selectXaX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Out("knows").As("b").Select<object>("a").By("name")}}, 
               {"g_V_asXaX_out_asXbX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("b").Select<object>("a", "b").By("name")}}, 
               {"g_V_asXaX_out_aggregateXxX_asXbX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().Aggregate("x").As("b").Select<object>("a", "b").By("name")}}, 
               {"g_V_asXaX_name_order_asXbX_selectXa_bX_byXnameX_by_XitX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Values<object>("name").Order().As("b").Select<object>("a", "b").By("name").By()}}, 
               {"g_V_hasXname_gremlinX_inEXusesX_order_byXskill_ascX_asXaX_outV_asXbX_selectXa_bX_byXskillX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "gremlin").InE("uses").Order().By("skill", Order.Asc).As("a").OutV().As("b").Select<object>("a", "b").By("skill").By("name")}}, 
               {"g_V_whereX_valueXnameX_isXmarkoXX_asXaX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Where(__.Values<object>("name").Is("marko")).As("a").Select<object>("a")}}, 
               {"g_V_label_groupCount_asXxX_selectXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Label().GroupCount<object>().As("x").Select<object>("x")}}, 
               {"g_V_hasLabelXpersonX_asXpX_mapXbothE_label_groupCountX_asXrX_selectXp_rX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("p").Map<object>(__.BothE().Label().GroupCount<object>()).As("r").Select<object>("p", "r")}}, 
               {"g_V_chooseXoutE_count_isX0X__asXaX__asXbXX_chooseXselectXaX__selectXaX__selectXbXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.OutE().Count().Is(p["xx1"]), __.As("a"), __.As("b")).Choose<object>(__.Select<object>("a"), __.Select<object>("a"), __.Select<object>("b"))}}, 
               {"g_VX1X_groupXaX_byXconstantXaXX_byXnameX_selectXaX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Group("a").By(__.Constant<object>("a")).By(__.Values<object>("name")).Barrier().Select<object>("a").Select<object>("a")}}, 
               {"g_VX1X_asXhereX_out_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("here").Out().Select<object>("here")}}, 
               {"g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).As("here").Out().Select<object>("here")}}, 
               {"g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Out().As("here").Has("lang", "java").Select<object>("here").Values<object>("name")}}, 
               {"g_VX1X_outE_asXhereX_inV_hasXname_vadasX_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().As("here").InV().Has("name", "vadas").Select<object>("here")}}, 
               {"g_VX1X_outEXknowsX_hasXweight_1X_asXhereX_inV_hasXname_joshX_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").Has("weight", 1.0).As("here").InV().Has("name", "josh").Select<object>("here")}}, 
               {"g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_asXfakeX_inV_hasXname_joshX_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).As("fake").InV().Has("name", "josh").Select<object>("here")}}, 
               {"g_V_asXhereXout_name_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("here").Out().Values<object>("name").Select<object>("here")}}, 
               {"g_V_outXcreatedX_unionXasXprojectX_inXcreatedX_hasXname_markoX_selectXprojectX__asXprojectX_inXcreatedX_inXknowsX_hasXname_markoX_selectXprojectXX_groupCount_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Union<object>(__.As("project").In("created").Has("name", "marko").Select<object>("project"), __.As("project").In("created").In("knows").Has("name", "marko").Select<object>("project")).GroupCount<object>().By("name")}}, 
               {"g_V_untilXout_outX_repeatXin_asXaXX_selectXaX_byXtailXlocalX_nameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Until(__.Out().Out()).Repeat(__.In().As("a")).Select<object>("a").By(__.Tail<object>(Scope.Local).Values<object>("name"))}}, 
               {"g_V_outE_weight_groupCount_selectXkeysX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").GroupCount<object>().Select<object>(Column.Keys).Unfold<object>()}}, 
               {"g_V_hasLabelXsoftwareX_asXnameX_asXlanguageX_asXcreatorsX_selectXname_language_creatorsX_byXnameX_byXlangX_byXinXcreatedX_name_fold_orderXlocalXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").As("name").As("language").As("creators").Select<object>("name", "language", "creators").By("name").By("lang").By(__.In("created").Values<object>("name").Fold().Order(Scope.Local))}}, 
               {"g_V_outE_weight_groupCount_unfold_selectXkeysX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").GroupCount<object>().Unfold<object>().Select<object>(Column.Keys).Unfold<object>()}}, 
               {"g_V_outE_weight_groupCount_unfold_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").GroupCount<object>().Unfold<object>().Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_V_untilXout_outX_repeatXin_asXaX_in_asXbXX_selectXa_bX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Until(__.Out().Out()).Repeat(__.In().As("a").In().As("b")).Select<object>("a", "b").By("name")}}, 
               {"g_V_outE_weight_groupCount_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").GroupCount<object>().Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_V_asXaX_whereXoutXknowsXX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Where(__.Out("knows")).Select<object>("a")}}, 
               {"g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXfirst_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Repeat(__.Out().As("a")).Times(2).Select<object>(Pop.First, "a")}}, 
               {"g_V_asXaX_outXknowsX_asXbX_localXselectXa_bX_byXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("knows").As("b").Local<object>(__.Select<object>("a", "b").By("name"))}}, 
               {"g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXlast_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).As("a").Repeat(__.Out().As("a")).Times(2).Select<object>(Pop.Last, "a")}}, 
               {"g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_inV_hasXname_joshX_selectXhereX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").As("here").Has("weight", 1.0).InV().Has("name", "josh").Select<object>("here")}}, 
               {"g_V_asXaX_hasXname_markoX_asXbX_asXcX_selectXa_b_cX_by_byXnameX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Has("name", "marko").As("b").As("c").Select<object>("a", "b", "c").By().By("name").By("age")}}, 
               {"g_V_outE_weight_groupCount_selectXvaluesX_unfold_groupCount_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE().Values<object>("weight").GroupCount<object>().Select<object>(Column.Values).Unfold<object>().GroupCount<object>().Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Group("m").By().By(__.BothE().Count()).Barrier().Select<object>("m").Select<object>(__.Select<object>("a"))}}, 
               {"g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX_byXmathX_plus_XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Group("m").By().By(__.BothE().Count()).Barrier().Select<object>("m").Select<object>(__.Select<object>("a")).By(__.Math("_+_"))}}, 
               {"g_V_asXaX_outXknowsX_asXaX_selectXall_constantXaXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out("knows").As("a").Select<object>(Pop.All, __.Constant<object>("a"))}}, 
               {"g_V_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>("a")}}, 
               {"g_V_selectXaX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>("a").Count()}}, 
               {"g_V_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>("a", "b")}}, 
               {"g_V_valueMap_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>("a")}}, 
               {"g_V_valueMap_selectXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>("a", "b")}}, 
               {"g_V_selectXfirst_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.First, "a")}}, 
               {"g_V_selectXfirst_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.First, "a", "b")}}, 
               {"g_V_valueMap_selectXfirst_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.First, "a")}}, 
               {"g_V_valueMap_selectXfirst_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.First, "a", "b")}}, 
               {"g_V_selectXlast_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.Last, "a")}}, 
               {"g_V_selectXlast_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.Last, "a", "b")}}, 
               {"g_V_valueMap_selectXlast_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.Last, "a")}}, 
               {"g_V_valueMap_selectXlast_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.Last, "a", "b")}}, 
               {"g_V_selectXall_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.All, "a")}}, 
               {"g_V_selectXall_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Select<object>(Pop.All, "a", "b")}}, 
               {"g_V_valueMap_selectXall_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.All, "a")}}, 
               {"g_V_valueMap_selectXall_a_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Select<object>(Pop.All, "a", "b")}}, 
               {"g_V_asXa_bX_out_asXcX_path_selectXkeysX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a", "b").Out().As("c").Path().Select<object>(Column.Keys), (g,p) =>g.V().As("a", "b").Out().As("c").Path().Select<object>(Column.Keys)}}, 
               {"g_V_hasXperson_name_markoX_barrier_asXaX_outXknows_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Barrier().As("a").Out("knows").Select<object>("a")}}, 
               {"g_V_hasXperson_name_markoX_elementMapXnameX_asXaX_unionXidentity_identityX_selectXaX_selectXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").ElementMap<object>("name").As("a").Union<object>(__.Identity(), __.Identity()).Select<object>("a").Select<object>("name")}}, 
               {"g_V_hasXperson_name_markoX_count_asXaX_unionXidentity_identityX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Count().As("a").Union<object>(__.Identity(), __.Identity()).Select<object>("a")}}, 
               {"g_V_hasXperson_name_markoX_path_asXaX_unionXidentity_identityX_selectXaX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Path().As("a").Union<object>(__.Identity(), __.Identity()).Select<object>("a").Unfold<object>()}}, 
               {"g_EX11X_propertiesXweightX_asXaX_selectXaX_byXkeyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).Properties<object>("weight").As("a").Select<object>("a").By(T.Key)}}, 
               {"g_EX11X_propertiesXweightX_asXaX_selectXaX_byXvalueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E(p["eid11"]).Properties<object>("weight").As("a").Select<object>("a").By(T.Value)}}, 
               {"g_V_asXaX_selectXaX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Select<object>("a").By("age")}}, 
               {"g_V_asXa_nX_selectXa_nX_byXageX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a", "n").Select<object>("a", "n").By("age").By("name")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_asXaX_selectXaX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().As("a").Select<object>("a").By("age")}}, 
               {"g_withSideEffectXk_nullX_injectXxX_selectXkX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("k", null).Inject<object>("x").Select<object>("k")}}, 
               {"g_V_out_in_selectXall_a_a_aX_byXunfold_name_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("A").Property("name", "a1").As("a1").AddV("B").Property("name", "b1").As("b1").AddE("ab").From("a1").To("b1"), (g,p) =>g.V().As("a").Out().As("a").In().As("a").Select<object>(Pop.All, "a", "a", "a").By(__.Unfold<object>().Values<object>("name").Fold())}}, 
               {"g_V_asXlabelX_localXaggregateXxX_selectXxX_selectXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("label").Local<object>(__.Aggregate("x")).Barrier().Select<object>("x").Select<object>("label")}}, 
               {"g_V_name_asXaX_selectXfirst_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").As("a").Select<object>(Pop.First, "a")}}, 
               {"g_V_name_asXaX_selectXlast_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").As("a").Select<object>(Pop.Last, "a")}}, 
               {"g_V_name_asXaX_selectXmixed_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").As("a").Select<object>(Pop.Mixed, "a")}}, 
               {"g_V_name_asXaX_selectXall_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").As("a").Select<object>(Pop.All, "a")}}, 
               {"g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Concat("X").As("a").Length().As("a").Select<object>("a")}}, 
               {"g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXfirst_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Concat("X").As("a").Length().As("a").Select<object>(Pop.First, "a")}}, 
               {"g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXlast_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Concat("X").As("a").Length().As("a").Select<object>(Pop.Last, "a")}}, 
               {"g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXmixed_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Concat("X").As("a").Concat("YZ").As("a").Select<object>(Pop.Mixed, "a")}}, 
               {"g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXall_aX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").As("a").Concat("X").As("a").Concat("YZ").As("a").Select<object>(Pop.All, "a")}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.Mixed, "a").By(__.Unfold<object>().Values<object>("name").Fold())}}, 
               {"g_V_asXaX_out_asXaX_out_asXaX_selectXall_aX_byXunfold_valuesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().As("a").Out().As("a").Out().As("a").Select<object>(Pop.All, "a").By(__.Unfold<object>().Values<object>("name").Fold())}}, 
               {"g_V_shortestPath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath()}}, 
               {"g_V_both_dedup_shortestPath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Dedup().ShortestPath()}}, 
               {"g_V_shortestPath_edgesIncluded", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.includeEdges")}}, 
               {"g_V_shortestPath_directionXINX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.edges", Direction.In)}}, 
               {"g_V_shortestPath_edgesXoutEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.edges", __.OutE())}}, 
               {"g_V_shortestPath_edgesIncluded_edgesXoutEX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.includeEdges").With("~tinkerpop.shortestPath.edges", __.OutE())}}, 
               {"g_V_hasXname_markoX_shortestPath", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").ShortestPath()}}, 
               {"g_V_shortestPath_targetXhasXname_markoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.target", __.Has("name", "marko"))}}, 
               {"g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ShortestPath().With("~tinkerpop.shortestPath.target", __.Values<object>("name").Is("marko"))}}, 
               {"g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", __.HasLabel("software"))}}, 
               {"g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.target", __.Has("name", "josh")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
               {"g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "daniel").ShortestPath().With("~tinkerpop.shortestPath.target", __.Has("name", "stephen")).With("~tinkerpop.shortestPath.edges", __.BothE("uses"))}}, 
               {"g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("song", "name", "MIGHT AS WELL").ShortestPath().With("~tinkerpop.shortestPath.target", __.Has("song", "name", "MAYBE YOU KNOW HOW I FEEL")).With("~tinkerpop.shortestPath.edges", __.OutE("followedBy")).With("~tinkerpop.shortestPath.distance", "weight")}}, 
               {"g_V_hasXname_markoX_shortestPath_maxDistanceX1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").ShortestPath().With("~tinkerpop.shortestPath.maxDistance", 1)}}, 
               {"g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "vadas").ShortestPath().With("~tinkerpop.shortestPath.distance", "weight").With("~tinkerpop.shortestPath.maxDistance", 1.3)}}, 
               {"g_injectXthat_this_testX_spiltXhX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("that", "this", "test", null).Split("h")}}, 
               {"g_injectXhello_worldX_spiltXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("hello world").Split(null)}}, 
               {"g_injectXthat_this_test_nullX_splitXemptyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("that", "this", "test", null).Split("")}}, 
               {"g_injectXListXa_bXcX_splitXa_bX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).Split("a")}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_splitXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Split(null)}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_aX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Order().Fold().Split<object>(Scope.Local, "a").Unfold<object>()}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_emptyX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Order().Fold().Split<object>(Scope.Local, "").Unfold<object>()}}, 
               {"g_injectXthat_this_testX_substringX1_8X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("test", "hello world", null).Substring(1, 8)}}, 
               {"g_injectXListXa_bXcX_substringX1_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "aa", "bb" }).Substring(1, 2)}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_substringX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(2)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_substringX1_4X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(1, 4)}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_order_fold_substringXlocal_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Order().Fold().Substring<object>(Scope.Local, 2)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_order_fold_substringXlocal_1_4X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Order().Fold().Substring<object>(Scope.Local, 1, 4)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_substringX1_0X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(1, 0)}}, 
               {"g_V_hasLabelXpersonX_valueXnameX_substringXneg3X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Values<object>("name").Substring(-3)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_substringX1_neg1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(1, -1)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_substringXneg4_2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(-4, 2)}}, 
               {"g_V_hasLabelXsoftwareX_valueXnameX_substringXneg3_neg1X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Values<object>("name").Substring(-3, -1)}}, 
               {"g_V_injectX127b_1bX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 127, (sbyte) 1).Sum<object>()}}, 
               {"g_V_injectX_128b__1bX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((short) -128, (short) -1).Sum<object>()}}, 
               {"g_V_injectX32767s_1sX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((short) 32767, (short) 1).Sum<object>()}}, 
               {"g_V_injectX_32768s__1sX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((short) -32768, (short) -1).Sum<object>()}}, 
               {"g_V_injectX2147483647i_1iX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(2147483647, 1).Sum<object>()}}, 
               {"g_V_injectX_2147483648i__1iX_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(-2147483648, -1).Sum<object>()}}, 
               {"g_V_age_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Sum<object>()}}, 
               {"g_V_foo_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Sum<object>()}}, 
               {"g_V_age_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Fold().Sum<object>(Scope.Local)}}, 
               {"g_V_foo_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("foo").Fold().Sum<object>(Scope.Local)}}, 
               {"g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Group<object, object>().By("name").By(__.BothE().Values<object>("weight").Sum<object>())}}, 
               {"g_V_aggregateXaX_byXageX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Sum<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Sum<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXageX_capXaX_unfold_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Sum<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("age").Cap<object>("a").Unfold<object>().Sum<object>()}}, 
               {"g_V_aggregateXaX_byXfooX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Sum<object>(Scope.Local)}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Sum<object>(Scope.Local)}}, 
               {"g_V_aggregateXaX_byXfooX_capXaX_unfold_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Sum<object>()}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("a").By("foo").Cap<object>("a").Unfold<object>().Sum<object>()}}, 
               {"g_injectXnull_10_5_nullX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, 10, 5, null).Sum<object>()}}, 
               {"g_injectXlistXnull_10_5_nullXX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { null, 10, 5, null }).Sum<object>(Scope.Local)}}, 
               {"g_VX1X_valuesXageX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Values<object>("age").Sum<object>(Scope.Local)}}, 
               {"g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Union<object>(__.Values<object>("age"), __.OutE().Values<object>("weight")).Fold()).Sum<object>(Scope.Local)}}, 
               {"g_V_age_injectX1000nX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Inject(BigInteger.Parse("1000")).Sum<object>()}}, 
               {"g_injectX1b_2b_3bX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, (sbyte) 3).Sum<object>()}}, 
               {"g_injectX1b_2b_3sX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, (short) 3).Sum<object>()}}, 
               {"g_injectX1b_26b_3iX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, 3).Sum<object>()}}, 
               {"g_injectX1f_26f_3fX_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1f, 2f, 3f).Sum<object>()}}, 
               {"g_V_age_injectX1000nX_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("age").Inject(BigInteger.Parse("1000")).Fold().Sum<object>(Scope.Local)}}, 
               {"g_injectX1b_2b_3bX_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, (sbyte) 3).Fold().Sum<object>(Scope.Local)}}, 
               {"g_injectX1b_2b_3sX_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, (short) 3).Fold().Sum<object>(Scope.Local)}}, 
               {"g_injectX1b_26b_3iX_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>((sbyte) 1, (sbyte) 2, 3).Fold().Sum<object>(Scope.Local)}}, 
               {"g_injectX1f_26f_3fX_fold_sumXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1f, 2f, 3f).Fold().Sum<object>(Scope.Local)}}, 
               {"g_injectXfeature_test_nullX_toLower", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("FEATURE", "tESt", null).ToLower()}}, 
               {"g_injectXfeature_test_nullX_toLowerXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "FEATURE", "tESt", null }).ToLower<object>(Scope.Local)}}, 
               {"g_injectXListXa_bXX_toLower", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).ToLower()}}, 
               {"g_V_valuesXnameX_toLower", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").ToLower()}}, 
               {"g_V_valuesXnameX_toLowerXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").ToLower<object>(Scope.Local)}}, 
               {"g_V_valuesXnameX_order_fold_toLowerXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "MARKO").Property("age", 29).As("marko").AddV("person").Property("name", "VADAS").Property("age", 27).As("vadas").AddV("software").Property("name", "LOP").Property("lang", "java").As("lop").AddV("person").Property("name", "JOSH").Property("age", 32).As("josh").AddV("software").Property("name", "RIPPLE").Property("lang", "java").As("ripple").AddV("person").Property("name", "PETER").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").Order().Fold().ToLower<object>(Scope.Local)}}, 
               {"g_injectXfeature_test_nullX_toUpper", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("feature", "tESt", null).ToUpper()}}, 
               {"g_injectXfeature_test_nullX_toUpperXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "feature", "tESt", null }).ToUpper<object>(Scope.Local)}}, 
               {"g_injectXListXa_bXX_toUpper", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).ToUpper()}}, 
               {"g_V_valuesXnameX_toUpper", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").ToUpper()}}, 
               {"g_V_valuesXnameX_toUpperXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").ToUpper<object>(Scope.Local)}}, 
               {"g_V_valuesXnameX_order_fold_toUpperXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Order().Fold().ToUpper<object>(Scope.Local)}}, 
               {"g_injectX__feature___test__nullX_trim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　").Trim()}}, 
               {"g_injectX__feature___test__nullX_trimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　" }).Trim<object>(Scope.Local)}}, 
               {"g_injectXListXa_bXX_trim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { "a", "b" }).Trim()}}, 
               {"g_injectXListX1_2XX_trimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 2 }).Trim<object>(Scope.Local)}}, 
               {"g_V_valuesXnameX_trim", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").Trim()}}, 
               {"g_V_valuesXnameX_order_fold_trimXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", " marko ").Property("age", 29).As("marko").AddV("person").Property("name", "  vadas  ").Property("age", 27).As("vadas").AddV("software").Property("name", "  lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh  ").Property("age", 32).As("josh").AddV("software").Property("name", "   ripple   ").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Values<object>("name").Order().Fold().Trim<object>(Scope.Local)}}, 
               {"g_V_localXoutE_foldX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.OutE().Fold()).Unfold<object>()}}, 
               {"g_V_valueMap_unfold_mapXselectXkeysXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().Unfold<object>().Map<object>(__.Select<object>(Column.Keys))}}, 
               {"g_VX1X_repeatXboth_simplePathX_untilXhasIdX6XX_path_byXnameX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Repeat(__.Both().SimplePath()).Until(__.HasId(p["vid6"])).Path().By("name").Unfold<object>()}}, 
               {"g_V_valueMap", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>()}}, 
               {"g_V_valueMapXtrueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>(true)}}, 
               {"g_V_valueMap_withXtokensX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>().With(WithOptions.Tokens)}}, 
               {"g_V_valueMapXname_ageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age")}}, 
               {"g_V_valueMapXtrue_name_ageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>(true, "name", "age")}}, 
               {"g_V_valueMapXname_ageX_withXtokensX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age").With(WithOptions.Tokens)}}, 
               {"g_V_valueMapXname_ageX_withXtokens_labelsX_byXunfoldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age").With(WithOptions.Tokens, WithOptions.Labels).By(__.Unfold<object>())}}, 
               {"g_V_valueMapXname_ageX_withXtokens_idsX_byXunfoldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age").With(WithOptions.Tokens, WithOptions.Ids).By(__.Unfold<object>())}}, 
               {"g_VX1X_outXcreatedX_valueMap", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("created").ValueMap<object, object>()}}, 
               {"g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMapXtrueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Filter(__.OutE("created")).ValueMap<object, object>(true)}}, 
               {"g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMap_withXtokensX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Filter(__.OutE("created")).ValueMap<object, object>().With(WithOptions.Tokens)}}, 
               {"g_VX1X_valueMapXname_locationX_byXunfoldX_by", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).ValueMap<object, object>("name", "location").By(__.Unfold<object>()).By()}}, 
               {"g_V_valueMapXname_age_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age", null)}}, 
               {"g_V_valueMapXname_ageX_byXisXxXXbyXunfoldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().ValueMap<object, object>("name", "age").By(__.Is("x")).By(__.Unfold<object>())}}, 
               {"g_VXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(null)}}, 
               {"g_VXlistXnullXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"])}}, 
               {"g_VX1_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"], null)}}, 
               {"g_VXlistX1_2_3XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"]).Values<object>("name")}}, 
               {"g_VXlistXv1_v2_v3XX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"]).Values<object>("name")}}, 
               {"g_V", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V()}}, 
               {"g_VXv1X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out()}}, 
               {"g_VX1X_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out()}}, 
               {"g_VX2X_in", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).In()}}, 
               {"g_VX4X_both", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).Both()}}, 
               {"g_VX1X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE()}}, 
               {"g_VX2X_outE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).InE()}}, 
               {"g_VX4X_bothEXcreatedX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).BothE("created")}}, 
               {"g_VX4X_bothEXcreatedvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).BothE((string) p["xx1"])}}, 
               {"g_VX4X_bothE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid4"]).BothE()}}, 
               {"g_V_out_outE_inV_inE_inV_both_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().OutE().InV().InE().InV().Both().Values<object>("name")}}, 
               {"g_VX2X_inE", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid2"]).BothE()}}, 
               {"g_VX1X_outXknowsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("knows")}}, 
               {"g_VX1AsStringX_outXknowsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("knows")}}, 
               {"g_VX1X_outXknows_createdX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out("knows", "created")}}, 
               {"g_VX1X_outXknowsvar_createdvarX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out((string) p["xx2"], (string) p["xx3"])}}, 
               {"g_V_out_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out()}}, 
               {"g_VX1X_out_out_out", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Out()}}, 
               {"g_VX1X_out_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Values<object>("name")}}, 
               {"g_VX1X_to_XOUT_knowsX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).To(Direction.Out, "knows")}}, 
               {"g_VX1_2_3_4X_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().Has("software", "name", "lop").Drop(), (g,p) =>g.V(p["vid1"], p["vid2"], p["vid3"], p["vid4"])}}, 
               {"g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").V().HasLabel("software").Values<object>("name")}}, 
               {"g_V_hasLabelXloopsX_bothEXselfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("loops").BothE("self")}}, 
               {"g_V_hasLabelXloopsX_bothXselfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("loops").Both("self")}}, 
               {"g_injectX1X_VXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).V(null)}}, 
               {"g_injectX1X_VX1_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1).V(p["vid1"], null)}}, 
               {"g_VX1X_V_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).V().Values<object>("name")}}, 
               {"g_V_outXknowsX_V_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("knows").V().Values<object>("name")}}, 
               {"g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("artist", "name", "Garcia").In("sungBy").As("song").V().Has("artist", "name", "Willie_Dixon").In("writtenBy").Where(P.Eq("song")).Values<object>("name")}}, 
               {"g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "marko").Property("age", 29).As("marko").AddV("person").Property("name", "vadas").Property("age", 27).As("vadas").AddV("software").Property("name", "lop").Property("lang", "java").As("lop").AddV("person").Property("name", "josh").Property("age", 32).As("josh").AddV("software").Property("name", "ripple").Property("lang", "java").As("ripple").AddV("person").Property("name", "peter").Property("age", 35).As("peter").AddE("knows").From("marko").To("vadas").Property("weight", 0.5d).AddE("knows").From("marko").To("josh").Property("weight", 1.0d).AddE("created").From("marko").To("lop").Property("weight", 0.4d).AddE("created").From("josh").To("ripple").Property("weight", 1.0d).AddE("created").From("josh").To("lop").Property("weight", 0.4d).AddE("created").From("peter").To("lop").Property("weight", 0.2d), (g,p) =>g.V().HasLabel("person").As("p").V(p["xx1"]).AddE("uses").From("p"), (g,p) =>g.E().HasLabel("uses"), (g,p) =>g.V(p["vid1"]).OutE("uses"), (g,p) =>g.V(p["vid2"]).OutE("uses"), (g,p) =>g.V(p["vid3"]).InE("uses"), (g,p) =>g.V(p["vid4"]).OutE("uses"), (g,p) =>g.V(p["vid5"]).InE("uses"), (g,p) =>g.V(p["vid6"]).OutE("uses")}}, 
               {"InjectXnullX_eqXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Eq(null))}}, 
               {"InjectXnullX_neqXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Neq(null))}}, 
               {"InjectXnullX_ltXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Lt(null))}}, 
               {"InjectXnullX_lteXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Lte(null))}}, 
               {"InjectXnullX_gtXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Gt(null))}}, 
               {"InjectXnullX_gteXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null).Is(P.Gte(null))}}, 
               {"InjectXNaNX_eqXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Eq(Double.NaN))}}, 
               {"InjectXNaNX_neqXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Neq(Double.NaN))}}, 
               {"InjectXNaNX_ltXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Lt(Double.NaN))}}, 
               {"InjectXNaNX_lteXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Lte(Double.NaN))}}, 
               {"InjectXNaNX_gtXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Gt(Double.NaN))}}, 
               {"InjectXNaNX_gteXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Gte(Double.NaN))}}, 
               {"InjectX1dX_eqXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Eq(Double.NaN))}}, 
               {"InjectX1dX_neqXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Neq(Double.NaN))}}, 
               {"InjectX1dX_ltXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Lt(Double.NaN))}}, 
               {"InjectX1dX_lteXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Lte(Double.NaN))}}, 
               {"InjectX1dX_gtXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Gt(Double.NaN))}}, 
               {"InjectX1dX_gteXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Gte(Double.NaN))}}, 
               {"InjectXNaNX_eqXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Eq(null))}}, 
               {"InjectXNaNX_neqXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Neq(null))}}, 
               {"InjectXNaNX_ltXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Lt(null))}}, 
               {"InjectXNaNX_lteXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Lte(null))}}, 
               {"InjectXNaNX_gtXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Gt(null))}}, 
               {"InjectXNaNX_gteXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NaN).Is(P.Gte(null))}}, 
               {"InjectXfooX_eqX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Eq(1.0d))}}, 
               {"InjectXfooX_neqX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Neq(1.0d))}}, 
               {"InjectXfooX_ltX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Lt(1.0d))}}, 
               {"InjectXfooX_lteX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Lte(1.0d))}}, 
               {"InjectXfooX_gtX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Gt(1.0d))}}, 
               {"InjectXfooX_gteX1dX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("foo").Is(P.Gte(1.0d))}}, 
               {"InjectX1dX_eqXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Eq("foo"))}}, 
               {"InjectX1dX_neqXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Neq("foo"))}}, 
               {"InjectX1dX_ltXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Lt("foo"))}}, 
               {"InjectX1dX_lteXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Lte("foo"))}}, 
               {"InjectX1dX_gtXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Gt("foo"))}}, 
               {"InjectX1dX_gteXfooX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1.0d).Is(P.Gte("foo"))}}, 
               {"InjectX1dX_andXtrue_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Eq(1)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXtrue_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).And(P.Gt(0)))}}, 
               {"InjectX1dX_andXtrue_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Eq(1)), __.Is(P.Lt(0)))}}, 
               {"InjectX1dX_isXtrue_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).And(P.Lt(0)))}}, 
               {"InjectX1dX_andXtrue_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Eq(1)), __.Is(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_isXtrue_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).And(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_andXfalse_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Neq(1)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXfalse_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).And(P.Gt(0)))}}, 
               {"InjectX1dX_andXfalse_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Neq(1)), __.Is(P.Lt(0)))}}, 
               {"InjectX1dX_isXfalse_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).And(P.Lt(0)))}}, 
               {"InjectX1dX_andXfalse_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Neq(1)), __.Is(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_isXfalse_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).And(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_andXerror_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXerror_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).And(P.Gt(0)))}}, 
               {"InjectX1dX_andXerror_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(2)))}}, 
               {"InjectX1dX_isXerror_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).And(P.Gt(2)))}}, 
               {"InjectX1dX_andXerror_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).And(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(Double.NaN)))}}, 
               {"InjectX1dX_isXerror_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).And(P.Gt(Double.NaN)))}}, 
               {"InjectX1dX_orXtrue_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Eq(1)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXtrue_or_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).Or(P.Gt(0)))}}, 
               {"InjectX1dX_orXtrue_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Eq(1)), __.Is(P.Lt(0)))}}, 
               {"InjectX1dX_isXtrue_or_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).Or(P.Lt(0)))}}, 
               {"InjectX1dX_orXtrue_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Eq(1)), __.Is(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_isXtrue_or_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Eq(1).Or(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_orXfalse_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Neq(1)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXfalse_or_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).Or(P.Gt(0)))}}, 
               {"InjectX1dX_orXfalse_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Neq(1)), __.Is(P.Lt(0)))}}, 
               {"InjectX1dX_isXfalse_or_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).Or(P.Lt(0)))}}, 
               {"InjectX1dX_orXfalse_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Neq(1)), __.Is(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_isXfalse_or_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Neq(1).Or(P.Lt(Double.NaN)))}}, 
               {"InjectX1dX_orXerror_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(0)))}}, 
               {"InjectX1dX_isXerror_or_trueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).Or(P.Gt(0)))}}, 
               {"InjectX1dX_orXerror_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(2)))}}, 
               {"InjectX1dX_isXerror_or_falseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).Or(P.Gt(2)))}}, 
               {"InjectX1dX_orXerror_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Or(__.Is(P.Lt(Double.NaN)), __.Is(P.Gt(Double.NaN)))}}, 
               {"InjectX1dX_isXerror_or_errorX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Is(P.Lt(Double.NaN).Or(P.Gt(Double.NaN)))}}, 
               {"InjectX1dX_notXtrueX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Not(__.Is(P.Gt(0)))}}, 
               {"InjectX1dX_notXfalseX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Not(__.Is(P.Lt(0)))}}, 
               {"InjectX1dX_notXNaNX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Not(__.Is(P.Gt(Double.NaN)))}}, 
               {"InjectX1dX_notXisXeqXNaNXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1d).Not(__.Is(P.Eq(Double.NaN)))}}, 
               {"InjectXInfX_eqXInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.PositiveInfinity).Is(P.Eq(Double.PositiveInfinity))}}, 
               {"InjectXInfX_neqXInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.PositiveInfinity).Is(P.Neq(Double.PositiveInfinity))}}, 
               {"InjectXNegInfX_eqXNegInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NegativeInfinity).Is(P.Eq(Double.NegativeInfinity))}}, 
               {"InjectXNegInfX_neqXNegInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NegativeInfinity).Is(P.Neq(Double.NegativeInfinity))}}, 
               {"InjectXInfX_gtXNegInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.PositiveInfinity).Is(P.Gt(Double.NegativeInfinity))}}, 
               {"InjectXInfX_ltXNegInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.PositiveInfinity).Is(P.Lt(Double.NegativeInfinity))}}, 
               {"InjectXNegInfX_ltXInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NegativeInfinity).Is(P.Lt(Double.PositiveInfinity))}}, 
               {"InjectXNegInfX_gtXInfX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(Double.NegativeInfinity).Is(P.Gt(Double.PositiveInfinity))}}, 
               {"Primitives_Number_eqXbyteX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXshortX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXintX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXlongX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXbigintX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXfloatX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXdoubleX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"Primitives_Number_eqXbigdecimalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { (sbyte) 1, (short) 1, 1, 1l, 1f, 1d, 1000, (decimal) 1, BigInteger.Parse("1") }).Unfold<object>().Where(__.Is(p["xx1"]))}}, 
               {"g_V_values_order", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>().Order()}}, 
               {"g_V_properties_order", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().Order()}}, 
               {"g_V_properties_order_id", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Properties<object>().Order().Id()}}, 
               {"g_E_properties_order_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").As("a").AddE("self").From("a").To("a").Property("weight", 0.5d).Property("a", 10).AddE("self").From("a").To("a").Property("weight", 1.0d).Property("a", 11).AddE("self").From("a").To("a").Property("weight", 0.4d).Property("a", 12).AddE("self").From("a").To("a").Property("weight", 1.0d).Property("a", 13).AddE("self").From("a").To("a").Property("weight", 0.4d).Property("a", 14).AddE("self").From("a").To("a").Property("weight", 0.2d).Property("a", 15), (g,p) =>g.E().Properties<object>().Order().Value<object>()}}, 
               {"g_E_properties_order_byXdescX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("name", "alice").As("a").AddE("self").From("a").To("a").Property("weight", 0.5d).Property("a", 10).AddE("self").From("a").To("a").Property("weight", 1.0d).Property("a", 11).AddE("self").From("a").To("a").Property("weight", 0.4d).Property("a", 12).AddE("self").From("a").To("a").Property("weight", 1.0d).Property("a", 13).AddE("self").From("a").To("a").Property("weight", 0.4d).Property("a", 14).AddE("self").From("a").To("a").Property("weight", 0.2d).Property("a", 15), (g,p) =>g.E().Properties<object>().Order().By(Order.Desc).Value<object>()}}, 
               {"g_inject_order", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("zzz", "foo", new List<object> { "a", "b", "c", "d" }, 1, new List<object> { "a", "b", "c" }, new Dictionary<object, object> {{ "a", "a" }, { "b", "b" }}, null, 2.0d, new Dictionary<object, object> {{ "a", "a" }, { "b", false }, { "c", "c" }}, "bar", true, false, Double.PositiveInfinity, Double.NaN, Double.NegativeInfinity).Order()}}, 
               {"g_inject_order_byXdescX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>("zzz", "foo", new List<object> { "a", "b", "c", "d" }, 1, new List<object> { "a", "b", "c" }, new Dictionary<object, object> {{ "a", "a" }, { "b", "b" }}, null, 2.0d, new Dictionary<object, object> {{ "a", "a" }, { "b", false }, { "c", "c" }}, "bar", true, false, Double.PositiveInfinity, Double.NaN, Double.NegativeInfinity).Order().By(Order.Desc)}}, 
               {"g_V_out_out_order_byXascX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Order().By(Order.Asc)}}, 
               {"g_V_out_out_order_byXdescX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Order().By(Order.Desc)}}, 
               {"g_V_out_out_asXheadX_path_order_byXascX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().As("head").Path().Order().By(Order.Asc).Select<object>("head")}}, 
               {"g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().As("head").Path().Order().By(Order.Desc).Select<object>("head")}}, 
               {"g_V_out_outE_order_byXascX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().OutE().Order().By(Order.Asc)}}, 
               {"g_V_out_outE_order_byXdescX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().OutE().Order().By(Order.Desc)}}, 
               {"g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().OutE().As("head").Path().Order().By(Order.Asc).Select<object>("head")}}, 
               {"g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().OutE().As("head").Path().Order().By(Order.Desc).Select<object>("head")}}, 
               {"g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Properties<object>().As("head").Path().Order().By(Order.Asc).Select<object>("head").Value<object>()}}, 
               {"g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Properties<object>().As("head").Path().Order().By(Order.Desc).Select<object>("head").Value<object>()}}, 
               {"g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Values<object>().As("head").Path().Order().By(Order.Asc).Select<object>("head")}}, 
               {"g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Values<object>().As("head").Path().Order().By(Order.Desc).Select<object>("head")}}, 
               {"g_V_valueXnameX_aggregateXxX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Values<object>("name").Aggregate("x").Cap<object>("x")}}, 
               {"g_V_aggregateXxX_byXnameX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("x").By("name").Cap<object>("x")}}, 
               {"g_V_out_aggregateXaX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Aggregate("a").Path()}}, 
               {"g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Aggregate("x").By("age").Cap<object>("x").As("y").Select<object>("y")}}, 
               {"g_V_aggregateXxX_byXageX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("x").By("age").Cap<object>("x")}}, 
               {"g_V_localXaggregateXxX_byXageXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("x").By("age")).Cap<object>("x")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_localXaggregateXxX_byXageXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Local<object>(__.Aggregate("x").By("age")).Cap<object>("x")}}, 
               {"g_V_localX_aggregateXa_byXnameXX_out_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a").By("name")).Out().Cap<object>("a")}}, 
               {"g_VX1X_localXaggregateXaX_byXnameXX_out_localXaggregateXaX_byXnameXX_name_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Local<object>(__.Aggregate("a").By("name")).Out().Local<object>(__.Aggregate("a").By("name")).Values<object>("name").Cap<object>("a")}}, 
               {"g_withSideEffectXa_setX_V_both_name_localXaggregateX_aXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Values<object>("name").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_set_inlineX_V_both_name_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new HashSet<object> { "alice" }).V().Both().Values<object>("name").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_localXaggregateXaX_byXoutEXcreatedX_countXX_out_out_localXaggregateXaX_byXinEXcreatedX_weight_sumXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a").By(__.OutE("created").Count())).Out().Out().Local<object>(__.Aggregate("a").By(__.InE("created").Values<object>("weight").Sum<object>())).Cap<object>("a")}}, 
               {"g_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("x").By(__.Values<object>("age").Is(P.Gt(29))).Cap<object>("x")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("x").By(__.Values<object>("age").Is(P.Gt(29))).Cap<object>("x")}}, 
               {"g_V_aggregateXxX_byXout_order_byXnameXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("x").By(__.Out().Order().By("name")).Cap<object>("x")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXout_order_byXnameXX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Aggregate("x").By(__.Out().Order().By("name")).Cap<object>("x")}}, 
               {"g_V_aggregateXaX_hasXperson_age_gteX30XXX_capXaX_unfold_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Aggregate("a").Has("person", "age", P.Gte(30)).Cap<object>("a").Unfold<object>().Values<object>("name")}}, 
               {"g_withSideEffectXa_1_sumX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Sum).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_sumX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Sum).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_123_minusX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 123, Operator.Minus).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_123_minusX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 123, Operator.Minus).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_2_multX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 2, Operator.Mult).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_2_multX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 2, Operator.Mult).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_876960_divX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 876960, Operator.Div).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_876960_divX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 876960, Operator.Div).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_minX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Min).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_minX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Min).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_100_minX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 100, Operator.Min).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_100_minX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 100, Operator.Min).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_maxX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Max).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_maxX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 1, Operator.Max).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_100_maxX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 100, Operator.Max).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_100_maxX_V_localXaggregateX_aX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", 100, Operator.Max).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_true_andX_V_constantXfalseX_aggregateXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", true, Operator.And).V().Constant<object>(false).Aggregate("a").Cap<object>("a")}}, 
               {"g_withSideEffectXa_true_andX_V_constantXfalseX_localXaggregateX_aXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", true, Operator.And).V().Constant<object>(false).Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_true_orX_V_constantXfalseX_aggregateXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", true, Operator.Or).V().Constant<object>(false).Aggregate("a").Cap<object>("a")}}, 
               {"g_withSideEffectXa_true_orX_V_constantXfalseX_localXaggregateX_aXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", true, Operator.Or).V().Constant<object>(false).Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_2_3_addAllX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new List<object> { 1, 2, 3 }, Operator.AddAll).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_2_3_addAllX_V_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new List<object> { 1, 2, 3 }, Operator.AddAll).V().Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_2_3_assignX_V_aggregateXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new List<object> { 1, 2, 3 }, Operator.Assign).V().Aggregate("a").By("age").Cap<object>("a")}}, 
               {"g_withSideEffectXa_1_2_3_assignX_V_order_byXageX_localXaggregateX_aX_byXageXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("a", new List<object> { 1, 2, 3 }, Operator.Assign).V().Order().By("age").Local<object>(__.Aggregate("a").By("age")).Cap<object>("a")}}, 
               {"g_V_localXaggregateXa_nameXX_out_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a").By("name")).Out().Cap<object>("a")}}, 
               {"g_withSideEffectXa_setX_V_both_name_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Values<object>("name").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX_unfold_dedup", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a")).OutE().InV().Local<object>(__.Aggregate("a")).Cap<object>("a").Unfold<object>().Dedup()}}, 
               {"g_V_hasLabelXpersonX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Local<object>(__.Aggregate("a")).Out("created").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_localXaggregateXaXX_repeatXout_localXaggregateXaXXX_timesX2X_capXaX_unfold_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a")).Repeat(__.Out().Local<object>(__.Aggregate("a"))).Times(2).Cap<object>("a").Unfold<object>().Values<object>("name").GroupCount<object>()}}, 
               {"g_V_hasXname_markoX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "marko").Local<object>(__.Aggregate("a")).Out("knows").Local<object>(__.Aggregate("a")).Out("created").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_hasLabelXsoftwareX_localXaggregateXaXX_inXcreatedX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("software").Local<object>(__.Aggregate("a")).In("created").Local<object>(__.Aggregate("a")).Out("knows").Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_localXaggregateXaXX_outE_hasXweight_lgtX0_5XX_inV_localXaggregateXaXX_capXaX_unfold_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a")).OutE().Has("weight", P.Gt(0.5)).InV().Local<object>(__.Aggregate("a")).Cap<object>("a").Unfold<object>().Path()}}, 
               {"g_V_localXaggregateXaXX_bothE_sampleX1X_otherV_localXaggregateXaXX_capXaX_unfold_groupCount_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a")).BothE().Sample(1).OtherV().Local<object>(__.Aggregate("a")).Cap<object>("a").Unfold<object>().GroupCount<object>().By(T.Label)}}, 
               {"g_V_hasLabelXpersonX_localXaggregateXaXX_outE_inV_simplePath_localXaggregateXaXX_capXaX_unfold_hasLabelXsoftwareX_count", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Local<object>(__.Aggregate("a")).OutE().InV().SimplePath().Local<object>(__.Aggregate("a")).Cap<object>("a").Unfold<object>().HasLabel("software").Count()}}, 
               {"g_V_localXaggregateXaXX_unionXout_inX_localXaggregateXaXX_capXaX_unfold_dedup_valuesXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Aggregate("a")).Union<object>(__.Out(), __.In()).Local<object>(__.Aggregate("a")).Cap<object>("a").Unfold<object>().Dedup().Values<object>("name")}}, 
               {"g_V_hasXname_joshX_localXaggregateXaXX_outE_hasXweight_ltX1_0XX_inV_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("name", "josh").Local<object>(__.Aggregate("a")).OutE().Has("weight", P.Lt(1.0)).InV().Local<object>(__.Aggregate("a")).OutE().InV().Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_hasLabelXpersonX_localXaggregateXaXX_outE_order_byXweightX_limitX1X_inV_localXaggregateXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").Local<object>(__.Aggregate("a")).OutE().Order().By("weight").Limit<object>(1).InV().Local<object>(__.Aggregate("a")).Cap<object>("a")}}, 
               {"g_V_fail", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fail()}}, 
               {"g_V_failXmsgX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Fail("msg")}}, 
               {"g_V_unionXout_failX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.Out(), __.Fail())}}, 
               {"g_V_group_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By("name")}}, 
               {"g_V_group_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By("age")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_group_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().Group<object, object>().By("age")}}, 
               {"g_V_group_byXnameX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By("name").By("age")}}, 
               {"g_V_group_byXnameX_by", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By("name").By()}}, 
               {"g_V_hasXlangX_group_byXlangX_byXcountX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("lang").Group<object, object>().By("lang").By(__.Count())}}, 
               {"g_V_group_byXoutE_countX_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Order().By("name").Group<object, object>().By(__.OutE().Count()).By("name")}}, 
               {"g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both("followedBy")).Times(2).Group<object, object>().By("songType").By(__.Count())}}, 
               {"g_V_group_byXvaluesXnameX_substringX1XX_byXconstantX1XX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(__.Values<object>("name").Substring(0, 1)).By(__.Constant<object>(1))}}, 
               {"g_V_out_group_byXlabelX_selectXpersonX_unfold_outXcreatedX_name_limitX2X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Group<object, object>().By(T.Label).Select<object>("person").Unfold<object>().Out("created").Values<object>("name").Limit<object>(2)}}, 
               {"g_V_hasLabelXsongX_group_byXnameX_byXproperties_groupCount_byXlabelXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("song").Group<object, object>().By("name").By(__.Properties<object>().GroupCount<object>().By(T.Label))}}, 
               {"g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("followedBy").Group<object, object>().By("songType").By(__.BothE().Group<object, object>().By(T.Label).By(__.Values<object>("weight").Sum<object>()))}}, 
               {"g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(T.Label).By(__.BothE().Group("a").By(T.Label).By(__.Values<object>("weight").Sum<object>()).Values<object>("weight").Sum<object>())}}, 
               {"g_V_hasLabelXpersonX_asXpX_outXcreatedX_group_byXnameX_byXselectXpX_valuesXageX_sumX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("p").Out("created").Group<object, object>().By("name").By(__.Select<object>("p").Values<object>("age").Sum<object>())}}, 
               {"g_V_group_byXlabelX_byXlabel_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(__.Label()).By(__.Label().Count())}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group<object, object>().By().By(__.Out().Order().Fold())}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group<object, object>().By().By(__.Out().Fold())}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_orderX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group<object, object>().By().By(__.Out().Order())}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group<object, object>().By().By(__.Out().Order().Count())}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_fold_countXlocalXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group<object, object>().By().By(__.Out().Order().Fold().Count(Scope.Local))}}, 
               {"g_V_group_by_byXout_label_foldX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By().By(__.Out().Label().Fold()).Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_group_by_byXout_label_dedup_foldX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By().By(__.Out().Label().Dedup().Fold()).Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_group_by_byXout_label_limitX0X_foldX_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By().By(__.Out().Label().Limit<object>(0).Fold()).Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_V_group_by_byXout_label_limitX10X_foldX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By().By(__.Out().Label().Limit<object>(10).Fold()).Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_group_by_byXout_label_tailX10X_foldX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By().By(__.Out().Label().Tail<object>(10).Fold()).Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_groupXaX_byXnameX_by_selectXaX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By("name").By().Select<object>("a").Count(Scope.Local)}}, 
               {"g_V_localXgroupXaX_byXnameX_by_selectXaX_countXlocalXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.Group("a").By("name").By().Select<object>("a").Count(Scope.Local))}}, 
               {"g_V_group_byXvaluesXnameXX_byXboth_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(__.Values<object>("name")).By(__.Both().Count())}}, 
               {"g_V_outXcreatedX_groupCount_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").GroupCount<object>().By("name")}}, 
               {"g_V_groupCount_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().GroupCount<object>().By("age")}}, 
               {"g_withStrategiesXProductiveByStrategyX_V_groupCount_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithStrategies(new ProductiveByStrategy()).V().GroupCount<object>().By("age")}}, 
               {"g_V_outXcreatedX_name_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Values<object>("name").GroupCount<object>()}}, 
               {"g_V_outXcreatedX_groupCountXaX_byXnameX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").GroupCount("a").By("name").Cap<object>("a")}}, 
               {"g_V_outXcreatedX_name_groupCountXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").Values<object>("name").GroupCount("a").Cap<object>("a")}}, 
               {"g_V_repeatXout_groupCountXaX_byXnameXX_timesX2X_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out().GroupCount("a").By("name")).Times(2).Cap<object>("a")}}, 
               {"g_V_both_groupCountXaX_byXlabelX_asXbX_barrier_whereXselectXaX_selectXsoftwareX_isXgtX2XXX_selectXbX_name", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().GroupCount("a").By(T.Label).As("b").Barrier().Where(__.Select<object>("a").Select<object>("software").Is(P.Gt(2))).Select<object>("b").Values<object>("name")}}, 
               {"g_V_unionXoutXknowsX__outXcreatedX_inXcreatedXX_groupCount_selectXvaluesX_unfold_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.Out("knows"), __.Out("created").In("created")).GroupCount<object>().Select<object>(Column.Values).Unfold<object>().Sum<object>()}}, 
               {"g_V_hasXnoX_groupCount", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("no").GroupCount<object>()}}, 
               {"g_V_hasXnoX_groupCountXaX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("no").GroupCount("a").Cap<object>("a")}}, 
               {"g_V_unionXrepeatXoutX_timesX2X_groupCountXmX_byXlangXX__repeatXinX_timesX2X_groupCountXmX_byXnameXX_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Union<object>(__.Repeat(__.Out()).Times(2).GroupCount("m").By("lang"), __.Repeat(__.In()).Times(2).GroupCount("m").By("name")).Cap<object>("m")}}, 
               {"g_V_outXcreatedX_groupCountXxX_capXxX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").GroupCount("x").Cap<object>("x")}}, 
               {"g_V_groupCount_byXbothE_countX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().GroupCount<object>().By(__.BothE().Count())}}, 
               {"g_V_both_localXgroupCountXaXX_out_capXaX_selectXkeysX_unfold_both_localXgroupCountXaXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Both().Local<object>(__.GroupCount("a")).Out().Cap<object>("a").Select<object>(Column.Keys).Unfold<object>().Both().Local<object>(__.GroupCount("a")).Cap<object>("a")}}, 
               {"g_V_hasXperson_name_markoX_bothXknowsX_groupCount_byXvaluesXnameX_foldX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", "marko").Both("knows").GroupCount<object>().By(__.Values<object>("name").Fold())}}, 
               {"g_V_outXcreatedX_groupCount_byXnameX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").GroupCount<object>().By("name").By("age")}}, 
               {"g_V_outXcreatedX_groupCountXxX_byXnameX_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out("created").GroupCount("x").By("name").By("age")}}, 
               {"g_V_groupCountXaX_selectXaX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().GroupCount("a").Select<object>("a").Count(Scope.Local)}}, 
               {"g_V_localXgroupCountXaX_selectXaX_countXlocalXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Local<object>(__.GroupCount("a").Select<object>("a").Count(Scope.Local))}}, 
               {"g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Values<object>("name").Inject("daniel").As("a").Map<object>(__.Length()).Path()}}, 
               {"g_injectXnull_1_3_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, 1, 3, null)}}, 
               {"g_injectX10_20_null_20_10_10X_groupCountXxX_dedup_asXyX_projectXa_bX_by_byXselectXxX_selectXselectXyXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(10, 20, null, 20, 10, 10).GroupCount("x").Dedup().As("y").Project<object>("a", "b").By().By(__.Select<object>("x").Select<object>(__.Select<object>("y")))}}, 
               {"g_injectXname_marko_age_nullX_selectXname_ageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new Dictionary<object, object> {{ "name", "marko" }, { "age", null }}).Select<object>("name", "age")}}, 
               {"g_injectXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, null)}}, 
               {"g_injectXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null)}}, 
               {"g_inject", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>()}}, 
               {"g_VX1X_valuesXageX_injectXnull_nullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"]).Values<object>("age").Inject(null, null)}}, 
               {"g_VX1X_valuesXageX_injectXnullX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"]).Values<object>("age").Inject(null)}}, 
               {"g_VX1X_valuesXageX_inject", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["xx1"]).Values<object>("age").Inject()}}, 
               {"g_injectXnull_1_3_nullX_asXaX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(null, 1, 3, null).As("a").Select<object>("a")}}, 
               {"g_injectX1_3X_injectX100_300X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(1, 3).Inject(100, 300)}}, 
               {"g_injectX1_3_100_300X_list", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new List<object> { 1, 3, 100, 300 })}}, 
               {"g_injectX1_3_100_300X_set", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new HashSet<object> { 1, 3, 100, 300 })}}, 
               {"g_injectX1_1X_set", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Inject<object>(new HashSet<object> { 1, 1 })}}, 
               {"g_io_readXkryoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.kryo").Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_io_read_withXreader_gryoX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.kryo").With(IO.Reader, IO.Gryo).Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_io_readXgraphsonX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.json").Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_io_read_withXreader_graphsonX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.json").With(IO.Reader, IO.GraphSON).Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_io_readXgraphmlX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.xml").Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_io_read_withXreader_graphmlX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.Io<object>("data/tinkerpop-modern.xml").With(IO.Reader, IO.GraphML).Read(), (g,p) =>g.V(), (g,p) =>g.E()}}, 
               {"g_withSackX127bX_injectX1bX_sackXsumX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((sbyte) 127).Inject<object>((sbyte) 1).Sack(Operator.Sum).Sack<object>()}}, 
               {"g_withSackX32767sX_injectX1sX_sackXsumX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) 32767).Inject<object>((short) 1).Sack(Operator.Sum).Sack<object>()}}, 
               {"g_withSackX2147483647iX_injectX1iX_sackXsumX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(2147483647).Inject<object>(1).Sack(Operator.Sum).Sack<object>()}}, 
               {"g_withSackX1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXsumX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(1.7976931348623157e+308d).Inject<object>(1.7976931348623157e+308d).Sack(Operator.Sum).Sack<object>()}}, 
               {"g_withSackX_128bX_injectX1bX_sackXminusX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) -128).Inject<object>((short) 1).Sack(Operator.Minus).Sack<object>()}}, 
               {"g_withSackX_32768sX_injectX1sX_sackXminusX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) -32768).Inject<object>((short) 1).Sack(Operator.Minus).Sack<object>()}}, 
               {"g_withSackX_2147483648iX_injectX1iX_sackXminusX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(-2147483648).Inject<object>(1).Sack(Operator.Minus).Sack<object>()}}, 
               {"g_withSackX_1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXminusX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(-1.7976931348623157e+308d).Inject<object>(1.7976931348623157e+308d).Sack(Operator.Minus).Sack<object>()}}, 
               {"g_withSackX127bX_injectX2bX_sackXmultX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((sbyte) 127).Inject<object>((sbyte) 2).Sack(Operator.Mult).Sack<object>()}}, 
               {"g_withSackX32767sX_injectX2sX_sackXmultX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) 32767).Inject<object>((short) 2).Sack(Operator.Mult).Sack<object>()}}, 
               {"g_withSackX2147483647iX_injectX2iX_sackXmultX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(2147483647).Inject<object>(2).Sack(Operator.Mult).Sack<object>()}}, 
               {"g_withSackX1_7976931348623157E_308dX_injectX2dX_sackXmultX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(1.7976931348623157e+308d).Inject<object>(2d).Sack(Operator.Mult).Sack<object>()}}, 
               {"g_withSackX127bX_injectX0_5fX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((sbyte) 127).Inject<object>(0.5f).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX32767sX_injectX0_5fX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) 32767).Inject<object>(0.5f).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX2147483647iX_injectX0_5fX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(2147483647).Inject<object>(0.5f).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX1_7976931348623157E_308dX_injectX0_5dX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(1.7976931348623157e+308d).Inject<object>(0.5d).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX_128bX_injectX_1bX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) -128).Inject<object>((short) -1).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX_32768sX_injectX_1sX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack((short) -32768).Inject<object>((short) -1).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackX_2147483648iX_injectX_1iX_sackXdivX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(-2147483648).Inject<object>(-1).Sack(Operator.Div).Sack<object>()}}, 
               {"g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack("hello").V().OutE().Sack(Operator.Assign).By(T.Label).InV().Sack<object>()}}, 
               {"g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(0.0d).V().OutE().Sack(Operator.Sum).By("weight").InV().Sack<object>().Sum<object>()}}, 
               {"g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(0.0d).V().Repeat(__.OutE().Sack(Operator.Sum).By("weight").InV()).Times(2).Sack<object>()}}, 
               {"g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithBulk(false).WithSack(1.0d, Operator.Sum).V(p["vid1"]).Local<object>(__.OutE("knows").Barrier(Barrier.NormSack).InV()).In("knows").Barrier().Sack<object>()}}, 
               {"g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithBulk(false).WithSack(1, Operator.Sum).V().Out().Barrier().Sack<object>()}}, 
               {"g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(1.0d, Operator.Sum).V(p["vid1"]).Local<object>(__.Out("knows").Barrier(Barrier.NormSack)).In("knows").Barrier().Sack<object>()}}, 
               {"g_V_sackXassignX_byXageX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sack(Operator.Assign).By("age").Sack<object>()}}, 
               {"g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(BigInteger.Parse("10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"), Operator.Assign).V().Local<object>(__.Out("knows").Barrier(Barrier.NormSack)).In("knows").Barrier().Sack<object>()}}, 
               {"g_withSackX2X_V_sackXdivX_byXconstantX4_0XX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSack(2).V().Sack(Operator.Div).By(__.Constant<object>(4.0d)).Sack<object>()}}, 
               {"g_V_sackXassignX_byXageX_byXnameX_sack", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Sack(Operator.Assign).By("age").By("name").Sack<object>()}}, 
               {"g_V_sideEffectXidentityX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().SideEffect(__.Identity())}}, 
               {"g_V_sideEffectXidentity_valuesXnameXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().SideEffect(__.Identity().Values<object>("name"))}}, 
               {"g_V_sideEffectXpropertyXage_22X", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.AddV("person").Property("age", 21), (g,p) =>g.V().SideEffect(__.Property("age", 22)), (g,p) =>g.V().Has("age", 21), (g,p) =>g.V().Has("age", 22)}}, 
               {"g_V_group_byXvaluesXnameX_sideEffectXconstantXzyxXX_substringX1XX_byXconstantX1X_sideEffectXconstantXxyzXXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group<object, object>().By(__.Values<object>("name").SideEffect(__.Constant<object>("zyx")).Substring(0, 1)).By(__.Constant<object>(1).SideEffect(__.Constant<object>("xyz")))}}, 
               {"g_withSideEffectXx_setX_V_both_both_sideEffectXlocalXaggregateXxX_byXnameXX_capXxX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.WithSideEffect("x", new HashSet<object> {  }).V().Both().Both().SideEffect(__.Local<object>(__.Aggregate("x").By("name"))).Cap<object>("x").Unfold<object>()}}, 
               {"g_V_hasXageX_groupCountXaX_byXnameX_out_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("age").GroupCount("a").By("name").Out().Cap<object>("a")}}, 
               {"g_V_groupXaX_byXageX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By("age").Cap<object>("a")}}, 
               {"g_V_groupXaX_byXnameX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By("name").Cap<object>("a")}}, 
               {"g_V_hasXlangX_groupXaX_byXlangX_byXnameX_out_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("lang").Group("a").By("lang").By("name").Out().Cap<object>("a")}}, 
               {"g_V_repeatXout_groupXaX_byXnameX_byXcountX_timesX2X_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Out().Group("a").By("name").By(__.Count())).Times(2).Cap<object>("a")}}, 
               {"g_V_groupXaX_byXlabelX_byXoutE_weight_sumX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By(T.Label).By(__.OutE().Values<object>("weight").Sum<object>()).Cap<object>("a")}}, 
               {"g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.Both("followedBy")).Times(2).Group("a").By("songType").By(__.Count()).Cap<object>("a")}}, 
               {"g_V_groupXaX_byXvaluesXnameX_substringX1XX_byXconstantX1XX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By(__.Values<object>("name").Substring(0, 1)).By(__.Constant<object>(1)).Cap<object>("a")}}, 
               {"g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("song").Group("a").By("name").By(__.Properties<object>().GroupCount<object>().By(T.Label)).Out().Cap<object>("a")}}, 
               {"g_V_hasLabelXpersonX_asXpX_outXcreatedX_groupXaX_byXnameX_byXselectXpX_valuesXageX_sumX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().HasLabel("person").As("p").Out("created").Group("a").By("name").By(__.Select<object>("p").Values<object>("age").Sum<object>()).Cap<object>("a")}}, 
               {"g_V_groupXmX_byXnameX_byXinXknowsX_nameX_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("m").By("name").By(__.In("knows").Values<object>("name")).Cap<object>("m")}}, 
               {"g_V_groupXmX_byXlabelX_byXlabel_countX_capXmX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("m").By(__.Label()).By(__.Label().Count()).Cap<object>("m")}}, 
               {"g_V_chooseXlabel_person__age_groupCountXaX__name_groupCountXbXX_capXa_bX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Choose<object>(__.Has(T.Label, "person"), __.Values<object>("age").GroupCount("a"), __.Values<object>("name").GroupCount("b")).Cap<object>("a", "b").Unfold<object>()}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_orderX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group("a").By().By(__.Out().Order()).Cap<object>("a")}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_countX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group("a").By().By(__.Out().Order().Count()).Cap<object>("a")}}, 
               {"g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_fold_countXlocalXX_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Has("person", "name", P.Within("vadas", "peter")).Group("a").By().By(__.Out().Order().Fold().Count(Scope.Local)).Cap<object>("a")}}, 
               {"g_V_groupXaX_by_byXout_label_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By().By(__.Out().Label().Fold()).Cap<object>("a").Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_groupXaX_by_byXout_label_dedup_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By().By(__.Out().Label().Dedup().Fold()).Cap<object>("a").Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_groupXaX_by_byXout_label_limitX0X_foldX_capXaX_selectXvaluesX_unfold", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By().By(__.Out().Label().Limit<object>(0).Fold()).Cap<object>("a").Select<object>(Column.Values).Unfold<object>()}}, 
               {"g_V_groupXaX_by_byXout_label_limitX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By().By(__.Out().Label().Limit<object>(10).Fold()).Cap<object>("a").Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_V_groupXaX_by_byXout_label_tailX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Group("a").By().By(__.Out().Label().Tail<object>(10).Fold()).Cap<object>("a").Select<object>(Column.Values).Unfold<object>().Order(Scope.Local)}}, 
               {"g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE("knows").Subgraph("sg").Values<object>("name").Cap<object>("sg")}}, 
               {"g_V_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup_capXsgX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Repeat(__.BothE("created").Subgraph("sg").OutV()).Times(5).Values<object>("name").Dedup().Cap<object>("sg")}}, 
               {"g_V_outEXnoexistX_subgraphXsgXcapXsgX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().OutE("noexist").Subgraph("sg").Cap<object>("sg")}}, 
               {"g_E_hasXweight_0_5X_subgraphXaX_selectXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.E().Has("weight", 0.4).Subgraph("a").Select<object>("a")}}, 
               {"g_VX1X_out_out_tree_byXnameX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree<object>().By("name")}}, 
               {"g_VX1X_out_out_tree", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree<object>()}}, 
               {"g_V_out_tree_byXageX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Tree<object>().By("age")}}, 
               {"g_VX1X_out_out_treeXaX_byXnameX_both_both_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree("a").By("name").Both().Both().Cap<object>("a")}}, 
               {"g_VX1X_out_out_treeXaX_both_both_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree("a").Both().Both().Cap<object>("a")}}, 
               {"g_VX1X_out_out_tree_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree<object>().By(T.Label)}}, 
               {"g_VX1X_out_out_treeXaX_byXlabelX_both_both_capXaX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).Out().Out().Tree("a").By(T.Label).Both().Both().Cap<object>("a")}}, 
               {"g_VX1X_out_out_out_tree", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Out().Out().Tree<object>()}}, 
               {"g_VX1X_outE_inV_bothE_otherV_tree", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().InV().BothE().OtherV().Tree<object>()}}, 
               {"g_VX1X_outE_inV_bothE_otherV_tree_byXnameX_byXlabelX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V(p["vid1"]).OutE().InV().BothE().OtherV().Tree<object>().By("name").By(T.Label)}}, 
               {"g_V_out_treeXaX_selectXaX_countXlocalX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Tree("a").Select<object>("a").Count(Scope.Local)}}, 
               {"g_V_out_order_byXnameX_localXtreeXaX_selectXaX_countXlocalXX", new List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> {(g,p) =>g.V().Out().Local<object>(__.Tree("a").Select<object>("a").Count(Scope.Local))}}, 
            };

        public static ITraversal UseTraversal(string scenarioName, GraphTraversalSource g, IDictionary<string, object> parameters, IDictionary<string, object> sideEffects)
        {
            List<Func<GraphTraversalSource, IDictionary<string, object>, ITraversal>> list = _translationsForTestRun[scenarioName];
            Func<GraphTraversalSource, IDictionary<string, object>, ITraversal> f = list[0];
            list.RemoveAt(0);
            ITraversal traversal = f.Invoke(g, parameters);
            foreach (var sideEffect in sideEffects)
            {
                traversal.Bytecode.AddSource("withSideEffect", sideEffect.Key, sideEffect.Value);
            }
            return traversal;
        }
    }
}

#nullable restore

