/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;

public final class GValueManager
implements Serializable,
Cloneable {
    private final Map<String, GValue<?>> gValueRegistry = new HashMap();
    private final Set<String> pinnedVariables = new HashSet<String>();

    public GValueManager() {
        this(Collections.emptyMap(), Collections.emptySet());
    }

    private GValueManager(Map<String, GValue<?>> gValueRegistry, Set<String> pinnedVariables) {
        this.gValueRegistry.putAll(gValueRegistry);
        this.pinnedVariables.addAll(pinnedVariables);
    }

    public void mergeInto(GValueManager other) {
        other.register(this.gValueRegistry.values());
        other.pinGValues(this.pinnedVariables);
    }

    public Set<String> getVariableNames() {
        return Collections.unmodifiableSet(this.gValueRegistry.keySet());
    }

    public Set<String> getUnpinnedVariableNames() {
        HashSet<String> variableNames = new HashSet<String>(this.gValueRegistry.keySet());
        variableNames.removeAll(this.pinnedVariables);
        return Collections.unmodifiableSet(variableNames);
    }

    public Set<String> getPinnedVariableNames() {
        return Collections.unmodifiableSet(this.pinnedVariables);
    }

    public Set<GValue<?>> getGValues() {
        return Set.copyOf(this.gValueRegistry.values());
    }

    public Set<GValue<?>> getPinnedGValues() {
        return this.pinnedVariables.stream().map(this.gValueRegistry::get).collect(Collectors.toUnmodifiableSet());
    }

    public boolean hasVariables() {
        return !this.gValueRegistry.isEmpty();
    }

    public boolean hasUnpinnedVariables() {
        return !this.getUnpinnedVariableNames().isEmpty();
    }

    public boolean pinVariable(String name) {
        if (name == null) {
            return false;
        }
        if (!this.gValueRegistry.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Unable to pin variable '%s' because it is not registered", name));
        }
        return this.pinnedVariables.add(name);
    }

    public GValueManager clone() {
        HashMap clonedRegistry = new HashMap();
        for (Map.Entry<String, GValue<?>> entry : this.gValueRegistry.entrySet()) {
            clonedRegistry.put(entry.getKey(), (GValue<?>)entry.getValue().clone());
        }
        return new GValueManager(clonedRegistry, new HashSet<String>(this.pinnedVariables));
    }

    public void pinGValues(Set<String> names) {
        names.stream().filter(Objects::nonNull).forEach(this::pinVariable);
    }

    public void pinGValues(Collection<GValue<?>> gValues) {
        this.pinGValues(gValues.stream().filter(v -> v != null && v.isVariable()).map(GValue::getName).collect(Collectors.toSet()));
    }

    public void register(GValue<?> gValue) {
        if (gValue.isVariable()) {
            if (this.gValueRegistry.containsKey(gValue.getName()) && !this.gValueRegistry.get(gValue.getName()).equals(gValue)) {
                throw new IllegalArgumentException(String.format("Unable to register both %s and %s in a single traversal", this.gValueRegistry.get(gValue.getName()), gValue));
            }
            this.gValueRegistry.put(gValue.getName(), gValue);
        }
    }

    public void register(Collection<GValue<?>> gValues) {
        gValues.forEach(this::register);
    }

    public void updateVariable(String name, Object value) {
        if (!this.gValueRegistry.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Unable to update variable '%s' as it has not been registered in this traversal", name));
        }
        if (this.pinnedVariables.contains(name)) {
            throw new IllegalArgumentException(String.format("Unable to update variable '%s' as it is already pinned", name));
        }
        this.gValueRegistry.put(name, GValue.of(name, value));
    }
}

