/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.EnumSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public final class SumGlobalStep<S extends Number>
extends ReducingBarrierStep<S, S> {
    private static final Set<TraverserRequirement> REQUIREMENTS = EnumSet.of(TraverserRequirement.BULK, TraverserRequirement.OBJECT);

    public SumGlobalStep(Traversal.Admin traversal) {
        super(traversal);
        this.setReducingBiOperator(Operator.sum);
    }

    @Override
    protected S generateSeedFromStarts() {
        Object s = null;
        while (this.starts.hasNext() && null == s) {
            s = this.projectTraverser((Traverser.Admin)this.starts.next());
        }
        return (S)s;
    }

    @Override
    public void processAllStarts() {
        if (this.starts.hasNext()) {
            super.processAllStarts();
        }
    }

    @Override
    public S projectTraverser(Traverser.Admin<S> traverser) {
        Number value = (Number)traverser.get();
        long bulk = traverser.bulk();
        Class clazz = null == value ? Long.class : value.getClass();
        return (S)NumberHelper.mul(value, NumberHelper.coerceTo(bulk, clazz));
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return REQUIREMENTS;
    }
}

