/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.util.DefaultCloseableIterator;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    public static <T> CloseableIterator<T> of(Iterator<T> iterator) {
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new DefaultCloseableIterator<T>(iterator);
    }

    @Override
    default public void close() {
    }

    public static <T> void closeIterator(Iterator<T> iterator) {
        if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> CloseableIterator<T> empty() {
        return EmptyCloseableIterator.instance();
    }

    public static class EmptyCloseableIterator<T>
    extends DefaultCloseableIterator<T> {
        private static final EmptyCloseableIterator INSTANCE = new EmptyCloseableIterator();

        public static <T> EmptyCloseableIterator<T> instance() {
            return INSTANCE;
        }

        private EmptyCloseableIterator() {
            super(EmptyIterator.instance());
        }
    }
}

