package org.apache.stratum.scheduler;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This bean represents the settings used to assign jobstore properties for use in the Quartz scheduler.
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: JobStoreConfig.java 264191 2005-08-29 18:07:52Z henning $
 */
public class JobStoreConfig
{
    /** The loggername used by the Quartz jobstore */
    private String loggerName;

    /** The classname used by the Quartz jobstore */
    private String className;

    /**
     * Default contructor
     */
    public JobStoreConfig()
    {
    }

    /**
     * This is the reference name of the logger that has been registered with Quartz that will be used by the Quartz jobstore.
     *
     * @param s logger name
     */
    public void setLoggerName(String s)
    {
        this.loggerName = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the name of the logger for the jobstore
     */
    public String getLoggerName()
    {
        return this.loggerName;
    }

    /**
     * This is the full package/class name of the class used for the Quartz jobstore.
     *
     * @param s the full package/class name used for the jobstore
     */
    public void setClassName(String s)
    {
        this.className = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the full package/class name used for the jobstore
     */
    public String getClassName()
    {
        return this.className;
    }
}
