/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.model;

import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.model.AbstractModelPart;

public class DescriptorTCAS
extends AbstractModelPart {
    private CAS cachedResult;

    public DescriptorTCAS(MultiPageEditor modelRoot) {
        super(modelRoot);
    }

    public void validate() throws ResourceInitializationException {
        AnalysisEngineDescription ae = (AnalysisEngineDescription)this.modelRoot.getAeDescription().clone();
        if (ae.isPrimitive()) {
            TypeSystemDescription tsd = this.modelRoot.getMergedTypeSystemDescription();
            if (null != tsd) {
                tsd = (TypeSystemDescription)tsd.clone();
            }
            ae.getAnalysisEngineMetaData().setTypeSystem(tsd);
        }
        ae.getAnalysisEngineMetaData().setFsIndexCollection(this.modelRoot.getMergedFsIndexCollection());
        ae.getAnalysisEngineMetaData().setTypePriorities(this.modelRoot.getMergedTypePriorities());
        try {
            this.cachedResult = this.modelRoot.createCas(ae, casCreateProperties, this.modelRoot.createResourceManager());
            if (null == this.cachedResult) {
                throw new InternalErrorCDE("null result from createTCas");
            }
        }
        catch (CASAdminException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.dirty = false;
        this.modelRoot.allTypes.dirty = true;
    }

    public CAS get() {
        if (this.dirty) {
            this.update();
        }
        return this.cachedResult;
    }

    public void set(CAS tcas) {
        this.cachedResult = tcas;
        this.dirty = false;
    }

    private void update() {
        try {
            this.validate();
        }
        catch (ResourceInitializationException e) {
            throw new InternalErrorCDE("Unexpected Exception", e);
        }
    }
}

