/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionCondition
extends TypeSentiveCondition {
    private final NumberExpression position;
    private final BooleanExpression relative;

    public PositionCondition(TypeExpression type, NumberExpression position, BooleanExpression relative) {
        super(type);
        this.position = position;
        this.relative = relative;
    }

    @Override
    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type t = this.type.getType(element.getParent());
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = stream.getEndAnchor(annotation.getEnd());
        if (beginAnchor == null || endAnchor == null || !beginAnchor.isPartOf(t) || !endAnchor.isPartOf(t)) {
            return new EvaluatedCondition(this, false);
        }
        boolean relatively = this.relative == null ? true : this.relative.getBooleanValue(element.getParent());
        FSIterator iterator = stream.getCas().getAnnotationIndex(t).iterator((FeatureStructure)beginAnchor);
        if (!iterator.isValid()) {
            iterator.moveToNext();
        }
        if (!iterator.isValid()) {
            iterator.moveToLast();
        }
        AnnotationFS window = null;
        while (iterator.isValid()) {
            AnnotationFS annotationFS = (AnnotationFS)iterator.get();
            if (annotationFS.getBegin() <= annotation.getBegin() && annotationFS.getEnd() >= annotation.getEnd()) {
                window = annotationFS;
                break;
            }
            iterator.moveToPrevious();
        }
        ArrayList<Type> targetTypes = new ArrayList<Type>();
        if (element instanceof RutaRuleElement) {
            RutaRuleElement re = (RutaRuleElement)element;
            targetTypes.addAll(re.getMatcher().getTypes(element.getParent(), stream));
        } else {
            targetTypes.add(annotation.getType());
        }
        if (window == null) {
            return new EvaluatedCondition(this, false);
        }
        int integerValue = this.position.getIntegerValue(element.getParent());
        if (relatively) {
            int counter = 0;
            List<RutaBasic> inWindow = stream.getBasicsInWindow(window);
            for (RutaBasic each : inWindow) {
                if (!this.beginsWith(each, targetTypes)) continue;
                if (++counter == integerValue) {
                    if (each.getBegin() == beginAnchor.getBegin()) {
                        return new EvaluatedCondition(this, true);
                    }
                    return new EvaluatedCondition(this, false);
                }
                if (counter <= integerValue) continue;
                return new EvaluatedCondition(this, false);
            }
            return new EvaluatedCondition(this, false);
        }
        int counter = 0;
        List<RutaBasic> inWindow = stream.getBasicsInWindow(window);
        for (RutaBasic each : inWindow) {
            boolean beginsWith = this.beginsWith(each, targetTypes);
            if (each.getBegin() == beginAnchor.getBegin() && beginsWith && ++counter == integerValue) {
                return new EvaluatedCondition(this, true);
            }
            if (counter <= integerValue) continue;
            return new EvaluatedCondition(this, false);
        }
        return new EvaluatedCondition(this, false);
    }

    private boolean beginsWith(RutaBasic each, List<Type> targetTypes) {
        for (Type type : targetTypes) {
            if (!each.beginsWith(type)) continue;
            return true;
        }
        return false;
    }

    public NumberExpression getPosition() {
        return this.position;
    }

    public BooleanExpression getRelative() {
        return this.relative;
    }
}

