/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class RutaProjectUtils {
    public static final String JAVANATURE = "org.eclipse.jdt.core.javanature";
    private static final String CDE_DATA_PATH = "CDEdataPath";

    public static IPath getEngineDescriptorPath(IPath scriptPath, IProject project) {
        String elementName = RutaProjectUtils.getModuleName(scriptPath);
        IPath descPackagePath = RutaProjectUtils.getDescriptorPackagePath(scriptPath, project);
        IPath result = descPackagePath.append(elementName + "Engine.xml");
        return result;
    }

    public static IPath getTypeSystemDescriptorPath(IPath scriptPath, IProject project) {
        String elementName = RutaProjectUtils.getModuleName(scriptPath);
        IPath descPackagePath = RutaProjectUtils.getDescriptorPackagePath(scriptPath.makeAbsolute(), project);
        IPath result = descPackagePath.append(elementName + "TypeSystem.xml");
        return result;
    }

    public static IPath getDescriptorRootPath(IProject project) {
        IPath projectPath = project.getLocation();
        IPath descPath = projectPath.append(RutaProjectUtils.getDefaultDescriptorLocation());
        return descPath;
    }

    public static List<IFolder> getAllScriptFolders(IScriptProject proj) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        result.addAll(RutaProjectUtils.getScriptFolders(proj));
        result.addAll(RutaProjectUtils.getReferencedScriptFolders(proj));
        return result;
    }

    public static List<IFolder> getReferencedScriptFolders(IScriptProject proj) throws CoreException {
        return RutaProjectUtils.getReferencedScriptFolders(proj, new HashSet<IProject>());
    }

    public static List<IFolder> getReferencedScriptFolders(IScriptProject proj, Collection<IProject> visited) throws CoreException {
        IProject[] referencedProjects;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        for (IProject eachProject : referencedProjects = proj.getProject().getReferencedProjects()) {
            if (visited.contains(eachProject)) continue;
            IScriptProject scriptProject = DLTKCore.create((IProject)eachProject);
            result.addAll(RutaProjectUtils.getScriptFolders(scriptProject));
            visited.add(eachProject);
            result.addAll(RutaProjectUtils.getReferencedScriptFolders(scriptProject, visited));
        }
        return result;
    }

    public static List<IFolder> getScriptFolders(IScriptProject proj) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        IScriptFolder[] scriptFolders = null;
        try {
            scriptFolders = proj.getScriptFolders();
        }
        catch (ModelException e) {
            // empty catch block
        }
        if (scriptFolders != null) {
            for (IScriptFolder eachScriptFolder : scriptFolders) {
                IResource resource;
                IModelElement parent = eachScriptFolder.getParent();
                if (parent == null || (resource = parent.getResource()) == null || !(resource instanceof IFolder) || result.contains(resource)) continue;
                result.add((IFolder)resource);
            }
        }
        return result;
    }

    public static List<IFolder> getAllDescriptorFolders(IProject proj) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        result.addAll(RutaProjectUtils.getDescriptorFolders(proj));
        result.addAll(RutaProjectUtils.getReferencedDescriptorFolders(proj));
        return result;
    }

    public static List<IFolder> getReferencedDescriptorFolders(IProject proj) throws CoreException {
        return RutaProjectUtils.getReferencedDescriptorFolders(proj, new HashSet<IProject>());
    }

    public static List<IFolder> getReferencedDescriptorFolders(IProject proj, Collection<IProject> visited) throws CoreException {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        Collection<IProject> referencedProjects = RutaProjectUtils.getReferencedProjects(proj, new HashSet<IProject>());
        for (IProject eachProject : referencedProjects) {
            if (visited.contains(eachProject)) continue;
            result.addAll(RutaProjectUtils.getDescriptorFolders(eachProject));
            visited.add(eachProject);
            result.addAll(RutaProjectUtils.getReferencedDescriptorFolders(eachProject, visited));
        }
        return result;
    }

    public static Collection<IProject> getReferencedProjects(IProject proj, Collection<IProject> visited) throws CoreException {
        HashSet<IProject> result = new HashSet<IProject>();
        if (!proj.isOpen()) {
            return result;
        }
        IProject[] referencedProjects = proj.getReferencedProjects();
        result.addAll(Arrays.asList(referencedProjects));
        IProjectNature nature = proj.getNature(JAVANATURE);
        if (nature != null) {
            IClasspathEntry[] resolvedClasspath;
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)proj);
            for (IClasspathEntry eachCPE : resolvedClasspath = javaProject.getResolvedClasspath()) {
                if (eachCPE.getEntryKind() != 2) continue;
                IProject project = RutaProjectUtils.getProject(eachCPE.getPath());
                result.add(project);
            }
        }
        return result;
    }

    public static List<IFolder> getDescriptorFolders(IProject proj) throws CoreException {
        IFolder findElement;
        IProjectNature rutaNature;
        IFolder findElement2;
        IProjectNature pearNature;
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        if (!proj.isOpen()) {
            return result;
        }
        IProjectNature javaNature = proj.getNature(JAVANATURE);
        if (javaNature != null) {
            IJavaProject javaProject = JavaCore.create((IProject)proj);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder);
        }
        if ((pearNature = proj.getNature("org.apache.uima.pear.UimaNature")) != null && (findElement2 = proj.getFolder("desc")) != null) {
            result.add(findElement2);
        }
        if ((rutaNature = proj.getNature("org.apache.uima.ruta.ide.nature")) != null && (findElement = proj.getFolder(RutaProjectUtils.getDefaultDescriptorLocation())) != null) {
            result.add(findElement);
        }
        return result;
    }

    public static List<String> getFolderLocations(List<IFolder> folders) {
        ArrayList<String> result = new ArrayList<String>();
        if (folders == null) {
            return result;
        }
        for (IFolder each : folders) {
            String portableString = each.getLocation().toPortableString();
            result.add(portableString);
        }
        return result;
    }

    public static IPath getScriptRootPath(IProject project) {
        IPath projectPath = project.getLocation();
        IPath descPath = projectPath.append(RutaProjectUtils.getDefaultScriptLocation());
        return descPath;
    }

    public static IPath getDescriptorPackagePath(IPath scriptPath, IProject project) {
        IPath projectPath = project.getLocation().makeAbsolute();
        IPath packagePath = scriptPath.removeLastSegments(1);
        IPath relativePackagePath = packagePath.makeRelativeTo(projectPath).removeFirstSegments(1);
        IPath descPackagePath = projectPath.append(RutaProjectUtils.getDefaultDescriptorLocation());
        descPackagePath = descPackagePath.append(relativePackagePath);
        return descPackagePath;
    }

    public static String getModuleName(IPath path) {
        String result = path.lastSegment();
        int lastIndexOf = result.lastIndexOf(".ruta");
        if (lastIndexOf != -1) {
            result = result.substring(0, lastIndexOf);
        }
        return result;
    }

    public static void addProjectDataPath(IProject project, IFolder folder) throws CoreException {
        String addon;
        String[] split;
        List<String> paths;
        String dataPath = project.getPersistentProperty(new QualifiedName("", CDE_DATA_PATH));
        String sep = System.getProperty("path.separator");
        if (dataPath == null) {
            dataPath = "";
        }
        if (!(paths = Arrays.asList(split = dataPath.split(sep))).contains(addon = folder.getLocation().toPortableString())) {
            if (!StringUtils.isEmpty((CharSequence)dataPath)) {
                dataPath = dataPath + sep;
            }
            dataPath = dataPath + addon;
            project.setPersistentProperty(new QualifiedName("", CDE_DATA_PATH), dataPath);
        }
    }

    public static void removeProjectDataPath(IProject project, IFolder folder) throws CoreException {
        String dataPath = project.getPersistentProperty(new QualifiedName("", CDE_DATA_PATH));
        String sep = System.getProperty("path.separator");
        if (dataPath == null) {
            return;
        }
        String path = folder.getLocation().toPortableString();
        if (!StringUtils.isEmpty((CharSequence)dataPath)) {
            dataPath = dataPath.replaceAll(path, "");
            dataPath = dataPath.replaceAll(sep + sep, "");
        }
        project.setPersistentProperty(new QualifiedName("", CDE_DATA_PATH), dataPath);
    }

    public static IProject getProject(IPath path) {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (member instanceof IProject) {
            IProject p = (IProject)member;
            return p;
        }
        return null;
    }

    public static Collection<String> getClassPath(IProject project) throws CoreException {
        TreeSet<String> result = new TreeSet<String>();
        RutaProjectUtils.extendClasspathWithProject(result, project.getProject(), new HashSet<IProject>());
        Collection<String> dependencies = RutaProjectUtils.getDependencies(project.getProject());
        result.addAll(dependencies);
        return result;
    }

    private static Collection<String> getDependencies(IProject project) throws CoreException {
        IProject[] referencedProjects;
        TreeSet<String> result = new TreeSet<String>();
        for (IProject eachProject : referencedProjects = project.getReferencedProjects()) {
            RutaProjectUtils.extendClasspathWithProject(result, eachProject, new HashSet<IProject>());
            IProjectNature nature = eachProject.getNature("org.apache.uima.ruta.ide.nature");
            if (nature == null) continue;
            result.addAll(RutaProjectUtils.getDependencies(eachProject));
        }
        return result;
    }

    private static void extendClasspathWithProject(Collection<String> result, IProject project, Collection<IProject> visited) throws CoreException, JavaModelException {
        IProjectNature javaNature;
        IProjectNature rutaNature = project.getNature("org.apache.uima.ruta.ide.nature");
        if (rutaNature != null) {
            IScriptProject sp = DLTKCore.create((IProject)project);
            List<IFolder> scriptFolders = RutaProjectUtils.getScriptFolders(sp);
            for (IFolder each : scriptFolders) {
                result.add(each.getLocation().toPortableString());
            }
            List<IFolder> descriptorFolders = RutaProjectUtils.getDescriptorFolders(project);
            for (IFolder each : descriptorFolders) {
                result.add(each.getLocation().toPortableString());
            }
            IFolder resourceFolder = project.getFolder(RutaProjectUtils.getDefaultResourcesLocation());
            if (resourceFolder != null && resourceFolder.exists()) {
                result.add(resourceFolder.getLocation().toPortableString());
            }
        }
        if ((javaNature = project.getNature(JAVANATURE)) != null) {
            IClasspathEntry[] rawClasspath;
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
            IPath readOutputLocation = javaProject.readOutputLocation();
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(readOutputLocation);
            result.add(folder.getLocation().toPortableString());
            for (IClasspathEntry each : rawClasspath = javaProject.getRawClasspath()) {
                IClasspathEntry[] resolveClasspath;
                String segment;
                int entryKind = each.getEntryKind();
                IPath path = each.getPath();
                if (entryKind == 2) {
                    IProject p = RutaProjectUtils.getProject(path);
                    if (visited.contains(p)) continue;
                    visited.add(p);
                    RutaProjectUtils.extendClasspathWithProject(result, p, visited);
                    continue;
                }
                if (entryKind == 3 || (segment = path.segment(0)).equals("org.eclipse.jdt.launching.JRE_CONTAINER")) continue;
                for (IClasspathEntry eachResolved : resolveClasspath = javaProject.resolveClasspath(new IClasspathEntry[]{each})) {
                    if (eachResolved.getEntryKind() == 2) {
                        IProject p = RutaProjectUtils.getProject(eachResolved.getPath());
                        if (visited.contains(p)) continue;
                        visited.add(p);
                        RutaProjectUtils.extendClasspathWithProject(result, p, visited);
                        continue;
                    }
                    result.add(eachResolved.getPath().toPortableString());
                }
            }
        }
    }

    public static String getDefaultInputLocation() {
        return "input";
    }

    public static String getDefaultOutputLocation() {
        return "output";
    }

    public static String getDefaultTestLocation() {
        return "test";
    }

    public static String getDefaultCleanTestLocation() {
        return "temp_clean";
    }

    public static String getDefaultScriptLocation() {
        return "script";
    }

    public static String getDefaultResourcesLocation() {
        return "resources";
    }

    public static String getDefaultDescriptorLocation() {
        return "descriptor";
    }

    public static String getDefaultTempTestLocation() {
        return "temp";
    }
}

