/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.ajax.markup.html.ajaxLink;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.model.PropertyModel;

/**
 * 
 */
public class AjaxLinkWithBorderPage extends WebPage
{
	private static final long serialVersionUID = 1L;

	private String labelText = "UpdateMe";

	/**
	 * Construct.
	 */
	public AjaxLinkWithBorderPage()
	{
		Border border = new AjaxTestBorder("border");
		add(border);

		final Label label = new Label("ajaxLabel", new PropertyModel<String>(this, "labelText"));
		label.setOutputMarkupId(true);
		border.add(label);
		border.add(new AjaxLink<Void>("ajaxLink")
		{
			private static final long serialVersionUID = 1L;

			@Override
			public void onClick(AjaxRequestTarget target)
			{
				labelText = "Updated!";
				target.add(label);
			}
		});
	}

	/**
	 * 
	 * @return String
	 */
	public String getLabelText()
	{
		return labelText;
	}
}
