<?
// ADDED COMMENT TO TEST NEW SETUP
/*
PHP to SQLite interface
akaihola 2000-11-01
  Robert Shingledecker major revision: 2001-11-27
  added function sqlite_schema
  added Class ResultSet in order to create the following functions:
   sqlite_query
   sqlite_fetch_row
   sqlite_fetch_array
   sqlite_num_rows
   sqlite_num-cols
   sqlite_field_name
   sqlite_col_names
Philip Cheung add single/double quote accomodation 2001-09-15 (change to use
  doubleQuote from singleQuote for bash exec()
*/

// replace this with path to your sqlite binary:
$sqlite_bin_path = "/usr/bin/sqlite";

function sqlite_parse_table($s) {
  $a = array();
  while (list($key, $row) = each($s)){
    $a[count($a)] = explode("|", $row);
  }  
  return $a; 
}

function sqlite_exec($dbdir, $sql) {
  global $sqlite_bin_path;
  $tries=0;
  do {
    exec("$sqlite_bin_path $dbdir \"$sql\" 2>&1", $s, $r);
    if($r) {
      $tries++;
      sleep(3);
    }  
  } while ($r && $tries<3);  
  if ($r) {
    print "<HR>sqlite_exec: $sql<HR>";
    print "<HR>sqlite_exec result:<BR>" . join("<BR>", $s) . "<HR>";
    return false; 
  }
  return sqlite_parse_table($s);
}

function sqlite_connect($dbdir) {
  if (sqlite_exec($dbdir, "SELECT * FROM sqlite_master;"))
    return $dbdir;
  return false;
}

function sqlite_tables($dbdir) {
  $t = sqlite_exec($dbdir, "SELECT tbl_name FROM sqlite_master WHERE type = 'table';");
  if (!$t) return false;
  $ret = array();
  while (list($key, $table) = each($t)) array_push($ret, $table[0]);
  return $ret;
}

function sqlite_schema($dbdir,$tablename) {
  sqlite_connect($dbdir) or die("Could not connect to database ".$dbdir."\n");
  $command = "select sql from sqlite_master where type = 'table' and tbl_name='".$tablename."';";
# print $command;
  $row = sqlite_exec($dbdir,$command);
  if (!$row) return false;
  for($i=0; $i<count($row); $i++) {
    $line = join("",$row[$i]);
    $result .= $line;
  }
  $work = explode(",",substr($result,(strpos($result,"("))+1));
  for($i=0; $i<count($work); $i++) {
    $work[$i]=trim($work[$i]);
  }  
  while( list($index,$data) = each($work)) $schema[count($schema)]=explode(" ",$data);
  return $schema;
}   

function sqlite_query($sql, $dbdir) {
  global $sqlite_bin_path;
  $results = new ResultSet; 
  $query=trim($sql);
  if(strncasecmp("select", $query, 6)) {
    $results->fieldNames="";
  } else {
    $fromPos = strpos($query,"from") + strpos($query,"FROM");
    $work=substr($query,$fromPos+5);
#   print "Tablename work: ".$work."\n";
    if(strpos($work," ")) {
      $tablename=substr($work,0,strpos($work," "));
    } elseif(strpos($work,";")) {
      $tablename=substr($work,0,strpos($work,";"));
    } else {
      $tablename=$work;
    }  
#   print $dbdir."\n";
#   print $tablename."\n";
    $needSchema = strpos($query,"*");
    if($needSchema === false) {
      $startPos=strpos($query," ")+1;
      $endPos = $fromPos - $startPos;
      $colSpecs = trim(substr($query,$startPos,$endPos));
#     print "Column Specs: ".$colSpecs."\n";
      $multipleCols = strpos($colSpecs,",");
      if($multipleCols === false) {
        $colNames[0] = $colSpecs;
      } else {  
        $colNames=explode(",",$colSpecs);
      }
    } else {
      $schema = sqlite_schema($dbdir,$tablename);
      $schemaRows = count($schema);
      for($i=0; $i < $schemaRows; $i++) {
        $colNames[$i]=$schema[$i][0];
#       print "Col from schema: ".$colNames[$i]."\n";
      }  
    }  
    for($i=0; $i < count($colNames); $i++) {
      $colNames[$i] = trim($colNames[$i]);
#     print "FieldNames: ".$colNames[$i]."\n";
    }  
  }  
  $tries=0;
  do {
    exec("$sqlite_bin_path $dbdir \"$sql\" 2>&1", $s, $r);
    if($r) {
      $tries++;
      sleep(3);
    }  
  } while ($r && $tries<3);
  if ($r) {
    print "<HR>sqlite_exec: $sql<HR>";
    print "<HR>sqlite_query result:<BR>" . join("<BR>", $s) . "<HR>";
    return false; 
  }
  $results->dataTable = sqlite_parse_table($s);
  $results->curRow = 0;
  $results->totRows = count($results->dataTable);
  $results->fieldNames = $colNames;
  $results->fieldCount = count($colNames);
# print "FieldCount: ".count($colNames)."\n";
  return $results;
}

function sqlite_fetch_row(&$results){
  $row = $results->curRow;
  $results->curRow++;
  if($row >= $results->totRows) return false;
  return $results->dataTable[$row];
}

function sqlite_fetch_array(&$results){
  $row = sqlite_fetch_row($results);
  if(!$row) return $row;
  for($i=0; $i < sqlite_num_cols($results); $i++) {
    $row[sqlite_field_name($results,$i)] = $row[$i];
#   print "Name: ".$i." ".sqlite_field_name($results,$i)." has the value ".$row[$i]."\n";
  }
  return $row;
}

function sqlite_num_rows($results){
  return $results->totRows;
}

function sqlite_num_cols($results){
# print "FieldCount: ".$results->fieldCount."\n";
  return $results->fieldCount;
}

function sqlite_field_name($results,$num){
  return $results->fieldNames[$num];
}

function sqlite_fetch_col_names($results){
  return $results->fieldNames;
}
function sqlite_quote_escape($input){
  $ans=$input;
  $enclosed="'";
  //if ans has backslashes, the bash script will add an extra one, can't help
  //if ans has single quote, change enclosed to double quote
  if(strpos($ans,"'")!=false) {
    $enclosed='\"';
    $ans=str_replace('"','""',$ans); //add 2nd doubleQuote prepare for later
                                     //  escape to satisfy bash script requirment
  }
  $ans=str_replace('"','\"',$ans); //escape doubleQuote regardless enclosedQuote
  $ans=str_replace('$','\$',$ans); //escape Dollar Sign regardless enclosedQuote
  return $enclosed.$ans.$enclosed;
}
Class ResultSet {
  var $dataTable;
  var $curRow;
  var $totRows;
  var $fieldNames;
  var $fieldCount;
}  
?>
