dnl Copyright (C) 2001-2005 Open Source Telecom Corporation.
dnl Copyright (C) 2006-2010 David Sugar, Tycho Softworks.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if you
dnl distribute this file as part of a program that contains a configuration
dnl script generated by Autoconf, you may include it under the same
dnl distribution terms that you use for the rest of that program.

dnl modification of AC_SEARCH_LIBS for problem with c++ name mangling

dnl OST_SEARCH_LIBS(FUNCTION, INCLUDES, MAIN, SEARCH-LIBS [, ACTION-IF-FOUND
dnl            [, ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES]]])
dnl Search for a library defining FUNC, if it's not already available.

AC_DEFUN([OST_SEARCH_LIBS],[
    AC_PREREQ([2.13])
    AC_CACHE_CHECK([for library containing $1], [ost_cv_search_$1],[
        ac_func_search_save_LIBS="$LIBS"
        ost_cv_search_$1="no"
        AC_TRY_LINK([$2], [$3], [ost_cv_search_$1="none required"])
        test "$ost_cv_search_$1" = "no" && for i in $4; do
            LIBS="-l$i $7 $ac_func_search_save_LIBS"
            AC_TRY_LINK([$2], [$3],[
                ost_cv_search_$1="-l$i"
                break
            ])
        done
        LIBS="$ac_func_search_save_LIBS"
    ])
    if test "$ost_cv_search_$1" != "no"; then
        test "$ost_cv_search_$1" = "none required" || LIBS="$ost_cv_search_$1 $LIBS"
        $5
    else :
        $6
    fi
])


AC_DEFUN([OST_SGI_STLPORT],[
    AC_REQUIRE([OST_CXX_PROGRAMMING])

    dnl
    dnl Check for sgi/stlport portable c++ library
    dnl

    AC_LANG_SAVE
    ac_save_CXXFLAGS="$CXXFLAGS"
    CXXFLAGS=""
    AC_LANG_CPLUSPLUS

    AC_ARG_WITH(stlport, [  --with-stlport[=dir]        using SGI portable C++ stream library
                            ie: /usr/local, not all include directory],[
        if test "$withval" = "" ; then
            COMMON_FLAGS="-I$(includedir)/stlport $COMMON_FLAGS"
        else
            COMMON_FLAGS="-I$withval/include/stlport $COMMON_FLAGS"
            LIBS="-L$withval/lib $LIBS"
        fi
        dnl AC_SEARCH_LIBS do not run (consider name mangling)
        OST_SEARCH_LIBS(__stl_throw_invalid_argument, [
            namespace _STL { void __stl_throw_invalid_argument(const char*); }
        ], [_STL::__stl_throw_invalid_argument("x")], [stlport_gcc stlport_cygwin stlport_mingw32 stlport_sunpro stlport_watcom])
    ])

    AC_LANG_RESTORE
    CXXFLAGS="$ac_save_CXXFLAGS"
])


