/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eclipse.andmore.android.generatemenucode.model.codegenerators;

/**
 * Constants for creating code based on menu (method names, variables, types)
 */
public interface CodeGeneratorBasedOnMenuConstants {
	/*
	 * Constants
	 */
	public static final String GET_ITEM_ID = "getItemId"; //$NON-NLS-1$

	public static final String ITEM = "item"; //$NON-NLS-1$

	public static final String MENU_ITEM = "MenuItem"; //$NON-NLS-1$

	public static final String ON_OPTIONS_ITEM_SELECTED = "onOptionsItemSelected"; //$NON-NLS-1$

	public static final String MENU_INFLATER_VARIABLE = "MenuInflater"; //$NON-NLS-1$

	public static final String GET_MENU_INFLATER = "getMenuInflater"; //$NON-NLS-1$

	public static final String INFLATE_METHOD = "inflate"; //$NON-NLS-1$

	public static final String INFLATER_VARIABLE = "inflater"; //$NON-NLS-1$

	public static final String R = "R"; //$NON-NLS-1$

	public static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu"; //$NON-NLS-1$

	public static final String MENU_VARIABLE = "menu"; //$NON-NLS-1$

	public static final String MENU_TYPE = "Menu"; //$NON-NLS-1$

	public static final String BUNDLE = "Bundle"; //$NON-NLS-1$

	public static final String ON_CREATE = "onCreate"; //$NON-NLS-1$

	public static final String SAVED_INSTANCE_STATE = "savedInstanceState"; //$NON-NLS-1$

	public static final String SET_HAS_OPTIONS_MENU = "setHasOptionsMenu"; //$NON-NLS-1$
}
