/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.IAbstractFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.launch.ILaunchConfigurationConstants;
import org.eclipse.andmore.android.launch.LaunchPlugin;
import org.eclipse.andmore.android.launch.LaunchUtils;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.andmore.android.launch.ui.StartedInstancesDialog;
import org.eclipse.andmore.internal.launch.AndroidLaunch;
import org.eclipse.andmore.internal.launch.AndroidLaunchController;
import org.eclipse.andmore.internal.launch.LaunchConfigDelegate;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.io.IFolderWrapper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class StudioAndroidConfigurationDelegate
extends LaunchConfigDelegate {
    private static final String ERRONEOUS_LAUNCH_CONFIGURATION = "erroneous.launch.config.dialog";
    private static final String NO_COMPATIBLE_DEVICE = "no.compatible.device.dialog";
    IAndroidEmulatorInstance compatibleInstance = null;
    IAndroidEmulatorInstance initialEmulatorInstance = null;
    public List<Client> waitingDebugger = new ArrayList<Client>();

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IProject project;
        String projectName;
        this.initialEmulatorInstance = null;
        boolean isOk = super.preLaunchCheck(configuration, mode, monitor);
        if (isOk) {
            String instanceName = configuration.getAttribute("org.eclipse.andmore.android.launch.instanceName", null);
            if (instanceName != null && instanceName.length() > 0) {
                IAndroidEmulatorInstance instance = DeviceFrameworkManager.getInstance().getInstanceByName(instanceName);
                if (instance == null) {
                    String serialNumber = LaunchUtils.getSerialNumberForInstance(instanceName);
                    if (!DDMSFacade.isDeviceOnline((String)serialNumber)) {
                        isOk = false;
                        this.handleErrorDuringLaunch(configuration, mode, instanceName);
                    }
                } else {
                    if (!instance.isAvailable()) {
                        isOk = false;
                        this.handleErrorDuringLaunch(configuration, mode, instanceName);
                    }
                    if (!instance.isStarted()) {
                        this.initialEmulatorInstance = instance;
                        isOk = this.checkForCompatibleRunningInstances(configuration);
                    }
                }
            } else {
                isOk = false;
                this.handleErrorDuringLaunch(configuration, mode, null);
            }
        }
        if (isOk && (projectName = configuration.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, null)) != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && SdkUtils.isLibraryProject((IProject)project)) {
            this.handleProjectError(configuration, project, mode);
            isOk = false;
        }
        return isOk;
    }

    private void handleProjectError(final ILaunchConfiguration config, IProject project, final String mode) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = LaunchUtils.getActiveWorkbenchShell();
                String message = LaunchNLS.UI_LaunchConfigurationTab_ERR_PROJECT_IS_LIBRARY;
                String prefKey = StudioAndroidConfigurationDelegate.ERRONEOUS_LAUNCH_CONFIGURATION;
                DialogWithToggleUtils.showInformation((String)prefKey, (String)LaunchNLS.ERR_LaunchConfigurationShortcut_MsgTitle, (String)message);
                String groupId = "org.eclipse.debug.ui.launchGroup.run";
                ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
                groupId = group.getIdentifier();
                StructuredSelection struturedSelection = new StructuredSelection((Object)config);
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)struturedSelection, (String)groupId);
            }
        });
    }

    private void handleErrorDuringLaunch(final ILaunchConfiguration config, final String mode, final String instanceName) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = LaunchUtils.getActiveWorkbenchShell();
                String message = instanceName != null ? NLS.bind((String)LaunchNLS.ERR_LaunchDelegate_InvalidDeviceInstance, (Object)instanceName) : NLS.bind((String)LaunchNLS.ERR_LaunchDelegate_No_Compatible_Device, (Object)config.getName());
                String prefKey = instanceName != null ? StudioAndroidConfigurationDelegate.ERRONEOUS_LAUNCH_CONFIGURATION : StudioAndroidConfigurationDelegate.NO_COMPATIBLE_DEVICE;
                DialogWithToggleUtils.showInformation((String)prefKey, (String)LaunchNLS.ERR_LaunchConfigurationShortcut_MsgTitle, (String)message);
                String groupId = "org.eclipse.debug.ui.launchGroup.run";
                ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
                groupId = group.getIdentifier();
                StructuredSelection struturedSelection = new StructuredSelection((Object)config);
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)struturedSelection, (String)groupId);
            }
        });
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block34: {
            ILaunchConfigurationWorkingCopy configurationWorkingCopy = configuration.getWorkingCopy();
            AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)("Launch Android Application using Studio for Android wizard. Configuration: " + configurationWorkingCopy + " mode:" + mode + " launch: " + launch));
            try {
                try {
                    String projectName = configurationWorkingCopy.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                    int launchAction = configurationWorkingCopy.getAttribute("org.eclipse.andmore.action", 0);
                    String instanceName = configurationWorkingCopy.getAttribute("org.eclipse.andmore.android.launch.instanceName", null);
                    if (projectName != null && instanceName != null) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (project == null) {
                            Status status = new Status(4, "org.eclipse.andmore.android.launch", "Could not retrieve project: " + projectName);
                            throw new CoreException((IStatus)status);
                        }
                        String appToLaunch = null;
                        if (launchAction == 0) {
                            ManifestData manifestParser = AndroidManifestParser.parse((IAbstractFolder)new IFolderWrapper((IContainer)project));
                            ManifestData.Activity launcherActivity = manifestParser.getLauncherActivity();
                            String activityName = null;
                            if (launcherActivity != null) {
                                activityName = launcherActivity.getName();
                            }
                            if (activityName != null) {
                                appToLaunch = activityName;
                            }
                        } else if (launchAction == 1 && ((appToLaunch = configurationWorkingCopy.getAttribute("org.eclipse.andmore.activity", null)) == null || "".equals(appToLaunch))) {
                            Status status = new Status(4, "org.eclipse.andmore.android.launch", "Activity field cannot be empty. Specify an activity or use the default activity on launch configuration.");
                            throw new CoreException((IStatus)status);
                        }
                        IAndroidEmulatorInstance emuInstance = DeviceFrameworkManager.getInstance().getInstanceByName(instanceName);
                        RunAsClientListener list = null;
                        if (this.initialEmulatorInstance != null) {
                            emuInstance = this.initialEmulatorInstance;
                        }
                        try {
                            if (appToLaunch != null) {
                                list = new RunAsClientListener(emuInstance, appToLaunch);
                                AndmoreEventManager.asyncAddClientChangeListener((AndroidDebugBridge.IClientChangeListener)list);
                            }
                            if (emuInstance != null && !emuInstance.isStarted()) {
                                if (this.compatibleInstance != null) {
                                    emuInstance = this.compatibleInstance;
                                    instanceName = emuInstance.getName();
                                    configurationWorkingCopy.setAttribute("org.eclipse.andmore.android.launch.instanceName", emuInstance.getName());
                                    configurationWorkingCopy.setAttribute("org.eclipse.andmore.avd", emuInstance.getName());
                                } else {
                                    this.startEmuInstance(emuInstance);
                                }
                            }
                            AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)("AVD where the application will be executed: " + instanceName));
                            String serialNumber = LaunchUtils.getSerialNumberForInstance(instanceName);
                            if (serialNumber == null) {
                                Status status = new Status(4, "org.eclipse.andmore.android.launch", "Could not retrieve AVD instance: " + instanceName);
                                throw new CoreException((IStatus)status);
                            }
                            this.bringConsoleView();
                            String descriptionToLog = "";
                            if (emuInstance != null) {
                                descriptionToLog = "emulator";
                            } else if (serialNumber != null && !serialNumber.equals("")) {
                                descriptionToLog = "handset";
                            }
                            if (!descriptionToLog.equals("")) {
                                descriptionToLog = "device=" + descriptionToLog + "|";
                            }
                            descriptionToLog = String.valueOf(descriptionToLog) + "use_vdl=";
                            descriptionToLog = String.valueOf(descriptionToLog) + "n";
                            super.launch((ILaunchConfiguration)configurationWorkingCopy, mode, launch, monitor);
                            try {
                                String prjTarget = "";
                                if (project != null) {
                                    prjTarget = Sdk.getCurrent().getTarget(project).getName();
                                }
                                if (!descriptionToLog.equals("")) {
                                    descriptionToLog = String.valueOf(descriptionToLog) + "|";
                                }
                                descriptionToLog = String.valueOf(descriptionToLog) + "prj_target=" + prjTarget;
                                if (emuInstance != null) {
                                    String emuTarget = emuInstance.getTarget();
                                    descriptionToLog = String.valueOf(descriptionToLog) + "|";
                                    descriptionToLog = String.valueOf(descriptionToLog) + "target=" + emuTarget;
                                }
                                AndmoreLogger.collectUsageData((String)mode, (String)"application_management", (String)descriptionToLog, (String)"org.eclipse.andmore.android.launch", (String)LaunchPlugin.getDefault().getBundle().getVersion().toString());
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable throwable) {
                            if (list != null) {
                                AndmoreEventManager.asyncRemoveClientChangeListener(list);
                            }
                            AndmoreEventManager.asyncAddClientChangeListener((AndroidDebugBridge.IClientChangeListener)AndroidLaunchController.getInstance());
                            throw throwable;
                        }
                        if (list != null) {
                            AndmoreEventManager.asyncRemoveClientChangeListener((AndroidDebugBridge.IClientChangeListener)list);
                        }
                        AndmoreEventManager.asyncAddClientChangeListener((AndroidDebugBridge.IClientChangeListener)AndroidLaunchController.getInstance());
                        break block34;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.andmore.android.launch", "Missing parameters for launch"));
                }
                catch (CoreException e) {
                    AndroidLaunch androidLaunch = (AndroidLaunch)launch;
                    androidLaunch.stopLaunch();
                    AndmoreLogger.error(StudioAndroidConfigurationDelegate.class, (String)("Error while lauching " + configurationWorkingCopy.getName()), (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    AndmoreLogger.error(LaunchUtils.class, (String)"An error occurred trying to parse AndroidManifest", (Throwable)e);
                    if (mode.equals("run")) {
                        AndroidLaunch androidLaunch = (AndroidLaunch)launch;
                        androidLaunch.stopLaunch();
                    }
                }
            }
            finally {
                if (mode.equals("run")) {
                    AndroidLaunch androidLaunch = (AndroidLaunch)launch;
                    androidLaunch.stopLaunch();
                }
            }
        }
    }

    private boolean checkForCompatibleRunningInstances(ILaunchConfiguration configuration) throws CoreException {
        IProject project = null;
        this.compatibleInstance = null;
        String projectName = configuration.getAttribute(ILaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            Status status = new Status(4, "org.eclipse.andmore.android.launch", "Could not retrieve project: " + projectName);
            throw new CoreException((IStatus)status);
        }
        Collection startedInstances = DeviceFrameworkManager.getInstance().getAllStartedInstances();
        HashSet<IAndroidEmulatorInstance> compatibleStartedInstances = new HashSet<IAndroidEmulatorInstance>();
        boolean continueLaunch = true;
        for (IAndroidEmulatorInstance i : startedInstances) {
            IStatus resultStatus = LaunchUtils.isCompatible(project, i.getName());
            if (resultStatus.getSeverity() != 0 && resultStatus.getSeverity() != 2) continue;
            compatibleStartedInstances.add(i);
        }
        if (compatibleStartedInstances.size() > 0) {
            StartedInstancesDialogProxy proxy = new StartedInstancesDialogProxy(compatibleStartedInstances, configuration, project);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)proxy);
            this.compatibleInstance = proxy.getSelectedInstance();
            continueLaunch = proxy.continueLaunch();
        }
        return continueLaunch;
    }

    private void bringConsoleView() {
        IConsole[] consoles;
        IConsole activeConsole = null;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals("Android")) {
                activeConsole = console;
            }
            ++n2;
        }
        if (activeConsole != null) {
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView(activeConsole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEmuInstance(IAndroidEmulatorInstance instance) throws CoreException {
        AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)"Needs to Start the AVD instance before launching... ");
        ServiceHandler startHandler = EmulatorPlugin.getStartServiceHandler();
        IStatus status = startHandler.run((IInstance)instance, null, (IProgressMonitor)new NullProgressMonitor());
        AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)("Status of the launch service: " + status));
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        if (status.getSeverity() == 8) {
            AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)"Abort launch session because the AVD start was canceled. ");
            return;
        }
        if (!instance.isStarted()) {
            status = new Status(4, "org.eclipse.andmore.android.launch", "The Android Virtual Device is not started: " + instance.getName());
            throw new CoreException(status);
        }
        StudioAndroidConfigurationDelegate studioAndroidConfigurationDelegate = this;
        synchronized (studioAndroidConfigurationDelegate) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                AndmoreLogger.info((String)"Could not wait: ", (String)e.getMessage());
            }
        }
    }

    private class RunAsClientListener
    implements AndroidDebugBridge.IClientChangeListener {
        private final IAndroidEmulatorInstance instance;
        private final String appToLaunch;

        RunAsClientListener(IAndroidEmulatorInstance instance, String appToLaunch) {
            this.instance = instance;
            this.appToLaunch = appToLaunch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientChanged(Client client, int changeMask) {
            String applicationName;
            if ((changeMask & 1) == 1 && (applicationName = client.getClientData().getClientDescription()) != null) {
                IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
                String home = store.getString("org.eclipse.andmore.homePackage");
                if (home.equals(applicationName)) {
                    String serialNumber = client.getDevice().getSerialNumber();
                    String avdName = DDMSFacade.getNameBySerialNumber((String)serialNumber);
                    if (this.instance != null && this.instance.getName().equals(avdName)) {
                        AndmoreLogger.info(StudioAndroidConfigurationDelegate.class, (String)"Delegating launch session to ADT... ");
                        Object object = StudioAndroidConfigurationDelegate.this;
                        synchronized (object) {
                            ((Object)((Object)StudioAndroidConfigurationDelegate.this)).notify();
                        }
                    }
                }
                Client removeClient = null;
                for (Client waiting : StudioAndroidConfigurationDelegate.this.waitingDebugger) {
                    int pid = waiting.getClientData().getPid();
                    if (pid != client.getClientData().getPid()) continue;
                    client.getDebuggerListenPort();
                    StudioAndroidConfigurationDelegate studioAndroidConfigurationDelegate = StudioAndroidConfigurationDelegate.this;
                    synchronized (studioAndroidConfigurationDelegate) {
                        ((Object)((Object)StudioAndroidConfigurationDelegate.this)).notify();
                    }
                    removeClient = waiting;
                    break;
                }
                if (removeClient != null) {
                    StudioAndroidConfigurationDelegate.this.waitingDebugger.remove(removeClient);
                }
            }
            if ((changeMask & 2) == 2) {
                ClientData clientData = client.getClientData();
                String applicationName2 = clientData.getClientDescription();
                if (clientData.getDebuggerConnectionStatus() == ClientData.DebuggerStatus.DEFAULT) {
                    if (this.appToLaunch != null && applicationName2 != null && applicationName2.equals(this.appToLaunch.substring(0, this.appToLaunch.lastIndexOf(".")))) {
                        client.getDebuggerListenPort();
                        StudioAndroidConfigurationDelegate studioAndroidConfigurationDelegate = StudioAndroidConfigurationDelegate.this;
                        synchronized (studioAndroidConfigurationDelegate) {
                            ((Object)((Object)StudioAndroidConfigurationDelegate.this)).notify();
                        }
                    } else if (this.appToLaunch != null) {
                        StudioAndroidConfigurationDelegate.this.waitingDebugger.add(client);
                    }
                }
            }
        }
    }

    private class StartedInstancesDialogProxy
    implements Runnable {
        private IAndroidEmulatorInstance selectedInstance = null;
        private boolean continueLaunch = true;
        private final ILaunchConfiguration configuration;
        Collection<IAndroidEmulatorInstance> compatibleStartedInstances = null;
        IProject project = null;

        public StartedInstancesDialogProxy(Collection<IAndroidEmulatorInstance> compatibleStartedInstances, ILaunchConfiguration configuration, IProject project) {
            this.compatibleStartedInstances = compatibleStartedInstances;
            this.configuration = configuration;
            this.project = project;
        }

        @Override
        public void run() {
            Shell aShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Shell shell = new Shell(aShell);
            try {
                StartedInstancesDialog dialog = new StartedInstancesDialog(shell, this.compatibleStartedInstances, this.configuration, this.project);
                dialog.setBlockOnOpen(true);
                dialog.open();
                this.selectedInstance = null;
                if (dialog.getReturnCode() == 0) {
                    this.selectedInstance = dialog.getSelectedInstance();
                } else if (dialog.getReturnCode() == 7) {
                    this.continueLaunch = false;
                }
            }
            catch (CoreException e) {
                AndmoreLogger.error(StudioAndroidConfigurationDelegate.class, (String)"It was not possible to open Started Instance Dialog", (Throwable)e);
            }
        }

        public IAndroidEmulatorInstance getSelectedInstance() {
            return this.selectedInstance;
        }

        public boolean continueLaunch() {
            return this.continueLaunch;
        }
    }
}

