/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.launch.ui;

import java.util.Collection;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.launch.LaunchUtils;
import org.eclipse.andmore.android.launch.i18n.LaunchNLS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StartedInstancesDialog
extends TitleAreaDialog {
    Collection<IAndroidEmulatorInstance> compatibleStartedInstances = null;
    private TableViewer viewer;
    private IAndroidEmulatorInstance selectedInstance;
    private Button okButton;
    private Button ignoreButton;
    private Button abortButton;
    private final IAndroidEmulatorInstance preferredAvd;
    private IProject project = null;
    private ILaunchConfiguration configuration = null;
    private boolean isUpdateConfigurationSelected = false;
    private static String DIALOG_IMAGE = "icons/choose_compatible_avd_instance.png";
    private static final String STARTED_INSTANCES_HELP_ID = "org.eclipse.andmore.android.started_instances_selection_dialog";

    public StartedInstancesDialog(Shell parentShell, Collection<IAndroidEmulatorInstance> compatibleStartedInstances, ILaunchConfiguration configuration, IProject project) throws CoreException {
        super(parentShell);
        this.configuration = configuration;
        this.compatibleStartedInstances = compatibleStartedInstances;
        this.project = project;
        String instanceName = configuration.getAttribute("org.eclipse.andmore.android.launch.instanceName", null);
        this.preferredAvd = DeviceFrameworkManager.getInstance().getInstanceByName(instanceName);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText(LaunchNLS.UI_StartedInstancesDialog_WindowTitle);
        this.setTitle(NLS.bind((String)LaunchNLS.UI_StartedInstancesDialog_Title, (Object)this.preferredAvd.getName()));
        this.setMessage(LaunchNLS.UI_StartedInstancesDialog_Message);
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.launch", (String)DIALOG_IMAGE).createImage());
        this.enableOkButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, STARTED_INSTANCES_HELP_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, STARTED_INSTANCES_HELP_ID);
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.ignoreButton = this.createButton(parent, 9, IDialogConstants.IGNORE_LABEL, false);
        this.abortButton = this.createButton(parent, 7, IDialogConstants.ABORT_LABEL, false);
        this.ignoreButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StartedInstancesDialog.this.setReturnCode(9);
                StartedInstancesDialog.this.close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.abortButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StartedInstancesDialog.this.setReturnCode(7);
                StartedInstancesDialog.this.close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void enableOkButton() {
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.createTableArea(parent);
        return parent;
    }

    private void createTableArea(Composite parent) {
        this.viewer = new TableViewer(parent, 68356);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        TableViewerColumn avds = new TableViewerColumn(this.viewer, 0);
        avds.getColumn().setText(LaunchNLS.UI_StartedInstancesDialog_CompatibleAvdsColumnName);
        avds.getColumn().setResizable(true);
        avds.getColumn().setWidth(480);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StartedInstancesDialog.this.enableOkButton();
            }
        });
        avds.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IAndroidEmulatorInstance instance = (IAndroidEmulatorInstance)element;
                return String.valueOf(instance.getName()) + " (" + instance.getTarget() + ", " + LaunchNLS.UI_StartedInstancesDialog_ApiLevel + " " + instance.getAPILevel() + ")";
            }

            public Image getImage(Object element) {
                Image img = null;
                IAndroidEmulatorInstance instance = (IAndroidEmulatorInstance)element;
                IStatus compatible = LaunchUtils.isCompatible(StartedInstancesDialog.this.project, instance.getName());
                if (compatible.getSeverity() == 2) {
                    img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
                return img;
            }

            public String getToolTipText(Object element) {
                String toolTip = null;
                IAndroidEmulatorInstance instance = (IAndroidEmulatorInstance)element;
                IStatus compatible = LaunchUtils.isCompatible(StartedInstancesDialog.this.project, instance.getName());
                if (compatible.getSeverity() == 2) {
                    toolTip = LaunchNLS.UI_StartedInstancesDialog_Tooltip;
                }
                return toolTip;
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 500;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        ArrayContentProvider provider = new ArrayContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(this.compatibleStartedInstances);
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(LaunchNLS.UI_StartedInstancesDialog_UpdateRunConfigurarion);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StartedInstancesDialog.this.isUpdateConfigurationSelected) {
                    StartedInstancesDialog.this.isUpdateConfigurationSelected = false;
                } else {
                    StartedInstancesDialog.this.isUpdateConfigurationSelected = true;
                }
            }
        });
    }

    public IAndroidEmulatorInstance getSelectedInstance() {
        return this.selectedInstance;
    }

    protected void okPressed() {
        this.selectedInstance = null;
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.selectedInstance = (IAndroidEmulatorInstance)this.viewer.getTable().getSelection()[0].getData();
        }
        if (this.isUpdateConfigurationSelected) {
            try {
                this.updateRunConfiguration();
            }
            catch (CoreException coreException) {
                AndmoreLogger.error(StartedInstancesDialog.class, (String)"It was not possible to update the current run configuration");
            }
        }
        super.okPressed();
    }

    private void updateRunConfiguration() throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.configuration.getWorkingCopy();
        workingCopy.setAttribute("org.eclipse.andmore.android.launch.instanceName", this.selectedInstance.getName());
        workingCopy.setAttribute("org.eclipse.andmore.avd", this.selectedInstance.getName());
        workingCopy.doSave();
    }
}

