/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.manager.ServiceManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceServicesComposite;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceStatusComposite;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeEvent;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceMgtView
extends ViewPart {
    private static final Set<InstanceSelectionChangeListener> listeners = new LinkedHashSet<InstanceSelectionChangeListener>();
    private static InstanceServicesComposite instanceServicesComposite = null;
    private static IInstance selectedInstance = null;
    private static InstanceStatusComposite topComposite;
    private static InstanceSelectionChangeListener selectionChangeListener;
    private static SashForm form;
    private static String contextId;
    private boolean useDropDown = false;
    private String viewLayout = "vertical";
    private static HashMap<String, Action> serviceActionMap;
    private static final String LAYOUT_HORIZONTAL = "horizontal";
    private static final String LAYOUT_VERTICAL = "vertical";

    static {
        serviceActionMap = new HashMap();
    }

    public static InstanceServicesComposite getInstanceServicesComposite() {
        return instanceServicesComposite;
    }

    public static void setHelp(String string) {
        contextId = string;
        if (form != null) {
            form.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
                }
            });
        }
    }

    private List<IService> getServicesFromDeviceTypes() {
        Collection collection = DeviceTypeRegistry.getInstance().getDeviceTypes();
        ArrayList<IService> arrayList = new ArrayList<IService>();
        HashSet<String> hashSet = new HashSet<String>();
        for (IDeviceType iDeviceType : collection) {
            for (IService iService : iDeviceType.getServices()) {
                if (!iService.isVisible() || !hashSet.add(iService.getId())) continue;
                arrayList.add(iService);
            }
        }
        return arrayList;
    }

    private void createServicesToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        List<IService> list = this.getServicesFromDeviceTypes();
        for (final IService iService : list) {
            Action action = new Action(iService.getName()){

                public void run() {
                    List<IInstance> list = InstanceMgtView.getSelectedInstances();
                    try {
                        ServiceManager.runServices(list, (String)iService.getId());
                    }
                    catch (SequoyahException sequoyahException) {
                        sequoyahException.printStackTrace();
                    }
                }
            };
            action.setImageDescriptor(iService.getImage());
            action.setEnabled(false);
            serviceActionMap.put(iService.getId(), action);
            iToolBarManager.add((IAction)action);
        }
        if (list.size() > 0) {
            iToolBarManager.add((IContributionItem)new Separator());
        }
    }

    public void createPartControl(Composite composite) {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.sequoyah.device.framework.ui.deviceManagerView");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iConfigurationElementArray2[n2];
            String string = object.getAttribute("useDropDown");
            this.useDropDown = Boolean.parseBoolean(string);
            this.viewLayout = object.getAttribute("viewLayout");
            ++n2;
        }
        this.createServicesToolbar();
        form = LAYOUT_VERTICAL.equals(this.viewLayout) ? new SashForm(composite, 512) : new SashForm(composite, 256);
        form.setLayout((Layout)new FillLayout());
        topComposite = new InstanceStatusComposite((Composite)form, this.getViewSite(), this.useDropDown);
        topComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (selectionChangeListener != null) {
                    topComposite.removeInstanceSelectionChangeListener(selectionChangeListener);
                    topComposite.removeDisposeListener(this);
                    selectionChangeListener = null;
                }
            }
        });
        if (selectionChangeListener != null) {
            topComposite.removeInstanceSelectionChangeListener(selectionChangeListener);
        }
        if (!this.useDropDown) {
            object = new InstanceServicesComposite((Composite)form);
            instanceServicesComposite = object;
            form.setWeights(new int[]{60, 40});
            selectionChangeListener = new InstanceSelectionChangeListener((InstanceServicesComposite)((Object)object)){
                private final /* synthetic */ InstanceServicesComposite val$bottomComposite;
                {
                    this.val$bottomComposite = instanceServicesComposite;
                }

                public void instanceSelectionChanged(InstanceSelectionChangeEvent instanceSelectionChangeEvent) {
                    this.val$bottomComposite.setSelectedInstances(InstanceMgtView.getSelectedInstances());
                }
            };
            topComposite.addInstanceSelectionChangeListener(selectionChangeListener);
        } else {
            form.setWeights(new int[]{100});
        }
        if (contextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
        }
    }

    public void setFocus() {
        if (form != null) {
            form.setFocus();
        }
    }

    public static void setSeletectedInstance(IInstance iInstance) {
        selectedInstance = iInstance;
        if (topComposite != null) {
            topComposite.selectInstance(iInstance);
        }
    }

    public static IInstance getSelectedInstance() {
        if (topComposite != null) {
            return topComposite.getSelectedInstance();
        }
        return selectedInstance;
    }

    public static List<IInstance> getSelectedInstances() {
        if (topComposite != null) {
            return topComposite.getSelectedInstances();
        }
        return null;
    }

    public static List<Object> getSelection() {
        if (topComposite != null) {
            return topComposite.getSelection();
        }
        return null;
    }

    public static void addInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        listeners.add(instanceSelectionChangeListener);
    }

    public static void removeInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        listeners.remove(instanceSelectionChangeListener);
    }

    protected static void notifyInstanceSelectionChangeListeners(IInstance iInstance) {
        InstanceSelectionChangeEvent instanceSelectionChangeEvent = new InstanceSelectionChangeEvent(iInstance);
        for (InstanceSelectionChangeListener instanceSelectionChangeListener : listeners) {
            instanceSelectionChangeListener.instanceSelectionChanged(instanceSelectionChangeEvent);
        }
    }

    public void dispose() {
        if (topComposite != null) {
            topComposite.removeListener();
        }
        super.dispose();
    }

    private static void disableAllServices() {
        for (Action action : serviceActionMap.values()) {
            action.setEnabled(false);
        }
    }

    public static void updateServicesToolbar() {
        List<Object> list = InstanceMgtView.getSelection();
        List<IInstance> list2 = InstanceMgtView.getSelectedInstances();
        InstanceMgtView.disableAllServices();
        if (list.size() == list2.size() && list2 != null && !list2.isEmpty()) {
            List list3 = ServiceManager.getCommonServices(list2, (list2.size() > 1 ? 1 : 0) != 0);
            List list4 = ServiceManager.getAllServices(list2, (boolean)false);
            for (IService iService : list4) {
                Action action = serviceActionMap.get(iService.getId());
                if (action == null) continue;
                action.setEnabled(iService.isVisible() && list3.contains(iService));
            }
        }
    }
}

