/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.internal.model;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IDeviceTypeDropSupport;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IDeviceHandler;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileDeviceType
implements IDeviceType {
    private static final String ELEMENT_DEVICE = "deviceType";
    private static final String ATR_ICON = "icon";
    private static final String ATR_IS_PERSISTENT = "isPersistent";
    private static final String ATR_SUPPORTS_USER_INSTANCES = "supportsUserInstances";
    private static final String ATR_DROP_SUPPORT_HANDLER = "dropSupportHandler";
    private static final String PROPERTY_ICON = "icon";
    private String id;
    private String label;
    private String bundleName;
    private boolean isAbstract = false;
    private String superClass;
    private IDeviceHandler handler;
    private Properties properties = new Properties();
    private List<IService> services;
    private boolean isPersistent = true;
    private boolean supportsUserInstances = true;
    private final IDeviceTypeDropSupport dropSupport;

    public MobileDeviceType(String string, String string2) {
        this.id = string;
        this.label = string2;
        IExtension iExtension = PluginUtils.getExtension((String)"org.eclipse.sequoyah.device.framework.deviceTypes", (String)string);
        String string3 = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)ATR_IS_PERSISTENT);
        String string4 = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)ATR_SUPPORTS_USER_INSTANCES);
        IDeviceTypeDropSupport iDeviceTypeDropSupport = null;
        try {
            Object object = PluginUtils.getExecutableAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)ATR_DROP_SUPPORT_HANDLER);
            if (object instanceof IDeviceTypeDropSupport) {
                iDeviceTypeDropSupport = (IDeviceTypeDropSupport)object;
            }
        }
        catch (CoreException coreException) {}
        this.dropSupport = iDeviceTypeDropSupport;
        if (string3 != null) {
            this.isPersistent = Boolean.valueOf(string3);
        }
        if (string4 != null) {
            this.supportsUserInstances = Boolean.valueOf(string4);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void addProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public void setBundleName(String string) {
        this.bundleName = string;
    }

    @Override
    public List<IService> getServices() {
        return this.services;
    }

    @Override
    public void setServices(List<IService> list) {
        this.services = list;
    }

    @Override
    public IDeviceHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(IDeviceHandler iDeviceHandler) {
        this.handler = iDeviceHandler;
    }

    @Override
    public Image getImage() {
        if (this.getProperties().containsKey("icon")) {
            String string = this.getProperties().getProperty("icon");
            Image image = DevicePlugin.getDefault().getImageFromRegistry(this.getBundleName(), string);
            return image;
        }
        IExtension iExtension = PluginUtils.getExtension((String)"org.eclipse.sequoyah.device.framework.deviceTypes", (String)this.id);
        String string = PluginUtils.getPluginAttribute((IExtension)iExtension, (String)ELEMENT_DEVICE, (String)"icon");
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = DevicePlugin.getPluginImage((Bundle)Platform.getBundle((String)iExtension.getContributor().getName()), (String)string);
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            invalidRegistryObjectException.printStackTrace();
        }
        return imageDescriptor.createImage();
    }

    public String toString() {
        return "[DeviceType: id=" + (this.id == null ? "" : this.id) + ",label=" + (this.label == null ? "" : this.label) + ",bundleName=" + (this.bundleName == null ? "" : this.bundleName) + "]";
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    @Override
    public String getSuperClass() {
        return this.superClass;
    }

    @Override
    public void setSuperClass(String string) {
        this.superClass = string;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public boolean supportsUserInstances() {
        return this.supportsUserInstances;
    }

    @Override
    public IDeviceTypeDropSupport getDropSupport() {
        return this.dropSupport;
    }
}

