/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Logit;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction bounded, double[] lower, double[] upper) {
        MathUtils.checkNotNull(lower);
        MathUtils.checkNotNull(upper);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        int i = 0;
        while (i < lower.length) {
            if (!(upper[i] >= lower[i])) {
                throw new NumberIsTooSmallException(upper[i], (Number)lower[i], true);
            }
            ++i;
        }
        this.bounded = bounded;
        this.mappers = new Mapper[lower.length];
        i = 0;
        while (i < this.mappers.length) {
            this.mappers[i] = Double.isInfinite(lower[i]) ? (Double.isInfinite(upper[i]) ? new NoBoundsMapper() : new UpperBoundMapper(upper[i])) : (Double.isInfinite(upper[i]) ? new LowerBoundMapper(lower[i]) : new LowerUpperBoundMapper(lower[i], upper[i]));
            ++i;
        }
    }

    public double[] unboundedToBounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        int i = 0;
        while (i < this.mappers.length) {
            mapped[i] = this.mappers[i].unboundedToBounded(point[i]);
            ++i;
        }
        return mapped;
    }

    public double[] boundedToUnbounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        int i = 0;
        while (i < this.mappers.length) {
            mapped[i] = this.mappers[i].boundedToUnbounded(point[i]);
            ++i;
        }
        return mapped;
    }

    @Override
    public double value(double[] point) {
        return this.bounded.value(this.unboundedToBounded(point));
    }

    private static class LowerBoundMapper
    implements Mapper {
        private final double lower;

        public LowerBoundMapper(double lower) {
            this.lower = lower;
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.lower + FastMath.exp(y);
        }

        @Override
        public double boundedToUnbounded(double x) {
            return FastMath.log(x - this.lower);
        }
    }

    private static class LowerUpperBoundMapper
    implements Mapper {
        private final UnivariateFunction boundingFunction;
        private final UnivariateFunction unboundingFunction;

        public LowerUpperBoundMapper(double lower, double upper) {
            this.boundingFunction = new Sigmoid(lower, upper);
            this.unboundingFunction = new Logit(lower, upper);
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.boundingFunction.value(y);
        }

        @Override
        public double boundedToUnbounded(double x) {
            return this.unboundingFunction.value(x);
        }
    }

    private static interface Mapper {
        public double unboundedToBounded(double var1);

        public double boundedToUnbounded(double var1);
    }

    private static class NoBoundsMapper
    implements Mapper {
        private NoBoundsMapper() {
        }

        @Override
        public double unboundedToBounded(double y) {
            return y;
        }

        @Override
        public double boundedToUnbounded(double x) {
            return x;
        }
    }

    private static class UpperBoundMapper
    implements Mapper {
        private final double upper;

        public UpperBoundMapper(double upper) {
            this.upper = upper;
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.upper - FastMath.exp(-y);
        }

        @Override
        public double boundedToUnbounded(double x) {
            return -FastMath.log(this.upper - x);
        }
    }
}

