/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.monitoring.NumberNotificationCondition;
import org.eclipse.apogy.addons.monitoring.provider.NumberNotificationConditionItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class NumberNotificationConditionCustomItemProvider
extends NumberNotificationConditionItemProvider {
    private DecimalFormat decimalFormat = new DecimalFormat("0.###");

    public NumberNotificationConditionCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        NumberNotificationCondition condition = (NumberNotificationCondition)object;
        String label = condition.getName();
        if (label == null) {
            label = this.getString("_UI_NumberNotificationCondition_type");
        }
        String suffix = "";
        suffix = String.valueOf(suffix) + "value " + condition.getRelation() + " ";
        if ((suffix = String.valueOf(suffix) + this.decimalFormat.format(condition.getTargetValue())).length() > 0) {
            label = String.valueOf(label) + " (" + suffix + ")";
        }
        return label;
    }

    @Override
    public Object getImage(Object object) {
        NumberNotificationCondition condition = (NumberNotificationCondition)object;
        String imageFilePath = "/custom/";
        switch (condition.getRelation().getValue()) {
            case 1: {
                imageFilePath = String.valueOf(imageFilePath) + "LessThan";
                break;
            }
            case 2: {
                imageFilePath = String.valueOf(imageFilePath) + "LessThanOrEqual";
                break;
            }
            case 3: {
                imageFilePath = String.valueOf(imageFilePath) + "Equal";
                break;
            }
            case 4: {
                imageFilePath = String.valueOf(imageFilePath) + "GreaterThanOrEqual";
                break;
            }
            case 5: {
                imageFilePath = String.valueOf(imageFilePath) + "GreaterThan";
                break;
            }
            case 6: {
                imageFilePath = String.valueOf(imageFilePath) + "NotEqual";
                break;
            }
        }
        return this.overlayImage(object, this.getResourceLocator().getImage(imageFilePath));
    }
}

