/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.SolarCell;
import org.eclipse.apogy.addons.powersystems.SolarPanel;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SolarPanelListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, SolarPanel> {
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static DecimalFormat angleFormat = new DecimalFormat("0.0");
    protected static final int POWER_AVAILABLE_MIN_WIDTH = 150;
    protected static final int POWER_PROVIDED_MIN_WIDTH = 150;
    protected static final int SUN_ANGLE_MIN_WIDTH = 120;
    protected static final int SHADOWED_CELLS_COUNT_MIN_WIDTH = 100;

    public SolarPanelListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        powerInputColumn.getColumn().setText("Power Provided (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SolarPanel) {
                    SolarPanel solarPanel = (SolarPanel)element;
                    return decimalFormat.format(solarPanel.getPowerProvided());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_PROVIDED);
            }

            public Color getBackground(Object element) {
                if (element instanceof SolarPanel) {
                    return SolarPanelListComposite.this.getBackgroundColor((SolarPanel)element);
                }
                return null;
            }
        });
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        stateColumn.getColumn().setText("Power Available (W)");
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SolarPanel) {
                    SolarPanel solarPanel = (SolarPanel)element;
                    return decimalFormat.format(solarPanel.getPowerAvailable());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_AVAILABLE);
            }

            public Color getBackground(Object element) {
                if (element instanceof SolarPanel) {
                    return SolarPanelListComposite.this.getBackgroundColor((SolarPanel)element);
                }
                return null;
            }
        });
        TreeViewerColumn sunAngleColumn = new TreeViewerColumn(viewer, 0);
        sunAngleColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        sunAngleColumn.getColumn().setText("Sun Angle (deg)");
        sunAngleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SolarPanel) {
                    SolarPanel solarPanel = (SolarPanel)element;
                    return angleFormat.format(Math.toDegrees(solarPanel.getSunIncidenceAngle()));
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_PANEL__SUN_INCIDENCE_ANGLE);
            }

            public Color getBackground(Object element) {
                if (element instanceof SolarPanel) {
                    return SolarPanelListComposite.this.getBackgroundColor((SolarPanel)element);
                }
                return null;
            }
        });
        TreeViewerColumn shadoweddCellsColumn = new TreeViewerColumn(viewer, 0);
        shadoweddCellsColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        shadoweddCellsColumn.getColumn().setText("Shadowed Cells");
        shadoweddCellsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SolarPanel) {
                    SolarPanel solarPanel = (SolarPanel)element;
                    int shadowedCellCount = 0;
                    for (SolarCell cell : solarPanel.getAllSolarCells()) {
                        if (!cell.isShadowed()) continue;
                        ++shadowedCellCount;
                    }
                    return String.valueOf(Integer.toString(shadowedCellCount)) + "/" + Integer.toString(solarPanel.getAllSolarCells().size());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return "Number of cells within the solar panel that are currently shadowed.";
            }

            public Color getBackground(Object element) {
                if (element instanceof SolarPanel) {
                    SolarPanel solarPanel = (SolarPanel)element;
                    int shadowedCellCount = 0;
                    for (SolarCell cell : solarPanel.getAllSolarCells()) {
                        if (!cell.isShadowed()) continue;
                        ++shadowedCellCount;
                    }
                    if (shadowedCellCount > 0) {
                        return Display.getCurrent().getSystemColor(13);
                    }
                    return SolarPanelListComposite.this.getBackgroundColor((SolarPanel)element);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof SolarPanel)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(SolarPanel solarPanel) {
        Color color = null;
        color = !solarPanel.isPowerStateValid() ? INVALID_COLOR : (solarPanel.getPowerProvided() == 0.0 ? Display.getCurrent().getSystemColor(15) : Display.getCurrent().getSystemColor(5));
        return color;
    }
}

