/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChargingState implements Enumerator
{
    CHARGING(0, "Charging", "Charging"),
    DISCHARGING(1, "Discharging", "Discharging"),
    FULL(2, "Full", "Full"),
    EMPTY(3, "Empty", "Empty"),
    NEUTRAL(4, "Neutral", "Neutral");

    public static final int CHARGING_VALUE = 0;
    public static final int DISCHARGING_VALUE = 1;
    public static final int FULL_VALUE = 2;
    public static final int EMPTY_VALUE = 3;
    public static final int NEUTRAL_VALUE = 4;
    private static final ChargingState[] VALUES_ARRAY;
    public static final List<ChargingState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChargingState[]{CHARGING, DISCHARGING, FULL, EMPTY, NEUTRAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChargingState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChargingState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChargingState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChargingState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChargingState get(int value) {
        switch (value) {
            case 0: {
                return CHARGING;
            }
            case 1: {
                return DISCHARGING;
            }
            case 2: {
                return FULL;
            }
            case 3: {
                return EMPTY;
            }
            case 4: {
                return NEUTRAL;
            }
        }
        return null;
    }

    private ChargingState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

