/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.apogy.addons.powersystems.AbstractInputElement;
import org.eclipse.apogy.addons.powersystems.AbstractOutputElement;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsFactory;
import org.eclipse.apogy.addons.powersystems.Battery;
import org.eclipse.apogy.addons.powersystems.Breaker;
import org.eclipse.apogy.addons.powersystems.DistributionBus;
import org.eclipse.apogy.addons.powersystems.EnergyStorage;
import org.eclipse.apogy.addons.powersystems.GearMotor;
import org.eclipse.apogy.addons.powersystems.InLineSystemElement;
import org.eclipse.apogy.addons.powersystems.LossyPowerTransmitter;
import org.eclipse.apogy.addons.powersystems.Motor;
import org.eclipse.apogy.addons.powersystems.MultipleOutputsElement;
import org.eclipse.apogy.addons.powersystems.MutipleInputsElement;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerConsumer;
import org.eclipse.apogy.addons.powersystems.PowerConverter;
import org.eclipse.apogy.addons.powersystems.PowerSource;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.PowerSystem;
import org.eclipse.apogy.addons.powersystems.PowerSystemEdge;
import org.eclipse.apogy.addons.powersystems.PowerSystemEdgeFactory;
import org.eclipse.apogy.addons.powersystems.SimpleLoad;
import org.eclipse.apogy.addons.powersystems.SimplePowerSource;
import org.eclipse.apogy.addons.powersystems.SimpleSolarCellSeriesString;
import org.eclipse.apogy.addons.powersystems.SingleInputElement;
import org.eclipse.apogy.addons.powersystems.SingleOutputElement;
import org.eclipse.apogy.addons.powersystems.SolarCell;
import org.eclipse.apogy.addons.powersystems.SolarPanel;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.impl.PowerSystemFacadeImpl;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class PowerSystemFacadeCustomImpl
extends PowerSystemFacadeImpl {
    public static final double SECONDS_IN_HOUR = 3600.0;

    @Override
    public SimpleLoad createSimpleLoad(PowerSystem powerSystem, String name, String description, double power) {
        SimpleLoad element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createSimpleLoad();
        element.setName(name);
        element.setDescription(description);
        element.setRequiredPower(power);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public SimplePowerSource createSimplePowerSource(PowerSystem powerSystem, String name, String description, double maximumPower) {
        SimplePowerSource element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createSimplePowerSource();
        element.setName(name);
        element.setDescription(description);
        element.setPowerAvailable(maximumPower);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public PowerConverter createPowerConverter(PowerSystem powerSystem, String name, String description, double efficiency, double maximumPower, boolean autoRestart) {
        PowerConverter element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createPowerConverter();
        element.setName(name);
        element.setDescription(description);
        element.setEfficiency(efficiency);
        element.setMaxPowerOutput(maximumPower);
        element.setAutoRestart(autoRestart);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public PowerSwitch createPowerSwitch(PowerSystem powerSystem, String name, String description, double efficiency) {
        PowerSwitch element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createPowerSwitch();
        element.setName(name);
        element.setDescription(description);
        element.setEfficiency(efficiency);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public Breaker createBreaker(PowerSystem powerSystem, String name, String description, double tripPower, boolean autoReset) {
        Breaker element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createBreaker();
        element.setName(name);
        element.setDescription(description);
        element.setTripPoint(tripPower);
        element.setAutoReset(autoReset);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public DistributionBus createDistributionBus(PowerSystem powerSystem, String name, String description) {
        DistributionBus element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createDistributionBus();
        element.setName(name);
        element.setDescription(description);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public PowerBus createPowerBus(PowerSystem powerSystem, String name, String description) {
        PowerBus element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createPowerBus();
        element.setName(name);
        element.setDescription(description);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
            powerSystem.setMainBus(element);
        }
        return element;
    }

    @Override
    public Battery createBattery(PowerSystem powerSystem, String name, String description, double dischargingEfficiency, double chargingEfficiency, double batteryVoltage, double batteryCapacity) {
        Battery element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createBattery();
        element.setName(name);
        element.setDescription(description);
        element.setDischargingEfficiency(dischargingEfficiency);
        element.setChargingEfficiency(chargingEfficiency);
        element.setBatteryVoltage(batteryVoltage);
        element.setBatteryCapacity(batteryCapacity);
        element.setStoredEnergy(element.getBatteryCapacity() * element.getBatteryVoltage() * 3600.0);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public SolarPanel createSolarPanel(PowerSystem powerSystem, String name, String description, double width, double length) {
        SolarPanel element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createSolarPanel();
        element.setName(name);
        element.setDescription(description);
        element.setWidth(width);
        element.setLength(length);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public Motor createMotor(PowerSystem powerSystem, String name, String description, double efficiency) {
        Motor element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createMotor();
        element.setName(name);
        element.setDescription(description);
        element.setEfficiency(efficiency);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public GearMotor createGearMotor(PowerSystem powerSystem, String name, String description, double motorEfficiency, double gearBoxEfficiency) {
        GearMotor element = ApogyAddonsPowerSystemsFactory.eINSTANCE.createGearMotor();
        element.setName(name);
        element.setDescription(description);
        element.setEfficiency(motorEfficiency);
        element.setGearBoxEfficiency(gearBoxEfficiency);
        Motor motor = ApogyAddonsPowerSystemsFactory.eINSTANCE.createMotor();
        motor.setEfficiency(motorEfficiency);
        element.setMotor(motor);
        if (powerSystem != null) {
            powerSystem.getElements().add((Object)element);
        }
        return element;
    }

    @Override
    public SimpleSolarCellSeriesString createSimpleSolarCellSeriesString(String cellNamePrefix, int numberOfCells, double cellLength, double cellWidth, double efficiency) {
        SimpleSolarCellSeriesString string = ApogyAddonsPowerSystemsFactory.eINSTANCE.createSimpleSolarCellSeriesString();
        int i = 0;
        while (i < numberOfCells) {
            SolarCell cell = ApogyAddonsPowerSystemsFactory.eINSTANCE.createSolarCell();
            cell.setEfficiency(efficiency);
            cell.setLength(cellLength);
            cell.setWidth(cellWidth);
            cell.setName(String.valueOf(cellNamePrefix) + Integer.toString(i + 1));
            cell.setSolarIllumination(1000.0);
            cell.setSunIncidenceVector(ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 1.0));
            cell.setShadowed(false);
            string.getCellsInSeries().add((Object)cell);
            ++i;
        }
        return string;
    }

    @Override
    public List<SystemElement> findPath(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from, SystemElement to) {
        List<PowerSystemEdge> edges = PowerSystemFacadeCustomImpl.getDijkstraShortestPath(graph, from, to);
        ArrayList<SystemElement> path = new ArrayList<SystemElement>();
        for (PowerSystemEdge edge : edges) {
            if (!path.contains(edge.getFrom())) {
                path.add(edge.getFrom());
            }
            if (path.contains(edge.getTo())) continue;
            path.add(edge.getTo());
        }
        return path;
    }

    @Override
    public List<SystemElement> getAllOutputs(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from) {
        GraphIterator it = new GraphIterator(graph, 1, from);
        ArrayList<SystemElement> elements = new ArrayList<SystemElement>();
        while (it.hasNext()) {
            SystemElement element = it.next();
            if (element == from) continue;
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<SystemElement> getAllInputs(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from) {
        GraphIterator it = new GraphIterator(graph, 2, from);
        ArrayList<SystemElement> elements = new ArrayList<SystemElement>();
        while (it.hasNext()) {
            SystemElement element = it.next();
            if (element == from) continue;
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<SystemElement> getImmediateInputs(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from) {
        ArrayList<SystemElement> elements = new ArrayList<SystemElement>();
        Set edges = graph.incomingEdgesOf((Object)from);
        for (PowerSystemEdge edge : edges) {
            if (elements.contains(edge.getFrom())) continue;
            elements.add(edge.getFrom());
        }
        return elements;
    }

    @Override
    public List<SystemElement> getImmediateOutputs(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from) {
        ArrayList<SystemElement> elements = new ArrayList<SystemElement>();
        Set edges = graph.outgoingEdgesOf((Object)from);
        for (PowerSystemEdge edge : edges) {
            if (elements.contains(edge.getTo())) continue;
            elements.add(edge.getTo());
        }
        return elements;
    }

    @Override
    public synchronized double findAvailablePowerFromSource(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement to) {
        ArrayList<SystemElement> visited = new ArrayList<SystemElement>();
        return this.findAvailablePowerFromSourceRecursive(graph, to, visited);
    }

    private double findAvailablePowerFromSourceRecursive(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement to, List<SystemElement> visited) {
        double availablePower = 0.0;
        if (!visited.contains(to)) {
            visited.add(to);
            if (to instanceof PowerSource) {
                availablePower += ((PowerSource)to).getPowerAvailable();
            }
            List<SystemElement> inputs = this.getImmediateInputs(graph, to);
            for (SystemElement element : inputs) {
                if (element instanceof PowerSource) {
                    availablePower += ((PowerSource)element).getPowerAvailable();
                    continue;
                }
                if (element instanceof LossyPowerTransmitter) {
                    double efficency = ((LossyPowerTransmitter)((Object)element)).getEffectiveEfficiency() / 100.0;
                    availablePower += efficency * this.findAvailablePowerFromSourceRecursive(graph, element, visited);
                    continue;
                }
                availablePower += this.findAvailablePowerFromSourceRecursive(graph, element, visited);
            }
        }
        return availablePower;
    }

    @Override
    public synchronized double findRequiredPowerFromConsumer(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from) {
        ArrayList<SystemElement> visited = new ArrayList<SystemElement>();
        double requiredPower = 0.0;
        double intrinsicPower = 0.0;
        double childRequiredPower = 0.0;
        double efficency = 1.0;
        if (from instanceof LossyPowerTransmitter) {
            efficency = ((LossyPowerTransmitter)((Object)from)).getEffectiveEfficiency() / 100.0;
        }
        if (from instanceof EnergyStorage) {
            return 0.0;
        }
        if (from instanceof PowerConsumer) {
            intrinsicPower = ((PowerConsumer)from).getRequiredPower();
        }
        visited.add(from);
        if (efficency > 0.0) {
            List<SystemElement> outputs = this.getImmediateOutputs(graph, from);
            for (SystemElement element : outputs) {
                double elementPower = this.findRequiredPowerFromConsumerRecursive(graph, element, visited);
                childRequiredPower += elementPower;
            }
            requiredPower = intrinsicPower + childRequiredPower / efficency;
        } else {
            requiredPower = intrinsicPower;
        }
        return requiredPower;
    }

    private double findRequiredPowerFromConsumerRecursive(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from, List<SystemElement> visited) {
        double requiredPower = 0.0;
        double intrinsicPower = 0.0;
        double childRequiredPower = 0.0;
        if (!visited.contains(from)) {
            visited.add(from);
            double efficency = 1.0;
            if (from instanceof LossyPowerTransmitter) {
                efficency = ((LossyPowerTransmitter)((Object)from)).getEffectiveEfficiency() / 100.0;
            }
            if (from instanceof EnergyStorage) {
                return 0.0;
            }
            if (from instanceof PowerConsumer) {
                intrinsicPower = ((PowerConsumer)from).getRequiredPower();
            }
            visited.add(from);
            if (efficency > 0.0) {
                List<SystemElement> outputs = this.getImmediateOutputs(graph, from);
                for (SystemElement element : outputs) {
                    childRequiredPower += this.findRequiredPowerFromConsumerRecursive(graph, element, visited);
                }
                requiredPower = intrinsicPower + childRequiredPower / efficency;
            } else {
                requiredPower = intrinsicPower;
            }
        }
        return requiredPower;
    }

    @Override
    public List<SystemElement> getAllConnectedSystemElement(PowerSystem powerSystem) {
        SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph = this.createSimpleDirectedWeightedGraph(powerSystem);
        ArrayList<SystemElement> elements = new ArrayList<SystemElement>();
        elements.addAll(graph.vertexSet());
        return elements;
    }

    @Override
    public void propagatePowerToConsumer(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from, double power) {
        ArrayList<SystemElement> visited = new ArrayList<SystemElement>();
        this.propagatePowerToConsumerRecursive(graph, from, power, visited);
    }

    private void propagatePowerToConsumerRecursive(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from, double power, List<SystemElement> visited) {
        block12: {
            if (visited.contains(from)) break block12;
            visited.add(from);
            double powerForChild = power;
            double efficiency = 1.0;
            if (from instanceof PowerConsumer) {
                PowerConsumer root = (PowerConsumer)from;
                powerForChild -= root.getRequiredPower();
                root.setPowerConsumed(power);
            }
            if (from instanceof LossyPowerTransmitter) {
                LossyPowerTransmitter lossyPowerTransmitter = (LossyPowerTransmitter)((Object)from);
                efficiency = lossyPowerTransmitter.getEffectiveEfficiency() / 100.0;
            }
            if (from instanceof InLineSystemElement) {
                InLineSystemElement inLineSystemElement = (InLineSystemElement)from;
                inLineSystemElement.setInputPower(power);
                inLineSystemElement.setOutputPower(powerForChild * efficiency);
            }
            if (from instanceof DistributionBus) {
                DistributionBus distributionBus = (DistributionBus)from;
                distributionBus.setInputPower(power);
            }
            if (from instanceof EnergyStorage) {
                return;
            }
            List<SystemElement> consumers = this.getImmediateOutputs(graph, from);
            if (!consumers.isEmpty()) {
                double powerOutput = efficiency * powerForChild;
                HashMap<SystemElement, Double> elementToPowerMap = new HashMap<SystemElement, Double>();
                if (powerOutput != 0.0) {
                    double powerForElement;
                    double totalRequiredPower = 0.0;
                    for (SystemElement element : consumers) {
                        powerForElement = this.findRequiredPowerFromConsumer(graph, element);
                        elementToPowerMap.put(element, powerForElement);
                        totalRequiredPower += powerForElement;
                    }
                    for (SystemElement element : consumers) {
                        powerForElement = 0.0;
                        if (powerOutput > 0.0) {
                            powerForElement = (Double)elementToPowerMap.get(element) / totalRequiredPower * powerOutput;
                        }
                        this.propagatePowerToConsumerRecursive(graph, element, powerForElement, visited);
                    }
                } else {
                    for (SystemElement element : consumers) {
                        this.propagatePowerToConsumerRecursive(graph, element, 0.0, visited);
                    }
                }
            }
        }
    }

    @Override
    public void propagatePowerDemandToPowerSources(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement to, double power) {
        ArrayList<SystemElement> visited = new ArrayList<SystemElement>();
        this.propagatePowerDemandToPowerSourcesRecursive(graph, to, power, visited);
    }

    private void propagatePowerDemandToPowerSourcesRecursive(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement to, double power, List<SystemElement> visited) {
        if (!visited.contains(to)) {
            InLineSystemElement inLineSystemElement;
            visited.add(to);
            double efficiency = 1.0;
            if (to instanceof InLineSystemElement && (efficiency = (inLineSystemElement = (InLineSystemElement)to).getEffectiveEfficiency() / 100.0) > 0.0 && efficiency <= 1.0) {
                inLineSystemElement.setInputPower(power * (1.0 / efficiency));
                inLineSystemElement.setOutputPower(power);
            }
            if (to instanceof EnergyStorage) {
                return;
            }
            if (to instanceof PowerSource) {
                PowerSource powerSource = (PowerSource)to;
                powerSource.requestPower(power);
            }
            List<SystemElement> inputs = this.getImmediateInputs(graph, to);
            double powerInput = 0.0;
            if (efficiency > 0.0 && efficiency <= 1.0) {
                powerInput = 1.0 / efficiency * power;
            }
            HashMap<SystemElement, Double> elementToPowerMap = new HashMap<SystemElement, Double>();
            double totalProvidedPower = 0.0;
            for (SystemElement element : inputs) {
                if (element instanceof EnergyStorage) continue;
                double elementEfficiency = 1.0;
                if (element instanceof LossyPowerTransmitter) {
                    elementEfficiency = ((LossyPowerTransmitter)((Object)element)).getEffectiveEfficiency() / 100.0;
                }
                double powerAtElementInput = 0.0;
                if (elementEfficiency >= 0.0 && elementEfficiency <= 1.0) {
                    double pow = this.findAvailablePowerFromSource(graph, element);
                    powerAtElementInput = pow * elementEfficiency;
                }
                elementToPowerMap.put(element, powerAtElementInput);
                totalProvidedPower += powerAtElementInput;
            }
            for (SystemElement element : elementToPowerMap.keySet()) {
                double powerForElement = (Double)elementToPowerMap.get(element);
                if (totalProvidedPower > 0.0) {
                    powerForElement = (Double)elementToPowerMap.get(element) / totalProvidedPower * powerInput;
                }
                this.propagatePowerDemandToPowerSourcesRecursive(graph, element, powerForElement, visited);
            }
        }
    }

    @Override
    public double computeEfficiency(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, SystemElement from, SystemElement to) throws Exception {
        List<SystemElement> path = this.findPath(graph, from, to);
        if (path.size() == 0) {
            return 0.0;
        }
        double efficiency = 1.0;
        Iterator<SystemElement> it = path.iterator();
        while (it.hasNext() && efficiency != 0.0) {
            SystemElement element = it.next();
            if (!(element instanceof LossyPowerTransmitter)) continue;
            LossyPowerTransmitter lossyTransmitter = (LossyPowerTransmitter)((Object)element);
            efficiency *= lossyTransmitter.getEffectiveEfficiency() / 100.0;
        }
        return efficiency * 100.0;
    }

    @Override
    public SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> createSimpleDirectedWeightedGraph(PowerSystem powerSystem) {
        PowerSystemEdgeFactory edgeFactory = ApogyAddonsPowerSystemsFactory.eINSTANCE.createPowerSystemEdgeFactory();
        SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> simpleDirectedWeightedGraph = new SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge>((EdgeFactory)edgeFactory){

            public double getEdgeWeight(PowerSystemEdge e) {
                return 1.0;
            }
        };
        EList<SystemElement> elements = powerSystem.getElements();
        for (SystemElement element : elements) {
            simpleDirectedWeightedGraph.addVertex((Object)element);
        }
        TreeSet<PowerSystemEdge> edgeSet = new TreeSet<PowerSystemEdge>(new Comparator<PowerSystemEdge>(){

            @Override
            public int compare(PowerSystemEdge o1, PowerSystemEdge o2) {
                if (o1.getFrom() == o2.getFrom() && o1.getTo() == o2.getTo()) {
                    return 0;
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        for (SystemElement element : simpleDirectedWeightedGraph.vertexSet()) {
            if (element instanceof SingleOutputElement) {
                edgeSet.addAll(this.createEdgeForSingleOutputElement(edgeFactory, (SingleOutputElement)element));
            }
            if (element instanceof SingleInputElement) {
                edgeSet.addAll(this.createEdgeForSingleInputElement(edgeFactory, (SingleInputElement)element));
            }
            if (element instanceof MultipleOutputsElement) {
                edgeSet.addAll(this.createEdgeForMultipleOutputsElement(edgeFactory, (MultipleOutputsElement)element));
            }
            if (!(element instanceof MutipleInputsElement)) continue;
            edgeSet.addAll(this.createEdgeForMutipleInputsElement(edgeFactory, (MutipleInputsElement)element));
        }
        for (PowerSystemEdge edge : edgeSet) {
            simpleDirectedWeightedGraph.addEdge((Object)edge.getFrom(), (Object)edge.getTo());
        }
        return simpleDirectedWeightedGraph;
    }

    private Collection<PowerSystemEdge> createEdgeForSingleOutputElement(PowerSystemEdgeFactory edgeFactory, SingleOutputElement singleOutputElement) {
        ArrayList<PowerSystemEdge> edges = new ArrayList<PowerSystemEdge>();
        if (singleOutputElement.getOutput() != null) {
            edges.add((PowerSystemEdge)edgeFactory.createEdge(singleOutputElement, singleOutputElement.getOutput()));
        }
        return edges;
    }

    private Collection<PowerSystemEdge> createEdgeForSingleInputElement(PowerSystemEdgeFactory edgeFactory, SingleInputElement singleOutputElement) {
        ArrayList<PowerSystemEdge> edges = new ArrayList<PowerSystemEdge>();
        if (singleOutputElement.getInput() != null) {
            edges.add((PowerSystemEdge)edgeFactory.createEdge(singleOutputElement.getInput(), singleOutputElement));
        }
        return edges;
    }

    private Collection<PowerSystemEdge> createEdgeForMultipleOutputsElement(PowerSystemEdgeFactory edgeFactory, MultipleOutputsElement multipleOutputsElement) {
        ArrayList<PowerSystemEdge> edges = new ArrayList<PowerSystemEdge>();
        for (AbstractInputElement element : multipleOutputsElement.getOutputs()) {
            edges.add((PowerSystemEdge)edgeFactory.createEdge(multipleOutputsElement, element));
        }
        return edges;
    }

    private Collection<PowerSystemEdge> createEdgeForMutipleInputsElement(PowerSystemEdgeFactory edgeFactory, MutipleInputsElement mutipleInputsElement) {
        ArrayList<PowerSystemEdge> edges = new ArrayList<PowerSystemEdge>();
        for (AbstractOutputElement element : mutipleInputsElement.getInputs()) {
            edges.add((PowerSystemEdge)edgeFactory.createEdge(element, mutipleInputsElement));
        }
        return edges;
    }

    public static List<PowerSystemEdge> getDijkstraShortestPath(Graph graph, SystemElement from, SystemElement to) {
        ArrayList<PowerSystemEdge> edgeList = new ArrayList<PowerSystemEdge>();
        List temp = DijkstraShortestPath.findPathBetween((Graph)graph, (Object)from, (Object)to);
        if (temp != null) {
            for (PowerSystemEdge edge : temp) {
                edgeList.add(edge);
            }
        }
        return edgeList;
    }

    public class GraphIterator
    implements Iterator<SystemElement> {
        public static final int ALONG_EDGE = 1;
        public static final int REVERS_EDGE = 2;
        private SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph;
        private int direction = 0;
        private List<SystemElement> nodes = new ArrayList<SystemElement>();
        private Iterator<SystemElement> iterator;

        public GraphIterator(SimpleDirectedWeightedGraph<SystemElement, PowerSystemEdge> graph, int direction, SystemElement from) {
            this.graph = graph;
            this.direction = direction;
            this.explore(from, this.nodes);
            this.iterator = this.nodes.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SystemElement next() {
            return this.iterator.next();
        }

        private void explore(SystemElement node, List<SystemElement> nodes) {
            this.exploreRecursive(node, nodes);
        }

        private void exploreRecursive(SystemElement node, List<SystemElement> nodes) {
            Set edges = null;
            edges = this.direction == 1 ? this.graph.outgoingEdgesOf((Object)node) : this.graph.incomingEdgesOf((Object)node);
            for (PowerSystemEdge edge : edges) {
                SystemElement next;
                if (this.direction == 1) {
                    next = edge.getTo();
                    if (nodes.contains(next)) continue;
                    nodes.add(edge.getTo());
                    this.exploreRecursive(next, nodes);
                    continue;
                }
                next = edge.getFrom();
                if (nodes.contains(next)) continue;
                nodes.add(next);
                this.exploreRecursive(next, nodes);
            }
        }
    }
}

