/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.preferences;

import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MRTData3DUIPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor triangularMeshVisibilityBooleanFieldEditor;
    private BooleanFieldEditor cartesianCoordSetVisibilityBooleanFieldEditor;
    private BooleanFieldEditor triangularMeshUseShadingBooleanFieldEditor;
    private RadioGroupFieldEditor wayPointPathPresentationModeRadioGroupFieldEditor;
    private ColorFieldEditor triangularMeshColorFieldEditor;
    private ColorFieldEditor cartesianCoordSetColorFieldEditor;
    private IntegerFieldEditor triangularMeshPointSizeIntegerFieldEditor;
    private IntegerFieldEditor cartesianCoordSetPointSizeIntegerFieldEditor;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpCartesianCoordSet = new Group(container, 0);
        grpCartesianCoordSet.setLayout((Layout)new GridLayout(2, true));
        grpCartesianCoordSet.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        grpCartesianCoordSet.setText("Cartesian Coordinates Set (Point Cloud)");
        Label cartesianCoordSetVisibilityLabel = new Label((Composite)grpCartesianCoordSet, 0);
        cartesianCoordSetVisibilityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        cartesianCoordSetVisibilityLabel.setText("Visibility");
        this.cartesianCoordSetVisibilityBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpCartesianCoordSet, "DEFAULT_CARTESIAN_COORD_SET_VISIBILITY_ID", "");
        this.cartesianCoordSetColorFieldEditor = this.createColorFieldEditor((Composite)grpCartesianCoordSet, "DEFAULT_CARTESIAN_COORD_SET_COLOR_ID", "Default Color:");
        this.cartesianCoordSetPointSizeIntegerFieldEditor = this.createIntegerFieldEditor((Composite)grpCartesianCoordSet, "DEFAULT_CARTESIAN_COORD_SET_POINT_SIZE_ID", "Point Size:");
        Group grpTriangularMesh = new Group(container, 0);
        grpTriangularMesh.setLayout((Layout)new GridLayout(2, true));
        grpTriangularMesh.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        grpTriangularMesh.setText("Triangular Mesh");
        Label triangularMeshVisibilityLabel = new Label((Composite)grpTriangularMesh, 0);
        triangularMeshVisibilityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        triangularMeshVisibilityLabel.setText("Visibility");
        this.triangularMeshVisibilityBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpTriangularMesh, "DEFAULT_TRIANGULAR_MESH_VISIBILITY_ID", "");
        Label triangularMeshUseShadingLabel = new Label((Composite)grpTriangularMesh, 0);
        triangularMeshUseShadingLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        triangularMeshUseShadingLabel.setText("Use Shading");
        this.triangularMeshUseShadingBooleanFieldEditor = this.createBooleanFieldEditor((Composite)grpTriangularMesh, "DEFAULT_TRIANGULAR_MESH_USE_SHADING_ID", "");
        this.triangularMeshColorFieldEditor = this.createColorFieldEditor((Composite)grpTriangularMesh, "DEFAULT_TRIANGULAR_MESH_COLOR_ID", "Default Color:");
        this.triangularMeshPointSizeIntegerFieldEditor = this.createIntegerFieldEditor((Composite)grpTriangularMesh, "DEFAULT_TRIANGULAR_MESH_POINT_SIZE_ID", "Point Size:");
        this.wayPointPathPresentationModeRadioGroupFieldEditor = this.createPathPresentationRadioGroupFieldEditor((Composite)grpTriangularMesh, "DEFAULT_TRIANGULAR_MESH_PRESENTATION_MODE_ID", "");
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.triangularMeshVisibilityBooleanFieldEditor.loadDefault();
        this.cartesianCoordSetVisibilityBooleanFieldEditor.loadDefault();
        this.wayPointPathPresentationModeRadioGroupFieldEditor.loadDefault();
        this.triangularMeshColorFieldEditor.loadDefault();
        this.cartesianCoordSetColorFieldEditor.loadDefault();
        this.triangularMeshPointSizeIntegerFieldEditor.loadDefault();
        this.cartesianCoordSetPointSizeIntegerFieldEditor.loadDefault();
        this.triangularMeshUseShadingBooleanFieldEditor.loadDefault();
        super.performDefaults();
    }

    private String[][] getModeLabelsAndValues() {
        String[][] labelAndValues = new String[MeshPresentationMode.VALUES.size()][2];
        int i = 0;
        for (MeshPresentationMode value : MeshPresentationMode.VALUES) {
            labelAndValues[i][0] = value.getName();
            labelAndValues[i][1] = Integer.toString(value.getValue());
            ++i;
        }
        return labelAndValues;
    }

    private BooleanFieldEditor createBooleanFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        BooleanFieldEditor editor = new BooleanFieldEditor(preferenceID, preferenceLabel, container);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private RadioGroupFieldEditor createPathPresentationRadioGroupFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(preferenceID, preferenceLabel, 1, this.getModeLabelsAndValues(), editorContainer, false);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        ColorFieldEditor colorEditor = new ColorFieldEditor(preferenceID, preferenceLabel, container);
        colorEditor.setPreferenceStore(this.getPreferenceStore());
        colorEditor.load();
        return colorEditor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(preferenceID, preferenceLabel, container);
        integerFieldEditor.setPreferenceStore(this.getPreferenceStore());
        integerFieldEditor.load();
        return integerFieldEditor;
    }

    private void storePreferences() {
        this.triangularMeshVisibilityBooleanFieldEditor.store();
        this.cartesianCoordSetVisibilityBooleanFieldEditor.store();
        this.wayPointPathPresentationModeRadioGroupFieldEditor.store();
        this.triangularMeshColorFieldEditor.store();
        this.cartesianCoordSetColorFieldEditor.store();
        this.triangularMeshPointSizeIntegerFieldEditor.store();
        this.cartesianCoordSetPointSizeIntegerFieldEditor.store();
        this.triangularMeshUseShadingBooleanFieldEditor.store();
    }
}

