/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.apogy.common.geometry.data3d.converters.CartesianCoordinatesSetFileExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshFileExporter
implements IFileExporter {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshFileExporter.class);
    public static final String TRIANGLE_FILE_EXTENSION = "tri";
    public static final String VRML_FILE_EXTENSION = "wrl";

    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return CartesianTriangularMesh.class;
    }

    public boolean canConvert(Object input) {
        if (input instanceof CartesianTriangularMesh) {
            CartesianTriangularMesh mesh = (CartesianTriangularMesh)input;
            return mesh.getPoints().size() > 0;
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)input;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime() + "." + TRIANGLE_FILE_EXTENSION;
            Data3DIO.INSTANCE.saveCoordinatesSetToXYZ((CartesianCoordinatesSet)mesh, fileName);
            return new File(fileName);
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        boolean xyzExported = false;
        CartesianTriangularMesh mesh = (CartesianTriangularMesh)input;
        for (String extension : extensions) {
            String fullPathString = filePath;
            if (extension.equalsIgnoreCase(TRIANGLE_FILE_EXTENSION)) {
                Data3DIO.INSTANCE.saveTriangularMeshAsASCII(mesh, fullPathString);
                xyzExported = true;
                continue;
            }
            if (extension.equalsIgnoreCase("xyz")) {
                if (xyzExported) continue;
                if (!fullPathString.endsWith(".xyz")) {
                    fullPathString = String.valueOf(fullPathString) + ".xyz";
                }
                Data3DIO.INSTANCE.saveCoordinatesSetToXYZ((CartesianCoordinatesSet)mesh, fullPathString);
                xyzExported = true;
                continue;
            }
            if (extension.equalsIgnoreCase(VRML_FILE_EXTENSION)) {
                if (!fullPathString.endsWith(".wrl")) {
                    fullPathString = String.valueOf(fullPathString) + ".wrl";
                }
                Data3DIO.INSTANCE.saveTriangularMeshAsVRML(mesh, fullPathString);
                continue;
            }
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)CartesianTriangularMeshFileExporter.getMetaData(mesh));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("xyz");
        extensions.add(TRIANGLE_FILE_EXTENSION);
        extensions.add(VRML_FILE_EXTENSION);
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains("xyz")) {
            return "The mesh vertices in a xyz file format.";
        }
        if (fileExtension.contains(TRIANGLE_FILE_EXTENSION)) {
            return "The mesh triangles in a .tri file format. Exporting this file also exports the .xyz file.";
        }
        if (fileExtension.contains(VRML_FILE_EXTENSION)) {
            return "The mesh triangles as a VRML file";
        }
        if (fileExtension.contains("metadata")) {
            return "The mesh metadata.";
        }
        return null;
    }

    public static String getMetaData(CartesianTriangularMesh mesh) {
        String metadata = "";
        if (mesh != null) {
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            metadata = String.valueOf(metadata) + "Mesh number of triangles = " + mesh.getPolygons().size() + "\n";
            metadata = String.valueOf(metadata) + "Mesh surface (m\u00b2)= " + decimalFormat.format(mesh.getSurface()) + "\n";
            metadata = String.valueOf(metadata) + CartesianCoordinatesSetFileExporter.getMetaData(mesh);
        }
        return metadata;
    }
}

